/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.math.MyVector3f;

public class HingeJoint
extends Constraint {
    public static final Logger logger2 = Logger.getLogger(HingeJoint.class.getName());
    private static final String tagAngularOnly = "angularOnly";
    private static final String tagAxisA = "axisA";
    private static final String tagAxisB = "axisB";
    private static final String tagBiasFactor = "biasFactor";
    private static final String tagEnableAngularMotor = "enableAngularMotor";
    private static final String tagLimitSoftness = "limitSoftness";
    private static final String tagLowerLimit = "lowerLimit";
    private static final String tagMaxMotorImpulse = "maxMotorImpulse";
    private static final String tagRelaxationFactor = "relaxationFactor";
    private static final String tagTargetVelocity = "targetVelocity";
    private static final String tagUpperLimit = "upperLimit";
    private boolean angularOnly = false;
    private boolean useReferenceFrameA = false;
    private float biasFactor = 0.3f;
    private float limitSoftness = 0.9f;
    private float relaxationFactor = 1.0f;
    private Vector3f axisA;
    private Vector3f axisB;

    protected HingeJoint() {
    }

    public HingeJoint(PhysicsRigidBody rigidBodyA, Vector3f pivotInA, Vector3f pivotInWorld, Vector3f axisInA, Vector3f axisInWorld, JointEnd referenceFrame) {
        super(rigidBodyA, JointEnd.A, pivotInA, pivotInWorld);
        assert (axisInA.isUnitVector()) : axisInA;
        assert (axisInWorld.isUnitVector()) : axisInWorld;
        this.axisA = axisInA.clone();
        this.axisB = axisInWorld.clone();
        this.useReferenceFrameA = referenceFrame == JointEnd.A;
        this.createJoint();
        long constraintId = super.nativeId();
        HingeJoint.setAngularOnly(constraintId, this.angularOnly);
        float low = this.getLowerLimit();
        float high = this.getUpperLimit();
        HingeJoint.setLimit(constraintId, low, high, this.limitSoftness, this.biasFactor, this.relaxationFactor);
    }

    public HingeJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInA, Vector3f pivotInB, Vector3f axisInA, Vector3f axisInB) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, pivotInA, pivotInB);
        assert (axisInA.isUnitVector()) : axisInA;
        assert (axisInB.isUnitVector()) : axisInB;
        this.axisA = axisInA.clone();
        this.axisB = axisInB.clone();
        this.createJoint();
        long constraintId = super.nativeId();
        HingeJoint.setAngularOnly(constraintId, this.angularOnly);
        float low = this.getLowerLimit();
        float high = this.getUpperLimit();
        HingeJoint.setLimit(constraintId, low, high, this.limitSoftness, this.biasFactor, this.relaxationFactor);
    }

    public void enableMotor(boolean enable, float targetVelocity, float maxMotorImpulse) {
        long constraintId = this.nativeId();
        HingeJoint.enableMotor(constraintId, enable, targetVelocity, maxMotorImpulse);
    }

    public float getBiasFactor() {
        return this.biasFactor;
    }

    public boolean getEnableMotor() {
        long constraintId = this.nativeId();
        boolean result = HingeJoint.getEnableAngularMotor(constraintId);
        return result;
    }

    public Transform getFrameTransform(JointEnd end, Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        long constraintId = this.nativeId();
        switch (end) {
            case A: {
                HingeJoint.getFrameOffsetA(constraintId, result);
                break;
            }
            case B: {
                HingeJoint.getFrameOffsetB(constraintId, result);
                break;
            }
            default: {
                String message = "end = " + (Object)((Object)end);
                throw new IllegalArgumentException(message);
            }
        }
        return result;
    }

    public float getHingeAngle() {
        long constraintId = this.nativeId();
        float result = HingeJoint.getHingeAngle(constraintId);
        return result;
    }

    public float getLimitSoftness() {
        return this.limitSoftness;
    }

    public final float getLowerLimit() {
        long constraintId = this.nativeId();
        float result = HingeJoint.getLowerLimit(constraintId);
        return result;
    }

    public float getMotorTargetVelocity() {
        long constraintId = this.nativeId();
        float result = HingeJoint.getMotorTargetVelocity(constraintId);
        return result;
    }

    public float getMaxMotorImpulse() {
        long constraintId = this.nativeId();
        float result = HingeJoint.getMaxMotorImpulse(constraintId);
        return result;
    }

    public float getRelaxationFactor() {
        return this.relaxationFactor;
    }

    public final float getUpperLimit() {
        long constraintId = this.nativeId();
        float result = HingeJoint.getUpperLimit(constraintId);
        return result;
    }

    public boolean isAngularOnly() {
        return this.angularOnly;
    }

    public void setAngularOnly(boolean angularOnly) {
        this.angularOnly = angularOnly;
        long constraintId = this.nativeId();
        HingeJoint.setAngularOnly(constraintId, angularOnly);
    }

    public void setLimit(float low, float high) {
        long constraintId = this.nativeId();
        HingeJoint.setLimit(constraintId, low, high, this.limitSoftness, this.biasFactor, this.relaxationFactor);
    }

    public void setLimit(float low, float high, float softness, float bias, float relaxation) {
        long constraintId = this.nativeId();
        this.biasFactor = bias;
        this.relaxationFactor = relaxation;
        this.limitSoftness = softness;
        HingeJoint.setLimit(constraintId, low, high, softness, bias, relaxation);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        assert (!this.hasAssignedNativeObject());
        HingeJoint old = (HingeJoint)original;
        assert (old != this);
        assert (old.hasAssignedNativeObject());
        assert (!this.hasAssignedNativeObject());
        super.cloneFields(cloner, original);
        if (this.hasAssignedNativeObject()) {
            return;
        }
        this.axisA = (Vector3f)cloner.clone((Object)this.axisA);
        this.axisB = (Vector3f)cloner.clone((Object)this.axisB);
        this.createJoint();
        this.setAngularOnly(this.angularOnly);
        this.copyConstraintProperties(old);
        float low = old.getLowerLimit();
        float high = old.getUpperLimit();
        this.setLimit(low, high, this.limitSoftness, this.biasFactor, this.relaxationFactor);
        boolean enable = old.getEnableMotor();
        float targetVelocity = old.getMotorTargetVelocity();
        float maxImpulse = old.getMaxMotorImpulse();
        this.enableMotor(enable, targetVelocity, maxImpulse);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.axisA = (Vector3f)capsule.readSavable(tagAxisA, (Savable)new Vector3f());
        this.axisB = (Vector3f)capsule.readSavable(tagAxisB, (Savable)new Vector3f());
        this.angularOnly = capsule.readBoolean(tagAngularOnly, false);
        float lowerLimit = capsule.readFloat(tagLowerLimit, 1.0E30f);
        float upperLimit = capsule.readFloat(tagUpperLimit, -1.0E30f);
        this.biasFactor = capsule.readFloat(tagBiasFactor, 0.3f);
        this.relaxationFactor = capsule.readFloat(tagRelaxationFactor, 1.0f);
        this.limitSoftness = capsule.readFloat(tagLimitSoftness, 0.9f);
        this.createJoint();
        this.readConstraintProperties(capsule);
        boolean enableAngularMotor = capsule.readBoolean(tagEnableAngularMotor, false);
        float targetVelocity = capsule.readFloat(tagTargetVelocity, 0.0f);
        float maxMotorImpulse = capsule.readFloat(tagMaxMotorImpulse, 0.0f);
        this.enableMotor(enableAngularMotor, targetVelocity, maxMotorImpulse);
        this.setAngularOnly(this.angularOnly);
        this.setLimit(lowerLimit, upperLimit, this.limitSoftness, this.biasFactor, this.relaxationFactor);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.axisA, tagAxisA, null);
        capsule.write((Savable)this.axisB, tagAxisB, null);
        capsule.write(this.angularOnly, tagAngularOnly, false);
        capsule.write(this.getLowerLimit(), tagLowerLimit, 1.0E30f);
        capsule.write(this.getUpperLimit(), tagUpperLimit, -1.0E30f);
        capsule.write(this.biasFactor, tagBiasFactor, 0.3f);
        capsule.write(this.relaxationFactor, tagRelaxationFactor, 1.0f);
        capsule.write(this.limitSoftness, tagLimitSoftness, 0.9f);
        capsule.write(this.getEnableMotor(), tagEnableAngularMotor, false);
        capsule.write(this.getMotorTargetVelocity(), tagTargetVelocity, 0.0f);
        capsule.write(this.getMaxMotorImpulse(), tagMaxMotorImpulse, 0.0f);
    }

    private void createJoint() {
        long constraintId;
        PhysicsRigidBody a = this.getBodyA();
        long aId = a.nativeId();
        assert (this.pivotA != null);
        assert (this.axisA.isUnitVector()) : this.axisA;
        assert (this.pivotB != null);
        assert (this.axisB.isUnitVector()) : this.axisB;
        PhysicsRigidBody b = this.getBodyB();
        if (b == null) {
            Vector3f saveLocation = a.getPhysicsLocation(null);
            Quaternion saveRotation = a.getPhysicsRotation(null);
            Vector3f cross = this.axisB.cross(this.axisA);
            float sinAngle = cross.length();
            float cosAngle = this.axisB.dot(this.axisA);
            float angle = FastMath.atan2((float)sinAngle, (float)cosAngle);
            MyVector3f.normalizeLocal((Vector3f)cross);
            Quaternion rotation = new Quaternion();
            rotation.fromAngleNormalAxis(angle, cross);
            a.setPhysicsRotation(rotation);
            Vector3f offset = this.pivotB.subtract(this.pivotA);
            a.setPhysicsLocation(offset);
            constraintId = HingeJoint.createJoint1(aId, this.pivotA, this.axisA, this.useReferenceFrameA);
            a.setPhysicsLocation(saveLocation);
            a.setPhysicsRotation(saveRotation);
        } else {
            assert (!this.useReferenceFrameA);
            long bId = b.nativeId();
            constraintId = HingeJoint.createJoint(aId, bId, this.pivotA, this.axisA, this.pivotB, this.axisB);
        }
        assert (HingeJoint.getConstraintType(constraintId) == 4);
        this.setNativeId(constraintId);
    }

    private static native long createJoint(long var0, long var2, Vector3f var4, Vector3f var5, Vector3f var6, Vector3f var7);

    private static native long createJoint1(long var0, Vector3f var2, Vector3f var3, boolean var4);

    private static native void enableMotor(long var0, boolean var2, float var3, float var4);

    private static native boolean getEnableAngularMotor(long var0);

    private static native void getFrameOffsetA(long var0, Transform var2);

    private static native void getFrameOffsetB(long var0, Transform var2);

    private static native float getHingeAngle(long var0);

    private static native float getLowerLimit(long var0);

    private static native float getMaxMotorImpulse(long var0);

    private static native float getMotorTargetVelocity(long var0);

    private static native float getUpperLimit(long var0);

    private static native void setAngularOnly(long var0, boolean var2);

    private static native void setLimit(long var0, float var2, float var3, float var4, float var5, float var6);
}

