/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.RotationOrder;
import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.joints.motors.MotorParam;
import com.jme3.bullet.joints.motors.RotationMotor;
import com.jme3.bullet.joints.motors.TranslationMotor;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public class New6Dof
extends Constraint {
    public static final Logger logger2 = Logger.getLogger(New6Dof.class.getName());
    private static final String tagDampingLimited = "_DampingLimited";
    private static final String tagMotorEnabled = "_MotorEnabled";
    private static final String tagRotA = "rotA";
    private static final String tagRotB = "rotB";
    private static final String tagRotOrder = "rotOrder";
    private static final String tagRotMotor = "rm";
    private static final String tagServoEnabled = "_ServoEnabled";
    private static final String tagSpringEnabled = "_SpringEnabled";
    private static final String tagStiffnessLimited = "_StiffnessLimited";
    private static final String tagTransMotor = "tm";
    private Matrix3f rotA;
    private Matrix3f rotB;
    private RotationMotor[] rotationMotor;
    private RotationOrder rotationOrder;
    private TranslationMotor translationMotor;

    protected New6Dof() {
    }

    public New6Dof(PhysicsRigidBody rigidBodyB, Vector3f pivotInB, Vector3f pivotInWorld, Matrix3f rotInB, Matrix3f rotInWorld, RotationOrder rotationOrder) {
        super(rigidBodyB, JointEnd.B, pivotInB, pivotInWorld);
        this.rotA = rotInWorld.clone();
        this.rotB = rotInB.clone();
        this.rotationOrder = rotationOrder;
        this.createConstraint();
    }

    public New6Dof(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInA, Vector3f pivotInB, Matrix3f rotInA, Matrix3f rotInB, RotationOrder rotationOrder) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, pivotInA, pivotInB);
        this.rotA = rotInA.clone();
        this.rotB = rotInB.clone();
        this.rotationOrder = rotationOrder;
        this.createConstraint();
    }

    public Matrix3f calculatedBasisA(Matrix3f storeResult) {
        Matrix3f result = storeResult == null ? new Matrix3f() : storeResult;
        long constraintId = this.nativeId();
        New6Dof.getCalculatedBasisA(constraintId, result);
        return result;
    }

    public Matrix3f calculatedBasisB(Matrix3f storeResult) {
        Matrix3f result = storeResult == null ? new Matrix3f() : storeResult;
        long constraintId = this.nativeId();
        New6Dof.getCalculatedBasisB(constraintId, result);
        return result;
    }

    public Vector3f calculatedOriginA(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long constraintId = this.nativeId();
        New6Dof.getCalculatedOriginA(constraintId, result);
        return result;
    }

    public Vector3f calculatedOriginB(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long constraintId = this.nativeId();
        New6Dof.getCalculatedOriginB(constraintId, result);
        return result;
    }

    public boolean checkRotationOrder() {
        long constraintId = this.nativeId();
        int rotOrder = New6Dof.getRotationOrder(constraintId);
        boolean result = rotOrder == this.rotationOrder.ordinal();
        return result;
    }

    public void enableSpring(int dofIndex, boolean onOff) {
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)5);
        long constraintId = this.nativeId();
        New6Dof.enableSpring(constraintId, dofIndex, onOff);
    }

    public float get(MotorParam parameter, int dofIndex) {
        float result;
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)5);
        if (dofIndex >= 3) {
            int axisIndex = dofIndex - 3;
            RotationMotor motor = this.getRotationMotor(axisIndex);
            result = motor.get(parameter);
        } else {
            TranslationMotor motor = this.getTranslationMotor();
            Vector3f vector = motor.get(parameter, null);
            result = vector.get(dofIndex);
        }
        return result;
    }

    public Vector3f getAngles(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long constraintId = this.nativeId();
        New6Dof.getAngles(constraintId, result);
        return result;
    }

    public Vector3f getAxis(int axisIndex, Vector3f storeResult) {
        Validate.axisIndex((int)axisIndex, (String)"axis index");
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long constraintId = this.nativeId();
        New6Dof.getAxis(constraintId, axisIndex, result);
        return result;
    }

    public Transform getFrameTransform(JointEnd end, Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        long constraintId = this.nativeId();
        switch (end) {
            case A: {
                New6Dof.getFrameOffsetA(constraintId, result);
                break;
            }
            case B: {
                New6Dof.getFrameOffsetB(constraintId, result);
                break;
            }
            default: {
                String message = "end = " + (Object)((Object)end);
                throw new IllegalArgumentException(message);
            }
        }
        return result;
    }

    public Vector3f getPivotOffset(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long constraintId = this.nativeId();
        New6Dof.getPivotOffset(constraintId, result);
        return result;
    }

    public Matrix3f getRotationMatrix(JointEnd end, Matrix3f storeResult) {
        Matrix3f result;
        Validate.nonNull((Object)((Object)end), (String)"end");
        Matrix3f matrix3f = result = storeResult == null ? new Matrix3f() : storeResult;
        if (end == JointEnd.A) {
            result.set(this.rotA);
        } else {
            assert (end == JointEnd.B) : end;
            result.set(this.rotB);
        }
        return result;
    }

    public RotationMotor getRotationMotor(int axisIndex) {
        Validate.axisIndex((int)axisIndex, (String)"axis index");
        return this.rotationMotor[axisIndex];
    }

    public RotationOrder getRotationOrder() {
        this.checkRotationOrder();
        assert (this.rotationOrder != null);
        return this.rotationOrder;
    }

    public TranslationMotor getTranslationMotor() {
        return this.translationMotor;
    }

    public boolean isMotorEnabled(int dofIndex) {
        boolean result;
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)5);
        if (dofIndex >= 3) {
            int axisIndex = dofIndex - 3;
            RotationMotor motor = this.getRotationMotor(axisIndex);
            result = motor.isMotorEnabled();
        } else {
            TranslationMotor motor = this.getTranslationMotor();
            result = motor.isMotorEnabled(dofIndex);
        }
        return result;
    }

    public boolean isServoEnabled(int dofIndex) {
        boolean result;
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)5);
        if (dofIndex >= 3) {
            int axisIndex = dofIndex - 3;
            RotationMotor motor = this.getRotationMotor(axisIndex);
            result = motor.isServoEnabled();
        } else {
            TranslationMotor motor = this.getTranslationMotor();
            result = motor.isServoEnabled(dofIndex);
        }
        return result;
    }

    public boolean isSpringEnabled(int dofIndex) {
        boolean result;
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)5);
        if (dofIndex >= 3) {
            int axisIndex = dofIndex - 3;
            RotationMotor motor = this.getRotationMotor(axisIndex);
            result = motor.isSpringEnabled();
        } else {
            TranslationMotor motor = this.getTranslationMotor();
            result = motor.isSpringEnabled(dofIndex);
        }
        return result;
    }

    public static New6Dof newInstance(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInWorld, Quaternion rotInWorld, RotationOrder rotationOrder) {
        Validate.nonNull((Object)rigidBodyA, (String)"a");
        Validate.nonNull((Object)rigidBodyB, (String)"b");
        Validate.finite((Vector3f)pivotInWorld, (String)"pivot location");
        Validate.nonZero((Quaternion)rotInWorld, (String)"pivot orientation");
        Validate.nonNull((Object)((Object)rotationOrder), (String)"rotation order");
        Transform tmpTransform = new Transform();
        rigidBodyA.getTransform(tmpTransform);
        tmpTransform.setScale(1.0f);
        tmpTransform = tmpTransform.invert();
        Transform p2a = new Transform(pivotInWorld, rotInWorld);
        MyMath.combine((Transform)p2a, (Transform)tmpTransform, (Transform)p2a);
        Vector3f pivotInA = p2a.getTranslation();
        Matrix3f rotInA = p2a.getRotation().toRotationMatrix();
        rigidBodyB.getTransform(tmpTransform);
        tmpTransform.setScale(1.0f);
        tmpTransform = tmpTransform.invert();
        Transform p2b = new Transform(pivotInWorld, rotInWorld);
        MyMath.combine((Transform)p2b, (Transform)tmpTransform, (Transform)p2b);
        Vector3f pivotInB = p2b.getTranslation();
        Matrix3f rotInB = p2b.getRotation().toRotationMatrix();
        New6Dof result = new New6Dof(rigidBodyA, rigidBodyB, pivotInA, pivotInB, rotInA, rotInB, rotationOrder);
        return result;
    }

    public void set(MotorParam parameter, int dofIndex, float value) {
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)5);
        if (dofIndex >= 3) {
            int axisIndex = dofIndex - 3;
            RotationMotor motor = this.getRotationMotor(axisIndex);
            motor.set(parameter, value);
        } else {
            TranslationMotor motor = this.getTranslationMotor();
            Vector3f vector = motor.get(parameter, null);
            vector.set(dofIndex, value);
            motor.set(parameter, vector);
        }
    }

    public void setDamping(int dofIndex, float damping, boolean limitIfNeeded) {
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)5);
        long constraintId = this.nativeId();
        New6Dof.setDamping(constraintId, dofIndex, damping, limitIfNeeded);
    }

    public void setEquilibriumPoint() {
        long constraintId = this.nativeId();
        New6Dof.setAllEquilibriumPointsToCurrent(constraintId);
    }

    public void setEquilibriumPoint(int dofIndex) {
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)5);
        long constraintId = this.nativeId();
        New6Dof.setEquilibriumPointToCurrent(constraintId, dofIndex);
    }

    public void setEquilibriumPoint(int dofIndex, float value) {
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)5);
        long constraintId = this.nativeId();
        New6Dof.setEquilibriumPoint(constraintId, dofIndex, value);
    }

    public void setRotationOrder(RotationOrder rotationOrder) {
        long constraintId = this.nativeId();
        int rotOrder = rotationOrder.ordinal();
        New6Dof.setRotationOrder(constraintId, rotOrder);
    }

    public void setStiffness(int dofIndex, float stiffness, boolean limitIfNeeded) {
        Validate.inRange((int)dofIndex, (String)"DOF index", (int)0, (int)5);
        long constraintId = this.nativeId();
        New6Dof.setStiffness(constraintId, dofIndex, stiffness, limitIfNeeded);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        assert (!this.hasAssignedNativeObject());
        New6Dof old = (New6Dof)original;
        assert (old != this);
        assert (old.hasAssignedNativeObject());
        super.cloneFields(cloner, original);
        if (this.hasAssignedNativeObject()) {
            return;
        }
        this.rotA = (Matrix3f)cloner.clone((Object)this.rotA);
        this.rotB = (Matrix3f)cloner.clone((Object)this.rotB);
        this.rotationMotor = null;
        this.translationMotor = null;
        this.createConstraint();
        this.copyConstraintProperties(old);
        for (int i = 0; i < 3; ++i) {
            RotationMotor motor = this.getRotationMotor(i);
            RotationMotor oldMotor = old.getRotationMotor(i);
            motor.setDampingLimited(oldMotor.isDampingLimited());
            motor.setMotorEnabled(oldMotor.isMotorEnabled());
            motor.setServoEnabled(oldMotor.isServoEnabled());
            motor.setSpringEnabled(oldMotor.isSpringEnabled());
            motor.setStiffnessLimited(oldMotor.isStiffnessLimited());
            MotorParam[] motorParamArray = MotorParam.values();
            int n = motorParamArray.length;
            for (int j = 0; j < n; ++j) {
                MotorParam p = motorParamArray[j];
                motor.set(p, oldMotor.get(p));
            }
        }
        TranslationMotor motor = this.getTranslationMotor();
        TranslationMotor oldMotor = old.getTranslationMotor();
        for (int i = 0; i < 3; ++i) {
            motor.setDampingLimited(i, oldMotor.isDampingLimited(i));
            motor.setMotorEnabled(i, oldMotor.isMotorEnabled(i));
            motor.setServoEnabled(i, oldMotor.isServoEnabled(i));
            motor.setSpringEnabled(i, oldMotor.isSpringEnabled(i));
            motor.setStiffnessLimited(i, oldMotor.isStiffnessLimited(i));
        }
        for (MotorParam p : MotorParam.values()) {
            motor.set(p, oldMotor.get(p, null));
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.rotA = (Matrix3f)capsule.readSavable(tagRotA, null);
        this.rotB = (Matrix3f)capsule.readSavable(tagRotB, null);
        this.rotationOrder = (RotationOrder)capsule.readEnum(tagRotOrder, RotationOrder.class, (Enum)RotationOrder.XYZ);
        this.createConstraint();
        this.readConstraintProperties(capsule);
        for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
            RotationMotor motor = this.getRotationMotor(axisIndex);
            String motorTag = tagRotMotor + axisIndex;
            motor.setDampingLimited(capsule.readBoolean(motorTag + tagDampingLimited, false));
            motor.setMotorEnabled(capsule.readBoolean(motorTag + tagMotorEnabled, false));
            motor.setServoEnabled(capsule.readBoolean(motorTag + tagServoEnabled, false));
            motor.setSpringEnabled(capsule.readBoolean(motorTag + tagSpringEnabled, false));
            motor.setStiffnessLimited(capsule.readBoolean(motorTag + tagStiffnessLimited, false));
            MotorParam[] motorParamArray = MotorParam.values();
            int n = motorParamArray.length;
            for (int i = 0; i < n; ++i) {
                MotorParam param = motorParamArray[i];
                String tag = motorTag + param.tagSuffix();
                float defaultValue = param.defaultForRotationMotor();
                float value = capsule.readFloat(tag, defaultValue);
                motor.set(param, value);
            }
        }
        TranslationMotor motor = this.translationMotor;
        String motorTag = tagTransMotor;
        for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
            motor.setDampingLimited(axisIndex, capsule.readBoolean(motorTag + tagDampingLimited + axisIndex, false));
            motor.setMotorEnabled(axisIndex, capsule.readBoolean(motorTag + tagMotorEnabled + axisIndex, false));
            motor.setServoEnabled(axisIndex, capsule.readBoolean(motorTag + tagServoEnabled + axisIndex, false));
            motor.setSpringEnabled(axisIndex, capsule.readBoolean(motorTag + tagSpringEnabled + axisIndex, false));
            motor.setStiffnessLimited(axisIndex, capsule.readBoolean(motorTag + tagStiffnessLimited + axisIndex, false));
        }
        for (MotorParam p : MotorParam.values()) {
            String tag = motorTag + p.tagSuffix();
            float def = p.defaultForRotationMotor();
            Vector3f defaultVector = new Vector3f(def, def, def);
            Savable value = capsule.readSavable(tag, (Savable)defaultVector);
            motor.set(p, (Vector3f)value);
        }
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.rotA, tagRotA, null);
        capsule.write((Savable)this.rotB, tagRotB, null);
        capsule.write((Enum)this.rotationOrder, tagRotOrder, (Enum)RotationOrder.XYZ);
        for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
            RotationMotor motor = this.rotationMotor[axisIndex];
            String motorTag = tagRotMotor + axisIndex;
            capsule.write(motor.isDampingLimited(), motorTag + tagDampingLimited, false);
            capsule.write(motor.isMotorEnabled(), motorTag + tagMotorEnabled, false);
            capsule.write(motor.isServoEnabled(), motorTag + tagServoEnabled, false);
            capsule.write(motor.isSpringEnabled(), motorTag + tagSpringEnabled, false);
            capsule.write(motor.isStiffnessLimited(), motorTag + tagStiffnessLimited, false);
            MotorParam[] motorParamArray = MotorParam.values();
            int n = motorParamArray.length;
            for (int i = 0; i < n; ++i) {
                MotorParam param = motorParamArray[i];
                float value = motor.get(param);
                String tag = motorTag + param.tagSuffix();
                float defaultValue = param.defaultForRotationMotor();
                capsule.write(value, tag, defaultValue);
            }
        }
        TranslationMotor motor = this.translationMotor;
        String motorTag = tagTransMotor;
        for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
            capsule.write(motor.isDampingLimited(axisIndex), motorTag + tagDampingLimited + axisIndex, false);
            capsule.write(motor.isMotorEnabled(axisIndex), motorTag + tagMotorEnabled + axisIndex, false);
            capsule.write(motor.isServoEnabled(axisIndex), motorTag + tagServoEnabled + axisIndex, false);
            capsule.write(motor.isSpringEnabled(axisIndex), motorTag + tagSpringEnabled + axisIndex, false);
            capsule.write(motor.isStiffnessLimited(axisIndex), motorTag + tagStiffnessLimited + axisIndex, false);
        }
        for (MotorParam param : MotorParam.values()) {
            Vector3f values = motor.get(param, null);
            String tag = motorTag + param.tagSuffix();
            capsule.write((Savable)values, tag, null);
        }
    }

    private void createConstraint() {
        long constraintId;
        PhysicsRigidBody a = this.getBodyA();
        assert (this.pivotA != null);
        assert (this.rotA != null);
        PhysicsRigidBody b = this.getBodyB();
        long bId = b.nativeId();
        assert (this.pivotB != null);
        assert (this.rotB != null);
        int rotOrder = this.rotationOrder.ordinal();
        if (a == null) {
            Transform jInWorld = new Transform();
            jInWorld.getRotation().fromRotationMatrix(this.rotA);
            jInWorld.setTranslation(this.pivotA);
            Transform jInB = new Transform();
            jInB.getRotation().fromRotationMatrix(this.rotB);
            jInB.setTranslation(this.pivotB);
            Transform bToWorld = jInB.invert();
            MyMath.combine((Transform)bToWorld, (Transform)jInWorld, (Transform)bToWorld);
            Vector3f saveLocation = b.getPhysicsLocation(null);
            Quaternion saveRotation = b.getPhysicsRotation(null);
            b.setPhysicsLocation(bToWorld.getTranslation());
            b.setPhysicsRotation(bToWorld.getRotation());
            constraintId = New6Dof.createSingleEnded(bId, this.pivotB, this.rotB, rotOrder);
            b.setPhysicsLocation(saveLocation);
            b.setPhysicsRotation(saveRotation);
        } else {
            long aId = a.nativeId();
            constraintId = New6Dof.createDoubleEnded(aId, bId, this.pivotA, this.rotA, this.pivotB, this.rotB, rotOrder);
            if (logger2.isLoggable(Level.INFO)) {
                logger2.log(Level.INFO, "Created {0} with A={1} B={2}", new Object[]{Long.toHexString(constraintId), Long.toHexString(aId), Long.toHexString(bId)});
            }
        }
        assert (New6Dof.getConstraintType(constraintId) == 12);
        this.setNativeId(constraintId);
        this.gatherMotors();
    }

    private void gatherMotors() {
        assert (this.rotationMotor == null);
        assert (this.translationMotor == null);
        long constraintId = this.nativeId();
        this.rotationMotor = new RotationMotor[3];
        for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
            long motorId = New6Dof.getRotationalMotor(constraintId, axisIndex);
            this.rotationMotor[axisIndex] = new RotationMotor(motorId);
        }
        long motorId = New6Dof.getTranslationalMotor(constraintId);
        this.translationMotor = new TranslationMotor(motorId);
    }

    private static native long createDoubleEnded(long var0, long var2, Vector3f var4, Matrix3f var5, Vector3f var6, Matrix3f var7, int var8);

    private static native long createSingleEnded(long var0, Vector3f var2, Matrix3f var3, int var4);

    private static native void enableSpring(long var0, int var2, boolean var3);

    private static native void getAngles(long var0, Vector3f var2);

    private static native void getAxis(long var0, int var2, Vector3f var3);

    private static native void getCalculatedBasisA(long var0, Matrix3f var2);

    private static native void getCalculatedBasisB(long var0, Matrix3f var2);

    private static native void getCalculatedOriginA(long var0, Vector3f var2);

    private static native void getCalculatedOriginB(long var0, Vector3f var2);

    private static native void getFrameOffsetA(long var0, Transform var2);

    private static native void getFrameOffsetB(long var0, Transform var2);

    private static native void getPivotOffset(long var0, Vector3f var2);

    private static native long getRotationalMotor(long var0, int var2);

    private static native int getRotationOrder(long var0);

    private static native long getTranslationalMotor(long var0);

    private static native void setAllEquilibriumPointsToCurrent(long var0);

    private static native void setDamping(long var0, int var2, float var3, boolean var4);

    private static native void setEquilibriumPoint(long var0, int var2, float var3);

    private static native void setEquilibriumPointToCurrent(long var0, int var2);

    private static native void setRotationOrder(long var0, int var2);

    private static native void setStiffness(long var0, int var2, float var3, boolean var4);
}

