/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.RotationOrder;
import com.jme3.bullet.joints.New6Dof;
import com.jme3.bullet.joints.motors.MotorParam;
import com.jme3.bullet.joints.motors.RotationMotor;
import com.jme3.bullet.joints.motors.TranslationMotor;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.math.MyMath;

public class NewHinge
extends New6Dof {
    public static final Logger logger3 = Logger.getLogger(NewHinge.class.getName());
    private static final String tagAxis1 = "axis1";
    private static final String tagAxis2 = "axis2";
    private Vector3f axis1;
    private Vector3f axis2;

    protected NewHinge() {
    }

    public NewHinge(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f anchor, Vector3f axis1, Vector3f axis2) {
        super(rigidBodyA, rigidBodyB, NewHinge.pivotInBody(rigidBodyA, anchor), NewHinge.pivotInBody(rigidBodyB, anchor), NewHinge.rotInBody(rigidBodyA, axis1, axis2), NewHinge.rotInBody(rigidBodyB, axis1, axis2), RotationOrder.XYZ);
        this.axis1 = axis1.clone();
        this.axis2 = axis2.clone();
        TranslationMotor translation = super.getTranslationMotor();
        translation.set(MotorParam.LowerLimit, new Vector3f(0.0f, 0.0f, -1.0f));
        translation.set(MotorParam.UpperLimit, new Vector3f(0.0f, 0.0f, 1.0f));
        this.setLowerLimit(-0.7853982f);
        this.setUpperLimit(0.7853982f);
        super.enableSpring(2, true);
        super.set(MotorParam.Damping, 2, 0.01f);
        float stiffness = 39.47842f;
        super.set(MotorParam.Stiffness, 2, stiffness);
        super.setEquilibriumPoint();
    }

    public Vector3f getAnchor(Vector3f storeResult) {
        Vector3f result = this.calculatedOriginA(storeResult);
        return result;
    }

    public Vector3f getAnchor2(Vector3f storeResult) {
        Vector3f result = this.calculatedOriginB(storeResult);
        return result;
    }

    public float getAngle1() {
        Vector3f angles = this.getAngles(null);
        float result = angles.z;
        return result;
    }

    public float getAngle2() {
        Vector3f angles = this.getAngles(null);
        float result = angles.x;
        return result;
    }

    public Vector3f getAxis1(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.axis1.clone() : storeResult.set(this.axis1);
        return result;
    }

    public Vector3f getAxis2(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.axis2.clone() : storeResult.set(this.axis2);
        return result;
    }

    public final void setLowerLimit(float angle1Min) {
        RotationMotor xMotor = this.getRotationMotor(0);
        xMotor.set(MotorParam.LowerLimit, 1.0f);
        RotationMotor yMotor = this.getRotationMotor(1);
        yMotor.set(MotorParam.LowerLimit, 0.0f);
        RotationMotor zMotor = this.getRotationMotor(2);
        zMotor.set(MotorParam.LowerLimit, angle1Min);
    }

    public final void setUpperLimit(float angle1Max) {
        RotationMotor xMotor = this.getRotationMotor(0);
        xMotor.set(MotorParam.UpperLimit, -1.0f);
        RotationMotor yMotor = this.getRotationMotor(1);
        yMotor.set(MotorParam.UpperLimit, 0.0f);
        RotationMotor zMotor = this.getRotationMotor(2);
        zMotor.set(MotorParam.UpperLimit, angle1Max);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        assert (!this.hasAssignedNativeObject());
        NewHinge old = (NewHinge)original;
        assert (old != this);
        assert (old.hasAssignedNativeObject());
        super.cloneFields(cloner, original);
        if (this.hasAssignedNativeObject()) {
            return;
        }
        this.axis1 = (Vector3f)cloner.clone((Object)this.axis1);
        this.axis2 = (Vector3f)cloner.clone((Object)this.axis2);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.axis1 = (Vector3f)capsule.readSavable(tagAxis1, null);
        this.axis2 = (Vector3f)capsule.readSavable(tagAxis2, null);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.axis1, tagAxis1, null);
        capsule.write((Savable)this.axis2, tagAxis2, null);
    }

    private static Vector3f pivotInBody(PhysicsRigidBody body, Vector3f anchor) {
        Transform bodyToWorld = body.getTransform(null);
        bodyToWorld.setScale(1.0f);
        Vector3f result = MyMath.transformInverse((Transform)bodyToWorld, (Vector3f)anchor, null);
        return result;
    }

    private static Matrix3f rotInBody(PhysicsRigidBody body, Vector3f axis1, Vector3f axis2) {
        Vector3f zAxis = axis1.normalize();
        Vector3f xAxis = axis2.normalize();
        Vector3f yAxis = zAxis.cross(xAxis);
        Matrix3f frameInW = new Matrix3f();
        frameInW.fromAxes(xAxis, yAxis, zAxis);
        Matrix3f rotation = body.getPhysicsRotationMatrix(null);
        rotation.invert(null);
        Matrix3f result = rotation.mult(frameInW, null);
        return result;
    }
}

