/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public class Point2PointJoint
extends Constraint {
    public static final Logger logger2 = Logger.getLogger(Point2PointJoint.class.getName());
    private static final String tagDamping = "damping";
    private static final String tagImpulseClamp = "impulseClamp";
    private static final String tagTau = "tau";

    protected Point2PointJoint() {
    }

    public Point2PointJoint(PhysicsRigidBody rigidBodyA, Vector3f pivotInA) {
        super(rigidBodyA, JointEnd.A, pivotInA);
        this.createJoint();
    }

    public Point2PointJoint(PhysicsRigidBody rigidBodyA, Vector3f pivotInA, Vector3f pivotInWorld) {
        super(rigidBodyA, JointEnd.A, pivotInA, pivotInWorld);
        this.createJoint();
    }

    public Point2PointJoint(PhysicsRigidBody rigidBodyA, PhysicsRigidBody rigidBodyB, Vector3f pivotInA, Vector3f pivotInB) {
        super((PhysicsBody)rigidBodyA, rigidBodyB, pivotInA, pivotInB);
        this.createJoint();
    }

    public float getDamping() {
        long constraintId = this.nativeId();
        float result = Point2PointJoint.getDamping(constraintId);
        return result;
    }

    public float getImpulseClamp() {
        long constraintId = this.nativeId();
        float result = Point2PointJoint.getImpulseClamp(constraintId);
        return result;
    }

    public float getTau() {
        long constraintId = this.nativeId();
        float result = Point2PointJoint.getTau(constraintId);
        return result;
    }

    public void setDamping(float value) {
        long constraintId = this.nativeId();
        Point2PointJoint.setDamping(constraintId, value);
    }

    public void setImpulseClamp(float value) {
        long constraintId = this.nativeId();
        Point2PointJoint.setImpulseClamp(constraintId, value);
    }

    public void setTau(float value) {
        long constraintId = this.nativeId();
        Point2PointJoint.setTau(constraintId, value);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        assert (!this.hasAssignedNativeObject());
        Point2PointJoint old = (Point2PointJoint)original;
        assert (old != this);
        assert (old.hasAssignedNativeObject());
        super.cloneFields(cloner, original);
        if (this.hasAssignedNativeObject()) {
            return;
        }
        this.createJoint();
        this.copyConstraintProperties(old);
        this.setDamping(old.getDamping());
        this.setImpulseClamp(old.getImpulseClamp());
        this.setTau(old.getTau());
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.createJoint();
        this.readConstraintProperties(capsule);
        this.setDamping(capsule.readFloat(tagDamping, 1.0f));
        this.setTau(capsule.readFloat(tagTau, 0.3f));
        this.setImpulseClamp(capsule.readFloat(tagImpulseClamp, 0.0f));
    }

    @Override
    public void setPivotInA(Vector3f location) {
        Validate.nonNull((Object)location, (String)"location");
        long constraintId = this.nativeId();
        Point2PointJoint.setPivotInA(constraintId, location);
        super.setPivotInA(location);
    }

    @Override
    public void setPivotInB(Vector3f location) {
        Validate.nonNull((Object)location, (String)"location");
        if (this.pivotB == null) {
            throw new IllegalStateException("The Point2PointJoint doesn't have a B end.");
        }
        long constraintId = this.nativeId();
        Point2PointJoint.setPivotInB(constraintId, location);
        super.setPivotInB(location);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.getDamping(), tagDamping, 1.0f);
        capsule.write(this.getTau(), tagTau, 0.3f);
        capsule.write(this.getImpulseClamp(), tagImpulseClamp, 0.0f);
    }

    private void createJoint() {
        long constraintId;
        PhysicsRigidBody a = this.getBodyA();
        long aId = a.nativeId();
        assert (this.pivotA != null);
        PhysicsRigidBody b = this.getBodyB();
        if (b == null) {
            if (this.pivotB == null) {
                constraintId = Point2PointJoint.createJoint1(aId, this.pivotA);
            } else {
                Vector3f saveLocation = a.getPhysicsLocation(null);
                Transform localToWorld = new Transform();
                localToWorld.setTranslation(saveLocation);
                a.getPhysicsRotation(localToWorld.getRotation());
                Vector3f pivotAWorld = MyMath.transform((Transform)localToWorld, (Vector3f)this.pivotA, null);
                Vector3f worldOffset = this.pivotB.subtract(pivotAWorld);
                Vector3f tempLocation = saveLocation.add(worldOffset);
                a.setPhysicsLocation(tempLocation);
                constraintId = Point2PointJoint.createJoint1(aId, this.pivotA);
                a.setPhysicsLocation(saveLocation);
            }
        } else {
            assert (this.pivotB != null);
            long bId = b.nativeId();
            constraintId = Point2PointJoint.createJoint(aId, bId, this.pivotA, this.pivotB);
        }
        assert (Point2PointJoint.getConstraintType(constraintId) == 3);
        this.setNativeId(constraintId);
    }

    private static native long createJoint(long var0, long var2, Vector3f var4, Vector3f var5);

    private static native long createJoint1(long var0, Vector3f var2);

    private static native float getDamping(long var0);

    private static native float getImpulseClamp(long var0);

    private static native void getPivotInA(long var0, Vector3f var2);

    private static native void getPivotInB(long var0, Vector3f var2);

    private static native float getTau(long var0);

    private static native void setDamping(long var0, float var2);

    private static native void setImpulseClamp(long var0, float var2);

    private static native void setPivotInA(long var0, Vector3f var2);

    private static native void setPivotInB(long var0, Vector3f var2);

    private static native void setTau(long var0, float var2);
}

