/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bounding.BoundingBox;
import com.jme3.bullet.SoftBodyWorldInfo;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.infos.Cluster;
import com.jme3.bullet.objects.infos.SoftBodyConfig;
import com.jme3.bullet.objects.infos.SoftBodyMaterial;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.clone.Cloner;
import com.simsilica.mathd.Matrix3d;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MeshNormals;
import jme3utilities.Validate;
import jme3utilities.math.MyBuffer;

public class PhysicsSoftBody
extends PhysicsBody {
    private static final int numAxes = 3;
    private static final int vpe = 2;
    private static final int vpt = 3;
    public static final Logger logger2 = Logger.getLogger(PhysicsSoftBody.class.getName());
    private static final String tagConfig = "config";
    private static final String tagFaceIndices = "faceIndices";
    private static final String tagIndices = "indices";
    private static final String tagIsWorldInfoProtected = "isWorldInfoProtected";
    private static final String tagLinkIndices = "linkIndices";
    private static final String tagMaterial = "material";
    private static final String tagNodeLocations = "nodeLocations";
    private static final String tagNodeMasses = "nodeMasses";
    private static final String tagNodeNormals = "nodeNormals";
    private static final String tagNodeVelocities = "nodeVelocities";
    private static final String tagNumClusters = "numClusters";
    private static final String tagPhysicsLocation = "physicsLocation";
    private static final String tagRestLengthScale = "restLengthScale";
    private static final String tagTetraIndices = "tetraIndices";
    private static final String tagWorldInfo = "worldInfo";
    private boolean isWorldInfoProtected = false;
    private SoftBodyConfig config;
    private SoftBodyMaterial material = null;
    private SoftBodyWorldInfo worldInfo = new SoftBodyWorldInfo();

    public PhysicsSoftBody() {
        long infoId = this.worldInfo.nativeId();
        long bodyId = PhysicsSoftBody.createEmpty(infoId);
        super.setNativeId(bodyId);
        assert (PhysicsSoftBody.getInternalType(bodyId) == 8) : PhysicsSoftBody.getInternalType(bodyId);
        logger2.log(Level.FINE, "Created {0}.", this);
        this.config = new SoftBodyConfig(this);
        super.initUserPointer();
        float defaultMargin = CollisionShape.getDefaultMargin();
        this.setMargin(defaultMargin);
        assert (!this.isInWorld());
        assert (this.isEmpty());
    }

    public void addVelocity(Vector3f velocity) {
        Validate.finite((Vector3f)velocity, (String)"velocity");
        long objectId = this.nativeId();
        PhysicsSoftBody.addVelocity(objectId, velocity);
    }

    public void addVelocity(Vector3f velocity, int nodeIndex) {
        Validate.finite((Vector3f)velocity, (String)"velocity");
        int numNodes = this.countNodes();
        Validate.inRange((int)nodeIndex, (String)"node index", (int)0, (int)(numNodes - 1));
        long objectId = this.nativeId();
        PhysicsSoftBody.addVelocity(objectId, velocity, nodeIndex);
    }

    public void appendFaces(IndexBuffer nodeIndices) {
        if (!nodeIndices.getBuffer().isDirect()) {
            throw new IllegalArgumentException("The buffer must be direct.");
        }
        if (nodeIndices.size() % 3 != 0) {
            throw new IllegalArgumentException("The number of indices must be a multiple of 3.");
        }
        long objectId = this.nativeId();
        int numFaces = nodeIndices.size() / 3;
        Buffer buffer = nodeIndices.getBuffer();
        if (buffer instanceof ByteBuffer) {
            PhysicsSoftBody.appendFaces(objectId, numFaces, (ByteBuffer)buffer);
        } else if (buffer instanceof ShortBuffer) {
            PhysicsSoftBody.appendFaces(objectId, numFaces, (ShortBuffer)buffer);
        } else if (buffer instanceof IntBuffer) {
            PhysicsSoftBody.appendFaces(objectId, numFaces, (IntBuffer)buffer);
        } else {
            throw new IllegalArgumentException(buffer.getClass().getSimpleName());
        }
    }

    public void appendLinks(IndexBuffer nodeIndices) {
        if (!nodeIndices.getBuffer().isDirect()) {
            throw new IllegalArgumentException("The buffer must be direct.");
        }
        if (nodeIndices.size() % 2 != 0) {
            throw new IllegalArgumentException("The number of indices must be a multiple of 2.");
        }
        long objectId = this.nativeId();
        int numLinks = nodeIndices.size() / 2;
        Buffer buffer = nodeIndices.getBuffer();
        if (buffer instanceof ByteBuffer) {
            PhysicsSoftBody.appendLinks(objectId, numLinks, (ByteBuffer)buffer);
        } else if (buffer instanceof ShortBuffer) {
            PhysicsSoftBody.appendLinks(objectId, numLinks, (ShortBuffer)buffer);
        } else if (buffer instanceof IntBuffer) {
            PhysicsSoftBody.appendLinks(objectId, numLinks, (IntBuffer)buffer);
        } else {
            throw new IllegalArgumentException(buffer.getClass().getSimpleName());
        }
    }

    public void appendNodes(FloatBuffer nodeLocations) {
        Validate.nonNull((Object)nodeLocations, (String)"node locations");
        Validate.require((boolean)nodeLocations.isDirect(), (String)"direct buffer");
        Validate.require((nodeLocations.limit() % 3 == 0 ? 1 : 0) != 0, (String)"limit a multiple of 3");
        long objectId = this.nativeId();
        int numNodes = nodeLocations.limit() / 3;
        PhysicsSoftBody.appendNodes(objectId, numNodes, nodeLocations);
    }

    public void appendTetras(IndexBuffer tetrahedra) {
        if (!tetrahedra.getBuffer().isDirect()) {
            throw new IllegalArgumentException("The buffer must be direct.");
        }
        if (tetrahedra.size() % 4 != 0) {
            throw new IllegalArgumentException("The number of indices must be a multiple of 4.");
        }
        long objectId = this.nativeId();
        int numTetras = tetrahedra.size() / 4;
        Buffer buffer = tetrahedra.getBuffer();
        if (buffer instanceof ByteBuffer) {
            PhysicsSoftBody.appendTetras(objectId, numTetras, (ByteBuffer)buffer);
        } else if (buffer instanceof ShortBuffer) {
            PhysicsSoftBody.appendTetras(objectId, numTetras, (ShortBuffer)buffer);
        } else if (buffer instanceof IntBuffer) {
            PhysicsSoftBody.appendTetras(objectId, numTetras, (IntBuffer)buffer);
        } else {
            throw new IllegalArgumentException(buffer.getClass().getSimpleName());
        }
    }

    public void applyForce(Vector3f force) {
        Validate.finite((Vector3f)force, (String)"force");
        long objectId = this.nativeId();
        PhysicsSoftBody.addForce(objectId, force);
    }

    public void applyForce(Vector3f force, int nodeIndex) {
        Validate.finite((Vector3f)force, (String)"force");
        int numNodes = this.countNodes();
        Validate.inRange((int)nodeIndex, (String)"node index", (int)0, (int)(numNodes - 1));
        long objectId = this.nativeId();
        PhysicsSoftBody.addForce(objectId, force, nodeIndex);
    }

    public void applyRotation(Quaternion rotation) {
        Validate.nonNull((Object)rotation, (String)"rotation");
        long objectId = this.nativeId();
        PhysicsSoftBody.applyPhysicsRotation(objectId, rotation);
    }

    public void applyScale(Vector3f factors) {
        Validate.finite((Vector3f)factors, (String)"factors");
        long objectId = this.nativeId();
        PhysicsSoftBody.applyPhysicsScale(objectId, factors);
    }

    public void applyTransform(Transform transform) {
        Validate.nonNull((Object)transform, (String)"transform");
        long objectId = this.nativeId();
        PhysicsSoftBody.applyPhysicsTransform(objectId, transform);
    }

    public void applyTranslation(Vector3f offset) {
        Validate.finite((Vector3f)offset, (String)"offset");
        long objectId = this.nativeId();
        PhysicsSoftBody.applyPhysicsTranslate(objectId, offset);
    }

    public Vector3f clusterCenter(int clusterIndex, Vector3f storeResult) {
        int numClusters = this.countClusters();
        Validate.inRange((int)clusterIndex, (String)"cluster index", (int)0, (int)(numClusters - 1));
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsSoftBody.getClusterCenter(objectId, clusterIndex, result);
        return result;
    }

    public FloatBuffer copyClusterCenters(FloatBuffer storeResult) {
        if (storeResult != null && !storeResult.isDirect()) {
            throw new IllegalArgumentException("The buffer must be direct.");
        }
        int numFloats = 3 * this.countClusters();
        FloatBuffer result = MyBuffer.ensureCapacity((int)numFloats, (FloatBuffer)storeResult);
        if (numFloats != 0) {
            long objectId = this.nativeId();
            PhysicsSoftBody.getClustersPositions(objectId, result);
        }
        return result;
    }

    public FloatBuffer copyClusterMasses(FloatBuffer storeResult) {
        if (storeResult != null && !storeResult.isDirect()) {
            throw new IllegalArgumentException("The buffer must be direct.");
        }
        int numFloats = this.countClusters();
        FloatBuffer result = MyBuffer.ensureCapacity((int)numFloats, (FloatBuffer)storeResult);
        if (numFloats != 0) {
            long objectId = this.nativeId();
            PhysicsSoftBody.getClustersMasses(objectId, result);
        }
        return result;
    }

    public FloatBuffer copyClusterVelocities(FloatBuffer storeResult) {
        if (storeResult != null && !storeResult.isDirect()) {
            throw new IllegalArgumentException("The buffer must be direct.");
        }
        int numFloats = 3 * this.countClusters();
        FloatBuffer result = MyBuffer.ensureCapacity((int)numFloats, (FloatBuffer)storeResult);
        if (numFloats != 0) {
            long objectId = this.nativeId();
            PhysicsSoftBody.getClustersLinearVelocities(objectId, result);
        }
        return result;
    }

    public IntBuffer copyFaces(IntBuffer storeResult) {
        IntBuffer result;
        int numInts = 3 * this.countFaces();
        if (storeResult == null) {
            result = BufferUtils.createIntBuffer((int)numInts);
        } else {
            assert (storeResult.isDirect());
            assert (storeResult.capacity() == numInts);
            result = storeResult;
        }
        if (numInts != 0) {
            long objectId = this.nativeId();
            PhysicsSoftBody.getFacesIndexes(objectId, result);
        }
        return result;
    }

    public IntBuffer copyLinks(IntBuffer storeResult) {
        IntBuffer result;
        int numInts = 2 * this.countLinks();
        if (storeResult == null) {
            result = BufferUtils.createIntBuffer((int)numInts);
        } else {
            assert (storeResult.isDirect());
            assert (storeResult.capacity() == numInts);
            result = storeResult;
        }
        if (numInts != 0) {
            long objectId = this.nativeId();
            PhysicsSoftBody.getLinksIndexes(objectId, result);
        }
        return result;
    }

    public FloatBuffer copyLocations(FloatBuffer storeResult) {
        if (storeResult != null && !storeResult.isDirect()) {
            throw new IllegalArgumentException("The buffer must be direct.");
        }
        int numFloats = 3 * this.countNodes();
        FloatBuffer result = MyBuffer.ensureCapacity((int)numFloats, (FloatBuffer)storeResult);
        if (numFloats != 0) {
            long objectId = this.nativeId();
            PhysicsSoftBody.getNodesPositions(objectId, result);
        }
        return result;
    }

    public FloatBuffer copyMasses(FloatBuffer storeResult) {
        if (storeResult != null && !storeResult.isDirect()) {
            throw new IllegalArgumentException("The buffer must be direct.");
        }
        int numFloats = this.countNodes();
        FloatBuffer result = MyBuffer.ensureCapacity((int)numFloats, (FloatBuffer)storeResult);
        if (numFloats != 0) {
            long objectId = this.nativeId();
            PhysicsSoftBody.getMasses(objectId, result);
        }
        return result;
    }

    public FloatBuffer copyNormals(FloatBuffer storeResult) {
        if (storeResult != null && !storeResult.isDirect()) {
            throw new IllegalArgumentException("The buffer must be direct.");
        }
        int numFloats = 3 * this.countNodes();
        FloatBuffer result = MyBuffer.ensureCapacity((int)numFloats, (FloatBuffer)storeResult);
        if (numFloats != 0) {
            long objectId = this.nativeId();
            PhysicsSoftBody.getNodesNormals(objectId, result);
        }
        return result;
    }

    public IntBuffer copyTetras(IntBuffer storeResult) {
        IntBuffer result;
        int numInts = 4 * this.countTetras();
        if (storeResult == null) {
            result = BufferUtils.createIntBuffer((int)numInts);
        } else {
            assert (storeResult.isDirect());
            assert (storeResult.capacity() == numInts);
            result = storeResult;
        }
        if (numInts != 0) {
            long objectId = this.nativeId();
            PhysicsSoftBody.getTetrasIndexes(objectId, result);
        }
        return result;
    }

    public FloatBuffer copyVelocities(FloatBuffer storeResult) {
        if (storeResult != null && !storeResult.isDirect()) {
            throw new IllegalArgumentException("The buffer must be direct.");
        }
        int numFloats = 3 * this.countNodes();
        FloatBuffer result = MyBuffer.ensureCapacity((int)numFloats, (FloatBuffer)storeResult);
        if (numFloats != 0) {
            long objectId = this.nativeId();
            PhysicsSoftBody.getNodesVelocities(objectId, result);
        }
        return result;
    }

    public final int countClusters() {
        long objectId = this.nativeId();
        int result = PhysicsSoftBody.getClusterCount(objectId);
        return result;
    }

    public final int countFaces() {
        long objectId = this.nativeId();
        int result = PhysicsSoftBody.getNbFaces(objectId);
        return result;
    }

    public final int countLinks() {
        long objectId = this.nativeId();
        int result = PhysicsSoftBody.getNbLinks(objectId);
        return result;
    }

    public final int countNodes() {
        long objectId = this.nativeId();
        int result = PhysicsSoftBody.getNbNodes(objectId);
        return result;
    }

    public int countNodesInCluster(int clusterIndex) {
        int numClusters = this.countClusters();
        Validate.inRange((int)clusterIndex, (String)"cluster index", (int)0, (int)(numClusters - 1));
        long objectId = this.nativeId();
        int result = PhysicsSoftBody.countNodesInCluster(objectId, clusterIndex);
        return result;
    }

    public final int countPinnedNodes() {
        long objectId = this.nativeId();
        int result = PhysicsSoftBody.getNbPinnedNodes(objectId);
        return result;
    }

    public final int countTetras() {
        long objectId = this.nativeId();
        int result = PhysicsSoftBody.getNbTetras(objectId);
        return result;
    }

    public boolean cutLink(int nodeIndex0, int nodeIndex1, float cutLocation) {
        int numNodes = this.countNodes();
        Validate.inRange((int)nodeIndex0, (String)"node index 0", (int)0, (int)(numNodes - 1));
        Validate.inRange((int)nodeIndex1, (String)"node index 1", (int)0, (int)(numNodes - 1));
        long objectId = this.nativeId();
        boolean result = PhysicsSoftBody.cutLink(objectId, nodeIndex0, nodeIndex1, cutLocation);
        return result;
    }

    public void generateBendingConstraints(int numHops, SoftBodyMaterial material) {
        Validate.inRange((int)numHops, (String)"number of hops", (int)2, (int)Integer.MAX_VALUE);
        long objectId = this.nativeId();
        long materialId = material.nativeId();
        PhysicsSoftBody.generateBendingConstraints(objectId, numHops, materialId);
    }

    public void generateClusters() {
        long objectId = this.nativeId();
        PhysicsSoftBody.generateClusters(objectId, 0, 8192);
    }

    public void generateClusters(int k, int maxIterations) {
        int numNodes = this.countNodes();
        Validate.inRange((int)k, (String)"k", (int)1, (int)numNodes);
        Validate.positive((int)maxIterations, (String)"maximum number of iterations");
        long objectId = this.nativeId();
        PhysicsSoftBody.generateClusters(objectId, k, maxIterations);
    }

    public float get(Cluster parameter, int clusterIndex) {
        float result;
        int numClusters = this.countClusters();
        Validate.inRange((int)clusterIndex, (String)"cluster index", (int)0, (int)(numClusters - 1));
        long objectId = this.nativeId();
        switch (parameter) {
            case AngularDamping: {
                result = PhysicsSoftBody.getClusterAngularDamping(objectId, clusterIndex);
                break;
            }
            case LinearDamping: {
                result = PhysicsSoftBody.getClusterLinearDamping(objectId, clusterIndex);
                break;
            }
            case Matching: {
                result = PhysicsSoftBody.getClusterMatching(objectId, clusterIndex);
                break;
            }
            case MaxSelfImpulse: {
                result = PhysicsSoftBody.getClusterMaxSelfImpulse(objectId, clusterIndex);
                break;
            }
            case NodeDamping: {
                result = PhysicsSoftBody.getClusterNodeDamping(objectId, clusterIndex);
                break;
            }
            case SelfImpulse: {
                result = PhysicsSoftBody.getClusterSelfImpulse(objectId, clusterIndex);
                break;
            }
            default: {
                throw new IllegalArgumentException(parameter.toString());
            }
        }
        return result;
    }

    public SoftBodyConfig getSoftConfig() {
        return this.config;
    }

    public SoftBodyMaterial getSoftMaterial() {
        if (this.material == null) {
            this.material = new SoftBodyMaterial(this);
        }
        return this.material;
    }

    public SoftBodyWorldInfo getWorldInfo() {
        assert (this.worldInfo != null);
        assert (this.worldInfo.nativeId() == PhysicsSoftBody.getSoftBodyWorldInfo(this.nativeId()));
        return this.worldInfo;
    }

    public boolean isCollisionAllowed(long pcoId) {
        Validate.nonZero((long)pcoId, (String)"collision object ID");
        long objectId = this.nativeId();
        boolean result = PhysicsSoftBody.isCollisionAllowed(objectId, pcoId);
        return result;
    }

    public final boolean isEmpty() {
        boolean result = this.countNodes() == 0 && this.countFaces() == 0 && this.countLinks() == 0 && this.countTetras() == 0 && this.countJoints() == 0 && this.countClusters() == 0;
        return result;
    }

    public boolean isWorldInfoProtected() {
        boolean result = this.isWorldInfoProtected;
        return result;
    }

    public IntBuffer listNodesInCluster(int clusterIndex, IntBuffer storeResult) {
        IntBuffer resultBuffer;
        int numClusters = this.countClusters();
        Validate.inRange((int)clusterIndex, (String)"cluster index", (int)0, (int)(numClusters - 1));
        int numNodes = this.countNodesInCluster(clusterIndex);
        if (storeResult == null) {
            resultBuffer = BufferUtils.createIntBuffer((int)numNodes);
        } else {
            assert (storeResult.isDirect());
            assert (storeResult.capacity() == numNodes);
            resultBuffer = storeResult;
        }
        long objectId = this.nativeId();
        PhysicsSoftBody.listNodesInCluster(objectId, clusterIndex, resultBuffer);
        return resultBuffer;
    }

    public float margin() {
        long objectId = this.nativeId();
        float result = PhysicsSoftBody.getMargin(objectId);
        return result;
    }

    public Vector3f nodeLocation(int nodeIndex, Vector3f storeResult) {
        int numNodes = this.countNodes();
        Validate.inRange((int)nodeIndex, (String)"node index", (int)0, (int)(numNodes - 1));
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsSoftBody.getNodeLocation(objectId, nodeIndex, result);
        return result;
    }

    public float nodeMass(int nodeIndex) {
        int numNodes = this.countNodes();
        Validate.inRange((int)nodeIndex, (String)"node index", (int)0, (int)(numNodes - 1));
        long objectId = this.nativeId();
        float result = PhysicsSoftBody.getMass(objectId, nodeIndex);
        return result;
    }

    public Vector3f nodeNormal(int nodeIndex, Vector3f storeResult) {
        int numNodes = this.countNodes();
        Validate.inRange((int)nodeIndex, (String)"node index", (int)0, (int)(numNodes - 1));
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsSoftBody.getNodeNormal(objectId, nodeIndex, result);
        return result;
    }

    public Vector3f nodeVelocity(int nodeIndex, Vector3f storeResult) {
        int numNodes = this.countNodes();
        Validate.inRange((int)nodeIndex, (String)"node index", (int)0, (int)(numNodes - 1));
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsSoftBody.getNodeVelocity(objectId, nodeIndex, result);
        return result;
    }

    public void randomizeConstraints() {
        long objectId = this.nativeId();
        PhysicsSoftBody.randomizeConstraints(objectId);
    }

    public void releaseAllClusters() {
        long objectId = this.nativeId();
        PhysicsSoftBody.releaseClusters(objectId);
    }

    public void releaseCluster(int clusterIndex) {
        int numClusters = this.countClusters();
        Validate.inRange((int)clusterIndex, (String)"cluster index", (int)0, (int)(numClusters - 1));
        long objectId = this.nativeId();
        PhysicsSoftBody.releaseCluster(objectId, clusterIndex);
    }

    public void resetRestingLengths() {
        long objectId = this.nativeId();
        PhysicsSoftBody.resetLinkRestLengths(objectId);
    }

    public float restingLengthsScale() {
        long objectId = this.nativeId();
        float result = PhysicsSoftBody.getRestLengthScale(objectId);
        return result;
    }

    public void set(Cluster parameter, int clusterIndex, float value) {
        int numClusters = this.countClusters();
        Validate.inRange((int)clusterIndex, (String)"cluster index", (int)0, (int)(numClusters - 1));
        long objectId = this.nativeId();
        switch (parameter) {
            case AngularDamping: {
                PhysicsSoftBody.setClusterAngularDamping(objectId, clusterIndex, value);
                break;
            }
            case LinearDamping: {
                PhysicsSoftBody.setClusterLinearDamping(objectId, clusterIndex, value);
                break;
            }
            case Matching: {
                PhysicsSoftBody.setClusterMatching(objectId, clusterIndex, value);
                break;
            }
            case MaxSelfImpulse: {
                PhysicsSoftBody.setClusterMaxSelfImpulse(objectId, clusterIndex, value);
                break;
            }
            case NodeDamping: {
                PhysicsSoftBody.setClusterNodeDamping(objectId, clusterIndex, value);
                break;
            }
            case SelfImpulse: {
                PhysicsSoftBody.setClusterSelfImpulse(objectId, clusterIndex, value);
                break;
            }
            default: {
                throw new IllegalArgumentException(parameter.toString());
            }
        }
    }

    public final void setMargin(float margin) {
        Validate.positive((float)margin, (String)"margin");
        long objectId = this.nativeId();
        PhysicsSoftBody.setMargin(objectId, margin);
    }

    public void setMassByArea(float totalMass) {
        Validate.positive((float)totalMass, (String)"total mass");
        long objectId = this.nativeId();
        PhysicsSoftBody.setTotalMass(objectId, totalMass, true);
    }

    public void setMassByCurrent(float totalMass) {
        Validate.positive((float)totalMass, (String)"total mass");
        long objectId = this.nativeId();
        PhysicsSoftBody.setTotalMass(objectId, totalMass, false);
    }

    public void setMasses(FloatBuffer masses) {
        Validate.nonNull((Object)masses, (String)"masses");
        if (!masses.isDirect()) {
            throw new IllegalArgumentException("The buffer must be direct.");
        }
        long objectId = this.nativeId();
        PhysicsSoftBody.setMasses(objectId, masses);
    }

    public void setMassFromDensity(float density) {
        Validate.positive((float)density, (String)"density");
        long objectId = this.nativeId();
        PhysicsSoftBody.setTotalDensity(objectId, density);
    }

    public void setNodeMass(int nodeIndex, float mass) {
        int numNodes = this.countNodes();
        Validate.inRange((int)nodeIndex, (String)"node index", (int)0, (int)(numNodes - 1));
        Validate.nonNegative((float)mass, (String)"mass");
        long objectId = this.nativeId();
        PhysicsSoftBody.setMass(objectId, nodeIndex, mass);
    }

    public void setNodeVelocity(int nodeIndex, Vector3f velocity) {
        int numNodes = this.countNodes();
        Validate.inRange((int)nodeIndex, (String)"node index", (int)0, (int)(numNodes - 1));
        Validate.finite((Vector3f)velocity, (String)"velocity");
        long objectId = this.nativeId();
        PhysicsSoftBody.setNodeVelocity(objectId, nodeIndex, velocity);
    }

    public void setNormals(FloatBuffer normals) {
        Validate.nonNull((Object)normals, (String)"normals");
        if (!normals.isDirect()) {
            throw new IllegalArgumentException("The buffer must be direct.");
        }
        long objectId = this.nativeId();
        PhysicsSoftBody.setNormals(objectId, normals);
    }

    public void setPhysicsLocationDp(Vec3d location) {
        Validate.nonNull((Object)location, (String)"location");
        long objectId = this.nativeId();
        PhysicsSoftBody.setPhysicsLocationDp(objectId, location);
    }

    public void setPose(boolean setVolumePose, boolean setFramePose) {
        long objectId = this.nativeId();
        PhysicsSoftBody.setPose(objectId, setVolumePose, setFramePose);
    }

    public void setProtectWorldInfo(boolean newState) {
        this.isWorldInfoProtected = newState;
    }

    public void setRestingLengthScale(float scale) {
        long objectId = this.nativeId();
        PhysicsSoftBody.setRestLengthScale(objectId, scale);
    }

    public void setVelocities(FloatBuffer velocities) {
        Validate.nonNull((Object)velocities, (String)"velocities");
        if (!velocities.isDirect()) {
            throw new IllegalArgumentException("The buffer must be direct.");
        }
        long objectId = this.nativeId();
        PhysicsSoftBody.setVelocities(objectId, velocities);
    }

    public void setVelocity(Vector3f velocity) {
        Validate.finite((Vector3f)velocity, (String)"velocity");
        long objectId = this.nativeId();
        PhysicsSoftBody.setVelocity(objectId, velocity);
    }

    public void setVolumeDensity(float density) {
        long objectId = this.nativeId();
        PhysicsSoftBody.setVolumeDensity(objectId, density);
    }

    public void setVolumeMass(float mass) {
        long objectId = this.nativeId();
        PhysicsSoftBody.setVolumeMass(objectId, mass);
    }

    public void setWindVelocity(Vector3f velocity) {
        Validate.finite((Vector3f)velocity, (String)"velocity");
        long objectId = this.nativeId();
        PhysicsSoftBody.setWindVelocity(objectId, velocity);
    }

    public void setWorldInfo(SoftBodyWorldInfo worldInfo) {
        if (!this.isInWorld()) {
            logger2.warning("The body is not in any space.");
        }
        long objectId = this.nativeId();
        long worldInfoId = worldInfo.nativeId();
        PhysicsSoftBody.setSoftBodyWorldInfo(objectId, worldInfoId);
        this.worldInfo = worldInfo;
    }

    public float volume() {
        long objectId = this.nativeId();
        float result = PhysicsSoftBody.getVolume(objectId);
        return result;
    }

    public Vector3f windVelocity(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsSoftBody.getWindVelocity(objectId, result);
        return result;
    }

    protected void destroySoftBody() {
        if (this.hasAssignedNativeObject()) {
            logger2.log(Level.FINE, "Destroying {0}.", this);
            this.unassignNativeObject();
        }
        this.material = null;
        this.config = null;
    }

    protected void initDefault() {
        long objectId = this.nativeId();
        PhysicsSoftBody.initDefault(objectId);
    }

    protected void newEmptySoftBody() {
        this.destroySoftBody();
        long infoId = this.worldInfo.nativeId();
        long objectId = PhysicsSoftBody.createEmpty(infoId);
        this.setNativeId(objectId);
        assert (PhysicsSoftBody.getInternalType(objectId) == 8) : PhysicsSoftBody.getInternalType(objectId);
        logger2.log(Level.FINE, "Created {0}.", this);
        this.config = new SoftBodyConfig(this);
        this.initUserPointer();
        assert (!this.isInWorld());
        assert (this.countNodes() == 0);
        assert (this.countFaces() == 0);
        assert (this.countLinks() == 0);
        assert (this.countTetras() == 0);
        assert (this.countClusters() == 0);
    }

    @Override
    public BoundingBox boundingBox(BoundingBox storeResult) {
        BoundingBox result = storeResult == null ? new BoundingBox() : storeResult;
        Vector3f minima = new Vector3f();
        Vector3f maxima = new Vector3f();
        long objectId = this.nativeId();
        PhysicsSoftBody.getBounds(objectId, minima, maxima);
        result.setMinMax(minima, maxima);
        return result;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        assert (!this.hasAssignedNativeObject());
        PhysicsSoftBody old = (PhysicsSoftBody)original;
        assert (old != this);
        assert (old.hasAssignedNativeObject());
        super.cloneFields(cloner, original);
        if (this.hasAssignedNativeObject()) {
            return;
        }
        this.worldInfo = (SoftBodyWorldInfo)cloner.clone((Object)old.worldInfo);
        long infoId = this.worldInfo.nativeId();
        long objectId = PhysicsSoftBody.createEmpty(infoId);
        this.setNativeId(objectId);
        assert (PhysicsSoftBody.getInternalType(objectId) == 8) : PhysicsSoftBody.getInternalType(objectId);
        logger2.log(Level.FINE, "Created {0}.", this);
        this.config = new SoftBodyConfig(this);
        this.initUserPointer();
        this.cloneIgnoreList(cloner, old);
        this.copyPcoProperties(old);
        this.config.copyAll(old.config);
        this.material = (SoftBodyMaterial)cloner.clone((Object)old.material);
        FloatBuffer floats = old.copyLocations(null);
        this.appendNodes(floats);
        old.copyNormals(floats);
        this.setNormals(floats);
        old.copyVelocities(floats);
        this.setVelocities(floats);
        FloatBuffer masses = old.copyMasses(null);
        this.setMasses(masses);
        IntBuffer faces = old.copyFaces(null);
        IndexBuffer faceIndices = IndexBuffer.wrapIndexBuffer((Buffer)faces);
        this.appendFaces(faceIndices);
        IntBuffer links = old.copyLinks(null);
        IndexBuffer linkIndices = IndexBuffer.wrapIndexBuffer((Buffer)links);
        this.appendLinks(linkIndices);
        IntBuffer tetras = old.copyTetras(null);
        IndexBuffer tetraIndices = IndexBuffer.wrapIndexBuffer((Buffer)tetras);
        this.appendLinks(tetraIndices);
        assert (this.countClusters() == 0) : this.countClusters();
        int numClusters = old.countClusters();
        for (int clusterIndex = 0; clusterIndex < numClusters; ++clusterIndex) {
            IntBuffer nodeIndices = old.listNodesInCluster(clusterIndex, null);
            int numNodesInCluster = nodeIndices.capacity();
            PhysicsSoftBody.appendCluster(objectId, numNodesInCluster, nodeIndices);
            for (Cluster clusterParameter : Cluster.values()) {
                float value = old.get(clusterParameter, clusterIndex);
                this.set(clusterParameter, clusterIndex, value);
            }
        }
        PhysicsSoftBody.finishClusters(objectId);
        assert (this.countClusters() == numClusters) : this.countClusters();
        this.cloneJoints(cloner, old);
    }

    @Override
    public Vector3f getGravity(Vector3f storeResult) {
        SoftBodyWorldInfo info = this.getWorldInfo();
        Vector3f result = info.copyGravity(storeResult);
        return result;
    }

    @Override
    public float getMass() {
        long objectId = this.nativeId();
        float totalMass = PhysicsSoftBody.getTotalMass(objectId);
        assert (totalMass >= 0.0f) : totalMass;
        return totalMass;
    }

    @Override
    public Vector3f getPhysicsLocation(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long objectId = this.nativeId();
        PhysicsSoftBody.getPhysicsLocation(objectId, result);
        assert (Vector3f.isValidVector((Vector3f)result)) : result;
        return result;
    }

    @Override
    public Vec3d getPhysicsLocationDp(Vec3d storeResult) {
        Vec3d result = storeResult == null ? new Vec3d() : storeResult;
        long objectId = this.nativeId();
        PhysicsSoftBody.getPhysicsLocationDp(objectId, result);
        assert (result.isFinite()) : result;
        return result;
    }

    @Override
    public Quaternion getPhysicsRotation(Quaternion storeResult) {
        Quaternion result = storeResult == null ? new Quaternion() : storeResult;
        result.loadIdentity();
        return result;
    }

    @Override
    public Quatd getPhysicsRotationDp(Quatd storeResult) {
        Quatd result = storeResult == null ? new Quatd() : storeResult.set(0.0, 0.0, 0.0, 1.0);
        return result;
    }

    @Override
    public Matrix3f getPhysicsRotationMatrix(Matrix3f storeResult) {
        Matrix3f result = storeResult == null ? new Matrix3f() : storeResult;
        result.loadIdentity();
        return result;
    }

    @Override
    public Matrix3d getPhysicsRotationMatrixDp(Matrix3d storeResult) {
        Matrix3d result = storeResult == null ? new Matrix3d() : storeResult.makeIdentity();
        return result;
    }

    @Override
    public Vector3f getScale(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        result.set(1.0f, 1.0f, 1.0f);
        return result;
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.worldInfo = (SoftBodyWorldInfo)capsule.readSavable(tagWorldInfo, null);
        this.newEmptySoftBody();
        super.read(importer);
        this.readPcoProperties(capsule);
        this.isWorldInfoProtected = capsule.readBoolean(tagIsWorldInfoProtected, false);
        this.config = (SoftBodyConfig)capsule.readSavable(tagConfig, null);
        assert (this.config != null);
        this.material = (SoftBodyMaterial)capsule.readSavable(tagMaterial, null);
        float[] fArray = capsule.readFloatArray(tagNodeLocations, new float[0]);
        this.appendNodes(BufferUtils.createFloatBuffer((float[])fArray));
        fArray = capsule.readFloatArray(tagNodeMasses, new float[0]);
        this.setMasses(BufferUtils.createFloatBuffer((float[])fArray));
        fArray = capsule.readFloatArray(tagNodeNormals, new float[0]);
        this.setNormals(BufferUtils.createFloatBuffer((float[])fArray));
        fArray = capsule.readFloatArray(tagNodeVelocities, new float[0]);
        this.setVelocities(BufferUtils.createFloatBuffer((float[])fArray));
        int[] nodeIndices = capsule.readIntArray(tagFaceIndices, new int[0]);
        IndexBuffer indexBuffer = IndexBuffer.wrapIndexBuffer((Buffer)BufferUtils.createIntBuffer((int[])nodeIndices));
        this.appendFaces(indexBuffer);
        nodeIndices = capsule.readIntArray(tagLinkIndices, new int[0]);
        indexBuffer = IndexBuffer.wrapIndexBuffer((Buffer)BufferUtils.createIntBuffer((int[])nodeIndices));
        this.appendLinks(indexBuffer);
        nodeIndices = capsule.readIntArray(tagTetraIndices, new int[0]);
        indexBuffer = IndexBuffer.wrapIndexBuffer((Buffer)BufferUtils.createIntBuffer((int[])nodeIndices));
        this.appendTetras(indexBuffer);
        assert (this.countClusters() == 0) : this.countClusters();
        long objectId = this.nativeId();
        int numClusters = capsule.readInt(tagNumClusters, 0);
        for (int clusterIndex = 0; clusterIndex < numClusters; ++clusterIndex) {
            nodeIndices = capsule.readIntArray(tagIndices + clusterIndex, new int[0]);
            int numNodesInCluster = nodeIndices.length;
            IntBuffer intBuffer = BufferUtils.createIntBuffer((int[])nodeIndices);
            PhysicsSoftBody.appendCluster(objectId, numNodesInCluster, intBuffer);
            for (Cluster clusterParameter : Cluster.values()) {
                String tag = clusterParameter.toString() + clusterIndex;
                float defValue = clusterParameter.defValue();
                float value = capsule.readFloat(tag, defValue);
                this.set(clusterParameter, clusterIndex, value);
            }
        }
        PhysicsSoftBody.finishClusters(objectId);
        assert (this.countClusters() == numClusters) : this.countClusters();
        this.setRestingLengthScale(capsule.readFloat(tagRestLengthScale, 0.0f));
        this.setPhysicsLocation((Vector3f)capsule.readSavable(tagPhysicsLocation, (Savable)new Vector3f()));
        this.readJoints(capsule);
    }

    @Override
    public void setDebugMeshNormals(MeshNormals newSetting) {
        Validate.nonNull((Object)newSetting, (String)"new setting");
        switch (newSetting) {
            case None: 
            case Smooth: {
                super.setDebugMeshNormals(newSetting);
                break;
            }
            default: {
                String message = "normals = " + newSetting;
                throw new IllegalArgumentException(message);
            }
        }
    }

    @Override
    public void setGravity(Vector3f acceleration) {
        Validate.finite((Vector3f)acceleration, (String)"acceleration");
        SoftBodyWorldInfo newInfo = new SoftBodyWorldInfo();
        newInfo.copyAll(this.worldInfo);
        newInfo.setGravity(acceleration);
        this.setWorldInfo(newInfo);
    }

    @Override
    public void setMass(float totalMass) {
        Validate.positive((float)totalMass, (String)"total mass");
        this.setMassByCurrent(totalMass);
    }

    @Override
    public void setPhysicsLocation(Vector3f location) {
        Validate.finite((Vector3f)location, (String)"location");
        long objectId = this.nativeId();
        PhysicsSoftBody.setPhysicsLocation(objectId, location);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.isWorldInfoProtected, tagIsWorldInfoProtected, false);
        capsule.write(this.restingLengthsScale(), tagRestLengthScale, 0.0f);
        capsule.write((Savable)this.getPhysicsLocation(null), tagPhysicsLocation, null);
        FloatBuffer floatBuffer = this.copyLocations(null);
        int capacity = floatBuffer.capacity();
        float[] floatArray = MyBuffer.toFloatArray((FloatBuffer)floatBuffer, (int)0, (int)capacity);
        capsule.write(floatArray, tagNodeLocations, null);
        floatBuffer = this.copyMasses(null);
        capacity = floatBuffer.capacity();
        floatArray = MyBuffer.toFloatArray((FloatBuffer)floatBuffer, (int)0, (int)capacity);
        capsule.write(floatArray, tagNodeMasses, null);
        floatBuffer = this.copyNormals(null);
        capacity = floatBuffer.capacity();
        floatArray = MyBuffer.toFloatArray((FloatBuffer)floatBuffer, (int)0, (int)capacity);
        capsule.write(floatArray, tagNodeNormals, null);
        floatBuffer = this.copyVelocities(null);
        capacity = floatBuffer.capacity();
        floatArray = MyBuffer.toFloatArray((FloatBuffer)floatBuffer, (int)0, (int)capacity);
        capsule.write(floatArray, tagNodeVelocities, null);
        IntBuffer intBuffer = this.copyFaces(null);
        capacity = intBuffer.capacity();
        int[] intArray = MyBuffer.toIntArray((IntBuffer)intBuffer, (int)0, (int)capacity);
        capsule.write(intArray, tagFaceIndices, null);
        intBuffer = this.copyLinks(null);
        capacity = intBuffer.capacity();
        intArray = MyBuffer.toIntArray((IntBuffer)intBuffer, (int)0, (int)capacity);
        capsule.write(intArray, tagLinkIndices, null);
        intBuffer = this.copyTetras(null);
        capacity = intBuffer.capacity();
        intArray = MyBuffer.toIntArray((IntBuffer)intBuffer, (int)0, (int)capacity);
        capsule.write(intArray, tagTetraIndices, null);
        int numClusters = this.countClusters();
        capsule.write(numClusters, tagNumClusters, 0);
        for (int clusterIndex = 0; clusterIndex < numClusters; ++clusterIndex) {
            intBuffer = this.listNodesInCluster(clusterIndex, null);
            capacity = intBuffer.capacity();
            intArray = MyBuffer.toIntArray((IntBuffer)intBuffer, (int)0, (int)capacity);
            capsule.write(intArray, tagIndices + clusterIndex, null);
            for (Cluster clusterParameter : Cluster.values()) {
                float value = this.get(clusterParameter, clusterIndex);
                String tag = clusterParameter.toString() + clusterIndex;
                float defValue = clusterParameter.defValue();
                capsule.write(value, tag, defValue);
            }
        }
        assert (this.worldInfo != null);
        capsule.write((Savable)this.worldInfo, tagWorldInfo, null);
        assert (this.config != null);
        capsule.write((Savable)this.config, tagConfig, null);
        capsule.write((Savable)this.material, tagMaterial, null);
        this.writeJoints(capsule);
    }

    private static native void addForce(long var0, Vector3f var2);

    private static native void addForce(long var0, Vector3f var2, int var3);

    private static native void addVelocity(long var0, Vector3f var2);

    private static native void addVelocity(long var0, Vector3f var2, int var3);

    private static native void appendCluster(long var0, int var2, IntBuffer var3);

    private static native void appendFaces(long var0, int var2, ByteBuffer var3);

    private static native void appendFaces(long var0, int var2, IntBuffer var3);

    private static native void appendFaces(long var0, int var2, ShortBuffer var3);

    private static native void appendLinks(long var0, int var2, ByteBuffer var3);

    private static native void appendLinks(long var0, int var2, IntBuffer var3);

    private static native void appendLinks(long var0, int var2, ShortBuffer var3);

    private static native void appendNodes(long var0, int var2, FloatBuffer var3);

    private static native void appendTetras(long var0, int var2, ByteBuffer var3);

    private static native void appendTetras(long var0, int var2, IntBuffer var3);

    private static native void appendTetras(long var0, int var2, ShortBuffer var3);

    private static native void applyPhysicsRotation(long var0, Quaternion var2);

    private static native void applyPhysicsScale(long var0, Vector3f var2);

    private static native void applyPhysicsTransform(long var0, Transform var2);

    private static native void applyPhysicsTranslate(long var0, Vector3f var2);

    private static native int countNodesInCluster(long var0, int var2);

    private static native long createEmpty(long var0);

    private static native boolean cutLink(long var0, int var2, int var3, float var4);

    private static native void finishClusters(long var0);

    private static native void generateBendingConstraints(long var0, int var2, long var3);

    private static native void generateClusters(long var0, int var2, int var3);

    private static native void getBounds(long var0, Vector3f var2, Vector3f var3);

    private static native float getClusterAngularDamping(long var0, int var2);

    private static native void getClusterCenter(long var0, int var2, Vector3f var3);

    private static native int getClusterCount(long var0);

    private static native float getClusterLinearDamping(long var0, int var2);

    private static native float getClusterMatching(long var0, int var2);

    private static native float getClusterMaxSelfImpulse(long var0, int var2);

    private static native float getClusterNodeDamping(long var0, int var2);

    private static native float getClusterSelfImpulse(long var0, int var2);

    private static native void getClustersLinearVelocities(long var0, FloatBuffer var2);

    private static native void getClustersMasses(long var0, FloatBuffer var2);

    private static native void getClustersPositions(long var0, FloatBuffer var2);

    private static native void getFacesIndexes(long var0, IntBuffer var2);

    private static native void getLinksIndexes(long var0, IntBuffer var2);

    private static native float getMargin(long var0);

    private static native float getMass(long var0, int var2);

    private static native void getMasses(long var0, FloatBuffer var2);

    private static native int getNbFaces(long var0);

    private static native int getNbLinks(long var0);

    private static native int getNbNodes(long var0);

    private static native int getNbPinnedNodes(long var0);

    private static native int getNbTetras(long var0);

    private static native void getNodeLocation(long var0, int var2, Vector3f var3);

    private static native void getNodeNormal(long var0, int var2, Vector3f var3);

    private static native void getNodesNormals(long var0, FloatBuffer var2);

    private static native void getNodesPositions(long var0, FloatBuffer var2);

    private static native void getNodesVelocities(long var0, FloatBuffer var2);

    private static native void getNodeVelocity(long var0, int var2, Vector3f var3);

    private static native void getPhysicsLocation(long var0, Vector3f var2);

    private static native void getPhysicsLocationDp(long var0, Vec3d var2);

    private static native float getRestLengthScale(long var0);

    private static native long getSoftBodyWorldInfo(long var0);

    private static native void getTetrasIndexes(long var0, IntBuffer var2);

    private static native float getTotalMass(long var0);

    private static native float getVolume(long var0);

    private static native void getWindVelocity(long var0, Vector3f var2);

    private static native void initDefault(long var0);

    private static native boolean isCollisionAllowed(long var0, long var2);

    private static native void listNodesInCluster(long var0, int var2, IntBuffer var3);

    private static native void randomizeConstraints(long var0);

    private static native void releaseCluster(long var0, int var2);

    private static native void releaseClusters(long var0);

    private static native void resetLinkRestLengths(long var0);

    private static native void setClusterAngularDamping(long var0, int var2, float var3);

    private static native void setClusterLinearDamping(long var0, int var2, float var3);

    private static native void setClusterMatching(long var0, int var2, float var3);

    private static native void setClusterMaxSelfImpulse(long var0, int var2, float var3);

    private static native void setClusterNodeDamping(long var0, int var2, float var3);

    private static native void setClusterSelfImpulse(long var0, int var2, float var3);

    private static native void setMargin(long var0, float var2);

    private static native void setMass(long var0, int var2, float var3);

    private static native void setMasses(long var0, FloatBuffer var2);

    private static native void setNodeVelocity(long var0, int var2, Vector3f var3);

    private static native void setNormals(long var0, FloatBuffer var2);

    private static native void setPhysicsLocation(long var0, Vector3f var2);

    private static native void setPhysicsLocationDp(long var0, Vec3d var2);

    private static native void setPose(long var0, boolean var2, boolean var3);

    private static native void setRestLengthScale(long var0, float var2);

    private static native void setSoftBodyWorldInfo(long var0, long var2);

    private static native void setTotalDensity(long var0, float var2);

    private static native void setTotalMass(long var0, float var2, boolean var3);

    private static native void setVelocities(long var0, FloatBuffer var2);

    private static native void setVelocity(long var0, Vector3f var2);

    private static native void setVolumeDensity(long var0, float var2);

    private static native void setVolumeMass(long var0, float var2);

    private static native void setWindVelocity(long var0, Vector3f var2);
}

