/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects.infos;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.objects.PhysicsVehicle;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import com.simsilica.mathd.Matrix3d;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.math.MyQuaternion;

public class RigidBodyMotionState
extends NativePhysicsObject
implements JmeCloneable,
Savable {
    public static final Logger logger = Logger.getLogger(RigidBodyMotionState.class.getName());
    private static final String tagApplyPhysicsLocal = "applyPhysicsLocal";
    private static final String tagVehicle = "vehicle";
    private boolean applyPhysicsLocal = false;
    private PhysicsVehicle vehicle = null;
    private Quaternion tmpInverseWorldRotation = new Quaternion();

    public RigidBodyMotionState() {
        long motionStateId = RigidBodyMotionState.createMotionState();
        super.setNativeId(motionStateId);
        logger.log(Level.FINE, "Created {0}", this);
    }

    public boolean applyTransform(Spatial spatial) {
        Quaternion localRotationQuat;
        Vector3f localLocation;
        long motionStateId = this.nativeId();
        boolean physicsLocationDirty = RigidBodyMotionState.applyTransform(motionStateId, localLocation = spatial.getLocalTranslation(), localRotationQuat = spatial.getLocalRotation());
        if (!physicsLocationDirty) {
            return false;
        }
        if (!this.applyPhysicsLocal && spatial.getParent() != null) {
            Node parent = spatial.getParent();
            this.tmpInverseWorldRotation.set(parent.getWorldRotation());
            this.tmpInverseWorldRotation.inverseLocal();
            Vector3f pwScale = parent.getWorldScale();
            Vector3f pwTranslation = parent.getWorldTranslation();
            localLocation.subtractLocal(pwTranslation);
            localLocation.divideLocal(pwScale);
            MyQuaternion.rotate((Quaternion)this.tmpInverseWorldRotation, (Vector3f)localLocation, (Vector3f)localLocation);
            this.tmpInverseWorldRotation.mult(localRotationQuat, localRotationQuat);
            spatial.setLocalTranslation(localLocation);
            spatial.setLocalRotation(localRotationQuat);
        } else {
            spatial.setLocalTranslation(localLocation);
            spatial.setLocalRotation(localRotationQuat);
        }
        if (this.vehicle != null) {
            this.vehicle.updateWheels();
        }
        return true;
    }

    public Vector3f getLocation(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long motionStateId = this.nativeId();
        RigidBodyMotionState.getWorldLocation(motionStateId, result);
        assert (Vector3f.isValidVector((Vector3f)result));
        return result;
    }

    public Vec3d getLocationDp(Vec3d storeResult) {
        Vec3d result = storeResult == null ? new Vec3d() : storeResult;
        long motionStateId = this.nativeId();
        RigidBodyMotionState.getWorldLocationDp(motionStateId, result);
        assert (result.isFinite()) : result;
        return result;
    }

    public Matrix3f getOrientation(Matrix3f storeResult) {
        Matrix3f result = storeResult == null ? new Matrix3f() : storeResult;
        long motionStateId = this.nativeId();
        RigidBodyMotionState.getWorldRotation(motionStateId, result);
        return result;
    }

    public Quaternion getOrientation(Quaternion storeResult) {
        Quaternion result = storeResult == null ? new Quaternion() : storeResult;
        long motionStateId = this.nativeId();
        RigidBodyMotionState.getWorldRotationQuat(motionStateId, result);
        return result;
    }

    public Matrix3d getOrientationMatrixDp(Matrix3d storeResult) {
        Matrix3d result = storeResult == null ? new Matrix3d() : storeResult;
        long motionStateId = this.nativeId();
        RigidBodyMotionState.getWorldRotationDp(motionStateId, result);
        return result;
    }

    public Quatd getOrientationQuaternionDp(Quatd storeResult) {
        Quatd result = storeResult == null ? new Quatd() : storeResult;
        long motionStateId = this.nativeId();
        RigidBodyMotionState.getWorldRotationQuatDp(motionStateId, result);
        return result;
    }

    public boolean isApplyPhysicsLocal() {
        return this.applyPhysicsLocal;
    }

    public Transform physicsTransform(Transform storeResult) {
        Transform transform = storeResult == null ? new Transform() : storeResult.setScale(1.0f);
        long motionStateId = this.nativeId();
        RigidBodyMotionState.getWorldLocation(motionStateId, transform.getTranslation());
        RigidBodyMotionState.getWorldRotationQuat(motionStateId, transform.getRotation());
        return transform;
    }

    public void setApplyPhysicsLocal(boolean applyPhysicsLocal) {
        this.applyPhysicsLocal = applyPhysicsLocal;
    }

    public void setVehicle(PhysicsVehicle vehicle) {
        this.vehicle = vehicle;
    }

    public void cloneFields(Cloner cloner, Object original) {
        long motionStateId = RigidBodyMotionState.createMotionState();
        this.reassignNativeId(motionStateId);
        this.tmpInverseWorldRotation = (Quaternion)cloner.clone((Object)this.tmpInverseWorldRotation);
        this.vehicle = (PhysicsVehicle)cloner.clone((Object)this.vehicle);
    }

    public RigidBodyMotionState jmeClone() {
        try {
            RigidBodyMotionState clone = (RigidBodyMotionState)this.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.applyPhysicsLocal = capsule.readBoolean(tagApplyPhysicsLocal, false);
        this.vehicle = (PhysicsVehicle)capsule.readSavable(tagVehicle, null);
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.applyPhysicsLocal, tagApplyPhysicsLocal, false);
        capsule.write((Savable)this.vehicle, tagVehicle, null);
    }

    private static void freeNativeObject(long stateId) {
        assert (stateId != 0L);
        RigidBodyMotionState.finalizeNative(stateId);
    }

    private static native boolean applyTransform(long var0, Vector3f var2, Quaternion var3);

    private static native long createMotionState();

    private static native void finalizeNative(long var0);

    private static native void getWorldLocation(long var0, Vector3f var2);

    private static native void getWorldLocationDp(long var0, Vec3d var2);

    private static native void getWorldRotation(long var0, Matrix3f var2);

    private static native void getWorldRotationDp(long var0, Matrix3d var2);

    private static native void getWorldRotationQuat(long var0, Quaternion var2);

    private static native void getWorldRotationQuatDp(long var0, Quatd var2);
}

