/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects.infos;

public enum Sbcp {
    AnchorHardness,
    ClusterKineticHardness,
    ClusterKineticSplit,
    ClusterRigidHardness,
    ClusterRigidSplit,
    ClusterSoftHardness,
    ClusterSoftSplit,
    Damping,
    Drag,
    DynamicFriction,
    KineticHardness,
    Lift,
    MaxVolumeRatio,
    PoseMatching,
    Pressure,
    RigidHardness,
    SoftHardness,
    TimeScale,
    VelocityCorrection,
    VolumeConservation;


    public boolean canSet(float value) {
        boolean result = this.minValue() <= value && value <= this.maxValue();
        return result;
    }

    public float defValue() {
        float result;
        switch (this) {
            case Damping: 
            case Drag: 
            case Lift: 
            case PoseMatching: 
            case Pressure: 
            case VolumeConservation: {
                result = 0.0f;
                break;
            }
            case ClusterRigidHardness: 
            case KineticHardness: {
                result = 0.1f;
                break;
            }
            case DynamicFriction: {
                result = 0.2f;
                break;
            }
            case ClusterKineticSplit: 
            case ClusterRigidSplit: 
            case ClusterSoftHardness: 
            case ClusterSoftSplit: {
                result = 0.5f;
                break;
            }
            case AnchorHardness: {
                result = 0.7f;
                break;
            }
            case ClusterKineticHardness: 
            case MaxVolumeRatio: 
            case RigidHardness: 
            case SoftHardness: 
            case TimeScale: 
            case VelocityCorrection: {
                result = 1.0f;
                break;
            }
            default: {
                throw new IllegalArgumentException("parameter = " + (Object)((Object)this));
            }
        }
        return result;
    }

    public float maxValue() {
        switch (this) {
            case PoseMatching: 
            case ClusterRigidHardness: 
            case KineticHardness: 
            case DynamicFriction: 
            case ClusterKineticSplit: 
            case ClusterRigidSplit: 
            case ClusterSoftHardness: 
            case ClusterSoftSplit: 
            case AnchorHardness: 
            case ClusterKineticHardness: 
            case RigidHardness: 
            case SoftHardness: {
                return 1.0f;
            }
            case Damping: 
            case Drag: 
            case Lift: 
            case Pressure: 
            case VolumeConservation: 
            case MaxVolumeRatio: 
            case TimeScale: 
            case VelocityCorrection: {
                return Float.MAX_VALUE;
            }
        }
        throw new IllegalArgumentException("parameter = " + (Object)((Object)this));
    }

    public float minValue() {
        switch (this) {
            case Pressure: 
            case MaxVolumeRatio: 
            case TimeScale: 
            case VelocityCorrection: {
                return -3.4028235E38f;
            }
            case Damping: 
            case Drag: 
            case Lift: 
            case PoseMatching: 
            case VolumeConservation: 
            case ClusterRigidHardness: 
            case KineticHardness: 
            case DynamicFriction: 
            case ClusterKineticSplit: 
            case ClusterRigidSplit: 
            case ClusterSoftHardness: 
            case ClusterSoftSplit: 
            case AnchorHardness: 
            case ClusterKineticHardness: 
            case RigidHardness: 
            case SoftHardness: {
                return 0.0f;
            }
        }
        throw new IllegalArgumentException("parameter = " + (Object)((Object)this));
    }
}

