/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects.infos;

import com.jme3.bullet.NativePhysicsObject;
import com.jme3.bullet.objects.PhysicsSoftBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class SoftBodyMaterial
extends NativePhysicsObject
implements JmeCloneable,
Savable {
    public static final Logger logger = Logger.getLogger(SoftBodyMaterial.class.getName());
    private static final String tagAngularStiffness = "angularStiffness";
    private static final String tagBody = "body";
    private static final String tagLinearStiffness = "linearStiffness";
    private static final String tagVolumeStiffness = "volumeStiffness";
    private PhysicsSoftBody body = null;

    protected SoftBodyMaterial() {
    }

    public SoftBodyMaterial(PhysicsSoftBody body) {
        this.body = body;
        long softBodyId = body.nativeId();
        long materialId = SoftBodyMaterial.getMaterialId(softBodyId);
        super.setNativeIdNotTracked(materialId);
    }

    public float angularStiffness() {
        long materialId = this.nativeId();
        float result = SoftBodyMaterial.getAngularStiffnessFactor(materialId);
        return result;
    }

    public float linearStiffness() {
        long materialId = this.nativeId();
        float result = SoftBodyMaterial.getLinearStiffnessFactor(materialId);
        return result;
    }

    public void setAngularStiffness(float coefficient) {
        Validate.fraction((float)coefficient, (String)"stiffness coefficient");
        long materialId = this.nativeId();
        SoftBodyMaterial.setAngularStiffnessFactor(materialId, coefficient);
    }

    public void setLinearStiffness(float coefficient) {
        Validate.fraction((float)coefficient, (String)"stiffness coefficient");
        long materialId = this.nativeId();
        SoftBodyMaterial.setLinearStiffnessFactor(materialId, coefficient);
    }

    public void setVolumeStiffness(float coefficient) {
        Validate.fraction((float)coefficient, (String)"stiffness coefficient");
        long materialId = this.nativeId();
        SoftBodyMaterial.setVolumeStiffnessFactor(materialId, coefficient);
    }

    public float volumeStiffness() {
        long materialId = this.nativeId();
        float result = SoftBodyMaterial.getVolumeStiffnessFactor(materialId);
        return result;
    }

    public void cloneFields(Cloner cloner, Object original) {
        this.unassignNativeObject();
        this.body = (PhysicsSoftBody)cloner.clone((Object)this.body);
        long softBodyId = this.body.nativeId();
        long materialId = SoftBodyMaterial.getMaterialId(softBodyId);
        this.setNativeIdNotTracked(materialId);
        SoftBodyMaterial old = (SoftBodyMaterial)original;
        this.setAngularStiffness(old.angularStiffness());
        this.setLinearStiffness(old.linearStiffness());
        this.setVolumeStiffness(old.volumeStiffness());
    }

    public SoftBodyMaterial jmeClone() {
        try {
            SoftBodyMaterial clone = (SoftBodyMaterial)this.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void read(JmeImporter importer) throws IOException {
        assert (this.body == null);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.body = (PhysicsSoftBody)capsule.readSavable(tagBody, null);
        long softBodyId = this.body.nativeId();
        long materialId = SoftBodyMaterial.getMaterialId(softBodyId);
        this.setNativeIdNotTracked(materialId);
        this.setAngularStiffness(capsule.readFloat(tagAngularStiffness, 1.0f));
        this.setLinearStiffness(capsule.readFloat(tagLinearStiffness, 1.0f));
        this.setVolumeStiffness(capsule.readFloat(tagVolumeStiffness, 1.0f));
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.body, tagBody, null);
        capsule.write(this.angularStiffness(), tagAngularStiffness, 1.0f);
        capsule.write(this.linearStiffness(), tagLinearStiffness, 1.0f);
        capsule.write(this.volumeStiffness(), tagVolumeStiffness, 1.0f);
    }

    private static native float getAngularStiffnessFactor(long var0);

    private static native float getLinearStiffnessFactor(long var0);

    private static native long getMaterialId(long var0);

    private static native float getVolumeStiffnessFactor(long var0);

    private static native void setAngularStiffnessFactor(long var0, float var2);

    private static native void setLinearStiffnessFactor(long var0, float var2);

    private static native void setVolumeStiffnessFactor(long var0, float var2);
}

