/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.util;

import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.collision.shapes.GImpactCollisionShape;
import com.jme3.bullet.collision.shapes.HeightfieldCollisionShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.bullet.collision.shapes.MeshCollisionShape;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.terrain.Terrain;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.MyMesh;
import jme3utilities.Validate;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyQuaternion;
import jme3utilities.math.MyVector3f;
import vhacd.VHACD;
import vhacd.VHACDHull;
import vhacd.VHACDParameters;
import vhacd4.Vhacd4;
import vhacd4.Vhacd4Hull;
import vhacd4.Vhacd4Parameters;

public final class CollisionShapeFactory {
    private static final int numAxes = 3;
    public static final Logger logger = Logger.getLogger(CollisionShapeFactory.class.getName());

    private CollisionShapeFactory() {
    }

    public static CollisionShape createBoxShape(Spatial modelRoot) {
        CompoundCollisionShape result = new CompoundCollisionShape();
        boolean meshAccurate = false;
        boolean dynamic = true;
        if (modelRoot instanceof Geometry) {
            Geometry geometry = (Geometry)modelRoot;
            Vector3f centerOffset = new Vector3f();
            BoxCollisionShape box = CollisionShapeFactory.createSingleBoxShape(geometry, (Spatial)geometry, centerOffset);
            result.addChildShape((CollisionShape)box, centerOffset);
        } else if (modelRoot instanceof Node) {
            Node node = (Node)modelRoot;
            CollisionShapeFactory.createCompoundShape(node, node, result, meshAccurate, dynamic);
        } else {
            throw new IllegalArgumentException("The model root must either be a Node or a Geometry!");
        }
        return result;
    }

    public static CollisionShape createDynamicMeshShape(Spatial modelRoot) {
        if (modelRoot instanceof Geometry) {
            return CollisionShapeFactory.createSingleHullShape((Geometry)modelRoot, modelRoot);
        }
        if (modelRoot instanceof Node) {
            Node node = (Node)modelRoot;
            CompoundCollisionShape result = new CompoundCollisionShape();
            boolean meshAccurate = true;
            boolean dynamic = true;
            CollisionShapeFactory.createCompoundShape(node, node, result, meshAccurate, dynamic);
            return result;
        }
        throw new IllegalArgumentException("The model root must either be a Node or a Geometry!");
    }

    public static GImpactCollisionShape createGImpactShape(Spatial modelRoot) {
        Validate.nonNull((Object)modelRoot, (String)"model root");
        Mesh mergedMesh = CollisionShapeFactory.makeMergedMesh(modelRoot);
        GImpactCollisionShape result = new GImpactCollisionShape(mergedMesh);
        return result;
    }

    public static CollisionShape createMergedBoxShape(Spatial modelRoot) {
        Validate.nonNull((Object)modelRoot, (String)"model root");
        Mesh mergedMesh = CollisionShapeFactory.makeMergedMesh(modelRoot);
        int numVertices = mergedMesh.getVertexCount();
        int numFloats = 3 * numVertices;
        FloatBuffer positions = mergedMesh.getFloatBuffer(VertexBuffer.Type.Position);
        Vector3f maxima = new Vector3f();
        Vector3f minima = new Vector3f();
        MyBuffer.maxMin((FloatBuffer)positions, (int)0, (int)numFloats, (Vector3f)maxima, (Vector3f)minima);
        Vector3f centerOffset = new Vector3f();
        MyVector3f.midpoint((Vector3f)maxima, (Vector3f)minima, (Vector3f)centerOffset);
        Vector3f halfExtents = maxima.subtract(centerOffset);
        BoxCollisionShape box = new BoxCollisionShape(halfExtents);
        CompoundCollisionShape result = new CompoundCollisionShape();
        result.addChildShape((CollisionShape)box, centerOffset);
        return result;
    }

    public static HullCollisionShape createMergedHullShape(Spatial modelRoot) {
        Validate.nonNull((Object)modelRoot, (String)"model root");
        Mesh mergedMesh = CollisionShapeFactory.makeMergedMesh(modelRoot);
        HullCollisionShape result = new HullCollisionShape(mergedMesh);
        return result;
    }

    public static MeshCollisionShape createMergedMeshShape(Spatial modelRoot) {
        Validate.nonNull((Object)modelRoot, (String)"model root");
        Mesh mergedMesh = CollisionShapeFactory.makeMergedMesh(modelRoot);
        MeshCollisionShape result = new MeshCollisionShape(mergedMesh);
        return result;
    }

    public static CollisionShape createMeshShape(Spatial modelRoot) {
        if (modelRoot instanceof Terrain) {
            HeightfieldCollisionShape result = new HeightfieldCollisionShape((Terrain)modelRoot, modelRoot.getLocalScale());
            return result;
        }
        if (modelRoot instanceof Geometry) {
            return CollisionShapeFactory.createSingleMeshShape((Geometry)modelRoot, modelRoot);
        }
        if (modelRoot instanceof Node) {
            Node node = (Node)modelRoot;
            CompoundCollisionShape result = new CompoundCollisionShape();
            boolean meshAccurate = true;
            boolean dynamic = false;
            CollisionShapeFactory.createCompoundShape(node, node, result, meshAccurate, dynamic);
            return result;
        }
        throw new IllegalArgumentException("The model root must either be a Node or a Geometry!");
    }

    public static CompoundCollisionShape createVhacdShape(Spatial modelRoot, VHACDParameters parameters, CompoundCollisionShape addResult) {
        CompoundCollisionShape result;
        Validate.nonNull((Object)modelRoot, (String)"model root");
        Validate.nonNull((Object)parameters, (String)"parameters");
        Mesh mergedMesh = CollisionShapeFactory.makeMergedMesh(modelRoot);
        FloatBuffer positionBuffer = mergedMesh.getFloatBuffer(VertexBuffer.Type.Position);
        int numFloats = positionBuffer.limit();
        float[] positionArray = new float[numFloats];
        for (int offset = 0; offset < numFloats; ++offset) {
            positionArray[offset] = positionBuffer.get(offset);
        }
        IndexBuffer indexBuffer = mergedMesh.getIndicesAsList();
        int numIndices = indexBuffer.size();
        int[] indexArray = new int[numIndices];
        for (int offset = 0; offset < numIndices; ++offset) {
            indexArray[offset] = indexBuffer.get(offset);
        }
        List<VHACDHull> vhacdHulls = VHACD.compute(positionArray, indexArray, parameters);
        if (addResult == null) {
            int numHulls = vhacdHulls.size();
            result = new CompoundCollisionShape(numHulls);
        } else {
            result = addResult;
        }
        for (VHACDHull vhacdHull : vhacdHulls) {
            HullCollisionShape hullShape = new HullCollisionShape(vhacdHull);
            result.addChildShape(hullShape);
        }
        return result;
    }

    public static CompoundCollisionShape createVhacdShape(Spatial modelRoot, Vhacd4Parameters parameters, CompoundCollisionShape addResult) {
        CompoundCollisionShape result;
        Validate.nonNull((Object)modelRoot, (String)"model root");
        Validate.nonNull((Object)parameters, (String)"parameters");
        Mesh mergedMesh = CollisionShapeFactory.makeMergedMesh(modelRoot);
        FloatBuffer positionBuffer = mergedMesh.getFloatBuffer(VertexBuffer.Type.Position);
        int numFloats = positionBuffer.limit();
        float[] positionArray = new float[numFloats];
        for (int offset = 0; offset < numFloats; ++offset) {
            positionArray[offset] = positionBuffer.get(offset);
        }
        IndexBuffer indexBuffer = mergedMesh.getIndicesAsList();
        int numIndices = indexBuffer.size();
        int[] indexArray = new int[numIndices];
        for (int offset = 0; offset < numIndices; ++offset) {
            indexArray[offset] = indexBuffer.get(offset);
        }
        List<Vhacd4Hull> vhacdHulls = Vhacd4.compute(positionArray, indexArray, parameters);
        if (addResult == null) {
            int numHulls = vhacdHulls.size();
            result = new CompoundCollisionShape(numHulls);
        } else {
            result = addResult;
        }
        for (Vhacd4Hull vhacdHull : vhacdHulls) {
            HullCollisionShape hullShape = new HullCollisionShape(vhacdHull);
            result.addChildShape(hullShape);
        }
        return result;
    }

    private static void appendTriangles(Geometry geometry, Spatial modelRoot, FloatBuffer addPositions, IndexBuffer addIndices) {
        Mesh jmeMesh = geometry.getMesh();
        int indexBase = addPositions.position() / 3;
        IndexBuffer indexBuffer = jmeMesh.getIndicesAsList();
        int numIndices = indexBuffer.size();
        for (int offset = 0; offset < numIndices; ++offset) {
            int indexInGeometry = indexBuffer.get(offset);
            int indexInMergedMesh = indexBase + indexInGeometry;
            addIndices.put(indexInMergedMesh);
        }
        Transform transform = CollisionShapeFactory.relativeTransform((Spatial)geometry, modelRoot);
        Vector3f tmpPosition = new Vector3f();
        int numVertices = jmeMesh.getVertexCount();
        for (int vertexIndex = 0; vertexIndex < numVertices; ++vertexIndex) {
            MyMesh.vertexVector3f((Mesh)jmeMesh, (VertexBuffer.Type)VertexBuffer.Type.Position, (int)vertexIndex, (Vector3f)tmpPosition);
            MyMath.transform((Transform)transform, (Vector3f)tmpPosition, (Vector3f)tmpPosition);
            addPositions.put(tmpPosition.x);
            addPositions.put(tmpPosition.y);
            addPositions.put(tmpPosition.z);
        }
    }

    private static void createCompoundShape(Node modelRoot, Node parent, CompoundCollisionShape shape, boolean meshAccurate, boolean dynamic) {
        for (Spatial child : parent.getChildren()) {
            CollisionShape childShape;
            Boolean skipChild = (Boolean)child.getUserData("JmePhysicsIgnore");
            if (skipChild != null && skipChild.booleanValue()) continue;
            Transform transform = CollisionShapeFactory.relativeTransform(child, (Spatial)modelRoot);
            if (child instanceof Terrain) {
                childShape = new HeightfieldCollisionShape((Terrain)child, transform.getScale());
                shape.addChildShape(childShape, transform);
                continue;
            }
            if (child instanceof Node) {
                CollisionShapeFactory.createCompoundShape(modelRoot, (Node)child, shape, meshAccurate, dynamic);
                continue;
            }
            if (!(child instanceof Geometry)) continue;
            Geometry geometry = (Geometry)child;
            Vector3f centerOffset = new Vector3f(0.0f, 0.0f, 0.0f);
            if (meshAccurate) {
                childShape = dynamic ? CollisionShapeFactory.createSingleHullShape(geometry, (Spatial)modelRoot) : CollisionShapeFactory.createSingleMeshShape(geometry, (Spatial)modelRoot);
            } else {
                childShape = CollisionShapeFactory.createSingleBoxShape(geometry, (Spatial)modelRoot, centerOffset);
                MyQuaternion.rotate((Quaternion)transform.getRotation(), (Vector3f)centerOffset, (Vector3f)centerOffset);
                transform.getTranslation().addLocal(centerOffset);
            }
            if (childShape == null) continue;
            shape.addChildShape(childShape, transform);
        }
    }

    private static BoxCollisionShape createSingleBoxShape(Geometry geometry, Spatial modelRoot, Vector3f storeCenter) {
        Mesh mesh = geometry.getMesh();
        if (mesh == null) {
            return null;
        }
        int numVertices = mesh.getVertexCount();
        if (numVertices < 1) {
            return null;
        }
        Transform transform = CollisionShapeFactory.relativeTransform((Spatial)geometry, modelRoot);
        int numFloats = 3 * numVertices;
        FloatBuffer positions = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        Vector3f maxima = new Vector3f();
        Vector3f minima = new Vector3f();
        MyBuffer.maxMin((FloatBuffer)positions, (int)0, (int)numFloats, (Vector3f)maxima, (Vector3f)minima);
        MyVector3f.midpoint((Vector3f)maxima, (Vector3f)minima, (Vector3f)storeCenter);
        Vector3f halfExtents = maxima.subtract(storeCenter);
        BoxCollisionShape result = new BoxCollisionShape(halfExtents);
        result.setScale(transform.getScale());
        return result;
    }

    private static HullCollisionShape createSingleHullShape(Geometry geometry, Spatial modelRoot) {
        Mesh mesh = geometry.getMesh();
        if (mesh == null) {
            return null;
        }
        Transform transform = CollisionShapeFactory.relativeTransform((Spatial)geometry, modelRoot);
        HullCollisionShape hullShape = new HullCollisionShape(mesh);
        hullShape.setScale(transform.getScale());
        return hullShape;
    }

    private static MeshCollisionShape createSingleMeshShape(Geometry geometry, Spatial modelRoot) {
        Mesh mesh = geometry.getMesh();
        if (mesh == null || !MyMesh.hasTriangles((Mesh)mesh)) {
            return null;
        }
        Transform transform = CollisionShapeFactory.relativeTransform((Spatial)geometry, modelRoot);
        MeshCollisionShape result = new MeshCollisionShape(mesh);
        result.setScale(transform.getScale());
        return result;
    }

    private static List<Geometry> listUntaggedGeometries(Node parent, List<Geometry> addResult) {
        Validate.nonNull((Object)parent, (String)"subtree");
        ArrayList<Geometry> result = addResult == null ? new ArrayList<Geometry>(50) : addResult;
        for (Spatial child : parent.getChildren()) {
            Boolean skipChild = (Boolean)child.getUserData("JmePhysicsIgnore");
            if (skipChild != null && skipChild.booleanValue()) continue;
            if (child instanceof Node) {
                CollisionShapeFactory.listUntaggedGeometries((Node)child, result);
                continue;
            }
            result.add((Geometry)child);
        }
        return result;
    }

    private static Mesh makeMergedMesh(Spatial modelRoot) {
        List<Object> untaggedGeometries;
        if (modelRoot instanceof Geometry) {
            untaggedGeometries = new ArrayList<Geometry>(1);
            untaggedGeometries.add((Geometry)modelRoot);
        } else if (modelRoot instanceof Node) {
            untaggedGeometries = CollisionShapeFactory.listUntaggedGeometries((Node)modelRoot, null);
        } else {
            throw new IllegalArgumentException("The model root must either be a Node or a Geometry!");
        }
        ArrayList<Geometry> includedGeometries = new ArrayList<Geometry>(untaggedGeometries.size());
        int totalIndices = 0;
        int totalVertices = 0;
        for (Geometry geometry : untaggedGeometries) {
            int numVertices;
            Object indexBuffer;
            int numIndices;
            Mesh jmeMesh = geometry.getMesh();
            if (jmeMesh == null || (numIndices = (indexBuffer = jmeMesh.getIndicesAsList()).size()) == 0 || (numVertices = jmeMesh.getVertexCount()) == 0) continue;
            includedGeometries.add(geometry);
            totalIndices += numIndices;
            totalVertices += numVertices;
        }
        IndexBuffer indexBuffer = IndexBuffer.createIndexBuffer((int)totalVertices, (int)totalIndices);
        int n = 3 * totalVertices;
        FloatBuffer positionBuffer = BufferUtils.createFloatBuffer((int)n);
        for (Geometry geometry : includedGeometries) {
            CollisionShapeFactory.appendTriangles(geometry, modelRoot, positionBuffer, indexBuffer);
        }
        VertexBuffer.Format ibFormat = indexBuffer.getFormat();
        Buffer ibData = indexBuffer.getBuffer();
        Mesh result = new Mesh();
        result.setBuffer(VertexBuffer.Type.Index, 3, ibFormat, ibData);
        result.setBuffer(VertexBuffer.Type.Position, 3, positionBuffer);
        return result;
    }

    private static Transform relativeTransform(Spatial spatial, Spatial modelRoot) {
        Transform result = new Transform();
        for (Spatial currentSpatial = spatial; currentSpatial != modelRoot; currentSpatial = currentSpatial.getParent()) {
            MyMath.combine((Transform)result, (Transform)currentSpatial.getLocalTransform(), (Transform)result);
        }
        Transform mrTransform = new Transform();
        mrTransform.setScale(modelRoot.getLocalScale());
        MyMath.combine((Transform)result, (Transform)mrTransform, (Transform)result);
        return result;
    }
}

