/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.util;

import com.jme3.math.Transform;
import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyVector3f;
import jme3utilities.math.MyVolume;
import jme3utilities.math.RectangularSolid;
import jme3utilities.math.VectorSetUsingBuffer;

@Deprecated
class DebugMeshCallback {
    private static final int numAxes = 3;
    private static final int vpt = 3;
    public static final Logger logger = Logger.getLogger(DebugMeshCallback.class.getName());
    private final ArrayList<Vector3f> list = new ArrayList(250);

    DebugMeshCallback() {
    }

    Vector3f[] footprint(Transform meshToWorld) {
        int position;
        int vectorIndex;
        assert (meshToWorld != null);
        VectorSetUsingBuffer distinct = new VectorSetUsingBuffer(this.list.size(), false);
        distinct.addAll(this.list);
        FloatBuffer floatBuffer = distinct.toBuffer();
        int numFloats = floatBuffer.limit();
        MyBuffer.transform((FloatBuffer)floatBuffer, (int)0, (int)numFloats, (Transform)meshToWorld);
        float minY = Float.POSITIVE_INFINITY;
        int numVectors = numFloats / 3;
        for (vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            position = vectorIndex * 3 + 1;
            float y = floatBuffer.get(position);
            if (!(y < minY)) continue;
            minY = y;
        }
        for (vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            position = vectorIndex * 3 + 1;
            floatBuffer.put(position, minY);
        }
        RectangularSolid solid = new RectangularSolid(floatBuffer, 0, numFloats);
        Vector3f maxima = solid.maxima(null);
        Vector3f minima = solid.minima(null);
        float midX = (minima.x + maxima.x) / 2.0f;
        Vector3f[] cornerLocations = new Vector3f[]{new Vector3f(midX, maxima.y, maxima.z), new Vector3f(midX, minima.y, maxima.z), new Vector3f(midX, maxima.y, minima.z), new Vector3f(midX, minima.y, minima.z)};
        for (Vector3f location : cornerLocations) {
            solid.localToWorld(location, location);
        }
        return cornerLocations;
    }

    FloatBuffer getFaceNormals() {
        int numVertices = this.list.size();
        int numTriangles = numVertices / 3;
        assert (numTriangles * 3 == numVertices) : numVertices;
        int numFloats = 3 * numVertices;
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)numFloats);
        Triangle triangle = new Triangle();
        for (int triIndex = 0; triIndex < numTriangles; ++triIndex) {
            int firstVertex = 3 * triIndex;
            Vector3f pos1 = this.list.get(firstVertex);
            Vector3f pos2 = this.list.get(firstVertex + 1);
            Vector3f pos3 = this.list.get(firstVertex + 2);
            triangle.set(pos1, pos2, pos3);
            Vector3f normal = triangle.getNormal();
            for (int j = 0; j < 3; ++j) {
                buffer.put(normal.x);
                buffer.put(normal.y);
                buffer.put(normal.z);
            }
        }
        buffer.flip();
        return buffer;
    }

    FloatBuffer getVertices() {
        int numFloats = 3 * this.list.size();
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)numFloats);
        for (Vector3f location : this.list) {
            buffer.put(location.x);
            buffer.put(location.y);
            buffer.put(location.z);
        }
        return buffer;
    }

    float maxDistance(Transform meshToWorld) {
        double maxSquaredDistance = 0.0;
        Vector3f tmpVector = new Vector3f();
        for (Vector3f vertex : this.list) {
            MyMath.transform((Transform)meshToWorld, (Vector3f)vertex, (Vector3f)tmpVector);
            double lengthSquared = MyVector3f.lengthSquared((Vector3f)tmpVector);
            if (!(lengthSquared > maxSquaredDistance)) continue;
            maxSquaredDistance = lengthSquared;
        }
        float result = (float)Math.sqrt(maxSquaredDistance);
        return result;
    }

    float volumeConvex() {
        int numVertices = this.list.size();
        int numTriangles = numVertices / 3;
        assert (numTriangles * 3 == numVertices) : numVertices;
        double total = 0.0;
        if (numTriangles > 0) {
            Vector3f fixed = this.list.get(0);
            for (int triIndex = 0; triIndex < numTriangles; ++triIndex) {
                int firstVertex = 3 * triIndex;
                Vector3f pos1 = this.list.get(firstVertex);
                Vector3f pos2 = this.list.get(firstVertex + 1);
                Vector3f pos3 = this.list.get(firstVertex + 2);
                double tetraVolume = MyVolume.tetrahedronVolume((Vector3f)pos1, (Vector3f)pos2, (Vector3f)pos3, (Vector3f)fixed);
                total += tetraVolume;
            }
        }
        float volume = (float)total;
        assert (volume >= 0.0f) : volume;
        return volume;
    }

    private void addVector(float x, float y, float z, int part, int index) {
        this.list.add(new Vector3f(x, y, z));
    }
}

