/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.util;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.MeshNormals;

class DebugMeshKey {
    public static final Logger logger = Logger.getLogger(DebugMeshKey.class.getName());
    private final float margin;
    private final int resolution;
    private final long shapeId;
    private final MeshNormals normals;
    private final Vector3f scale;

    DebugMeshKey(CollisionShape shape, MeshNormals normals, int resolution) {
        assert (normals != null);
        assert (shape != null);
        assert (!(shape instanceof CompoundCollisionShape));
        this.normals = normals;
        this.margin = shape.getMargin();
        this.resolution = shape.isConvex() ? resolution : 0;
        this.shapeId = shape.nativeId();
        this.scale = shape.getScale(null);
    }

    long shapeId() {
        return this.shapeId;
    }

    public boolean equals(Object otherObject) {
        boolean result;
        if (otherObject == this) {
            result = true;
        } else if (otherObject != null && otherObject.getClass() == this.getClass()) {
            DebugMeshKey otherKey = (DebugMeshKey)otherObject;
            result = this.shapeId == otherKey.shapeId && this.scale.equals((Object)otherKey.scale) && Float.compare(this.margin, otherKey.margin) == 0 && this.normals == otherKey.normals && this.resolution == otherKey.resolution;
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        int result = (int)(this.shapeId >> 4);
        result = 7 * result + this.scale.hashCode();
        result = 7 * result + Float.floatToIntBits(this.margin);
        result = 7 * result + this.resolution;
        result = 7 * result + this.normals.ordinal();
        return result;
    }

    public String toString() {
        String result = String.format("shape=%x scale=%s margin=%f res=%d normals=%s", this.shapeId, this.scale, Float.valueOf(this.margin), this.resolution, this.normals);
        return result;
    }
}

