/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.util;

import com.jme3.bullet.collision.shapes.infos.IndexedMesh;
import com.jme3.bullet.objects.PhysicsSoftBody;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.IntPair;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyQuaternion;
import jme3utilities.math.MyVector3f;

public final class NativeSoftBodyUtil {
    private static final int numAxes = 3;
    private static final int vpe = 2;
    private static final int vpt = 3;
    public static final Logger logger = Logger.getLogger(NativeSoftBodyUtil.class.getName());

    private NativeSoftBodyUtil() {
    }

    public static void appendFromLineMesh(Mesh mesh, PhysicsSoftBody softBody) {
        Mesh.Mode mode = mesh.getMode();
        assert (mode == Mesh.Mode.Lines) : mode;
        Validate.nonNull((Object)softBody, (String)"soft body");
        FloatBuffer positions = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        assert (positions.isDirect());
        softBody.appendNodes(positions);
        IndexBuffer lineIndices = mesh.getIndexBuffer();
        assert (lineIndices.getBuffer().isDirect());
        softBody.appendLinks(lineIndices);
    }

    public static void appendFromNativeMesh(IndexedMesh mesh, PhysicsSoftBody softBody) {
        Validate.nonNull((Object)softBody, (String)"soft body");
        FloatBuffer positions = mesh.copyVertexPositions();
        assert (positions.isDirect());
        softBody.appendNodes(positions);
        IntBuffer triangleIndices = mesh.copyIndices();
        assert (triangleIndices.isDirect());
        IndexBuffer indexBuffer = IndexBuffer.wrapIndexBuffer((Buffer)triangleIndices);
        softBody.appendFaces(indexBuffer);
        int size = triangleIndices.capacity();
        HashSet<IntPair> uniqueEdges = new HashSet<IntPair>(3 * size);
        for (int intOffset = 0; intOffset < size; intOffset += 3) {
            int ti0 = triangleIndices.get(intOffset);
            int ti1 = triangleIndices.get(intOffset + 1);
            int ti2 = triangleIndices.get(intOffset + 2);
            uniqueEdges.add(new IntPair(ti0, ti1));
            uniqueEdges.add(new IntPair(ti1, ti2));
            uniqueEdges.add(new IntPair(ti0, ti2));
        }
        int numUniqueEdges = uniqueEdges.size();
        int indexCount = 2 * numUniqueEdges;
        IntBuffer links = BufferUtils.createIntBuffer((int)indexCount);
        int edgeIndex = 0;
        for (IntPair edge : uniqueEdges) {
            links.put(edgeIndex, edge.smaller());
            links.put(edgeIndex + 1, edge.larger());
            edgeIndex += 2;
        }
        indexBuffer = IndexBuffer.wrapIndexBuffer((Buffer)links);
        softBody.appendLinks(indexBuffer);
    }

    public static void appendFromTriMesh(Mesh mesh, PhysicsSoftBody softBody) {
        Mesh.Mode mode = mesh.getMode();
        assert (mode == Mesh.Mode.Triangles) : mode;
        Validate.nonNull((Object)softBody, (String)"soft body");
        FloatBuffer positions = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        assert (positions.isDirect());
        softBody.appendNodes(positions);
        IndexBuffer triangleIndices = mesh.getIndexBuffer();
        assert (triangleIndices.getBuffer().isDirect());
        softBody.appendFaces(triangleIndices);
        int size = triangleIndices.size();
        HashSet<IntPair> uniqueEdges = new HashSet<IntPair>(3 * size);
        for (int intOffset = 0; intOffset < size; intOffset += 3) {
            int ti0 = triangleIndices.get(intOffset);
            int ti1 = triangleIndices.get(intOffset + 1);
            int ti2 = triangleIndices.get(intOffset + 2);
            uniqueEdges.add(new IntPair(ti0, ti1));
            uniqueEdges.add(new IntPair(ti1, ti2));
            uniqueEdges.add(new IntPair(ti0, ti2));
        }
        int vertexCount = positions.limit();
        int numUniqueEdges = uniqueEdges.size();
        int indexCount = 2 * numUniqueEdges;
        IndexBuffer links = IndexBuffer.createIndexBuffer((int)vertexCount, (int)indexCount);
        int edgeIndex = 0;
        for (IntPair edge : uniqueEdges) {
            links.put(edgeIndex, edge.smaller());
            links.put(edgeIndex + 1, edge.larger());
            edgeIndex += 2;
        }
        softBody.appendLinks(links);
    }

    public static void appendTetras(PhysicsSoftBody softBody) {
        int centerIndex = softBody.countNodes();
        Vector3f centerLocation = softBody.getPhysicsLocation(null);
        FloatBuffer buffer = BufferUtils.createFloatBuffer((Vector3f[])new Vector3f[]{centerLocation});
        softBody.appendNodes(buffer);
        int numNodes = softBody.countNodes();
        assert (numNodes == centerIndex + 1);
        int numFaces = softBody.countFaces();
        IndexBuffer newTetras = IndexBuffer.createIndexBuffer((int)numNodes, (int)(4 * numFaces));
        IntBuffer faceIndices = softBody.copyFaces(null);
        for (int faceIndex = 0; faceIndex < numFaces; ++faceIndex) {
            int fi0 = faceIndices.get(3 * faceIndex);
            int fi1 = faceIndices.get(3 * faceIndex + 1);
            int fi2 = faceIndices.get(3 * faceIndex + 2);
            newTetras.put(4 * faceIndex, fi0);
            newTetras.put(4 * faceIndex + 1, fi1);
            newTetras.put(4 * faceIndex + 2, fi2);
            newTetras.put(4 * faceIndex + 3, centerIndex);
        }
        softBody.appendTetras(newTetras);
    }

    public static IntBuffer generateIndexMap(FloatBuffer positionBuffer) {
        int numFloats = positionBuffer.limit();
        Validate.require((numFloats % 3 == 0 ? 1 : 0) != 0, (String)"limit a multiple of 3");
        int numVertices = numFloats / 3;
        IntBuffer result = BufferUtils.createIntBuffer((int)numVertices);
        HashMap<Vector3f, Integer> tmpHashMap = new HashMap<Vector3f, Integer>(numVertices);
        int nextMappedIndex = 0;
        for (int vertexIndex = 0; vertexIndex < numVertices; ++vertexIndex) {
            Vector3f position = new Vector3f();
            MyBuffer.get((FloatBuffer)positionBuffer, (int)(3 * vertexIndex), (Vector3f)position);
            MyVector3f.standardize((Vector3f)position, (Vector3f)position);
            if (!tmpHashMap.containsKey(position)) {
                tmpHashMap.put(position, nextMappedIndex);
                result.put(nextMappedIndex);
                ++nextMappedIndex;
                continue;
            }
            int mappedIndex = (Integer)tmpHashMap.get(position);
            result.put(mappedIndex);
        }
        result.flip();
        return result;
    }

    public static IndexBuffer mapIndices(IntBuffer indexMap, IndexBuffer inputBuffer, IndexBuffer reuseBuffer) {
        IndexBuffer result;
        int numIndices = inputBuffer.size();
        if (reuseBuffer == null) {
            int vertexCount = Integer.MAX_VALUE;
            result = IndexBuffer.createIndexBuffer((int)vertexCount, (int)numIndices);
        } else {
            int reuseBufferSize = reuseBuffer.size();
            if (reuseBufferSize < numIndices) {
                logger.log(Level.SEVERE, "outputSize={0}", reuseBufferSize);
                String message = String.format("Reuse buffer size must be greater than or equal to %d.", numIndices);
                throw new IllegalArgumentException(message);
            }
            result = reuseBuffer;
        }
        for (int offset = 0; offset < numIndices; ++offset) {
            int oldIndex = inputBuffer.get(offset);
            int newIndex = indexMap.get(oldIndex);
            result.put(offset, newIndex);
        }
        result.getBuffer().limit(numIndices);
        return result;
    }

    public static FloatBuffer mapVertexData(IntBuffer indexMap, FloatBuffer inputBuffer, int numFloatsPerVertex) {
        Validate.nonNull((Object)indexMap, (String)"index map");
        Validate.positive((int)numFloatsPerVertex, (String)"number of floats per vertex");
        int numFloats = inputBuffer.limit();
        assert (numFloats % numFloatsPerVertex == 0) : numFloats;
        int numVertices = numFloats / numFloatsPerVertex;
        FloatBuffer result = BufferUtils.createFloatBuffer((int)numFloats);
        int lastNewVIndex = -1;
        for (int oldVIndex = 0; oldVIndex < numVertices; ++oldVIndex) {
            int newVIndex = indexMap.get(oldVIndex);
            for (int i = 0; i < numFloatsPerVertex; ++i) {
                int oldFloatIndex = numFloatsPerVertex * oldVIndex + i;
                float x = inputBuffer.get(oldFloatIndex);
                int newFloatIndex = numFloatsPerVertex * newVIndex + i;
                result.put(newFloatIndex, x);
            }
            if (newVIndex <= lastNewVIndex) continue;
            lastNewVIndex = newVIndex;
        }
        int newLimit = numFloatsPerVertex * (lastNewVIndex + 1);
        result.limit(newLimit);
        return result;
    }

    public static void updateClusterMesh(PhysicsSoftBody body, Mesh store, boolean meshInLocalSpace) {
        long bodyId = body.nativeId();
        FloatBuffer positionBuffer = store.getFloatBuffer(VertexBuffer.Type.Position);
        assert (positionBuffer != null);
        NativeSoftBodyUtil.updateClusterMesh(bodyId, positionBuffer, meshInLocalSpace);
        store.getBuffer(VertexBuffer.Type.Position).setUpdateNeeded();
    }

    public static void updateMesh(PhysicsSoftBody body, IntBuffer vertexToNodeMap, Mesh store, boolean meshInLocalSpace, boolean updateNormals, Transform physicsToMesh) {
        long bodyId = body.nativeId();
        FloatBuffer positionBuffer = store.getFloatBuffer(VertexBuffer.Type.Position);
        assert (positionBuffer != null);
        FloatBuffer normalBuffer = null;
        if (updateNormals) {
            normalBuffer = store.getFloatBuffer(VertexBuffer.Type.Normal);
            assert (normalBuffer != null);
        }
        if (vertexToNodeMap != null) {
            NativeSoftBodyUtil.updateMesh(bodyId, vertexToNodeMap, positionBuffer, normalBuffer, meshInLocalSpace, updateNormals);
        } else {
            NativeSoftBodyUtil.updateMesh(bodyId, positionBuffer, normalBuffer, meshInLocalSpace, updateNormals);
        }
        if (physicsToMesh != null) {
            Vector3f tempVector = new Vector3f();
            positionBuffer.rewind();
            while (positionBuffer.hasRemaining()) {
                positionBuffer.mark();
                tempVector.x = positionBuffer.get();
                tempVector.y = positionBuffer.get();
                tempVector.z = positionBuffer.get();
                MyMath.transform((Transform)physicsToMesh, (Vector3f)tempVector, (Vector3f)tempVector);
                positionBuffer.reset();
                positionBuffer.put(tempVector.x);
                positionBuffer.put(tempVector.y);
                positionBuffer.put(tempVector.z);
            }
            if (normalBuffer != null) {
                Quaternion p2mr = physicsToMesh.getRotation();
                normalBuffer.rewind();
                while (normalBuffer.hasRemaining()) {
                    normalBuffer.mark();
                    tempVector.x = normalBuffer.get();
                    tempVector.y = normalBuffer.get();
                    tempVector.z = normalBuffer.get();
                    MyQuaternion.rotate((Quaternion)p2mr, (Vector3f)tempVector, (Vector3f)tempVector);
                    normalBuffer.reset();
                    normalBuffer.put(tempVector.x);
                    normalBuffer.put(tempVector.y);
                    normalBuffer.put(tempVector.z);
                }
            }
        }
        store.getBuffer(VertexBuffer.Type.Position).setUpdateNeeded();
        if (normalBuffer != null) {
            store.getBuffer(VertexBuffer.Type.Normal).setUpdateNeeded();
        }
    }

    public static void updatePinMesh(PhysicsSoftBody body, Mesh store, boolean meshInLocalSpace) {
        long bodyId = body.nativeId();
        FloatBuffer positionBuffer = store.getFloatBuffer(VertexBuffer.Type.Position);
        assert (positionBuffer != null);
        NativeSoftBodyUtil.updatePinMesh(bodyId, positionBuffer, meshInLocalSpace);
        store.getBuffer(VertexBuffer.Type.Position).setUpdateNeeded();
    }

    private static native void updateClusterMesh(long var0, FloatBuffer var2, boolean var3);

    private static native void updateMesh(long var0, IntBuffer var2, FloatBuffer var3, FloatBuffer var4, boolean var5, boolean var6);

    private static native void updateMesh(long var0, FloatBuffer var2, FloatBuffer var3, boolean var4, boolean var5);

    private static native void updatePinMesh(long var0, FloatBuffer var2, boolean var3);
}

