/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.util;

import com.jme3.bullet.debug.DebugMeshInitListener;
import com.jme3.bullet.util.DebugShapeFactory;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class PlaneDmiListener
implements DebugMeshInitListener {
    public static final Logger logger = Logger.getLogger(PlaneDmiListener.class.getName());
    private final float textureScale;

    public PlaneDmiListener(float sideLength) {
        Validate.positive((float)sideLength, (String)"side length");
        float meshSideLength = DebugShapeFactory.meshSideLength();
        this.textureScale = meshSideLength / sideLength;
    }

    @Override
    public void debugMeshInit(Mesh debugMesh) {
        int numVertices = 8;
        int numFloats = 2 * numVertices;
        FloatBuffer uvs = BufferUtils.createFloatBuffer((int)numFloats);
        debugMesh.setBuffer(VertexBuffer.Type.TexCoord, 2, uvs);
        for (int sideIndex = 0; sideIndex < 2; ++sideIndex) {
            uvs.put(new float[]{this.textureScale, this.textureScale, this.textureScale, 0.0f, 0.0f, 0.0f, 0.0f, this.textureScale});
        }
        assert (uvs.position() == numFloats);
        uvs.flip();
    }
}

