/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.minie;

import com.jme3.bullet.animation.DacLinks;
import com.jme3.bullet.animation.PhysicsLink;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.joints.JointEnd;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsBody;
import java.util.logging.Logger;

public class DacUserFilter
implements BulletDebugAppState.DebugAppStateFilter {
    private static final Logger logger = Logger.getLogger(DacUserFilter.class.getName());
    private final DacLinks dac;

    public DacUserFilter(DacLinks dac) {
        this.dac = dac;
    }

    @Override
    public boolean displayObject(Object physicsObject) {
        boolean result = false;
        if (physicsObject instanceof PhysicsCollisionObject) {
            PhysicsLink link;
            PhysicsCollisionObject pco = (PhysicsCollisionObject)physicsObject;
            Object user = pco.getUserObject();
            if (user instanceof PhysicsLink && (link = (PhysicsLink)user).getControl() == this.dac) {
                result = true;
            }
        } else if (physicsObject instanceof PhysicsJoint) {
            PhysicsJoint joint = (PhysicsJoint)physicsObject;
            PhysicsBody a = joint.getBody(JointEnd.A);
            if (this.displayObject(a)) {
                result = true;
            } else {
                PhysicsBody b = joint.getBody(JointEnd.B);
                if (this.displayObject(b)) {
                    result = true;
                }
            }
        }
        return result;
    }
}

