/*
 * Decompiled with CFR 0.152.
 */
package vhacd;

import com.jme3.util.BufferUtils;
import com.jme3.util.SafeArrayList;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.Validate;
import vhacd.VHACDHull;
import vhacd.VHACDParameters;
import vhacd.VHACDProgressListener;

public final class VHACD {
    private static final int vpt = 3;
    public static final Logger logger = Logger.getLogger(VHACD.class.getName());
    private static final Collection<VHACDProgressListener> progressListeners = new SafeArrayList(VHACDProgressListener.class);
    private static List<VHACDHull> results;

    private VHACD() {
    }

    public static void addProgressListener(VHACDProgressListener listener) {
        Validate.nonNull((Object)listener, (String)"listener");
        assert (!progressListeners.contains(listener));
        progressListeners.add(listener);
    }

    public static List<VHACDHull> compute(float[] positions, int[] indices, VHACDParameters params) {
        Validate.nonNull((Object)positions, (String)"positions");
        Validate.nonNull((Object)indices, (String)"indices");
        assert (positions.length % 3 == 0) : positions.length;
        assert (indices.length % 3 == 0) : indices.length;
        FloatBuffer positionsBuffer = BufferUtils.createFloatBuffer((float[])positions);
        IntBuffer indexBuffer = BufferUtils.createIntBuffer((int[])indices);
        results = new ArrayList<VHACDHull>(50);
        VHACD.compute(positionsBuffer, indexBuffer, params.nativeId(), params.getDebugEnabled());
        return results;
    }

    public static void removeProgressListener(VHACDProgressListener listener) {
        Validate.nonNull((Object)listener, (String)"listener");
        boolean success = progressListeners.remove(listener);
        assert (success);
    }

    private static void addHull(long hullId) {
        VHACDHull hull = new VHACDHull(hullId);
        results.add(hull);
    }

    private static void update(double overallPercent, double stagePercent, double operationPercent, String stageName, String operationName) {
        for (VHACDProgressListener listener : progressListeners) {
            listener.update(overallPercent, stagePercent, operationPercent, stageName, operationName);
        }
    }

    private static native void compute(FloatBuffer var0, IntBuffer var1, long var2, boolean var4);
}

