/*
 * Decompiled with CFR 0.152.
 */
package vhacd;

import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.logging.Logger;

public class VHACDHull {
    public static final Logger logger = Logger.getLogger(VHACDHull.class.getName());
    private final float[] positions;

    VHACDHull(long hullId) {
        assert (hullId != 0L);
        int numFloats = VHACDHull.getNumFloats(hullId);
        assert (numFloats % 3 == 0) : numFloats;
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer((int)numFloats);
        VHACDHull.getPositions(hullId, floatBuffer);
        this.positions = new float[numFloats];
        for (int floatIndex = 0; floatIndex < numFloats; ++floatIndex) {
            this.positions[floatIndex] = floatBuffer.get(floatIndex);
        }
    }

    public float[] clonePositions() {
        int numFloats = this.positions.length;
        assert (numFloats % 3 == 0) : numFloats;
        float[] result = new float[numFloats];
        System.arraycopy(this.positions, 0, result, 0, numFloats);
        return result;
    }

    private static native int getNumFloats(long var0);

    private static native void getPositions(long var0, FloatBuffer var2);
}

