/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.wes;

import com.jme3.anim.AnimClip;
import com.jme3.anim.AnimTrack;
import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.anim.SkinningControl;
import com.jme3.anim.TransformTrack;
import com.jme3.anim.util.HasLocalTransform;
import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.animation.Track;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.plugins.bvh.BoneMapping;
import com.jme3.scene.plugins.bvh.SkeletonMapping;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.MyAnimation;
import jme3utilities.MySkeleton;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;
import jme3utilities.wes.TweenTransforms;

public class Pose
implements JmeCloneable {
    private static final Logger logger = Logger.getLogger(Pose.class.getName());
    private Armature armature;
    private List<Transform> bindTransforms;
    private List<Transform> transforms;
    private Skeleton skeleton;

    public Pose(Armature armature) {
        this.armature = armature;
        this.skeleton = null;
        int jointCount = armature == null ? 0 : armature.getJointCount();
        this.bindTransforms = new ArrayList<Transform>(jointCount);
        this.transforms = new ArrayList<Transform>(jointCount);
        if (armature != null) {
            Cloner cloner = new Cloner();
            for (Joint joint : armature.getJointList()) {
                Geometry target;
                Node attachment = MySkeleton.getAttachments((Joint)joint);
                if (attachment != null) {
                    cloner.setClonedValue((Object)attachment, (Object)attachment);
                }
                if ((target = MySkeleton.getTargetGeometry((Joint)joint)) == null) continue;
                cloner.setClonedValue((Object)target, (Object)target);
            }
            Armature clonedArmature = (Armature)cloner.clone((Object)armature);
            clonedArmature.applyBindPose();
            for (int jointIndex = 0; jointIndex < jointCount; ++jointIndex) {
                Transform transform = new Transform();
                this.transforms.add(transform);
                Joint cloneJoint = clonedArmature.getJoint(jointIndex);
                Transform bindTransform = cloneJoint.getLocalTransform();
                this.bindTransforms.add(bindTransform);
            }
        }
        assert (this.bindTransforms.size() == jointCount);
        assert (this.transforms.size() == jointCount);
    }

    public Pose(Skeleton skeleton) {
        this.armature = null;
        this.skeleton = skeleton;
        int boneCount = skeleton == null ? 0 : skeleton.getBoneCount();
        this.bindTransforms = null;
        this.transforms = new ArrayList<Transform>(boneCount);
        for (int boneIndex = 0; boneIndex < boneCount; ++boneIndex) {
            Transform transform = new Transform();
            this.transforms.add(transform);
        }
        assert (this.transforms.size() == boneCount);
    }

    public void applyTo(Armature targetArmature) {
        Validate.nonNull((Object)targetArmature, (String)"target armature");
        int numJoints = this.countBones();
        assert (targetArmature.getJointCount() == numJoints) : numJoints;
        Transform tempTransform = new Transform();
        for (int jointIndex = 0; jointIndex < numJoints; ++jointIndex) {
            this.localTransform(jointIndex, tempTransform);
            Joint targetJoint = targetArmature.getJoint(jointIndex);
            targetJoint.setLocalTransform(tempTransform);
        }
    }

    public void applyTo(Skeleton targetSkeleton) {
        Validate.nonNull((Object)targetSkeleton, (String)"target skeleton");
        int numBones = this.countBones();
        assert (targetSkeleton.getBoneCount() == numBones) : numBones;
        Transform tempTransform = new Transform();
        for (int boneIndex = 0; boneIndex < numBones; ++boneIndex) {
            this.localTransform(boneIndex, tempTransform);
            Bone targetBone = targetSkeleton.getBone(boneIndex);
            MySkeleton.setLocalTransform((Bone)targetBone, (Transform)tempTransform);
        }
    }

    public Transform bindTransform(int boneIndex, Transform storeResult) {
        Transform result;
        Validate.nonNegative((int)boneIndex, (String)"bone index");
        Transform transform = result = storeResult == null ? new Transform() : storeResult;
        if (this.skeleton == null) {
            Transform transform2 = this.bindTransforms.get(boneIndex);
            result.set(transform2);
        } else {
            Bone bone = this.skeleton.getBone(boneIndex);
            MySkeleton.copyBindTransform((Bone)bone, (Transform)result);
        }
        return result;
    }

    public Animation capture(String animationName) {
        Validate.nonNull((Object)animationName, (String)"animation name");
        float duration = 0.0f;
        Animation result = new Animation(animationName, duration);
        int numBones = this.countBones();
        Transform transform = new Transform();
        for (int boneIndex = 0; boneIndex < numBones; ++boneIndex) {
            this.userTransform(boneIndex, transform);
            if (MyMath.isIdentity((Transform)transform)) continue;
            Vector3f translation = transform.getTranslation();
            Quaternion rotation = transform.getRotation();
            Vector3f scale = transform.getScale();
            BoneTrack track = MyAnimation.newBoneTrack((int)boneIndex, (Vector3f)translation, (Quaternion)rotation, (Vector3f)scale);
            result.addTrack((Track)track);
        }
        return result;
    }

    public AnimClip captureToClip(String clipName) {
        Validate.nonNull((Object)clipName, (String)"clip name");
        AnimClip result = new AnimClip(clipName);
        int numJoints = this.countBones();
        ArrayList<TransformTrack> trackList = new ArrayList<TransformTrack>(numJoints);
        for (int jointIndex = 0; jointIndex < numJoints; ++jointIndex) {
            Transform transform = this.localTransform(jointIndex, null);
            if (MyMath.isIdentity((Transform)transform)) continue;
            Joint target = this.armature.getJoint(jointIndex);
            float[] times = new float[]{0.0f};
            Vector3f[] translations = new Vector3f[]{transform.getTranslation()};
            Quaternion[] rotations = new Quaternion[]{transform.getRotation()};
            Vector3f[] scales = new Vector3f[]{transform.getScale()};
            TransformTrack track = new TransformTrack((HasLocalTransform)target, times, translations, rotations, scales);
            trackList.add(track);
        }
        int numTracks = trackList.size();
        AnimTrack[] trackArray = new AnimTrack[numTracks];
        trackList.toArray(trackArray);
        result.setTracks(trackArray);
        return result;
    }

    public int countBones() {
        int count = this.transforms.size();
        return count;
    }

    public int findBone(String boneName) {
        int result = this.skeleton == null ? this.armature.getJointIndex(boneName) : this.skeleton.getBoneIndex(boneName);
        return result;
    }

    public Object findSkeleton() {
        if (this.skeleton == null) {
            return this.armature;
        }
        return this.skeleton;
    }

    public Quaternion localRotation(int boneIndex, Quaternion storeResult) {
        Quaternion bindRotation;
        Validate.nonNegative((int)boneIndex, (String)"bone index");
        if (this.skeleton == null) {
            Transform bindTransform = this.bindTransforms.get(boneIndex);
            bindRotation = bindTransform.getRotation();
        } else {
            Bone bone = this.skeleton.getBone(boneIndex);
            bindRotation = bone.getBindRotation();
        }
        Transform userTransform = this.transforms.get(boneIndex);
        Quaternion userRotation = userTransform.getRotation();
        Quaternion result = bindRotation.mult(userRotation, storeResult);
        return result;
    }

    public Transform localTransform(int boneIndex, Transform storeResult) {
        Validate.nonNegative((int)boneIndex, (String)"bone index");
        Transform result = this.bindTransform(boneIndex, storeResult);
        Transform user = this.userTransform(boneIndex, null);
        result.getTranslation().addLocal(user.getTranslation());
        result.getRotation().multLocal(user.getRotation());
        result.getScale().multLocal(user.getScale());
        return result;
    }

    public Vector3f modelLocation(int boneIndex, Vector3f storeResult) {
        Validate.nonNegative((int)boneIndex, (String)"bone index");
        Transform modelTransform = this.modelTransform(boneIndex, null);
        Vector3f result = modelTransform.getTranslation(storeResult);
        return result;
    }

    public Quaternion modelOrientation(int boneIndex, Quaternion storeResult) {
        Quaternion result;
        int parentIndex;
        boolean isRoot;
        Validate.nonNegative((int)boneIndex, (String)"bone index");
        if (this.skeleton == null) {
            Joint joint = this.armature.getJoint(boneIndex);
            Joint parentJoint = joint.getParent();
            isRoot = parentJoint == null;
            parentIndex = this.armature.getJointIndex(parentJoint);
        } else {
            Bone bone = this.skeleton.getBone(boneIndex);
            Bone parentBone = bone.getParent();
            isRoot = parentBone == null;
            parentIndex = this.skeleton.getBoneIndex(parentBone);
        }
        Quaternion quaternion = result = storeResult == null ? new Quaternion() : storeResult;
        if (isRoot) {
            this.localRotation(boneIndex, result);
        } else {
            this.modelOrientation(parentIndex, result);
            Quaternion localRotation = this.localRotation(boneIndex, null);
            result.multLocal(localRotation);
        }
        return result;
    }

    public Transform modelTransform(int boneIndex, Transform storeResult) {
        int parentIndex;
        Joint bone;
        Validate.nonNegative((int)boneIndex, (String)"bone index");
        Transform result = this.localTransform(boneIndex, storeResult);
        Transform parent = null;
        if (this.skeleton == null) {
            bone = this.armature.getJoint(boneIndex);
            Joint parentJoint = bone.getParent();
            if (parentJoint != null) {
                parentIndex = parentJoint.getId();
                parent = this.modelTransform(parentIndex, null);
            }
        } else {
            bone = this.skeleton.getBone(boneIndex);
            Bone parentBone = bone.getParent();
            if (parentBone != null) {
                parentIndex = this.skeleton.getBoneIndex(parentBone);
                parent = this.modelTransform(parentIndex, null);
            }
        }
        if (parent != null) {
            Transform local = result.clone();
            Vector3f mTranslation = result.getTranslation();
            Quaternion mRotation = result.getRotation();
            Vector3f mScale = result.getScale();
            parent.getRotation().mult(local.getRotation(), mRotation);
            parent.getScale().mult(local.getScale(), mScale);
            parent.getRotation().mult(local.getTranslation(), mTranslation);
            mTranslation.multLocal(parent.getScale());
            mTranslation.addLocal(parent.getTranslation());
        }
        return result;
    }

    public static Pose newInstance(AbstractControl sControl) {
        Pose result;
        if (sControl instanceof SkeletonControl) {
            Skeleton skeleton = ((SkeletonControl)sControl).getSkeleton();
            result = new Pose(skeleton);
        } else {
            Armature armature = ((SkinningControl)sControl).getArmature();
            result = new Pose(armature);
        }
        return result;
    }

    public int[] preOrderIndices() {
        int[] result;
        block5: {
            int boneCount;
            block4: {
                boneCount = this.transforms.size();
                result = new int[boneCount];
                if (this.armature == null) break block4;
                List list = MySkeleton.preOrderJoints((Armature)this.armature);
                assert (list.size() == boneCount) : boneCount;
                for (int index = 0; index < boneCount; ++index) {
                    Joint joint = (Joint)list.get(index);
                    result[index] = joint.getId();
                }
                break block5;
            }
            if (this.skeleton == null) break block5;
            List list = MySkeleton.preOrderBones((Skeleton)this.skeleton);
            assert (list.size() == boneCount) : boneCount;
            for (int index = 0; index < boneCount; ++index) {
                Bone bone = (Bone)list.get(index);
                result[index] = this.skeleton.getBoneIndex(bone);
            }
        }
        return result;
    }

    public void resetRotation(int boneIndex) {
        Validate.nonNegative((int)boneIndex, (String)"bone index");
        Transform transform = this.transforms.get(boneIndex);
        Quaternion rotation = transform.getRotation();
        rotation.loadIdentity();
    }

    public void resetScale(int boneIndex) {
        Validate.nonNegative((int)boneIndex, (String)"bone index");
        Transform transform = this.transforms.get(boneIndex);
        Vector3f scale = transform.getScale();
        scale.set(1.0f, 1.0f, 1.0f);
    }

    public void resetTranslation(int boneIndex) {
        Validate.nonNegative((int)boneIndex, (String)"bone index");
        Transform transform = this.transforms.get(boneIndex);
        Vector3f translation = transform.getTranslation();
        translation.zero();
    }

    public int[] rootBoneIndices() {
        int[] result;
        block7: {
            int numRootBones;
            block6: {
                numRootBones = 0;
                if (this.armature != null) {
                    numRootBones = MySkeleton.countRootJoints((Armature)this.armature);
                } else if (this.skeleton != null) {
                    numRootBones = MySkeleton.countRootBones((Skeleton)this.skeleton);
                }
                result = new int[numRootBones];
                if (this.armature == null) break block6;
                Joint[] roots = this.armature.getRoots();
                for (int rootIndex = 0; rootIndex < numRootBones; ++rootIndex) {
                    Joint root = roots[rootIndex];
                    result[rootIndex] = root.getId();
                }
                break block7;
            }
            if (this.skeleton == null) break block7;
            Bone[] roots = this.skeleton.getRoots();
            for (int rootIndex = 0; rootIndex < numRootBones; ++rootIndex) {
                Bone root = roots[rootIndex];
                int boneIndex = this.skeleton.getBoneIndex(root);
                assert (boneIndex >= 0) : boneIndex;
                result[rootIndex] = boneIndex;
            }
        }
        return result;
    }

    public void set(int boneIndex, Transform transform) {
        Validate.nonNegative((int)boneIndex, (String)"bone index");
        Validate.nonNull((Object)transform, (String)"transform");
        Transform boneTransform = this.transforms.get(boneIndex);
        boneTransform.set(transform);
    }

    public void setRotation(int boneIndex, Quaternion rotation) {
        Validate.nonNegative((int)boneIndex, (String)"bone index");
        Validate.nonNull((Object)rotation, (String)"rotation");
        Transform boneTransform = this.transforms.get(boneIndex);
        boneTransform.setRotation(rotation);
    }

    public void setScale(int boneIndex, Vector3f scale) {
        Validate.nonNegative((int)boneIndex, (String)"bone index");
        Validate.nonNull((Object)scale, (String)"scale");
        Validate.positive((float)scale.x, (String)"x scale");
        Validate.positive((float)scale.y, (String)"y scale");
        Validate.positive((float)scale.z, (String)"z scale");
        Transform boneTransform = this.transforms.get(boneIndex);
        boneTransform.setScale(scale);
    }

    public void setToAnimation(Animation animation, float time, TweenTransforms techniques) {
        Validate.nonNull((Object)animation, (String)"animation");
        Validate.nonNull((Object)techniques, (String)"techniques");
        int numBones = this.transforms.size();
        for (int boneIndex = 0; boneIndex < numBones; ++boneIndex) {
            Transform transform = this.transforms.get(boneIndex);
            BoneTrack track = MyAnimation.findBoneTrack((Animation)animation, (int)boneIndex);
            if (track == null) {
                transform.loadIdentity();
                continue;
            }
            float duration = animation.getLength();
            techniques.transform((Track)track, time, duration, null, transform);
        }
    }

    public void setToBind() {
        for (Transform transform : this.transforms) {
            transform.loadIdentity();
        }
    }

    public void setToClip(AnimClip clip, double time) {
        Validate.nonNull((Object)clip, (String)"animation");
        int numJoints = this.transforms.size();
        for (int jointIndex = 0; jointIndex < numJoints; ++jointIndex) {
            Transform transform = this.transforms.get(jointIndex);
            TransformTrack track = MyAnimation.findTransformTrack((AnimClip)clip, (int)jointIndex);
            if (track == null) {
                transform.loadIdentity();
                continue;
            }
            track.getDataAtTime(time, transform);
            this.userForLocal(jointIndex, transform, transform);
        }
    }

    public void setToRetarget(Pose sourcePose, SkeletonMapping map) {
        Validate.nonNull((Object)sourcePose, (String)"source pose");
        Validate.nonNull((Object)map, (String)"map");
        if (this.skeleton == null) {
            Joint[] rootJoints;
            for (Joint rootJoint : rootJoints = this.armature.getRoots()) {
                this.retargetJoints(rootJoint, sourcePose, map);
            }
        } else {
            Bone[] rootBones;
            for (Bone rootBone : rootBones = this.skeleton.getRoots()) {
                this.retargetBones(rootBone, sourcePose, map);
            }
        }
    }

    public void setTranslation(int boneIndex, Vector3f translation) {
        Validate.nonNegative((int)boneIndex, (String)"bone index");
        Validate.nonNull((Object)translation, (String)"translation");
        Transform boneTransform = this.transforms.get(boneIndex);
        boneTransform.setTranslation(translation);
    }

    public Matrix4f[] skin(Matrix4f[] storeResult) {
        Matrix4f[] result;
        int numBones = this.transforms.size();
        if (storeResult == null) {
            result = new Matrix4f[numBones];
        } else {
            result = storeResult;
            assert (result.length >= numBones) : numBones;
        }
        Vector3f skTranslation = new Vector3f();
        Quaternion skRotation = new Quaternion();
        Matrix3f skRotMatrix = new Matrix3f();
        Vector3f skScale = new Vector3f();
        Transform msTransform = new Transform();
        Vector3f msTranslation = msTransform.getTranslation();
        Quaternion msRotation = msTransform.getRotation();
        Vector3f msScale = msTransform.getScale();
        for (int boneIndex = 0; boneIndex < numBones; ++boneIndex) {
            this.modelTransform(boneIndex, msTransform);
            Matrix4f matrix4f = result[boneIndex];
            if (matrix4f == null) {
                result[boneIndex] = matrix4f = new Matrix4f();
            }
            if (this.skeleton == null) {
                msTransform.toTransformMatrix(matrix4f);
                Joint joint = this.armature.getJoint(boneIndex);
                Matrix4f mbi = joint.getInverseModelBindMatrix();
                matrix4f.mult(mbi, matrix4f);
                continue;
            }
            Bone bone = this.skeleton.getBone(boneIndex);
            Vector3f mbiTranslation = bone.getModelBindInversePosition();
            Quaternion mbiRotation = bone.getModelBindInverseRotation();
            Vector3f mbiScale = bone.getModelBindInverseScale();
            msScale.mult(mbiScale, skScale);
            msRotation.mult(mbiRotation, skRotation);
            skRotation.toRotationMatrix(skRotMatrix);
            skScale.mult(mbiTranslation, skTranslation);
            skRotation.mult(skTranslation, skTranslation);
            skTranslation.addLocal(msTranslation);
            matrix4f.setTransform(skTranslation, skScale, skRotMatrix);
        }
        return result;
    }

    public Transform userForLocal(int boneIndex, Transform localTransform, Transform storeResult) {
        Validate.nonNegative((int)boneIndex, (String)"bone index");
        Validate.nonNull((Object)localTransform, (String)"local transform");
        Transform result = storeResult == null ? new Transform() : storeResult;
        result.set(localTransform);
        Transform bind = this.bindTransform(boneIndex, null);
        result.getTranslation().subtractLocal(bind.getTranslation());
        Quaternion userRotation = result.getRotation();
        bind.getRotation().inverseLocal().mult(userRotation, userRotation);
        result.getScale().divideLocal(bind.getScale());
        return result;
    }

    public Quaternion userForModel(int boneIndex, Quaternion modelOrientation, Quaternion storeResult) {
        Quaternion local;
        Quaternion bind;
        Validate.nonNegative((int)boneIndex, (String)"bone index");
        Validate.nonZero((Quaternion)modelOrientation, (String)"model orientation");
        if (this.skeleton == null) {
            bind = this.bindTransforms.get(boneIndex).getRotation();
            Joint joint = this.armature.getJoint(boneIndex);
            local = this.localForModel(joint, modelOrientation, null);
        } else {
            Bone bone = this.skeleton.getBone(boneIndex);
            bind = bone.getBindRotation();
            local = this.localForModel(bone, modelOrientation, null);
        }
        Quaternion inverseBind = bind.inverse();
        Quaternion result = inverseBind.mult(local, storeResult);
        return result;
    }

    public Quaternion userRotation(int boneIndex, Quaternion storeResult) {
        Validate.nonNegative((int)boneIndex, (String)"bone index");
        Transform transform = this.transforms.get(boneIndex);
        Quaternion result = transform.getRotation(storeResult);
        return result;
    }

    public Vector3f userScale(int boneIndex, Vector3f storeResult) {
        Validate.nonNegative((int)boneIndex, (String)"bone index");
        Transform transform = this.transforms.get(boneIndex);
        Vector3f result = transform.getScale(storeResult);
        return result;
    }

    public Transform userTransform(int boneIndex, Transform storeResult) {
        Validate.nonNegative((int)boneIndex, (String)"bone index");
        Transform transform = this.transforms.get(boneIndex);
        if (storeResult == null) {
            return transform.clone();
        }
        return storeResult.set(transform);
    }

    public Vector3f userTranslation(int boneIndex, Vector3f storeResult) {
        Validate.nonNegative((int)boneIndex, (String)"bone index");
        Transform transform = this.transforms.get(boneIndex);
        Vector3f result = transform.getTranslation(storeResult);
        return result;
    }

    public void cloneFields(Cloner cloner, Object original) {
        Transform tClone;
        this.armature = (Armature)cloner.clone((Object)this.armature);
        this.skeleton = (Skeleton)cloner.clone((Object)this.skeleton);
        int numTransforms = this.transforms.size();
        List<Transform> originalTransforms = this.transforms;
        this.transforms = new ArrayList<Transform>(numTransforms);
        for (Transform t : originalTransforms) {
            tClone = t.clone();
            this.transforms.add(tClone);
        }
        if (this.bindTransforms != null) {
            originalTransforms = this.bindTransforms;
            this.bindTransforms = new ArrayList<Transform>(numTransforms);
            for (Transform t : originalTransforms) {
                tClone = t.clone();
                this.bindTransforms.add(tClone);
            }
        }
    }

    public Pose jmeClone() {
        try {
            Pose clone = (Pose)this.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    private Quaternion localForModel(Bone bone, Quaternion modelOrientation, Quaternion storeResult) {
        assert (bone != null);
        assert (modelOrientation != null);
        Quaternion result = storeResult == null ? new Quaternion() : storeResult;
        Bone parent = bone.getParent();
        if (parent == null) {
            result.set(modelOrientation);
        } else {
            int parentIndex = this.skeleton.getBoneIndex(parent);
            Quaternion parentMo = this.modelOrientation(parentIndex, null);
            Quaternion parentImo = parentMo.inverse();
            parentImo.mult(modelOrientation, result);
        }
        return result;
    }

    private Quaternion localForModel(Joint joint, Quaternion modelOrientation, Quaternion storeResult) {
        assert (joint != null);
        assert (modelOrientation != null);
        Quaternion result = storeResult == null ? new Quaternion() : storeResult;
        Joint parent = joint.getParent();
        if (parent == null) {
            result.set(modelOrientation);
        } else {
            int parentIndex = parent.getId();
            Quaternion parentMo = this.modelOrientation(parentIndex, null);
            Quaternion parentImo = parentMo.inverse();
            parentImo.mult(modelOrientation, result);
        }
        return result;
    }

    private void retargetBones(Bone bone, Pose sourcePose, SkeletonMapping map) {
        assert (bone != null);
        assert (sourcePose != null);
        assert (map != null);
        int targetIndex = this.skeleton.getBoneIndex(bone);
        Transform userTransform = this.transforms.get(targetIndex);
        userTransform.loadIdentity();
        String targetName = bone.getName();
        BoneMapping boneMapping = map.get(targetName);
        if (boneMapping != null) {
            String sourceName = boneMapping.getSourceName();
            int sourceIndex = sourcePose.findBone(sourceName);
            Quaternion mo = sourcePose.modelOrientation(sourceIndex, null);
            Quaternion userRotation = this.userForModel(targetIndex, mo, null);
            Quaternion twist = boneMapping.getTwist();
            userRotation.mult(twist, userTransform.getRotation());
            userTransform.getRotation().normalizeLocal();
        }
        ArrayList children = bone.getChildren();
        for (Bone childBone : children) {
            this.retargetBones(childBone, sourcePose, map);
        }
    }

    private void retargetJoints(Joint joint, Pose sourcePose, SkeletonMapping map) {
        assert (joint != null);
        assert (sourcePose != null);
        assert (map != null);
        int targetIndex = joint.getId();
        Transform userTransform = this.transforms.get(targetIndex);
        userTransform.loadIdentity();
        String targetName = joint.getName();
        BoneMapping boneMapping = map.get(targetName);
        if (boneMapping != null) {
            String sourceName = boneMapping.getSourceName();
            int sourceIndex = sourcePose.findBone(sourceName);
            Quaternion mo = sourcePose.modelOrientation(sourceIndex, null);
            Quaternion userRotation = this.userForModel(targetIndex, mo, null);
            Quaternion twist = boneMapping.getTwist();
            userRotation.mult(twist, userTransform.getRotation());
            userTransform.getRotation().normalizeLocal();
        }
        List children = joint.getChildren();
        for (Joint child : children) {
            this.retargetJoints(child, sourcePose, map);
        }
    }
}

