/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.wes;

import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyVector3f;

public final class SmoothVectors
extends Enum<SmoothVectors> {
    public static final /* enum */ SmoothVectors Lerp = new SmoothVectors();
    public static final /* enum */ SmoothVectors LoopLerp = new SmoothVectors();
    private static final /* synthetic */ SmoothVectors[] $VALUES;

    public static SmoothVectors[] values() {
        return (SmoothVectors[])$VALUES.clone();
    }

    public static SmoothVectors valueOf(String name) {
        return Enum.valueOf(SmoothVectors.class, name);
    }

    public Vector3f[] smooth(float[] times, float cycleTime, Vector3f[] samples, float width, Vector3f[] storeResult) {
        Vector3f[] result;
        assert (times.length > 0);
        assert (times.length == samples.length);
        int last = times.length - 1;
        assert (cycleTime >= times[last]) : cycleTime;
        Validate.inRange((float)width, (String)"width", (float)0.0f, (float)cycleTime);
        if (storeResult == null) {
            result = new Vector3f[times.length];
        } else {
            result = storeResult;
            assert (result.length >= times.length);
        }
        switch (this) {
            case Lerp: {
                SmoothVectors.lerp(times, samples, width, result);
                break;
            }
            case LoopLerp: {
                if (times[last] == cycleTime) {
                    if (last > 1) {
                        SmoothVectors.loopLerp(last - 1, times, cycleTime, samples, width, result);
                        result[last] = result[0].clone();
                        break;
                    }
                    SmoothVectors.lerp(times, samples, width, result);
                    break;
                }
                SmoothVectors.loopLerp(last, times, cycleTime, samples, width, result);
                break;
            }
            default: {
                throw new IllegalStateException("this = " + (Object)((Object)this));
            }
        }
        return result;
    }

    public static Vector3f[] lerp(float[] times, Vector3f[] samples, float width, Vector3f[] storeResult) {
        Vector3f[] result;
        Validate.nonNull((Object)times, (String)"times");
        assert (times.length > 0);
        Validate.nonNull((Object)samples, (String)"samples");
        assert (times.length == samples.length);
        Validate.nonNegative((float)width, (String)"width");
        if (storeResult == null) {
            result = new Vector3f[times.length];
        } else {
            result = storeResult;
            assert (result.length >= times.length);
        }
        int last = times.length - 1;
        float halfWidth = width / 2.0f;
        for (int i = 0; i <= last; ++i) {
            Vector3f sumVector = result[i];
            if (sumVector == null) {
                result[i] = sumVector = new Vector3f();
            } else {
                sumVector.zero();
            }
            float iTime = times[i];
            float sumWeight = 0.0f;
            for (int j = 0; j <= last; ++j) {
                float jTime = times[j];
                float dt = iTime - jTime;
                if (!((dt = FastMath.abs((float)dt)) < halfWidth)) continue;
                float weight = 1.0f - dt / halfWidth;
                MyVector3f.accumulateScaled((Vector3f)sumVector, (Vector3f)samples[j], (float)weight);
                sumWeight += weight;
            }
            assert (sumWeight > 0.0f) : sumWeight;
            sumVector.divideLocal(sumWeight);
        }
        return result;
    }

    public static Vector3f[] loopLerp(int last, float[] times, float cycleTime, Vector3f[] samples, float width, Vector3f[] storeResult) {
        Vector3f[] result;
        Validate.positive((int)last, (String)"last");
        Validate.nonNull((Object)samples, (String)"samples");
        assert (times.length > last) : times.length;
        assert (samples.length > last) : samples.length;
        assert (cycleTime > times[last]) : cycleTime;
        Validate.inRange((float)width, (String)"width", (float)0.0f, (float)cycleTime);
        if (storeResult == null) {
            result = new Vector3f[times.length];
        } else {
            result = storeResult;
            assert (result.length >= times.length);
        }
        float halfWidth = width / 2.0f;
        for (int i = 0; i <= last; ++i) {
            Vector3f sumVector = result[i];
            if (sumVector == null) {
                result[i] = sumVector = new Vector3f();
            } else {
                sumVector.zero();
            }
            float iTime = times[i];
            float sumWeight = 0.0f;
            for (int j = 0; j <= last; ++j) {
                float jTime = times[j];
                float dt = MyMath.modulo((float)(iTime - jTime), (float)cycleTime);
                if (dt > cycleTime / 2.0f) {
                    dt -= cycleTime;
                }
                if (!((dt = FastMath.abs((float)dt)) < halfWidth)) continue;
                float weight = 1.0f - dt / halfWidth;
                MyVector3f.accumulateScaled((Vector3f)sumVector, (Vector3f)samples[j], (float)weight);
                sumWeight += weight;
            }
            assert (sumWeight > 0.0f) : sumWeight;
            sumVector.divideLocal(sumWeight);
        }
        return result;
    }

    static {
        $VALUES = new SmoothVectors[]{Lerp, LoopLerp};
    }
}

