/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.wes;

import com.jme3.math.Vector3f;
import jme3utilities.Validate;
import jme3utilities.math.MyArray;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyVector3f;
import jme3utilities.wes.VectorCurve;

public final class TweenVectors
extends Enum<TweenVectors> {
    public static final /* enum */ TweenVectors CatmullRomSpline = new TweenVectors();
    public static final /* enum */ TweenVectors CentripetalSpline = new TweenVectors();
    public static final /* enum */ TweenVectors FdcSpline = new TweenVectors();
    public static final /* enum */ TweenVectors Lerp = new TweenVectors();
    public static final /* enum */ TweenVectors LoopCatmullRomSpline = new TweenVectors();
    public static final /* enum */ TweenVectors LoopCentripetalSpline = new TweenVectors();
    public static final /* enum */ TweenVectors LoopFdcSpline = new TweenVectors();
    public static final /* enum */ TweenVectors LoopLerp = new TweenVectors();
    private static final /* synthetic */ TweenVectors[] $VALUES;

    public static TweenVectors[] values() {
        return (TweenVectors[])$VALUES.clone();
    }

    public static TweenVectors valueOf(String name) {
        return Enum.valueOf(TweenVectors.class, name);
    }

    public Vector3f cubicSpline(float time, float[] times, Vector3f[] samples, Vector3f storeResult) {
        Validate.nonNull((Object)times, (String)"times");
        assert (times.length > 0);
        assert (time >= times[0]) : time;
        Validate.nonNull((Object)samples, (String)"samples");
        assert (times.length == samples.length);
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        int index1 = MyArray.findPreviousIndex((float)time, (float[])times);
        Vector3f v1 = samples[index1];
        int last = times.length - 1;
        if (index1 == last) {
            result.set(v1);
            return result;
        }
        int index2 = index1 + 1;
        Vector3f v2 = samples[index2];
        float inter12 = times[index2] - times[index1];
        float t = (time - times[index1]) / inter12;
        switch (this) {
            case CatmullRomSpline: 
            case FdcSpline: 
            case LoopCatmullRomSpline: 
            case LoopFdcSpline: {
                Vector3f m2;
                Vector3f m1;
                if (index1 == 0) {
                    m1 = MyVector3f.velocity((float)inter12, (Vector3f)v1, (Vector3f)v2, null);
                } else {
                    int index0 = index1 - 1;
                    Vector3f v0 = samples[index0];
                    float inter01 = times[index1] - times[index0];
                    m1 = this.slope(inter01, inter12, v0, v1, v2, null);
                }
                if (index2 == last) {
                    m2 = MyVector3f.velocity((float)inter12, (Vector3f)v1, (Vector3f)v2, null);
                } else {
                    int index3 = index2 + 1;
                    Vector3f v3 = samples[index3];
                    float inter23 = times[index3] - times[index2];
                    m2 = this.slope(inter12, inter23, v1, v2, v3, null);
                }
                TweenVectors.cubicSpline(t, inter12, v1, v2, m1, m2, result);
                break;
            }
            case CentripetalSpline: 
            case LoopCentripetalSpline: {
                Vector3f v3;
                int index3;
                Vector3f v0;
                int index0;
                for (index0 = index1 - 1; index0 >= 0 && !MyVector3f.ne((Vector3f)samples[index0], (Vector3f)v1); --index0) {
                }
                if (index0 < 0) {
                    v0 = v1.mult(2.0f);
                    v0.subtractLocal(v2);
                } else {
                    v0 = samples[index0];
                }
                for (index3 = index2 + 1; index3 <= last && !MyVector3f.ne((Vector3f)samples[index3], (Vector3f)v2); ++index3) {
                }
                if (index3 > last) {
                    v3 = v2.mult(2.0f);
                    v3.subtractLocal(v1);
                } else {
                    v3 = samples[index3];
                }
                TweenVectors.centripetal(t, v0, v1, v2, v3, result);
                break;
            }
            default: {
                throw new IllegalStateException("this = " + (Object)((Object)this));
            }
        }
        return result;
    }

    public Vector3f interpolate(float time, float[] times, float cycleTime, Vector3f[] samples, Vector3f storeResult) {
        Vector3f result;
        Validate.nonNull((Object)times, (String)"times");
        assert (times.length > 0);
        assert (times.length == samples.length);
        int last = times.length - 1;
        assert (cycleTime >= times[last]) : cycleTime;
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        if (last == 0 || time < times[0] || MyArray.countNe((Vector3f[])samples) == 1) {
            result.set(samples[0]);
            return result;
        }
        switch (this) {
            case CatmullRomSpline: 
            case FdcSpline: 
            case CentripetalSpline: {
                this.cubicSpline(time, times, samples, result);
                break;
            }
            case Lerp: {
                TweenVectors.lerp(time, times, samples, result);
                break;
            }
            case LoopCatmullRomSpline: 
            case LoopFdcSpline: 
            case LoopCentripetalSpline: {
                if (times[last] == cycleTime) {
                    if (last > 1) {
                        this.loopCubicSpline(time, last - 1, times, cycleTime, samples, result);
                        break;
                    }
                    this.cubicSpline(time, times, samples, result);
                    break;
                }
                this.loopCubicSpline(time, last, times, cycleTime, samples, result);
                break;
            }
            case LoopLerp: {
                if (times[last] == cycleTime) {
                    if (last > 1) {
                        TweenVectors.loopLerp(time, last - 1, times, cycleTime, samples, result);
                        break;
                    }
                    TweenVectors.lerp(time, times, samples, result);
                    break;
                }
                TweenVectors.loopLerp(time, last, times, cycleTime, samples, result);
                break;
            }
            default: {
                throw new IllegalStateException("this = " + (Object)((Object)this));
            }
        }
        return result;
    }

    public Vector3f interpolate(float time, VectorCurve curve, Vector3f storeResult) {
        Validate.nonNull((Object)curve, (String)"curve");
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        switch (this) {
            case CatmullRomSpline: 
            case FdcSpline: 
            case LoopCatmullRomSpline: 
            case LoopFdcSpline: 
            case CentripetalSpline: 
            case LoopCentripetalSpline: {
                this.spline(time, curve, result);
                break;
            }
            case Lerp: 
            case LoopLerp: {
                float[] times = curve.getTimes();
                float cycleTime = curve.getCycleTime();
                Vector3f[] samples = curve.getSamples();
                this.interpolate(time, times, cycleTime, samples, result);
                break;
            }
            default: {
                throw new IllegalStateException("this = " + (Object)((Object)this));
            }
        }
        return result;
    }

    public static Vector3f lerp(float time, float[] times, Vector3f[] samples, Vector3f storeResult) {
        Validate.nonNull((Object)times, (String)"times");
        assert (times.length > 0);
        assert (time >= times[0]) : time;
        Validate.nonNull((Object)samples, (String)"samples");
        assert (times.length == samples.length);
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        int index1 = MyArray.findPreviousIndex((float)time, (float[])times);
        Vector3f v1 = samples[index1];
        if (index1 >= times.length - 1) {
            result.set(samples[index1]);
        } else {
            int index2 = index1 + 1;
            float inter12 = times[index2] - times[index1];
            assert (inter12 > 0.0f) : inter12;
            float t = (time - times[index1]) / inter12;
            Vector3f v2 = samples[index2];
            MyVector3f.lerp((float)t, (Vector3f)v1, (Vector3f)v2, (Vector3f)result);
        }
        return result;
    }

    public Vector3f loopCubicSpline(float time, int last, float[] times, float cycleTime, Vector3f[] samples, Vector3f storeResult) {
        Vector3f result;
        float inter12;
        int index2;
        Validate.inRange((float)time, (String)"time", (float)0.0f, (float)cycleTime);
        Validate.positive((int)last, (String)"last");
        Validate.nonNull((Object)times, (String)"times");
        Validate.nonNull((Object)samples, (String)"samples");
        assert (times.length > last) : times.length;
        assert (samples.length > last) : samples.length;
        assert (cycleTime > times[last]) : cycleTime;
        int index1 = MyArray.findPreviousIndex((float)time, (float[])times);
        if (index1 < last) {
            index2 = index1 + 1;
            inter12 = times[index2] - times[index1];
        } else {
            index2 = 0;
            inter12 = cycleTime - times[last];
        }
        assert (inter12 > 0.0f) : inter12;
        Vector3f v1 = samples[index1];
        Vector3f v2 = samples[index2];
        float t = (time - times[index1]) / inter12;
        switch (this) {
            case LoopCatmullRomSpline: 
            case LoopFdcSpline: {
                float inter23;
                int index3;
                float inter01;
                int index0;
                if (index1 > 0) {
                    index0 = index1 - 1;
                    inter01 = times[index1] - times[index0];
                } else {
                    index0 = last;
                    inter01 = cycleTime - times[index0];
                }
                assert (inter01 > 0.0f) : inter01;
                if (index2 < last) {
                    index3 = index2 + 1;
                    inter23 = times[index3] - times[index2];
                } else {
                    index3 = 0;
                    inter23 = cycleTime - times[last];
                }
                assert (inter23 > 0.0f) : inter23;
                Vector3f v0 = samples[index0];
                Vector3f v3 = samples[index3];
                Vector3f m1 = this.slope(inter01, inter12, v0, v1, v2, null);
                Vector3f m2 = this.slope(inter12, inter23, v1, v2, v3, null);
                result = TweenVectors.cubicSpline(t, inter12, v1, v2, m1, m2, storeResult);
                break;
            }
            case LoopCentripetalSpline: {
                int numSamples = last + 1;
                int index0 = MyMath.modulo((int)(index1 - 1), (int)numSamples);
                while (index0 != index1 && !MyVector3f.ne((Vector3f)samples[index0], (Vector3f)v1)) {
                    index0 = MyMath.modulo((int)(index0 - 1), (int)numSamples);
                }
                int index3 = MyMath.modulo((int)(index2 + 1), (int)numSamples);
                while (index3 != index2 && !MyVector3f.ne((Vector3f)samples[index3], (Vector3f)v2)) {
                    index3 = MyMath.modulo((int)(index3 + 1), (int)numSamples);
                }
                Vector3f v0 = samples[index0];
                Vector3f v3 = samples[index3];
                result = TweenVectors.centripetal(t, v0, v1, v2, v3, storeResult);
                break;
            }
            default: {
                throw new IllegalStateException("this = " + (Object)((Object)this));
            }
        }
        return result;
    }

    public static Vector3f loopLerp(float time, int last, float[] times, float cycleTime, Vector3f[] samples, Vector3f storeResult) {
        float interval;
        int index2;
        Validate.inRange((float)time, (String)"time", (float)0.0f, (float)cycleTime);
        Validate.positive((int)last, (String)"last");
        Validate.nonNull((Object)times, (String)"times");
        Validate.nonNull((Object)samples, (String)"samples");
        assert (times.length > last) : times.length;
        assert (samples.length > last) : samples.length;
        assert (cycleTime > times[last]) : cycleTime;
        int index1 = MyArray.findPreviousIndex((float)time, (float[])times);
        if (index1 < last) {
            index2 = index1 + 1;
            interval = times[index2] - times[index1];
        } else {
            index2 = 0;
            interval = cycleTime - times[last];
        }
        assert (interval > 0.0f) : interval;
        float t = (time - times[index1]) / interval;
        Vector3f v1 = samples[index1];
        Vector3f v2 = samples[index2];
        Vector3f result = MyVector3f.lerp((float)t, (Vector3f)v1, (Vector3f)v2, (Vector3f)storeResult);
        return result;
    }

    public VectorCurve precompute(float[] times, float cycleTime, Vector3f[] samples) {
        Validate.nonNull((Object)times, (String)"times");
        assert (times.length > 0);
        assert (times.length == samples.length);
        int lastIndex = times.length - 1;
        assert (cycleTime >= times[lastIndex]) : cycleTime;
        VectorCurve result = new VectorCurve(times, cycleTime, samples);
        switch (this) {
            case CatmullRomSpline: 
            case FdcSpline: 
            case CentripetalSpline: {
                this.precomputeSpline(result);
                break;
            }
            case LoopCatmullRomSpline: 
            case LoopFdcSpline: 
            case LoopCentripetalSpline: {
                if (times[lastIndex] == cycleTime) {
                    if (lastIndex > 1) {
                        this.precomputeLoopSpline(result, lastIndex - 1);
                        break;
                    }
                    this.precomputeSpline(result);
                    break;
                }
                this.precomputeLoopSpline(result, lastIndex);
                break;
            }
            case Lerp: 
            case LoopLerp: {
                break;
            }
            default: {
                throw new IllegalStateException("this = " + (Object)((Object)this));
            }
        }
        return result;
    }

    private static Vector3f centripetal(float tt, Vector3f v0, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f storeResult) {
        assert (tt >= 0.0f) : tt;
        assert (tt <= 1.0f) : tt;
        assert (v0 != null);
        assert (v1 != null);
        assert (v2 != null);
        assert (v3 != null);
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        double ds12 = MyVector3f.distanceSquared((Vector3f)v1, (Vector3f)v2);
        if (ds12 == 0.0) {
            result.set(v1);
        } else {
            float dt12 = (float)MyMath.fourthRoot((double)ds12);
            if (dt12 == 0.0f) {
                result.set(v1);
            } else {
                double ds01 = MyVector3f.distanceSquared((Vector3f)v0, (Vector3f)v1);
                double ds23 = MyVector3f.distanceSquared((Vector3f)v2, (Vector3f)v3);
                float dt01 = (float)MyMath.fourthRoot((double)ds01);
                float dt23 = (float)MyMath.fourthRoot((double)ds23);
                TweenVectors.centripetal(tt, v0, v1, v2, v3, dt01, dt12, dt23, result);
            }
        }
        return result;
    }

    private static Vector3f centripetal(float tt, Vector3f v0, Vector3f v1, Vector3f v2, Vector3f v3, float dt01, float dt12, float dt23, Vector3f storeResult) {
        assert (tt >= 0.0f) : tt;
        assert (tt <= 1.0f) : tt;
        assert (v0 != null);
        assert (v1 != null);
        assert (v2 != null);
        assert (v3 != null);
        assert (dt01 > 0.0f) : dt01;
        assert (dt12 > 0.0f) : dt12;
        assert (dt23 > 0.0f) : dt23;
        float t = tt * dt12;
        Vector3f a1 = MyVector3f.lerp((float)((t + dt01) / dt01), (Vector3f)v0, (Vector3f)v1, null);
        Vector3f a2 = MyVector3f.lerp((float)(t / dt12), (Vector3f)v1, (Vector3f)v2, null);
        Vector3f a3 = MyVector3f.lerp((float)((t - dt12) / dt23), (Vector3f)v2, (Vector3f)v3, null);
        Vector3f b1 = MyVector3f.lerp((float)((t + dt01) / (dt01 + dt12)), (Vector3f)a1, (Vector3f)a2, null);
        Vector3f b2 = MyVector3f.lerp((float)(t / (dt12 + dt23)), (Vector3f)a2, (Vector3f)a3, null);
        Vector3f result = MyVector3f.lerp((float)t, (Vector3f)b1, (Vector3f)b2, (Vector3f)storeResult);
        return result;
    }

    private static Vector3f cubicSpline(float t, float interval, Vector3f v1, Vector3f v2, Vector3f m1, Vector3f m2, Vector3f storeResult) {
        assert (t >= 0.0f) : t;
        assert (t <= 1.0f) : t;
        assert (v1 != null);
        assert (v2 != null);
        assert (m1 != null);
        assert (m2 != null);
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        float u = 1.0f - t;
        float u2 = u * u;
        float h00 = (1.0f + 2.0f * t) * u2;
        float h01 = 1.0f - h00;
        float h10 = t * u2;
        float h11 = t * t * (t - 1.0f);
        result.set(v1);
        result.multLocal(h00);
        MyVector3f.accumulateScaled((Vector3f)result, (Vector3f)v2, (float)h01);
        MyVector3f.accumulateScaled((Vector3f)result, (Vector3f)m1, (float)(interval * h10));
        MyVector3f.accumulateScaled((Vector3f)result, (Vector3f)m2, (float)(interval * h11));
        return result;
    }

    private void precomputeLoopSpline(VectorCurve curve, int lastIndex) {
        this.setLastIndex(curve, lastIndex);
        float[] times = curve.getTimes();
        float cycleTime = curve.getCycleTime();
        Vector3f[] samples = curve.getSamples();
        block4: for (int index1 = 0; index1 <= lastIndex; ++index1) {
            float inter12;
            int index2;
            if (index1 < lastIndex) {
                index2 = index1 + 1;
                inter12 = times[index2] - times[index1];
            } else {
                index2 = 0;
                inter12 = cycleTime - times[lastIndex];
            }
            assert (inter12 > 0.0f) : inter12;
            Vector3f v1 = samples[index1];
            Vector3f v2 = samples[index2];
            curve.setParameters(index1, v2, inter12);
            switch (this) {
                case LoopCatmullRomSpline: 
                case LoopFdcSpline: {
                    float inter23;
                    int index3;
                    float inter01;
                    int index0;
                    if (index1 > 0) {
                        index0 = index1 - 1;
                        inter01 = times[index1] - times[index0];
                    } else {
                        index0 = lastIndex;
                        inter01 = cycleTime - times[index0];
                    }
                    assert (inter01 > 0.0f) : inter01;
                    if (index2 < lastIndex) {
                        index3 = index2 + 1;
                        inter23 = times[index3] - times[index2];
                    } else {
                        index3 = 0;
                        inter23 = cycleTime - times[lastIndex];
                    }
                    assert (inter23 > 0.0f) : inter23;
                    Vector3f v0 = samples[index0];
                    Vector3f v3 = samples[index3];
                    Vector3f m1 = this.slope(inter01, inter12, v0, v1, v2, null);
                    Vector3f m2 = this.slope(inter12, inter23, v1, v2, v3, null);
                    curve.setAuxPoints(index1, m1, m2);
                    continue block4;
                }
                case LoopCentripetalSpline: {
                    int numSamples = lastIndex + 1;
                    int index0 = MyMath.modulo((int)(index1 - 1), (int)numSamples);
                    while (index0 != index1 && !MyVector3f.ne((Vector3f)samples[index0], (Vector3f)v1)) {
                        index0 = MyMath.modulo((int)(index0 - 1), (int)numSamples);
                    }
                    int index3 = MyMath.modulo((int)(index2 + 1), (int)numSamples);
                    while (index3 != index2 && !MyVector3f.ne((Vector3f)samples[index3], (Vector3f)v2)) {
                        index3 = MyMath.modulo((int)(index3 + 1), (int)numSamples);
                    }
                    Vector3f v0 = samples[index0];
                    Vector3f v3 = samples[index3];
                    curve.setAuxPoints(index1, v0, v3);
                    double ds12 = MyVector3f.distanceSquared((Vector3f)v1, (Vector3f)v2);
                    if (ds12 > 0.0) {
                        float dt12 = (float)MyMath.fourthRoot((double)ds12);
                        if (dt12 > 0.0f) {
                            double ds01 = MyVector3f.distanceSquared((Vector3f)v0, (Vector3f)v1);
                            double ds23 = MyVector3f.distanceSquared((Vector3f)v2, (Vector3f)v3);
                            float dt01 = (float)MyMath.fourthRoot((double)ds01);
                            float dt23 = (float)MyMath.fourthRoot((double)ds23);
                            curve.setDts(index1, dt01, dt12, dt23);
                            continue block4;
                        }
                        curve.setDts(index1, 0.0f, 0.0f, 0.0f);
                        continue block4;
                    }
                    curve.setDts(index1, 0.0f, 0.0f, 0.0f);
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("this = " + (Object)((Object)this));
                }
            }
        }
    }

    private void precomputeSpline(VectorCurve curve) {
        Vector3f[] samples = curve.getSamples();
        int lastIndex = samples.length - 1;
        this.setLastIndex(curve, lastIndex);
        float[] times = curve.getTimes();
        block4: for (int index1 = 0; index1 <= lastIndex; ++index1) {
            float inter12;
            int index2;
            Vector3f v1 = samples[index1];
            if (index1 == lastIndex) {
                index2 = lastIndex;
                inter12 = curve.getCycleTime() - times[index1] + 0.001f;
            } else {
                index2 = index1 + 1;
                inter12 = times[index2] - times[index1];
            }
            Vector3f v2 = samples[index2];
            curve.setParameters(index1, v2, inter12);
            switch (this) {
                case CatmullRomSpline: 
                case FdcSpline: 
                case LoopCatmullRomSpline: 
                case LoopFdcSpline: {
                    Vector3f m2;
                    Vector3f m1;
                    if (index1 == 0) {
                        m1 = MyVector3f.velocity((float)inter12, (Vector3f)v1, (Vector3f)v2, null);
                    } else {
                        int index0 = index1 - 1;
                        Vector3f v0 = samples[index0];
                        float inter01 = times[index1] - times[index0];
                        m1 = this.slope(inter01, inter12, v0, v1, v2, null);
                    }
                    if (index2 == lastIndex) {
                        m2 = MyVector3f.velocity((float)inter12, (Vector3f)v1, (Vector3f)v2, null);
                    } else {
                        int index3 = index2 + 1;
                        Vector3f v3 = samples[index3];
                        float inter23 = times[index3] - times[index2];
                        m2 = this.slope(inter12, inter23, v1, v2, v3, null);
                    }
                    curve.setAuxPoints(index1, m1, m2);
                    continue block4;
                }
                case CentripetalSpline: 
                case LoopCentripetalSpline: {
                    Vector3f v3;
                    int index3;
                    Vector3f v0;
                    int index0;
                    for (index0 = index1 - 1; index0 >= 0 && !MyVector3f.ne((Vector3f)samples[index0], (Vector3f)v1); --index0) {
                    }
                    if (index0 < 0) {
                        v0 = v1.mult(2.0f);
                        v0.subtractLocal(v2);
                    } else {
                        v0 = samples[index0];
                    }
                    for (index3 = index2 + 1; index3 <= lastIndex && !MyVector3f.ne((Vector3f)samples[index3], (Vector3f)v2); ++index3) {
                    }
                    if (index3 > lastIndex) {
                        v3 = v2.mult(2.0f);
                        v3.subtractLocal(v1);
                    } else {
                        v3 = samples[index3];
                    }
                    curve.setAuxPoints(index1, v0, v3);
                    double ds12 = MyVector3f.distanceSquared((Vector3f)v1, (Vector3f)v2);
                    if (ds12 > 0.0) {
                        float dt12 = (float)MyMath.fourthRoot((double)ds12);
                        if (dt12 > 0.0f) {
                            double ds01 = MyVector3f.distanceSquared((Vector3f)v0, (Vector3f)v1);
                            double ds23 = MyVector3f.distanceSquared((Vector3f)v2, (Vector3f)v3);
                            float dt01 = (float)MyMath.fourthRoot((double)ds01);
                            float dt23 = (float)MyMath.fourthRoot((double)ds23);
                            curve.setDts(index1, dt01, dt12, dt23);
                            continue block4;
                        }
                        curve.setDts(index1, 0.0f, 0.0f, 0.0f);
                        continue block4;
                    }
                    curve.setDts(index1, 0.0f, 0.0f, 0.0f);
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("this = " + (Object)((Object)this));
                }
            }
        }
    }

    private void setLastIndex(VectorCurve curve, int lastIndex) {
        switch (this) {
            case CatmullRomSpline: 
            case FdcSpline: 
            case LoopCatmullRomSpline: 
            case LoopFdcSpline: {
                boolean allocateDts = false;
                curve.setLastIndex(lastIndex, allocateDts);
                break;
            }
            case CentripetalSpline: 
            case LoopCentripetalSpline: {
                boolean allocateDts = true;
                curve.setLastIndex(lastIndex, allocateDts);
                break;
            }
            default: {
                throw new IllegalStateException("this = " + (Object)((Object)this));
            }
        }
    }

    private Vector3f slope(float dt01, float dt12, Vector3f v0, Vector3f v1, Vector3f v2, Vector3f storeResult) {
        assert (dt01 > 0.0f) : dt01;
        assert (dt12 > 0.0f) : dt12;
        assert (v0 != null);
        assert (v1 != null);
        assert (v2 != null);
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        switch (this) {
            case CatmullRomSpline: 
            case LoopCatmullRomSpline: {
                float dt02 = dt01 + dt12;
                MyVector3f.velocity((float)dt02, (Vector3f)v0, (Vector3f)v2, (Vector3f)result);
                break;
            }
            case FdcSpline: 
            case LoopFdcSpline: {
                result.x = (v1.x - v0.x) / dt01 + (v2.x - v1.x) / dt12;
                result.y = (v1.y - v0.y) / dt01 + (v2.y - v1.y) / dt12;
                result.z = (v1.z - v0.z) / dt01 + (v2.z - v1.z) / dt12;
                result.divideLocal(2.0f);
                break;
            }
            default: {
                throw new IllegalStateException("this = " + (Object)((Object)this));
            }
        }
        return result;
    }

    private Vector3f spline(float time, VectorCurve curve, Vector3f storeResult) {
        assert (time >= 0.0f) : time;
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        float cycleTime = curve.getCycleTime();
        assert (time <= cycleTime) : time;
        int lastIndex = curve.getLastIndex();
        float[] times = curve.getTimes();
        int index1 = MyArray.findPreviousIndex((float)time, (float[])times);
        if (index1 > lastIndex) {
            index1 = lastIndex;
        }
        float intervalDuration = curve.getIntervalDuration(index1);
        float t = (time - times[index1]) / intervalDuration;
        assert (t <= 1.0f) : t;
        Vector3f v1 = curve.getStartValue(index1);
        Vector3f v2 = curve.getEndValue(index1);
        switch (this) {
            case CatmullRomSpline: 
            case FdcSpline: 
            case LoopCatmullRomSpline: 
            case LoopFdcSpline: {
                Vector3f m1 = curve.getAux1(index1);
                Vector3f m2 = curve.getAux2(index1);
                TweenVectors.cubicSpline(t, intervalDuration, v1, v2, m1, m2, result);
                break;
            }
            case CentripetalSpline: 
            case LoopCentripetalSpline: {
                float dt12 = curve.getDt12(index1);
                if (dt12 == 0.0f) {
                    result.set(v1);
                    break;
                }
                Vector3f v0 = curve.getAux1(index1);
                Vector3f v3 = curve.getAux2(index1);
                float dt01 = curve.getDt01(index1);
                float dt23 = curve.getDt23(index1);
                TweenVectors.centripetal(t, v0, v1, v2, v3, dt01, dt12, dt23, result);
                break;
            }
            default: {
                throw new IllegalStateException("this = " + (Object)((Object)this));
            }
        }
        return result;
    }

    static {
        $VALUES = new TweenVectors[]{CatmullRomSpline, CentripetalSpline, FdcSpline, Lerp, LoopCatmullRomSpline, LoopCentripetalSpline, LoopFdcSpline, LoopLerp};
    }
}

