/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.bvh;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.bvh.BoneMapping;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SkeletonMapping
implements Cloneable,
Savable {
    private static final Logger logger = Logger.getLogger(SkeletonMapping.class.getName());
    private Map<String, BoneMapping> mappings = new HashMap<String, BoneMapping>(50);

    public void addMapping(BoneMapping mapping) {
        String targetBoneName = mapping.getTargetName();
        this.mappings.put(targetBoneName, mapping);
    }

    public void clear() {
        this.mappings.clear();
    }

    public int countMappings() {
        int result = this.mappings.size();
        return result;
    }

    public BoneMapping get(String targetBoneName) {
        BoneMapping result = this.mappings.get(targetBoneName);
        return result;
    }

    public BoneMapping getForSource(String sourceBoneName) {
        BoneMapping result = null;
        for (BoneMapping boneMapping : this.mappings.values()) {
            String sourceName = boneMapping.getSourceName();
            if (!sourceName.equals(sourceBoneName)) continue;
            result = boneMapping;
            break;
        }
        return result;
    }

    public SkeletonMapping inverse() {
        SkeletonMapping result = new SkeletonMapping();
        for (BoneMapping boneMapping : this.mappings.values()) {
            Quaternion twist = boneMapping.getTwist();
            Quaternion inverseTwist = twist.inverse();
            String targetName = boneMapping.getTargetName();
            String sourceName = boneMapping.getSourceName();
            result.map(sourceName, targetName, inverseTwist);
        }
        return result;
    }

    public List<String> listSourceBones() {
        int numMappings = this.mappings.size();
        ArrayList<String> result = new ArrayList<String>(numMappings);
        for (BoneMapping boneMapping : this.mappings.values()) {
            String name = boneMapping.getSourceName();
            result.add(name);
        }
        return result;
    }

    public List<String> listTargetBones() {
        int numMappings = this.mappings.size();
        ArrayList<String> result = new ArrayList<String>(numMappings);
        result.addAll(this.mappings.keySet());
        return result;
    }

    public BoneMapping map(String targetBone, String sourceBone) {
        BoneMapping mapping = new BoneMapping(targetBone, sourceBone);
        this.mappings.put(targetBone, mapping);
        return mapping;
    }

    public BoneMapping map(String targetName, String sourceName, Quaternion twist) {
        BoneMapping boneMapping = this.mappings.get(targetName);
        if (boneMapping == null) {
            boneMapping = new BoneMapping(targetName, sourceName, twist);
            this.mappings.put(targetName, boneMapping);
        } else {
            logger.log(Level.WARNING, "Multiple mappings for target bone {0}.", targetName);
        }
        return boneMapping;
    }

    public BoneMapping map(String targetBone, String sourceBone, float twistAngle, Vector3f twistAxis) {
        BoneMapping mapping = new BoneMapping(targetBone, sourceBone, twistAngle, twistAxis);
        this.mappings.put(targetBone, mapping);
        return mapping;
    }

    public void removeMapping(BoneMapping mapping) {
        String targetBoneName = mapping.getTargetName();
        BoneMapping oldMapping = this.mappings.remove(targetBoneName);
        assert (oldMapping == mapping);
    }

    public void renameSourceBone(String oldName, String newName) {
        for (BoneMapping boneMapping : this.mappings.values()) {
            String sourceName = boneMapping.getSourceName();
            if (!sourceName.equals(oldName)) continue;
            boneMapping.setSourceName(newName);
        }
    }

    public void renameTargetBone(String oldName, String newName) {
        BoneMapping boneMapping = this.get(oldName);
        if (boneMapping != null) {
            this.removeMapping(boneMapping);
            boneMapping.setTargetName(newName);
            this.addMapping(boneMapping);
        }
    }

    public SkeletonMapping clone() throws CloneNotSupportedException {
        super.clone();
        SkeletonMapping result = new SkeletonMapping();
        for (BoneMapping boneMapping : this.mappings.values()) {
            Quaternion twist = boneMapping.getTwist();
            twist = twist.clone();
            String targetName = boneMapping.getTargetName();
            String sourceName = boneMapping.getSourceName();
            result.map(targetName, sourceName, twist);
        }
        return result;
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule((Savable)this);
        this.mappings = ic.readStringSavableMap("mappings", new HashMap(50));
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.writeStringSavableMap(this.mappings, "mappings", null);
    }
}

