/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.wes;

import com.jme3.math.Quaternion;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class RotationCurve {
    private static final Logger logger = Logger.getLogger(RotationCurve.class.getName());
    private final float cycleTime;
    private float[] intervalDurations;
    private final float[] times;
    private Quaternion[] controlPoint1s;
    private Quaternion[] controlPoint2s;
    private Quaternion[] endValues;
    private final Quaternion[] startValues;

    public RotationCurve(float[] times, float cycleTime, Quaternion[] quaternions) {
        Validate.nonNull((Object)times, (String)"times");
        Validate.nonNull((Object)quaternions, (String)"quaternions");
        assert (times.length == quaternions.length);
        this.times = times;
        this.cycleTime = cycleTime;
        this.startValues = quaternions;
        this.endValues = null;
        this.intervalDurations = null;
        this.controlPoint1s = null;
        this.controlPoint2s = null;
    }

    Quaternion getControlPoint1(int index) {
        Quaternion controlPoint = this.controlPoint1s[index];
        assert (controlPoint != null);
        return controlPoint;
    }

    Quaternion getControlPoint2(int index) {
        Quaternion controlPoint = this.controlPoint2s[index];
        assert (controlPoint != null);
        return controlPoint;
    }

    float getCycleTime() {
        return this.cycleTime;
    }

    Quaternion getEndValue(int index) {
        Quaternion value = this.endValues[index];
        assert (value != null);
        return value;
    }

    float getIntervalDuration(int index) {
        float intervalDuration = this.intervalDurations[index];
        assert (intervalDuration > 0.0f) : intervalDuration;
        return intervalDuration;
    }

    int getLastIndex() {
        int lastIndex = this.controlPoint1s.length - 1;
        assert (lastIndex >= 0) : lastIndex;
        return lastIndex;
    }

    Quaternion[] getSamples() {
        assert (this.startValues != null);
        return this.startValues;
    }

    Quaternion getStartValue(int index) {
        Quaternion value = this.startValues[index];
        assert (value != null);
        return value;
    }

    float[] getTimes() {
        assert (this.times != null);
        return this.times;
    }

    void setControlPoints(int index, Quaternion controlPoint1, Quaternion controlPoint2) {
        Validate.nonNull((Object)controlPoint1, (String)"control point 1");
        Validate.nonNull((Object)controlPoint2, (String)"control point 2");
        this.controlPoint1s[index] = controlPoint1;
        this.controlPoint2s[index] = controlPoint2;
    }

    void setLastIndex(int newLastIndex) {
        Validate.nonNegative((int)newLastIndex, (String)"new last index");
        this.controlPoint1s = new Quaternion[newLastIndex + 1];
        this.controlPoint2s = new Quaternion[newLastIndex + 1];
        this.endValues = new Quaternion[newLastIndex + 1];
        this.intervalDurations = new float[newLastIndex + 1];
    }

    void setParameters(int index, Quaternion endValue, float intervalDuration) {
        Validate.nonNull((Object)endValue, (String)"end value");
        Validate.positive((float)intervalDuration, (String)"interval duration");
        this.endValues[index] = endValue;
        this.intervalDurations[index] = intervalDuration;
    }
}

