/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.wes;

import com.jme3.math.Quaternion;
import jme3utilities.Validate;
import jme3utilities.math.MyArray;
import jme3utilities.math.MyQuaternion;
import jme3utilities.wes.RotationCurve;

public final class TweenRotations
extends Enum<TweenRotations> {
    public static final /* enum */ TweenRotations LoopNlerp = new TweenRotations();
    public static final /* enum */ TweenRotations LoopQuickSlerp = new TweenRotations();
    public static final /* enum */ TweenRotations LoopSlerp = new TweenRotations();
    public static final /* enum */ TweenRotations LoopSpline = new TweenRotations();
    public static final /* enum */ TweenRotations Nlerp = new TweenRotations();
    public static final /* enum */ TweenRotations QuickSlerp = new TweenRotations();
    public static final /* enum */ TweenRotations Slerp = new TweenRotations();
    public static final /* enum */ TweenRotations Spline = new TweenRotations();
    private static final /* synthetic */ TweenRotations[] $VALUES;

    public static TweenRotations[] values() {
        return (TweenRotations[])$VALUES.clone();
    }

    public static TweenRotations valueOf(String name) {
        return Enum.valueOf(TweenRotations.class, name);
    }

    public Quaternion interpolate(float time, float[] times, float cycleTime, Quaternion[] samples, Quaternion storeResult) {
        Quaternion result;
        Validate.nonNull((Object)times, (String)"times");
        assert (times.length > 0);
        assert (times.length == samples.length);
        int lastIndex = times.length - 1;
        assert (cycleTime >= times[lastIndex]) : cycleTime;
        Quaternion quaternion = result = storeResult == null ? new Quaternion() : storeResult;
        if (lastIndex == 0 || time < times[0]) {
            result.set(samples[0]);
            return result;
        }
        switch (this) {
            case LoopNlerp: 
            case LoopQuickSlerp: 
            case LoopSlerp: {
                if (times[lastIndex] == cycleTime) {
                    if (lastIndex > 1) {
                        this.loopLerp(time, lastIndex - 1, times, cycleTime, samples, result);
                        break;
                    }
                    this.lerp(time, times, samples, result);
                    break;
                }
                this.loopLerp(time, lastIndex, times, cycleTime, samples, result);
                break;
            }
            case LoopSpline: {
                if (times[lastIndex] == cycleTime) {
                    if (lastIndex > 1) {
                        TweenRotations.loopSpline(time, lastIndex - 1, times, cycleTime, samples, result);
                        break;
                    }
                    TweenRotations.spline(time, times, samples, result);
                    break;
                }
                TweenRotations.loopSpline(time, lastIndex, times, cycleTime, samples, result);
                break;
            }
            case Nlerp: 
            case QuickSlerp: 
            case Slerp: {
                this.lerp(time, times, samples, result);
                break;
            }
            case Spline: {
                TweenRotations.spline(time, times, samples, result);
                break;
            }
            default: {
                throw new IllegalStateException("this = " + (Object)((Object)this));
            }
        }
        return result;
    }

    public Quaternion interpolate(float time, RotationCurve curve, Quaternion storeResult) {
        Quaternion result;
        Validate.nonNull((Object)curve, (String)"curve");
        switch (this) {
            case LoopNlerp: 
            case LoopQuickSlerp: 
            case LoopSlerp: 
            case Nlerp: 
            case QuickSlerp: 
            case Slerp: {
                float[] times = curve.getTimes();
                float cycleTime = curve.getCycleTime();
                Quaternion[] samples = curve.getSamples();
                result = this.interpolate(time, times, cycleTime, samples, storeResult);
                break;
            }
            case LoopSpline: {
                result = TweenRotations.loopSpline(time, curve, storeResult);
                break;
            }
            case Spline: {
                result = TweenRotations.spline(time, curve, storeResult);
                break;
            }
            default: {
                throw new IllegalStateException("this = " + (Object)((Object)this));
            }
        }
        return result;
    }

    public Quaternion lerp(float time, float[] times, Quaternion[] samples, Quaternion storeResult) {
        Validate.nonNull((Object)times, (String)"times");
        assert (times.length > 0);
        assert (time >= times[0]) : time;
        Validate.nonNull((Object)samples, (String)"samples");
        assert (times.length == samples.length);
        Quaternion result = storeResult == null ? new Quaternion() : storeResult;
        int index1 = MyArray.findPreviousIndex((float)time, (float[])times);
        Quaternion q1 = samples[index1];
        if (index1 >= times.length - 1) {
            result.set(q1);
        } else {
            int index2 = index1 + 1;
            float inter12 = times[index2] - times[index1];
            assert (inter12 > 0.0f) : inter12;
            float t = (time - times[index1]) / inter12;
            Quaternion q2 = samples[index2];
            this.lerp(t, q1, q2, result);
        }
        return result;
    }

    public Quaternion loopLerp(float time, int lastIndex, float[] times, float cycleTime, Quaternion[] samples, Quaternion storeResult) {
        float interval;
        int index2;
        Validate.inRange((float)time, (String)"time", (float)0.0f, (float)cycleTime);
        Validate.positive((int)lastIndex, (String)"last index");
        Validate.nonNull((Object)times, (String)"times");
        Validate.nonNull((Object)samples, (String)"samples");
        assert (times.length > lastIndex) : times.length;
        assert (samples.length > lastIndex) : samples.length;
        assert (cycleTime > times[lastIndex]) : cycleTime;
        int index1 = MyArray.findPreviousIndex((float)time, (float[])times);
        if (index1 < lastIndex) {
            index2 = index1 + 1;
            interval = times[index2] - times[index1];
        } else {
            index2 = 0;
            interval = cycleTime - times[lastIndex];
        }
        assert (interval > 0.0f) : interval;
        float t = (time - times[index1]) / interval;
        Quaternion q1 = samples[index1];
        Quaternion q2 = samples[index2];
        Quaternion result = this.lerp(t, q1, q2, storeResult);
        return result;
    }

    public static Quaternion loopSpline(float time, int lastIndex, float[] times, float cycleTime, Quaternion[] samples, Quaternion storeResult) {
        float interval;
        int index2;
        Validate.inRange((float)time, (String)"time", (float)0.0f, (float)cycleTime);
        Validate.positive((int)lastIndex, (String)"last index");
        Validate.nonNull((Object)times, (String)"times");
        Validate.nonNull((Object)samples, (String)"samples");
        assert (times.length > lastIndex) : times.length;
        assert (samples.length > lastIndex) : samples.length;
        assert (cycleTime > times[lastIndex]) : cycleTime;
        int index1 = MyArray.findPreviousIndex((float)time, (float[])times);
        if (index1 < lastIndex) {
            index2 = index1 + 1;
            interval = times[index2] - times[index1];
        } else {
            index2 = 0;
            interval = cycleTime - times[lastIndex];
        }
        assert (interval > 0.0f) : interval;
        float t = (time - times[index1]) / interval;
        int index0 = index1 == 0 ? lastIndex : index1 - 1;
        int index3 = index2 == lastIndex ? 0 : index2 + 1;
        Quaternion q0 = samples[index0];
        Quaternion q1 = samples[index1];
        Quaternion q2 = samples[index2];
        Quaternion q3 = samples[index3];
        Quaternion result = TweenRotations.flipSpline(t, q0, q1, q2, q3, storeResult);
        return result;
    }

    public RotationCurve precompute(float[] times, float cycleTime, Quaternion[] samples) {
        Validate.nonNull((Object)times, (String)"times");
        assert (times.length > 0);
        assert (times.length == samples.length);
        int lastIndex = times.length - 1;
        assert (cycleTime >= times[lastIndex]) : cycleTime;
        RotationCurve result = new RotationCurve(times, cycleTime, samples);
        switch (this) {
            case LoopNlerp: 
            case LoopQuickSlerp: 
            case LoopSlerp: 
            case Nlerp: 
            case QuickSlerp: 
            case Slerp: {
                break;
            }
            case LoopSpline: {
                if (times[lastIndex] == cycleTime) {
                    if (lastIndex > 1) {
                        TweenRotations.precomputeLoopSpline(result, lastIndex - 1);
                        break;
                    }
                    TweenRotations.precomputeSpline(result);
                    break;
                }
                TweenRotations.precomputeLoopSpline(result, lastIndex);
                break;
            }
            case Spline: {
                TweenRotations.precomputeSpline(result);
                break;
            }
            default: {
                throw new IllegalStateException("this = " + (Object)((Object)this));
            }
        }
        return result;
    }

    public static Quaternion spline(float time, float[] times, Quaternion[] samples, Quaternion storeResult) {
        Validate.nonNull((Object)times, (String)"times");
        assert (times.length > 0);
        assert (time >= times[0]) : time;
        Validate.nonNull((Object)samples, (String)"samples");
        assert (times.length == samples.length);
        Quaternion result = storeResult == null ? new Quaternion() : storeResult;
        int index1 = MyArray.findPreviousIndex((float)time, (float[])times);
        Quaternion q1 = samples[index1];
        int lastIndex = times.length - 1;
        if (index1 == lastIndex) {
            result.set(q1);
            return result;
        }
        int index0 = index1 == 0 ? 0 : index1 - 1;
        int index2 = index1 + 1;
        int index3 = index2 == lastIndex ? lastIndex : index2 + 1;
        float inter12 = times[index2] - times[index1];
        float t = (time - times[index1]) / inter12;
        Quaternion q0 = samples[index0];
        Quaternion q2 = samples[index2];
        Quaternion q3 = samples[index3];
        TweenRotations.flipSpline(t, q0, q1, q2, q3, result);
        return result;
    }

    private static Quaternion align(Quaternion qa, Quaternion qb) {
        Quaternion result;
        if (qa.dot(qb) < 0.0f) {
            result = qa.clone();
            result.negate();
        } else {
            result = qa;
        }
        return result;
    }

    private static Quaternion flipSpline(float t, Quaternion q0, Quaternion q1, Quaternion q2, Quaternion q3, Quaternion storeResult) {
        Quaternion qq0 = TweenRotations.align(q0, q1);
        Quaternion qq2 = TweenRotations.align(q2, q1);
        Quaternion qq3 = TweenRotations.align(q3, qq2);
        Quaternion a1 = MyQuaternion.squadA((Quaternion)qq0, (Quaternion)q1, (Quaternion)qq2, null);
        Quaternion a2 = MyQuaternion.squadA((Quaternion)q1, (Quaternion)qq2, (Quaternion)qq3, null);
        Quaternion result = MyQuaternion.squad((float)t, (Quaternion)q1, (Quaternion)a1, (Quaternion)a2, (Quaternion)qq2, (Quaternion)storeResult);
        return result;
    }

    private Quaternion lerp(float t, Quaternion q0, Quaternion q1, Quaternion storeResult) {
        Quaternion result;
        block8: {
            block7: {
                Validate.inRange((float)t, (String)"t", (float)0.0f, (float)1.0f);
                MyQuaternion.validateUnit((Quaternion)q0, (String)"q0", (float)5.0E-4f);
                MyQuaternion.validateUnit((Quaternion)q1, (String)"q1", (float)5.0E-4f);
                Quaternion quaternion = result = storeResult == null ? new Quaternion() : storeResult;
                if (!MyQuaternion.ne((Quaternion)q0, (Quaternion)q1)) break block7;
                switch (this) {
                    case LoopNlerp: 
                    case Nlerp: {
                        result.set(q0);
                        result.nlerp(q1, t);
                        break block8;
                    }
                    case LoopQuickSlerp: 
                    case QuickSlerp: {
                        Quaternion q2copy = q1.clone();
                        result.slerp(q0, q2copy, t);
                        break block8;
                    }
                    case LoopSlerp: 
                    case Slerp: {
                        if (q0.dot(q1) < 0.0f) {
                            Quaternion negQ1 = q1.mult(-1.0f);
                            MyQuaternion.slerp((float)t, (Quaternion)q0, (Quaternion)negQ1, (Quaternion)result);
                        } else {
                            MyQuaternion.slerp((float)t, (Quaternion)q0, (Quaternion)q1, (Quaternion)result);
                        }
                        break block8;
                    }
                    default: {
                        throw new IllegalStateException("this = " + (Object)((Object)this));
                    }
                }
            }
            result.set(q0);
        }
        return result;
    }

    private static Quaternion loopSpline(float time, RotationCurve curve, Quaternion storeResult) {
        assert (time >= 0.0f) : time;
        float cycleTime = curve.getCycleTime();
        Validate.inRange((float)time, (String)"time", (float)0.0f, (float)cycleTime);
        int lastIndex = curve.getLastIndex();
        float[] times = curve.getTimes();
        int index1 = MyArray.findPreviousIndex((float)time, (float[])times);
        if (index1 > lastIndex) {
            index1 = lastIndex;
        }
        float intervalDuration = curve.getIntervalDuration(index1);
        float t = (time - times[index1]) / intervalDuration;
        Quaternion a1 = curve.getControlPoint1(index1);
        Quaternion a2 = curve.getControlPoint2(index1);
        Quaternion q1 = curve.getStartValue(index1);
        Quaternion q2 = curve.getEndValue(index1);
        Quaternion result = MyQuaternion.squad((float)t, (Quaternion)q1, (Quaternion)a1, (Quaternion)a2, (Quaternion)q2, (Quaternion)storeResult);
        return result;
    }

    private static void precomputeFlipSpline(RotationCurve curve, int index1, float inter12, Quaternion q0, Quaternion q1, Quaternion q2, Quaternion q3) {
        Quaternion qq0 = TweenRotations.align(q0, q1);
        Quaternion qq2 = TweenRotations.align(q2, q1);
        Quaternion qq3 = TweenRotations.align(q3, qq2);
        curve.setParameters(index1, qq2, inter12);
        Quaternion a = MyQuaternion.squadA((Quaternion)qq0, (Quaternion)q1, (Quaternion)qq2, null);
        Quaternion b = MyQuaternion.squadA((Quaternion)q1, (Quaternion)qq2, (Quaternion)qq3, null);
        curve.setControlPoints(index1, a, b);
    }

    private static void precomputeLoopSpline(RotationCurve curve, int lastIndex) {
        curve.setLastIndex(lastIndex);
        float[] times = curve.getTimes();
        float cycleTime = curve.getCycleTime();
        Quaternion[] samples = curve.getSamples();
        for (int index1 = 0; index1 <= lastIndex; ++index1) {
            float inter12;
            int index2;
            int index0;
            int n = index0 = index1 == 0 ? lastIndex : index1 - 1;
            if (index1 < lastIndex) {
                index2 = index1 + 1;
                inter12 = times[index2] - times[index1];
            } else {
                index2 = 0;
                inter12 = cycleTime - times[lastIndex];
            }
            assert (inter12 > 0.0f) : inter12;
            int index3 = index2 == lastIndex ? 0 : index2 + 1;
            Quaternion q0 = samples[index0];
            Quaternion q1 = samples[index1];
            Quaternion q2 = samples[index2];
            Quaternion q3 = samples[index3];
            TweenRotations.precomputeFlipSpline(curve, index1, inter12, q0, q1, q2, q3);
        }
    }

    private static void precomputeSpline(RotationCurve curve) {
        Quaternion[] samples = curve.getSamples();
        int lastIndex = samples.length - 1;
        curve.setLastIndex(lastIndex);
        float[] times = curve.getTimes();
        for (int index1 = 0; index1 <= lastIndex; ++index1) {
            float inter12;
            int index2;
            int index0 = index1 == 0 ? 0 : index1 - 1;
            if (index1 == lastIndex) {
                index2 = lastIndex;
                inter12 = curve.getCycleTime() - times[index1] + 0.001f;
            } else {
                index2 = index1 + 1;
                inter12 = times[index2] - times[index1];
            }
            int index3 = index2 == lastIndex ? lastIndex : index2 + 1;
            Quaternion q0 = samples[index0];
            Quaternion q1 = samples[index1];
            Quaternion q2 = samples[index2];
            Quaternion q3 = samples[index3];
            TweenRotations.precomputeFlipSpline(curve, index1, inter12, q0, q1, q2, q3);
        }
    }

    private static Quaternion spline(float time, RotationCurve curve, Quaternion storeResult) {
        Quaternion result = storeResult == null ? new Quaternion() : storeResult;
        float[] times = curve.getTimes();
        assert (time >= times[0]) : time;
        int index1 = MyArray.findPreviousIndex((float)time, (float[])times);
        Quaternion q1 = curve.getStartValue(index1);
        int lastIndex = curve.getLastIndex();
        if (index1 == lastIndex) {
            result.set(q1);
        } else {
            float intervalDuration = curve.getIntervalDuration(index1);
            float t = (time - times[index1]) / intervalDuration;
            Quaternion a1 = curve.getControlPoint1(index1);
            Quaternion a2 = curve.getControlPoint2(index1);
            Quaternion q2 = curve.getEndValue(index1);
            MyQuaternion.squad((float)t, (Quaternion)q1, (Quaternion)a1, (Quaternion)a2, (Quaternion)q2, (Quaternion)result);
        }
        return result;
    }

    static {
        $VALUES = new TweenRotations[]{LoopNlerp, LoopQuickSlerp, LoopSlerp, LoopSpline, Nlerp, QuickSlerp, Slerp, Spline};
    }
}

