/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.bvh;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Logger;

public class BoneMapping
implements Savable {
    private static final Logger logger = Logger.getLogger(BoneMapping.class.getName());
    private String sourceName;
    private Quaternion twist;
    private String targetName;

    public BoneMapping() {
    }

    public BoneMapping(String targetBone, String sourceBone) {
        this.targetName = targetBone;
        this.sourceName = sourceBone;
        this.twist = new Quaternion();
    }

    public BoneMapping(String targetBone, String sourceBone, Quaternion twist) {
        this.targetName = targetBone;
        this.sourceName = sourceBone;
        this.twist = twist;
    }

    public BoneMapping(String targetBone, String sourceBone, float twistAngle, Vector3f twistAxis) {
        this.targetName = targetBone;
        this.sourceName = sourceBone;
        this.twist = new Quaternion().fromAngleAxis(twistAngle, twistAxis);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public Quaternion getTwist() {
        return this.twist;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public void setTwist(Quaternion twist) {
        this.twist = twist;
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule((Savable)this);
        this.targetName = ic.readString("targetName", "");
        this.sourceName = ic.readString("sourceName", "");
        this.twist = (Quaternion)ic.readSavable("twist", null);
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write(this.targetName, "targetName", "");
        oc.write(this.sourceName, "sourceName", "");
        oc.write((Savable)this.twist, "twist", null);
    }
}

