/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.wes;

import com.jme3.anim.AnimClip;
import com.jme3.anim.AnimTrack;
import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.anim.MorphTrack;
import com.jme3.anim.TransformTrack;
import com.jme3.anim.util.HasLocalTransform;
import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SpatialTrack;
import com.jme3.animation.Track;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.bvh.BoneMapping;
import com.jme3.scene.plugins.bvh.SkeletonMapping;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.Logger;
import jme3utilities.Heart;
import jme3utilities.MyAnimation;
import jme3utilities.Validate;
import jme3utilities.math.MyArray;
import jme3utilities.wes.Pose;
import jme3utilities.wes.SupportUtils;
import jme3utilities.wes.TrackEdit;
import jme3utilities.wes.TweenTransforms;

public final class AnimationEdit {
    private static final Logger logger = Logger.getLogger(AnimationEdit.class.getName());

    private AnimationEdit() {
    }

    public static void addTrack(AnimClip clip, AnimTrack<?> track) {
        AnimTrack[] newTracks;
        Validate.nonNull(track, (String)"track");
        AnimTrack[] oldTracks = clip.getTracks();
        if (oldTracks == null) {
            newTracks = new AnimTrack[]{track};
        } else {
            int oldNumTracks = oldTracks.length;
            newTracks = new AnimTrack[oldNumTracks + 1];
            System.arraycopy(oldTracks, 0, newTracks, 0, oldNumTracks);
            newTracks[oldNumTracks] = track;
        }
        clip.setTracks(newTracks);
    }

    public static AnimClip convertToInPlace(AnimClip sourceClip, String resultName) {
        AnimTrack[] tracks;
        Validate.nonNull((Object)resultName, (String)"result name");
        AnimClip result = new AnimClip(resultName);
        for (AnimTrack oldTrack : tracks = sourceClip.getTracks()) {
            int numUnique;
            TransformTrack transformTrack;
            Vector3f[] translations;
            AnimTrack newTrack = null;
            if (oldTrack instanceof TransformTrack && (translations = (transformTrack = (TransformTrack)oldTrack).getTranslations()) != null && (numUnique = MyArray.countNe((Vector3f[])translations)) >= 2) {
                newTrack = TrackEdit.convertToInPlace(transformTrack);
            }
            if (newTrack == null) {
                newTrack = TrackEdit.cloneTrack(oldTrack);
            }
            AnimationEdit.addTrack(result, newTrack);
        }
        return result;
    }

    public static Animation extractAnimation(Animation sourceAnimation, float startTime, float endTime, TweenTransforms techniques, String resultName) {
        Track[] sourceTracks;
        Validate.nonNull((Object)sourceAnimation, (String)"source animation");
        Validate.inRange((float)startTime, (String)"start time", (float)0.0f, (float)endTime);
        Validate.inRange((float)endTime, (String)"end time", (float)startTime, (float)Float.MAX_VALUE);
        Validate.nonNull((Object)resultName, (String)"result name");
        float newDuration = endTime - startTime;
        Animation result = new Animation(resultName, newDuration);
        float sourceDuration = sourceAnimation.getLength();
        for (Track sourceTrack : sourceTracks = sourceAnimation.getTracks()) {
            Track newTrack;
            if (sourceTrack instanceof BoneTrack || sourceTrack instanceof SpatialTrack) {
                newTrack = TrackEdit.truncate(sourceTrack, endTime);
                if (startTime > 0.0f) {
                    Transform startTransform = techniques.interpolate(startTime, sourceTrack, sourceDuration, null, null);
                    newTrack = TrackEdit.behead(newTrack, startTime, startTransform, endTime);
                }
            } else {
                newTrack = sourceTrack.clone();
            }
            result.addTrack(newTrack);
        }
        return result;
    }

    public static AnimClip extractAnimation(AnimClip sourceClip, float startTime, float endTime, TweenTransforms techniques, String resultName) {
        AnimTrack[] sourceTracks;
        Validate.nonNull((Object)sourceClip, (String)"source clip");
        Validate.inRange((float)startTime, (String)"start time", (float)0.0f, (float)endTime);
        Validate.inRange((float)endTime, (String)"end time", (float)startTime, (float)Float.MAX_VALUE);
        Validate.nonNull((Object)resultName, (String)"result name");
        AnimClip result = new AnimClip(resultName);
        float duration = (float)sourceClip.getLength();
        for (AnimTrack sourceTrack : sourceTracks = sourceClip.getTracks()) {
            if (sourceTrack instanceof MorphTrack) {
                throw new UnsupportedOperationException();
            }
            TransformTrack oldTrack = (TransformTrack)sourceTrack;
            Transform endTransform = techniques.interpolate(endTime, oldTrack, duration, null);
            TransformTrack newTrack = TrackEdit.truncate(oldTrack, endTime, endTransform);
            if (startTime > 0.0f) {
                Transform startTransform = techniques.interpolate(startTime, oldTrack, duration, null);
                newTrack = TrackEdit.behead(newTrack, startTime, startTransform);
            }
            AnimationEdit.addTrack(result, newTrack);
        }
        return result;
    }

    public static int normalizeQuaternions(Animation animation, float tolerance) {
        Validate.nonNegative((float)tolerance, (String)"tolerance");
        Track[] tracks = animation.getTracks();
        int numTracks = tracks.length;
        int numTracksEdited = 0;
        for (int trackIndex = 0; trackIndex < numTracks; ++trackIndex) {
            Track newTrack;
            Track oldTrack = tracks[trackIndex];
            if (!(oldTrack instanceof BoneTrack) && !(oldTrack instanceof SpatialTrack) || oldTrack == (newTrack = TrackEdit.normalizeQuaternions(oldTrack, tolerance))) continue;
            ++numTracksEdited;
            tracks[trackIndex] = newTrack;
        }
        return numTracksEdited;
    }

    public static int normalizeQuaternions(AnimClip clip, float tolerance) {
        Validate.nonNegative((float)tolerance, (String)"tolerance");
        AnimTrack[] tracks = clip.getTracks();
        int numTracks = tracks.length;
        int numTracksEdited = 0;
        for (int trackIndex = 0; trackIndex < numTracks; ++trackIndex) {
            AnimTrack oldTrack = tracks[trackIndex];
            AnimTrack<?> newTrack = TrackEdit.normalizeQuaternions(oldTrack, tolerance);
            if (oldTrack == newTrack) continue;
            ++numTracksEdited;
            tracks[trackIndex] = newTrack;
        }
        return numTracksEdited;
    }

    public static int removeRepeats(Animation animation) {
        Track[] tracks;
        int numTracksEdited = 0;
        for (Track track : tracks = animation.getTracks()) {
            boolean removed;
            if (!(track instanceof BoneTrack) && !(track instanceof SpatialTrack) || !(removed = TrackEdit.removeRepeats(track))) continue;
            ++numTracksEdited;
        }
        return numTracksEdited;
    }

    public static int removeRepeats(AnimClip clip) {
        AnimTrack[] tracks;
        int numTracksEdited = 0;
        for (AnimTrack track : tracks = clip.getTracks()) {
            boolean removed = track instanceof MorphTrack ? TrackEdit.removeRepeats((MorphTrack)track) : TrackEdit.removeRepeats((TransformTrack)track);
            if (!removed) continue;
            ++numTracksEdited;
        }
        return numTracksEdited;
    }

    public static AnimClip replaceTranslations(AnimClip sourceClip, TransformTrack sourceTrack, Vector3f[] translations, String resultName) {
        Validate.nonNull((Object)resultName, (String)"result name");
        float[] oldTimes = sourceTrack.getTimes();
        int numKeyFrames = oldTimes.length;
        float[] newTimes = new float[numKeyFrames];
        System.arraycopy(oldTimes, 0, newTimes, 0, numKeyFrames);
        Quaternion[] rotations = sourceTrack.getRotations();
        Vector3f[] scales = sourceTrack.getScales();
        HasLocalTransform target = sourceTrack.getTarget();
        TransformTrack newTrack = new TransformTrack(target, newTimes, translations, rotations, scales);
        AnimClip result = new AnimClip(resultName);
        AnimTrack[] oldTracks = sourceClip.getTracks();
        int oldNumTracks = oldTracks.length;
        ArrayList<Object> trackList = new ArrayList<Object>(oldNumTracks);
        for (AnimTrack track : oldTracks) {
            if (track == sourceTrack) {
                trackList.add(newTrack);
                continue;
            }
            AnimTrack cloneTrack = TrackEdit.cloneTrack(track);
            trackList.add(cloneTrack);
        }
        int newNumTracks = trackList.size();
        AnimTrack[] newTracks = new AnimTrack[newNumTracks];
        trackList.toArray(newTracks);
        result.setTracks(newTracks);
        return result;
    }

    public static Animation retargetAnimation(Animation sourceAnimation, Skeleton sourceSkeleton, Skeleton targetSkeleton, SkeletonMapping map, TweenTransforms techniques, String resultName) {
        Track[] tracks;
        Validate.nonNull((Object)sourceSkeleton, (String)"source skeleton");
        Validate.nonNull((Object)targetSkeleton, (String)"target skeleton");
        Validate.nonNull((Object)map, (String)"map");
        Validate.nonNull((Object)techniques, (String)"techniques");
        Validate.nonNull((Object)resultName, (String)"result name");
        float duration = sourceAnimation.getLength();
        Animation result = new Animation(resultName, duration);
        TreeMap<Float, Pose> cache = new TreeMap<Float, Pose>();
        int numTargetBones = targetSkeleton.getBoneCount();
        for (int iTarget = 0; iTarget < numTargetBones; ++iTarget) {
            Bone targetBone = targetSkeleton.getBone(iTarget);
            String targetName = targetBone.getName();
            BoneMapping boneMapping = map.get(targetName);
            if (boneMapping == null) continue;
            String sourceName = boneMapping.getSourceName();
            int iSource = sourceSkeleton.getBoneIndex(sourceName);
            BoneTrack sourceTrack = MyAnimation.findBoneTrack((Animation)sourceAnimation, (int)iSource);
            BoneTrack track = TrackEdit.retargetTrack(sourceAnimation, sourceTrack, sourceSkeleton, targetSkeleton, iTarget, map, techniques, cache);
            result.addTrack((Track)track);
        }
        for (Track track : tracks = sourceAnimation.getTracks()) {
            if (track instanceof BoneTrack) continue;
            Track clone = track.clone();
            result.addTrack(clone);
        }
        return result;
    }

    public static Animation retargetAnimation(AnimClip sourceClip, Armature sourceArmature, Skeleton targetSkeleton, SkeletonMapping map, String resultName) {
        AnimTrack[] tracks;
        Validate.nonNull((Object)sourceArmature, (String)"source armature");
        Validate.nonNull((Object)targetSkeleton, (String)"target skeleton");
        Validate.nonNull((Object)map, (String)"map");
        Validate.nonNull((Object)resultName, (String)"result name");
        float duration = (float)sourceClip.getLength();
        Animation result = new Animation(resultName, duration);
        TreeMap<Float, Pose> cache = new TreeMap<Float, Pose>();
        int numTargetBones = targetSkeleton.getBoneCount();
        for (int iTarget = 0; iTarget < numTargetBones; ++iTarget) {
            Bone targetBone = targetSkeleton.getBone(iTarget);
            String targetName = targetBone.getName();
            BoneMapping boneMapping = map.get(targetName);
            if (boneMapping == null) continue;
            String sourceName = boneMapping.getSourceName();
            int iSource = sourceArmature.getJointIndex(sourceName);
            TransformTrack sourceTrack = MyAnimation.findJointTrack((AnimClip)sourceClip, (int)iSource);
            BoneTrack track = TrackEdit.retargetTrack(sourceClip, sourceTrack, sourceArmature, targetSkeleton, iTarget, map, cache);
            result.addTrack((Track)track);
        }
        for (AnimTrack track : tracks = sourceClip.getTracks()) {
            if (MyAnimation.isJointTrack((AnimTrack)track)) continue;
        }
        return result;
    }

    public static AnimClip retargetAnimation(AnimClip sourceClip, Armature sourceArmature, Armature targetArmature, SkeletonMapping map, String resultName) {
        AnimTrack[] tracks;
        Validate.nonNull((Object)sourceArmature, (String)"source armature");
        Validate.nonNull((Object)targetArmature, (String)"target armature");
        Validate.nonNull((Object)map, (String)"map");
        Validate.nonNull((Object)resultName, (String)"result name");
        AnimClip result = new AnimClip(resultName);
        TreeMap<Float, Pose> cache = new TreeMap<Float, Pose>();
        int numTargetJoints = targetArmature.getJointCount();
        for (int iTarget = 0; iTarget < numTargetJoints; ++iTarget) {
            Joint targetJoint = targetArmature.getJoint(iTarget);
            String targetName = targetJoint.getName();
            BoneMapping boneMapping = map.get(targetName);
            if (boneMapping == null) continue;
            String sourceName = boneMapping.getSourceName();
            int iSource = sourceArmature.getJointIndex(sourceName);
            TransformTrack sourceTrack = MyAnimation.findJointTrack((AnimClip)sourceClip, (int)iSource);
            TransformTrack newTrack = TrackEdit.retargetTrack(sourceClip, sourceTrack, sourceArmature, targetArmature, targetJoint, map, cache);
            int numSamples = newTrack.getTimes().length;
            assert (numSamples > 0) : numSamples;
            assert (newTrack.getTranslations().length == numSamples);
            assert (newTrack.getRotations().length == numSamples);
            assert (newTrack.getScales().length == numSamples);
            assert (newTrack.getLength() == sourceTrack.getLength());
            AnimationEdit.addTrack(result, newTrack);
        }
        for (AnimTrack track : tracks = sourceClip.getTracks()) {
            if (MyAnimation.isJointTrack((AnimTrack)track)) continue;
            AnimTrack clone = (AnimTrack)Heart.deepCopy((Object)track);
            AnimationEdit.addTrack(result, clone);
        }
        assert (result.getLength() == sourceClip.getLength());
        return result;
    }

    public static AnimClip reverseAnimation(AnimClip sourceClip, String resultName) {
        AnimTrack[] forwardTracks;
        Validate.nonNull((Object)resultName, (String)"result name");
        AnimClip result = new AnimClip(resultName);
        for (AnimTrack forwardTrack : forwardTracks = sourceClip.getTracks()) {
            AnimTrack<?> newTrack = TrackEdit.reverse(forwardTrack);
            assert (newTrack.getLength() == forwardTrack.getLength());
            AnimationEdit.addTrack(result, newTrack);
        }
        return result;
    }

    public static Animation reverseAnimation(Animation sourceAnimation, String resultName) {
        Track[] forwardTracks;
        Validate.nonNull((Object)resultName, (String)"result name");
        float duration = sourceAnimation.getLength();
        Animation result = new Animation(resultName, duration);
        for (Track forwardTrack : forwardTracks = sourceAnimation.getTracks()) {
            Track newTrack = TrackEdit.reverse(forwardTrack);
            result.addTrack(newTrack);
        }
        return result;
    }

    public static AnimClip translateForInitialSupport(AnimClip sourceClip, int jointIndex, Armature armature, Spatial subtree, float supportY, String resultName) {
        AnimClip result;
        Validate.nonNull((Object)sourceClip, (String)"source clip");
        Validate.nonNegative((int)jointIndex, (String)"joint index");
        Validate.nonNull((Object)armature, (String)"armature");
        Validate.nonNull((Object)subtree, (String)"subtree");
        Validate.nonNull((Object)resultName, (String)"result name");
        Vector3f[] translations = SupportUtils.translateForInitialSupport(sourceClip, jointIndex, armature, subtree, supportY);
        if (translations == null) {
            result = null;
        } else {
            TransformTrack oldTrack = MyAnimation.findJointTrack((AnimClip)sourceClip, (int)jointIndex);
            assert (oldTrack != null);
            result = AnimationEdit.replaceTranslations(sourceClip, oldTrack, translations, resultName);
        }
        return result;
    }

    public static AnimClip translateForSupport(AnimClip sourceClip, int jointIndex, Armature armature, Spatial subtree, float supportY, String resultName) {
        AnimClip result;
        Validate.nonNull((Object)sourceClip, (String)"source clip");
        Validate.nonNegative((int)jointIndex, (String)"joint index");
        Validate.nonNull((Object)armature, (String)"armature");
        Validate.nonNull((Object)subtree, (String)"subtree");
        Validate.nonNull((Object)resultName, (String)"result name");
        Vector3f[] translations = SupportUtils.translateForSupport(sourceClip, jointIndex, armature, subtree, supportY);
        if (translations == null) {
            result = null;
        } else {
            TransformTrack oldTrack = MyAnimation.findJointTrack((AnimClip)sourceClip, (int)jointIndex);
            result = AnimationEdit.replaceTranslations(sourceClip, oldTrack, translations, resultName);
        }
        return result;
    }

    public static AnimClip translateForTraction(AnimClip sourceClip, int jointIndex, Armature armature, Spatial subtree, String resultName) {
        AnimClip result;
        Validate.nonNull((Object)sourceClip, (String)"source clip");
        Validate.nonNegative((int)jointIndex, (String)"joint index");
        Validate.nonNull((Object)armature, (String)"armature");
        Validate.nonNull((Object)subtree, (String)"subtree");
        Validate.nonNull((Object)resultName, (String)"result name");
        Vector3f[] translations = SupportUtils.translateForTraction(sourceClip, jointIndex, armature, subtree);
        if (translations == null) {
            result = null;
        } else {
            TransformTrack oldTrack = MyAnimation.findJointTrack((AnimClip)sourceClip, (int)jointIndex);
            result = AnimationEdit.replaceTranslations(sourceClip, oldTrack, translations, resultName);
        }
        return result;
    }

    public static AnimClip setDuration(AnimClip sourceClip, float newDuration, String resultName) {
        AnimTrack[] oldTracks;
        Validate.nonNull((Object)resultName, (String)"result name");
        AnimClip result = new AnimClip(resultName);
        for (AnimTrack sourceTrack : oldTracks = sourceClip.getTracks()) {
            MorphTrack newTrack;
            MorphTrack oldTrack;
            if (sourceTrack instanceof MorphTrack) {
                oldTrack = (MorphTrack)sourceTrack;
                newTrack = TrackEdit.setDuration(oldTrack, newDuration);
            } else {
                oldTrack = (TransformTrack)sourceTrack;
                newTrack = TrackEdit.setDuration((TransformTrack)oldTrack, newDuration);
            }
            assert (newTrack.getLength() == (double)newDuration);
            AnimationEdit.addTrack(result, newTrack);
        }
        return result;
    }

    public static int zeroFirst(Animation animation) {
        Track[] tracks;
        int numTracksEdited = 0;
        for (Track track : tracks = animation.getTracks()) {
            float[] times = track.getKeyFrameTimes();
            if (times[0] == 0.0f) continue;
            times[0] = 0.0f;
            ++numTracksEdited;
        }
        return numTracksEdited;
    }

    public static int zeroFirst(AnimClip clip) {
        int numTracksEdited = 0;
        for (AnimTrack track : clip.getTracks()) {
            float[] times = track instanceof MorphTrack ? ((MorphTrack)track).getTimes() : ((TransformTrack)track).getTimes();
            if (times[0] == 0.0f) continue;
            times = (track = TrackEdit.cloneTrack(track)) instanceof MorphTrack ? ((MorphTrack)track).getTimes() : ((TransformTrack)track).getTimes();
            times[0] = 0.0f;
            tracks[i] = track;
            ++numTracksEdited;
        }
        return numTracksEdited;
    }
}

