/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.wes;

import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyQuaternion;

public final class SmoothRotations
extends Enum<SmoothRotations> {
    public static final /* enum */ SmoothRotations LoopNlerp = new SmoothRotations();
    public static final /* enum */ SmoothRotations Nlerp = new SmoothRotations();
    private static final /* synthetic */ SmoothRotations[] $VALUES;

    public static SmoothRotations[] values() {
        return (SmoothRotations[])$VALUES.clone();
    }

    public static SmoothRotations valueOf(String name) {
        return Enum.valueOf(SmoothRotations.class, name);
    }

    public Quaternion[] smooth(float[] times, float cycleTime, Quaternion[] samples, float width, Quaternion[] storeResult) {
        Quaternion[] result;
        assert (times.length > 0);
        assert (times.length == samples.length);
        int last = times.length - 1;
        assert (cycleTime >= times[last]) : cycleTime;
        Validate.inRange((float)width, (String)"width", (float)0.0f, (float)cycleTime);
        if (storeResult == null) {
            result = new Quaternion[times.length];
        } else {
            result = storeResult;
            assert (result.length >= times.length);
        }
        switch (this) {
            case Nlerp: {
                SmoothRotations.lerp(times, samples, width, result);
                break;
            }
            case LoopNlerp: {
                if (times[last] == cycleTime) {
                    if (last > 1) {
                        SmoothRotations.loopLerp(last - 1, times, cycleTime, samples, width, result);
                        result[last] = result[0].clone();
                        break;
                    }
                    SmoothRotations.lerp(times, samples, width, result);
                    break;
                }
                SmoothRotations.loopLerp(last, times, cycleTime, samples, width, result);
                break;
            }
            default: {
                throw new IllegalStateException("this = " + (Object)((Object)this));
            }
        }
        return result;
    }

    public static Quaternion[] lerp(float[] times, Quaternion[] samples, float width, Quaternion[] storeResult) {
        Quaternion[] result;
        Validate.nonNull((Object)times, (String)"times");
        assert (times.length > 0);
        Validate.nonNull((Object)samples, (String)"samples");
        assert (times.length == samples.length);
        Validate.nonNegative((float)width, (String)"width");
        if (storeResult == null) {
            result = new Quaternion[times.length];
        } else {
            result = storeResult;
            assert (result.length >= times.length);
        }
        int last = times.length - 1;
        float halfWidth = width / 2.0f;
        for (int i = 0; i <= last; ++i) {
            Quaternion sumQuaternion = result[i];
            if (sumQuaternion == null) {
                result[i] = sumQuaternion = new Quaternion();
            } else {
                sumQuaternion.set(0.0f, 0.0f, 0.0f, 0.0f);
            }
            float iTime = times[i];
            float sumWeight = 0.0f;
            for (int j = 0; j <= last; ++j) {
                float jTime = times[j];
                float dt = iTime - jTime;
                if (!((dt = FastMath.abs((float)dt)) < halfWidth)) continue;
                float weight = 1.0f - dt / halfWidth;
                MyQuaternion.accumulateScaled((Quaternion)sumQuaternion, (Quaternion)samples[j], (float)weight);
                sumWeight += weight;
            }
            assert (sumWeight > 0.0f) : sumWeight;
            MyQuaternion.normalizeLocal((Quaternion)sumQuaternion);
        }
        return result;
    }

    public static Quaternion[] loopLerp(int last, float[] times, float cycleTime, Quaternion[] samples, float width, Quaternion[] storeResult) {
        Quaternion[] result;
        Validate.positive((int)last, (String)"last");
        Validate.nonNull((Object)samples, (String)"samples");
        assert (times.length > last) : times.length;
        assert (samples.length > last) : samples.length;
        assert (cycleTime > times[last]) : cycleTime;
        Validate.inRange((float)width, (String)"width", (float)0.0f, (float)cycleTime);
        if (storeResult == null) {
            result = new Quaternion[times.length];
        } else {
            result = storeResult;
            assert (result.length >= times.length);
        }
        float halfWidth = width / 2.0f;
        for (int i = 0; i <= last; ++i) {
            Quaternion sumQuaternion = result[i];
            if (sumQuaternion == null) {
                result[i] = sumQuaternion = new Quaternion();
            } else {
                sumQuaternion.set(0.0f, 0.0f, 0.0f, 0.0f);
            }
            float iTime = times[i];
            float sumWeight = 0.0f;
            for (int j = 0; j <= last; ++j) {
                float jTime = times[j];
                float dt = MyMath.modulo((float)(iTime - jTime), (float)cycleTime);
                if (dt > cycleTime / 2.0f) {
                    dt -= cycleTime;
                }
                if (!((dt = FastMath.abs((float)dt)) < halfWidth)) continue;
                float weight = 1.0f - dt / halfWidth;
                MyQuaternion.accumulateScaled((Quaternion)sumQuaternion, (Quaternion)samples[j], (float)weight);
                sumWeight += weight;
            }
            assert (sumWeight > 0.0f) : sumWeight;
            MyQuaternion.normalizeLocal((Quaternion)sumQuaternion);
        }
        return result;
    }

    private static /* synthetic */ SmoothRotations[] $values() {
        return new SmoothRotations[]{LoopNlerp, Nlerp};
    }

    static {
        $VALUES = SmoothRotations.$values();
    }
}

