/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.wes;

import com.jme3.anim.AnimClip;
import com.jme3.anim.Armature;
import com.jme3.anim.TransformTrack;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.clone.Cloner;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.MyAnimation;
import jme3utilities.MyMesh;
import jme3utilities.Validate;
import jme3utilities.math.MyBuffer;
import jme3utilities.wes.Pose;

public final class SupportUtils {
    private static final Logger logger = Logger.getLogger(SupportUtils.class.getName());
    private static final Vector3f xAxis = new Vector3f(1.0f, 0.0f, 0.0f);
    private static final Vector3f yAxis = new Vector3f(0.0f, 1.0f, 0.0f);
    private static final Vector3f zAxis = new Vector3f(0.0f, 0.0f, 1.0f);

    private SupportUtils() {
    }

    public static int findSupport(Geometry geometry, Matrix4f[] skinningMatrices, Vector3f storeLocation) {
        Validate.nonNull((Object)skinningMatrices, (String)"skinning matrices");
        Validate.nonNull((Object)storeLocation, (String)"store location");
        int bestIndex = -1;
        float bestY = Float.POSITIVE_INFINITY;
        Vector3f meshLoc = new Vector3f();
        Vector3f worldLoc = new Vector3f();
        Mesh mesh = geometry.getMesh();
        int maxWeightsPerVertex = mesh.getMaxNumWeights();
        VertexBuffer posBuf = mesh.getBuffer(VertexBuffer.Type.BindPosePosition);
        FloatBuffer posBuffer = (FloatBuffer)posBuf.getDataReadOnly();
        posBuffer.rewind();
        VertexBuffer wBuf = mesh.getBuffer(VertexBuffer.Type.BoneWeight);
        FloatBuffer weightBuffer = (FloatBuffer)wBuf.getDataReadOnly();
        weightBuffer.rewind();
        VertexBuffer biBuf = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
        Buffer boneIndexBuffer = biBuf.getData();
        boneIndexBuffer.rewind();
        int numVertices = posBuffer.remaining() / 3;
        for (int vertexIndex = 0; vertexIndex < numVertices; ++vertexIndex) {
            int wIndex;
            float bx = posBuffer.get();
            float by = posBuffer.get();
            float bz = posBuffer.get();
            meshLoc.zero();
            for (wIndex = 0; wIndex < maxWeightsPerVertex; ++wIndex) {
                float weight = weightBuffer.get();
                int boneIndex = MyBuffer.readIndex((Buffer)boneIndexBuffer);
                if (weight == 0.0f) continue;
                Matrix4f s = skinningMatrices[boneIndex];
                float xOff = s.m00 * bx + s.m01 * by + s.m02 * bz + s.m03;
                float yOff = s.m10 * bx + s.m11 * by + s.m12 * bz + s.m13;
                float zOff = s.m20 * bx + s.m21 * by + s.m22 * bz + s.m23;
                meshLoc.x += weight * xOff;
                meshLoc.y += weight * yOff;
                meshLoc.z += weight * zOff;
            }
            if (geometry.isIgnoreTransform()) {
                worldLoc.set(meshLoc);
            } else {
                geometry.localToWorld(meshLoc, worldLoc);
            }
            if (worldLoc.y < bestY) {
                bestIndex = vertexIndex;
                bestY = worldLoc.y;
                storeLocation.set(worldLoc);
            }
            for (wIndex = maxWeightsPerVertex; wIndex < 4; ++wIndex) {
                weightBuffer.get();
                MyBuffer.readIndex((Buffer)boneIndexBuffer);
            }
        }
        return bestIndex;
    }

    public static int findSupport(Spatial subtree, Matrix4f[] skinningMatrices, Vector3f storeLocation, Geometry[] storeGeometry) {
        Validate.nonNull((Object)skinningMatrices, (String)"skinning matrices");
        Validate.nonNull((Object)storeLocation, (String)"store location");
        Validate.nonNull((Object)storeGeometry, (String)"store geometry");
        assert (storeGeometry.length == 1) : storeGeometry.length;
        int bestIndex = -1;
        storeGeometry[0] = null;
        float bestY = Float.POSITIVE_INFINITY;
        Vector3f tmpLocation = new Vector3f();
        if (subtree instanceof Geometry) {
            Geometry geometry = (Geometry)subtree;
            int index = SupportUtils.findSupport(geometry, skinningMatrices, tmpLocation);
            if (tmpLocation.y < bestY) {
                bestIndex = index;
                storeGeometry[0] = geometry;
                storeLocation.set(tmpLocation);
            }
        } else if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            Geometry[] tmpGeometry = new Geometry[1];
            for (Spatial child : children) {
                int index = SupportUtils.findSupport(child, skinningMatrices, tmpLocation, tmpGeometry);
                if (!(tmpLocation.y < bestY)) continue;
                bestIndex = index;
                bestY = tmpLocation.y;
                storeGeometry[0] = tmpGeometry[0];
                storeLocation.set(tmpLocation);
            }
        }
        return bestIndex;
    }

    public static Matrix3f sensitivity(int boneIndex, Geometry geometry, int vertexIndex, Pose pose, Matrix3f storeResult) {
        Validate.nonNull((Object)geometry, (String)"geometry");
        Matrix3f result = storeResult == null ? new Matrix3f() : storeResult;
        Cloner cloner = new Cloner();
        Object skeleton = pose.findSkeleton();
        if (skeleton != null) {
            cloner.setClonedValue(skeleton, skeleton);
        }
        Pose testPose = (Pose)cloner.clone((Object)pose);
        Vector3f testWorld = new Vector3f();
        Vector3f baseWorld = new Vector3f();
        int numBones = pose.countBones();
        Matrix4f[] matrices = new Matrix4f[numBones];
        pose.userTranslation(boneIndex, testWorld);
        testPose.skin(matrices);
        MyMesh.vertexWorldLocation((Geometry)geometry, (int)vertexIndex, (Matrix4f[])matrices, (Vector3f)baseWorld);
        pose.userTranslation(boneIndex, testWorld);
        testWorld.addLocal(xAxis);
        testPose.setTranslation(boneIndex, testWorld);
        testPose.skin(matrices);
        MyMesh.vertexWorldLocation((Geometry)geometry, (int)vertexIndex, (Matrix4f[])matrices, (Vector3f)testWorld);
        testWorld.subtractLocal(baseWorld);
        result.setColumn(0, testWorld);
        pose.userTranslation(boneIndex, testWorld);
        testWorld.addLocal(yAxis);
        testPose.setTranslation(boneIndex, testWorld);
        testPose.skin(matrices);
        MyMesh.vertexWorldLocation((Geometry)geometry, (int)vertexIndex, (Matrix4f[])matrices, (Vector3f)testWorld);
        testWorld.subtractLocal(baseWorld);
        result.setColumn(1, testWorld);
        pose.userTranslation(boneIndex, testWorld);
        testWorld.addLocal(zAxis);
        testPose.setTranslation(boneIndex, testWorld);
        testPose.skin(matrices);
        MyMesh.vertexWorldLocation((Geometry)geometry, (int)vertexIndex, (Matrix4f[])matrices, (Vector3f)testWorld);
        testWorld.subtractLocal(baseWorld);
        result.setColumn(2, testWorld);
        return result;
    }

    public static Vector3f[] translateForInitialSupport(AnimClip oldClip, int jointIndex, Armature armature, Spatial subtree, float supportY) {
        Validate.nonNull((Object)oldClip, (String)"old clip");
        Validate.nonNegative((int)jointIndex, (String)"joint index");
        Validate.nonNull((Object)armature, (String)"armature");
        Validate.nonNull((Object)subtree, (String)"subtree");
        TransformTrack oldTrack = MyAnimation.findJointTrack((AnimClip)oldClip, (int)jointIndex);
        assert (oldTrack != null);
        Pose tempPose = new Pose(armature);
        int numBones = tempPose.countBones();
        Matrix4f[] skinningMatrices = new Matrix4f[numBones];
        float[] times = oldTrack.getTimes();
        float trackTime = times[0];
        tempPose.setToClip(oldClip, trackTime);
        tempPose.skin(skinningMatrices);
        Geometry[] geometryRef = new Geometry[1];
        Vector3f worldOffset = new Vector3f();
        Matrix3f sensMat = new Matrix3f();
        int vertexIndex = SupportUtils.findSupport(subtree, skinningMatrices, worldOffset, geometryRef);
        assert (vertexIndex != -1);
        worldOffset.x = 0.0f;
        worldOffset.y = supportY - worldOffset.y;
        worldOffset.z = 0.0f;
        Geometry geometry = geometryRef[0];
        SupportUtils.sensitivity(jointIndex, geometry, vertexIndex, tempPose, sensMat);
        float det = sensMat.determinant();
        if (FastMath.abs((float)det) <= 1.1920929E-7f) {
            return null;
        }
        sensMat.invertLocal();
        Vector3f boneOffset = sensMat.mult(worldOffset, null);
        Vector3f[] oldTranslations = oldTrack.getTranslations();
        int numKeyframes = times.length;
        Vector3f[] result = new Vector3f[numKeyframes];
        for (int frameIndex = 0; frameIndex < numKeyframes; ++frameIndex) {
            Vector3f translation = oldTranslations[frameIndex];
            result[frameIndex] = translation.add(boneOffset);
        }
        return result;
    }

    public static Vector3f[] translateForSupport(AnimClip oldClip, int jointIndex, Armature armature, Spatial subtree, float supportY) {
        Validate.nonNull((Object)oldClip, (String)"old clip");
        Validate.nonNegative((int)jointIndex, (String)"joint index");
        Validate.nonNull((Object)armature, (String)"armature");
        Validate.nonNull((Object)subtree, (String)"subtree");
        TransformTrack oldTrack = MyAnimation.findJointTrack((AnimClip)oldClip, (int)jointIndex);
        assert (oldTrack != null);
        Pose tempPose = new Pose(armature);
        int numBones = tempPose.countBones();
        Matrix4f[] skinningMatrices = new Matrix4f[numBones];
        Geometry[] geometryRef = new Geometry[1];
        Vector3f worldOffset = new Vector3f();
        Matrix3f sensMat = new Matrix3f();
        float[] times = oldTrack.getTimes();
        Vector3f[] oldTranslations = oldTrack.getTranslations();
        int numKeyframes = times.length;
        Vector3f[] result = new Vector3f[numKeyframes];
        for (int frameIndex = 0; frameIndex < numKeyframes; ++frameIndex) {
            float trackTime = times[frameIndex];
            tempPose.setToClip(oldClip, trackTime);
            tempPose.skin(skinningMatrices);
            int vertexIndex = SupportUtils.findSupport(subtree, skinningMatrices, worldOffset, geometryRef);
            assert (vertexIndex != -1);
            worldOffset.x = 0.0f;
            worldOffset.y = supportY - worldOffset.y;
            worldOffset.z = 0.0f;
            Geometry geometry = geometryRef[0];
            SupportUtils.sensitivity(jointIndex, geometry, vertexIndex, tempPose, sensMat);
            float det = sensMat.determinant();
            if (FastMath.abs((float)det) <= 1.1920929E-7f) {
                return null;
            }
            sensMat.invertLocal();
            Vector3f boneOffset = sensMat.mult(worldOffset, null);
            Vector3f translation = oldTranslations[frameIndex];
            result[frameIndex] = translation.add(boneOffset);
        }
        return result;
    }

    public static Vector3f[] translateForTraction(AnimClip oldClip, int jointIndex, Armature armature, Spatial subtree) {
        Validate.nonNull((Object)oldClip, (String)"old clip");
        Validate.nonNegative((int)jointIndex, (String)"joint index");
        Validate.nonNull((Object)armature, (String)"armature");
        Validate.nonNull((Object)subtree, (String)"subtree");
        TransformTrack oldTrack = MyAnimation.findJointTrack((AnimClip)oldClip, (int)jointIndex);
        assert (oldTrack != null);
        Pose tempPose = new Pose(armature);
        int numBones = tempPose.countBones();
        Matrix4f[] skinningMatrices = new Matrix4f[numBones];
        Geometry[] previousGeometryRef = new Geometry[1];
        Vector3f previousWorld = new Vector3f();
        Vector3f worldOffset = new Vector3f();
        Vector3f w = new Vector3f();
        Matrix3f sensMat = new Matrix3f();
        float[] times = oldTrack.getTimes();
        Vector3f[] oldTranslations = oldTrack.getTranslations();
        int numKeyframes = times.length;
        Vector3f[] result = new Vector3f[numKeyframes];
        int previousVertexIndex = -1;
        for (int frameIndex = 0; frameIndex < numKeyframes; ++frameIndex) {
            float trackTime = times[frameIndex];
            tempPose.setToClip(oldClip, trackTime);
            tempPose.skin(skinningMatrices);
            Vector3f translation = oldTranslations[frameIndex];
            if (previousVertexIndex == -1) {
                worldOffset.zero();
                result[frameIndex] = translation;
            } else {
                MyMesh.vertexWorldLocation((Geometry)previousGeometryRef[0], (int)previousVertexIndex, (Matrix4f[])skinningMatrices, (Vector3f)w);
                previousWorld.subtractLocal(w);
                worldOffset.addLocal(previousWorld);
                SupportUtils.sensitivity(jointIndex, previousGeometryRef[0], previousVertexIndex, tempPose, sensMat);
                float determinant = sensMat.determinant();
                if (FastMath.abs((float)determinant) <= 1.1920929E-7f) {
                    return null;
                }
                sensMat.invertLocal();
                Vector3f boneOffset = sensMat.mult(worldOffset, null);
                result[frameIndex] = translation.add(boneOffset);
            }
            previousVertexIndex = SupportUtils.findSupport(subtree, skinningMatrices, previousWorld, previousGeometryRef);
            assert (previousVertexIndex != -1);
            assert (previousGeometryRef[0] != null);
        }
        return result;
    }
}

