/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.wes;

import com.jme3.anim.AnimClip;
import com.jme3.anim.AnimTrack;
import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.anim.MorphTrack;
import com.jme3.anim.TransformTrack;
import com.jme3.anim.util.HasLocalTransform;
import com.jme3.animation.Animation;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SpatialTrack;
import com.jme3.animation.Track;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.bvh.SkeletonMapping;
import java.util.Map;
import java.util.logging.Logger;
import jme3utilities.MyAnimation;
import jme3utilities.Validate;
import jme3utilities.math.MyArray;
import jme3utilities.math.MyQuaternion;
import jme3utilities.math.MyVector3f;
import jme3utilities.wes.Pose;
import jme3utilities.wes.SmoothRotations;
import jme3utilities.wes.SmoothVectors;
import jme3utilities.wes.TweenTransforms;

public final class TrackEdit {
    private static final Logger logger = Logger.getLogger(TrackEdit.class.getName());
    private static final Vector3f scaleIdentity = new Vector3f(1.0f, 1.0f, 1.0f);

    private TrackEdit() {
    }

    public static MorphTrack behead(MorphTrack oldTrack, float neckTime, float[] neckWeights) {
        Validate.positive((float)neckTime, (String)"neck time");
        Validate.nonNull((Object)neckWeights, (String)"neck weights");
        float[] oldTimes = oldTrack.getTimes();
        assert (neckTime >= oldTimes[0]) : neckTime;
        int oldCount = oldTimes.length;
        float[] oldWeights = oldTrack.getWeights();
        int neckIndex = MyArray.findPreviousIndex((float)neckTime, (float[])oldTimes);
        int newCount = oldCount - neckIndex;
        assert (newCount > 0) : newCount;
        float[] newTimes = new float[newCount];
        int numTargets = oldTrack.getNbMorphTargets();
        float[] newWeights = new float[newCount * numTargets];
        newTimes[0] = 0.0f;
        for (int j = 0; j < numTargets; ++j) {
            float weight;
            newWeights[j] = weight = neckWeights[j];
        }
        for (int newIndex = 1; newIndex < newCount; ++newIndex) {
            int oldIndex = newIndex + neckIndex;
            newTimes[newIndex] = oldTimes[oldIndex] - neckTime;
            int oldStart = oldIndex * numTargets;
            int newStart = newIndex * numTargets;
            for (int j = 0; j < numTargets; ++j) {
                float weight;
                newWeights[newStart + j] = weight = oldWeights[oldStart + j];
            }
        }
        Geometry target = oldTrack.getTarget();
        MorphTrack result = new MorphTrack(target, newTimes, newWeights, numTargets);
        return result;
    }

    public static Track behead(Track oldTrack, float neckTime, Transform neckTransform, float oldDuration) {
        assert (oldTrack instanceof BoneTrack || oldTrack instanceof SpatialTrack);
        Validate.positive((float)neckTime, (String)"neck time");
        float[] oldTimes = oldTrack.getKeyFrameTimes();
        Vector3f[] oldTranslations = MyAnimation.copyTranslations((Track)oldTrack);
        Quaternion[] oldRotations = MyAnimation.copyRotations((Track)oldTrack);
        Vector3f[] oldScales = MyAnimation.copyScales((Track)oldTrack);
        int oldCount = oldTimes.length;
        assert (oldCount > 0) : oldCount;
        int neckIndex = MyAnimation.findPreviousKeyframeIndex((Track)oldTrack, (float)neckTime);
        int newCount = oldCount - neckIndex;
        assert (newCount > 0) : newCount;
        float[] newTimes = new float[newCount];
        newTimes[0] = 0.0f;
        Vector3f[] newTranslations = null;
        if (oldTranslations != null) {
            newTranslations = new Vector3f[newCount];
            newTranslations[0] = neckTransform.getTranslation().clone();
        }
        Quaternion[] newRotations = null;
        if (oldRotations != null) {
            newRotations = new Quaternion[newCount];
            newRotations[0] = neckTransform.getRotation().clone();
        }
        Vector3f[] newScales = null;
        if (oldScales != null) {
            newScales = new Vector3f[newCount];
            newScales[0] = neckTransform.getScale().clone();
        }
        for (int newIndex = 1; newIndex < newCount; ++newIndex) {
            int oldIndex = newIndex + neckIndex;
            newTimes[newIndex] = oldTimes[oldIndex] - neckTime;
            if (newTranslations != null) {
                newTranslations[newIndex] = oldTranslations[oldIndex].clone();
            }
            if (newRotations != null) {
                newRotations[newIndex] = oldRotations[oldIndex].clone();
            }
            if (newScales == null) continue;
            newScales[newIndex] = oldScales[oldIndex].clone();
        }
        Track result = TrackEdit.newTrack(oldTrack, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static TransformTrack behead(TransformTrack oldTrack, float neckTime, Transform neckTransform) {
        Validate.positive((float)neckTime, (String)"neck time");
        float[] oldTimes = oldTrack.getTimes();
        assert (neckTime >= oldTimes[0]);
        int oldCount = oldTimes.length;
        Vector3f[] oldTranslations = oldTrack.getTranslations();
        Quaternion[] oldRotations = oldTrack.getRotations();
        Vector3f[] oldScales = oldTrack.getScales();
        int neckIndex = MyAnimation.findPreviousKeyframeIndex((TransformTrack)oldTrack, (float)neckTime);
        int newCount = oldCount - neckIndex;
        assert (newCount > 0) : newCount;
        float[] newTimes = new float[newCount];
        newTimes[0] = 0.0f;
        Vector3f[] newTranslations = null;
        if (oldTranslations != null) {
            newTranslations = new Vector3f[newCount];
            newTranslations[0] = neckTransform.getTranslation().clone();
        }
        Quaternion[] newRotations = null;
        if (oldRotations != null) {
            newRotations = new Quaternion[newCount];
            newRotations[0] = neckTransform.getRotation().clone();
        }
        Vector3f[] newScales = null;
        if (oldScales != null) {
            newScales = new Vector3f[newCount];
            newScales[0] = neckTransform.getScale().clone();
        }
        for (int newIndex = 1; newIndex < newCount; ++newIndex) {
            int oldIndex = newIndex + neckIndex;
            newTimes[newIndex] = oldTimes[oldIndex] - neckTime;
            if (newTranslations != null) {
                newTranslations[newIndex] = oldTranslations[oldIndex].clone();
            }
            if (newRotations != null) {
                newRotations[newIndex] = oldRotations[oldIndex].clone();
            }
            if (newScales == null) continue;
            newScales[newIndex] = oldScales[oldIndex].clone();
        }
        HasLocalTransform target = oldTrack.getTarget();
        TransformTrack result = new TransformTrack(target, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static Track chain(Track track1, Track track2, float startTime2, float newDuration) {
        int numCopy2;
        int numBlend;
        int numCopy1;
        assert (track1 instanceof BoneTrack && track2 instanceof BoneTrack || track1 instanceof SpatialTrack && track2 instanceof SpatialTrack);
        Validate.inRange((float)startTime2, (String)"start time for track2", (float)0.0f, (float)newDuration);
        float[] times1 = track1.getKeyFrameTimes();
        Vector3f[] translations1 = MyAnimation.copyTranslations((Track)track1);
        Quaternion[] rots1 = MyAnimation.copyRotations((Track)track1);
        Vector3f[] scales1 = MyAnimation.copyScales((Track)track1);
        float[] times2 = track2.getKeyFrameTimes();
        Vector3f[] translations2 = MyAnimation.copyTranslations((Track)track2);
        Quaternion[] rots2 = MyAnimation.copyRotations((Track)track2);
        Vector3f[] scales2 = MyAnimation.copyScales((Track)track2);
        int last1 = MyAnimation.findPreviousKeyframeIndex((Track)track1, (float)newDuration);
        assert (last1 >= 0) : last1;
        float newDuration2 = newDuration - startTime2;
        int last2 = MyAnimation.findPreviousKeyframeIndex((Track)track2, (float)newDuration2);
        assert (last2 >= 0) : last2;
        float lastTime1 = times1[last1];
        if (lastTime1 < startTime2) {
            numCopy1 = last1 + 1;
            numBlend = 0;
            numCopy2 = last2 + 1;
        } else if (lastTime1 == startTime2) {
            numCopy1 = last1;
            numBlend = 1;
            numCopy2 = last2;
        } else {
            throw new IllegalArgumentException("overlapping tracks");
        }
        int newCount = numCopy1 + numBlend + numCopy2;
        float[] newTimes = new float[newCount];
        Vector3f[] newTranslations = null;
        if (translations1 != null || translations2 != null) {
            newTranslations = new Vector3f[newCount];
        }
        Quaternion[] newRotations = null;
        if (rots1 != null || rots2 != null) {
            newRotations = new Quaternion[newCount];
        }
        Vector3f[] newScales = null;
        if (scales1 != null || scales2 != null) {
            newScales = new Vector3f[newCount];
        }
        for (int frameIndex = 0; frameIndex < newCount; ++frameIndex) {
            Vector3f scale2;
            Quaternion rot2;
            Vector3f tra2;
            Vector3f scale1;
            Quaternion rot1;
            Vector3f tra1;
            if (frameIndex < numCopy1) {
                newTimes[frameIndex] = times1[frameIndex];
                tra1 = translations1 == null ? null : translations1[frameIndex];
                rot1 = rots1 == null ? null : rots1[frameIndex];
                scale1 = scales1 == null ? null : scales1[frameIndex];
                tra2 = null;
                rot2 = null;
                scale2 = null;
            } else if (frameIndex > last1) {
                int index2 = frameIndex - numCopy1;
                newTimes[frameIndex] = times2[index2] + startTime2;
                tra1 = null;
                rot1 = null;
                scale1 = null;
                tra2 = translations2 == null ? null : translations2[index2];
                rot2 = rots2 == null ? null : rots2[index2];
                scale2 = scales2 == null ? null : scales2[index2];
            } else {
                assert (numBlend == 1) : numBlend;
                assert (frameIndex == last1);
                assert (lastTime1 == startTime2);
                newTimes[frameIndex] = startTime2;
                tra1 = translations1 == null ? null : translations1[frameIndex];
                rot1 = rots1 == null ? null : rots1[frameIndex];
                scale1 = scales1 == null ? null : scales1[frameIndex];
                tra2 = translations2 == null ? null : translations2[0];
                rot2 = rots2 == null ? null : rots2[0];
                Vector3f vector3f = scale2 = scales2 == null ? null : scales2[0];
            }
            if (newTranslations != null) {
                newTranslations[frameIndex] = TrackEdit.blendTranslations(0.5f, tra1, tra2);
            }
            if (newRotations != null) {
                newRotations[frameIndex] = TrackEdit.blendRotations(0.5f, rot1, rot2);
            }
            if (newScales == null) continue;
            newScales[frameIndex] = TrackEdit.blendScales(0.5f, scale1, scale2);
        }
        Track result = TrackEdit.newTrack(track1, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static <T> T cloneTrack(T track) {
        Track result;
        if (track instanceof MorphTrack) {
            MorphTrack oldTrack = (MorphTrack)track;
            Geometry target = oldTrack.getTarget();
            float[] oldTimes = oldTrack.getTimes();
            int numKeyFrames = oldTimes.length;
            float[] newTimes = new float[numKeyFrames];
            System.arraycopy(oldTimes, 0, newTimes, 0, numKeyFrames);
            float[] oldWeights = oldTrack.getWeights();
            int numWeights = oldWeights.length;
            float[] newWeights = new float[numWeights];
            System.arraycopy(oldWeights, 0, newWeights, 0, numWeights);
            int numTargets = oldTrack.getNbMorphTargets();
            MorphTrack clone = new MorphTrack(target, newTimes, newWeights, numTargets);
            result = clone;
        } else if (track instanceof Track) {
            result = ((Track)track).clone();
        } else if (track instanceof TransformTrack) {
            TransformTrack oldTrack = (TransformTrack)track;
            float[] oldTimes = oldTrack.getTimes();
            int numKeyFrames = oldTimes.length;
            float[] newTimes = new float[numKeyFrames];
            System.arraycopy(oldTimes, 0, newTimes, 0, numKeyFrames);
            Vector3f[] translations = oldTrack.getTranslations();
            Quaternion[] rotations = oldTrack.getRotations();
            Vector3f[] scales = oldTrack.getScales();
            HasLocalTransform target = oldTrack.getTarget();
            TransformTrack clone = new TransformTrack(target, newTimes, translations, rotations, scales);
            result = clone;
        } else {
            String className = track.getClass().getSimpleName();
            throw new IllegalArgumentException(className);
        }
        return (T)result;
    }

    public static TransformTrack convertToInPlace(TransformTrack oldTrack) {
        Vector3f[] oldTranslations = oldTrack.getTranslations();
        int numTranslations = oldTranslations == null ? 0 : oldTranslations.length;
        Validate.inRange((int)numTranslations, (String)"number of translations", (int)2, (int)Integer.MAX_VALUE);
        float[] oldTimes = oldTrack.getTimes();
        int frameCount = oldTimes.length;
        int lastFrame = frameCount - 1;
        float elapsed = oldTimes[lastFrame] - oldTimes[0];
        if (elapsed == 0.0f) {
            throw new IllegalArgumentException("The first and last frames must not be simultaneous!");
        }
        Quaternion[] oldRotations = oldTrack.getRotations();
        Vector3f[] oldScales = oldTrack.getScales();
        float[] newTimes = new float[frameCount];
        Vector3f[] newTranslations = new Vector3f[frameCount];
        Quaternion[] newRotations = null;
        if (oldRotations != null) {
            newRotations = new Quaternion[frameCount];
        }
        Vector3f[] newScales = null;
        if (oldScales != null) {
            newScales = new Vector3f[frameCount];
        }
        Vector3f startOffset = oldTranslations[0];
        Vector3f endOffset = oldTranslations[lastFrame];
        Vector3f velocity = MyVector3f.velocity((float)elapsed, (Vector3f)startOffset, (Vector3f)endOffset, null);
        for (int frameIndex = 0; frameIndex < frameCount; ++frameIndex) {
            float time;
            newTimes[frameIndex] = time = oldTimes[frameIndex];
            Vector3f translation = oldTranslations[frameIndex].clone();
            MyVector3f.accumulateScaled((Vector3f)translation, (Vector3f)velocity, (float)(-time));
            newTranslations[frameIndex] = translation;
            if (newRotations != null) {
                newRotations[frameIndex] = oldRotations[frameIndex].clone();
            }
            if (newScales == null) continue;
            newScales[frameIndex] = oldScales[frameIndex].clone();
        }
        HasLocalTransform target = oldTrack.getTarget();
        TransformTrack result = new TransformTrack(target, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static Track delayAll(Track oldTrack, float delayAmount, float newDuration) {
        Validate.inRange((float)delayAmount, (String)"delay amount", (float)0.0f, (float)newDuration);
        float[] oldTimes = oldTrack.getKeyFrameTimes();
        Vector3f[] oldTranslations = MyAnimation.copyTranslations((Track)oldTrack);
        Quaternion[] oldRotations = MyAnimation.copyRotations((Track)oldTrack);
        Vector3f[] oldScales = MyAnimation.copyScales((Track)oldTrack);
        float oldDuration = newDuration - delayAmount;
        assert (oldDuration < newDuration);
        int lastIndex = MyAnimation.findPreviousKeyframeIndex((Track)oldTrack, (float)oldDuration);
        int addFrames = delayAmount > 0.0f ? 1 : 0;
        int newCount = addFrames + lastIndex + 1;
        float[] newTimes = new float[newCount];
        newTimes[0] = 0.0f;
        Vector3f[] newTranslations = null;
        if (oldTranslations != null) {
            newTranslations = new Vector3f[newCount];
            newTranslations[0] = new Vector3f();
        }
        Quaternion[] newRotations = null;
        if (oldRotations != null) {
            newRotations = new Quaternion[newCount];
            newRotations[0] = new Quaternion();
        }
        Vector3f[] newScales = null;
        if (oldScales != null) {
            newScales = new Vector3f[newCount];
            newScales[0] = new Vector3f(1.0f, 1.0f, 1.0f);
        }
        for (int oldIndex = 0; oldIndex <= lastIndex; ++oldIndex) {
            int frameIndex = oldIndex + addFrames;
            newTimes[frameIndex] = oldTimes[oldIndex] + delayAmount;
            if (newTranslations != null) {
                newTranslations[frameIndex] = oldTranslations[oldIndex].clone();
            }
            if (newRotations != null) {
                newRotations[frameIndex] = oldRotations[oldIndex].clone();
            }
            if (newScales == null) continue;
            newScales[frameIndex] = oldScales[oldIndex].clone();
        }
        Track result = TrackEdit.newTrack(oldTrack, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static Track deleteRange(Track oldTrack, int startIndex, int deleteCount) {
        assert (oldTrack instanceof BoneTrack || oldTrack instanceof SpatialTrack);
        float[] oldTimes = oldTrack.getKeyFrameTimes();
        int oldCount = oldTimes.length;
        assert (oldCount > 0) : oldCount;
        int lastIndex = oldCount - 1;
        Validate.inRange((int)startIndex, (String)"start index", (int)1, (int)lastIndex);
        Validate.inRange((int)deleteCount, (String)"delete count", (int)1, (int)lastIndex);
        float endIndex = startIndex + deleteCount - 1;
        Validate.inRange((float)endIndex, (String)"end index", (float)1.0f, (float)lastIndex);
        Vector3f[] oldTranslations = MyAnimation.copyTranslations((Track)oldTrack);
        Quaternion[] oldRotations = MyAnimation.copyRotations((Track)oldTrack);
        Vector3f[] oldScales = MyAnimation.copyScales((Track)oldTrack);
        int newCount = oldCount - deleteCount;
        float[] newTimes = new float[newCount];
        Vector3f[] newTranslations = null;
        if (oldTranslations != null) {
            newTranslations = new Vector3f[newCount];
        }
        Quaternion[] newRotations = null;
        if (oldRotations != null) {
            newRotations = new Quaternion[newCount];
        }
        Vector3f[] newScales = null;
        if (oldScales != null) {
            newScales = new Vector3f[newCount];
        }
        for (int newIndex = 0; newIndex < newCount; ++newIndex) {
            int oldIndex = newIndex < startIndex ? newIndex : newIndex + deleteCount;
            newTimes[newIndex] = oldTimes[oldIndex];
            if (newTranslations != null) {
                newTranslations[newIndex] = oldTranslations[oldIndex].clone();
            }
            if (newRotations != null) {
                newRotations[newIndex] = oldRotations[oldIndex].clone();
            }
            if (newScales == null) continue;
            newScales[newIndex] = oldScales[oldIndex].clone();
        }
        Track result = TrackEdit.newTrack(oldTrack, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static TransformTrack deleteRange(TransformTrack oldTrack, int startIndex, int deleteCount) {
        float[] oldTimes = oldTrack.getTimes();
        int oldCount = oldTimes.length;
        assert (oldCount > 0) : oldCount;
        int lastIndex = oldCount - 1;
        Validate.inRange((int)startIndex, (String)"start index", (int)1, (int)lastIndex);
        Validate.inRange((int)deleteCount, (String)"delete count", (int)1, (int)lastIndex);
        float endIndex = startIndex + deleteCount - 1;
        Validate.inRange((float)endIndex, (String)"end index", (float)1.0f, (float)lastIndex);
        Vector3f[] oldTranslations = oldTrack.getTranslations();
        Quaternion[] oldRotations = oldTrack.getRotations();
        Vector3f[] oldScales = oldTrack.getScales();
        int newCount = oldCount - deleteCount;
        float[] newTimes = new float[newCount];
        Vector3f[] newTranslations = null;
        if (oldTranslations != null) {
            newTranslations = new Vector3f[newCount];
        }
        Quaternion[] newRotations = null;
        if (oldRotations != null) {
            newRotations = new Quaternion[newCount];
        }
        Vector3f[] newScales = null;
        if (oldScales != null) {
            newScales = new Vector3f[newCount];
        }
        for (int newIndex = 0; newIndex < newCount; ++newIndex) {
            int oldIndex = newIndex < startIndex ? newIndex : newIndex + deleteCount;
            newTimes[newIndex] = oldTimes[oldIndex];
            if (newTranslations != null) {
                newTranslations[newIndex] = oldTranslations[oldIndex].clone();
            }
            if (newRotations != null) {
                newRotations[newIndex] = oldRotations[oldIndex].clone();
            }
            if (newScales == null) continue;
            newScales[newIndex] = oldScales[oldIndex].clone();
        }
        HasLocalTransform target = oldTrack.getTarget();
        TransformTrack result = new TransformTrack(target, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static Track insertKeyframe(Track oldTrack, float frameTime, Transform transform) {
        assert (oldTrack instanceof BoneTrack || oldTrack instanceof SpatialTrack);
        Validate.positive((float)frameTime, (String)"keyframe time");
        assert (MyAnimation.findKeyframeIndex((Track)oldTrack, (float)frameTime) == -1);
        float[] oldTimes = oldTrack.getKeyFrameTimes();
        Vector3f[] oldTranslations = MyAnimation.copyTranslations((Track)oldTrack);
        Quaternion[] oldRotations = MyAnimation.copyRotations((Track)oldTrack);
        Vector3f[] oldScales = MyAnimation.copyScales((Track)oldTrack);
        int oldCount = oldTimes.length;
        assert (oldCount > 0) : oldCount;
        int newCount = oldCount + 1;
        float[] newTimes = new float[newCount];
        Vector3f[] newTranslations = new Vector3f[newCount];
        Quaternion[] newRotations = new Quaternion[newCount];
        Vector3f[] newScales = new Vector3f[newCount];
        boolean added = false;
        for (int oldIndex = 0; oldIndex < oldCount; ++oldIndex) {
            float time = oldTimes[oldIndex];
            int newIndex = oldIndex;
            if (time > frameTime) {
                if (!added) {
                    newTimes[newIndex] = frameTime;
                    newTranslations[newIndex] = transform.getTranslation().clone();
                    newRotations[newIndex] = transform.getRotation().clone();
                    newScales[newIndex] = transform.getScale().clone();
                    added = true;
                }
                ++newIndex;
            }
            newTimes[newIndex] = oldTimes[oldIndex];
            newTranslations[newIndex] = oldTranslations == null ? new Vector3f() : oldTranslations[oldIndex].clone();
            newRotations[newIndex] = oldRotations == null ? new Quaternion() : oldRotations[oldIndex].clone();
            newScales[newIndex] = oldScales == null ? new Vector3f(1.0f, 1.0f, 1.0f) : oldScales[oldIndex].clone();
        }
        if (!added) {
            newTimes[oldCount] = frameTime;
            newTranslations[oldCount] = transform.getTranslation().clone();
            newRotations[oldCount] = transform.getRotation().clone();
            newScales[oldCount] = transform.getScale().clone();
        }
        Track result = TrackEdit.newTrack(oldTrack, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static TransformTrack insertKeyframe(TransformTrack oldTrack, float frameTime, Transform transform) {
        Validate.positive((float)frameTime, (String)"keyframe time");
        assert (MyAnimation.findKeyframeIndex((TransformTrack)oldTrack, (float)frameTime) == -1);
        float[] oldTimes = oldTrack.getTimes();
        Vector3f[] oldTranslations = oldTrack.getTranslations();
        Quaternion[] oldRotations = oldTrack.getRotations();
        Vector3f[] oldScales = oldTrack.getScales();
        int oldCount = oldTimes.length;
        assert (oldCount > 0) : oldCount;
        int newCount = oldCount + 1;
        float[] newTimes = new float[newCount];
        Vector3f[] newTranslations = new Vector3f[newCount];
        Quaternion[] newRotations = new Quaternion[newCount];
        Vector3f[] newScales = new Vector3f[newCount];
        HasLocalTransform target = oldTrack.getTarget();
        Transform fillData = target.getLocalTransform();
        boolean added = false;
        for (int oldIndex = 0; oldIndex < oldCount; ++oldIndex) {
            float time = oldTimes[oldIndex];
            int newIndex = oldIndex;
            if (time > frameTime) {
                if (!added) {
                    newTimes[newIndex] = frameTime;
                    newTranslations[newIndex] = transform.getTranslation().clone();
                    newRotations[newIndex] = transform.getRotation().clone();
                    newScales[newIndex] = transform.getScale().clone();
                    added = true;
                }
                ++newIndex;
            }
            newTimes[newIndex] = oldTimes[oldIndex];
            newTranslations[newIndex] = oldTranslations == null ? fillData.getTranslation().clone() : oldTranslations[oldIndex].clone();
            newRotations[newIndex] = oldRotations == null ? fillData.getRotation().clone() : oldRotations[oldIndex].clone();
            newScales[newIndex] = oldScales == null ? fillData.getScale().clone() : oldScales[oldIndex].clone();
        }
        if (!added) {
            newTimes[oldCount] = frameTime;
            newTranslations[oldCount] = transform.getTranslation().clone();
            newRotations[oldCount] = transform.getRotation().clone();
            newScales[oldCount] = transform.getScale().clone();
        }
        TransformTrack result = new TransformTrack(target, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static Track newTrack(Track oldTrack, float[] times, Vector3f[] translations, Quaternion[] rotations, Vector3f[] scales) {
        BoneTrack result;
        Validate.nonNull((Object)times, (String)"times");
        int numKeyframes = times.length;
        assert (numKeyframes > 0) : numKeyframes;
        assert (translations == null || translations.length == numKeyframes);
        assert (rotations == null || rotations.length == numKeyframes);
        assert (scales == null || scales.length == numKeyframes);
        if (oldTrack instanceof BoneTrack) {
            BoneTrack boneTrack = (BoneTrack)oldTrack;
            int boneIndex = boneTrack.getTargetBoneIndex();
            result = MyAnimation.newBoneTrack((int)boneIndex, (float[])times, (Vector3f[])translations, (Quaternion[])rotations, (Vector3f[])scales);
        } else if (oldTrack instanceof SpatialTrack) {
            SpatialTrack spatialTrack = (SpatialTrack)oldTrack;
            Spatial spatial = spatialTrack.getTrackSpatial();
            SpatialTrack newSpatialTrack = new SpatialTrack(times, translations, rotations, scales);
            newSpatialTrack.setTrackSpatial(spatial);
            result = newSpatialTrack;
        } else {
            throw new IllegalArgumentException(oldTrack.getClass().getName());
        }
        return result;
    }

    public static AnimTrack<?> normalizeQuaternions(AnimTrack<?> inputTrack, float tolerance) {
        Validate.nonNegative((float)tolerance, (String)"tolerance");
        TransformTrack result = inputTrack;
        if (inputTrack instanceof MorphTrack) {
            return result;
        }
        TransformTrack oldTrack = inputTrack;
        Quaternion[] oldRotations = oldTrack.getRotations();
        if (oldRotations == null) {
            return result;
        }
        int numFrames = oldRotations.length;
        assert (numFrames > 0) : numFrames;
        boolean changes = false;
        for (Quaternion oldQuat : oldRotations) {
            double norm = MyQuaternion.lengthSquared((Quaternion)oldQuat);
            double delta = Math.abs(1.0 - norm);
            if (!(delta > (double)tolerance)) continue;
            changes = true;
            break;
        }
        if (!changes) {
            return result;
        }
        float[] oldTimes = oldTrack.getTimes();
        assert (oldTimes.length == numFrames);
        Vector3f[] oldTranslations = oldTrack.getTranslations();
        Vector3f[] oldScales = oldTrack.getScales();
        float[] times = new float[numFrames];
        Vector3f[] translations = null;
        if (oldTranslations != null) {
            assert (oldTranslations.length == numFrames);
            translations = new Vector3f[numFrames];
        }
        Quaternion[] rotations = new Quaternion[numFrames];
        Vector3f[] scales = null;
        if (oldScales != null) {
            assert (oldScales.length == numFrames);
            scales = new Vector3f[numFrames];
        }
        for (int frameI = 0; frameI < numFrames; ++frameI) {
            times[frameI] = oldTimes[frameI];
            if (translations != null) {
                translations[frameI] = oldTranslations[frameI].clone();
            }
            rotations[frameI] = oldRotations[frameI].clone();
            MyQuaternion.normalizeLocal((Quaternion)rotations[frameI]);
            if (scales == null) continue;
            scales[frameI] = oldScales[frameI].clone();
        }
        HasLocalTransform target = oldTrack.getTarget();
        result = new TransformTrack(target, times, translations, rotations, scales);
        return result;
    }

    public static Track normalizeQuaternions(Track inputTrack, float tolerance) {
        assert (inputTrack instanceof BoneTrack || inputTrack instanceof SpatialTrack);
        Validate.nonNegative((float)tolerance, (String)"tolerance");
        Track result = inputTrack;
        Quaternion[] oldRotations = MyAnimation.copyRotations((Track)inputTrack);
        if (oldRotations == null) {
            return result;
        }
        int numFrames = oldRotations.length;
        assert (numFrames > 0) : numFrames;
        boolean changes = false;
        for (Quaternion oldQuat : oldRotations) {
            double norm = MyQuaternion.lengthSquared((Quaternion)oldQuat);
            double delta = Math.abs(1.0 - norm);
            if (!(delta > (double)tolerance)) continue;
            changes = true;
            break;
        }
        if (!changes) {
            return result;
        }
        float[] oldTimes = inputTrack.getKeyFrameTimes();
        assert (oldTimes.length == numFrames);
        Vector3f[] oldTranslations = MyAnimation.copyTranslations((Track)inputTrack);
        Vector3f[] oldScales = MyAnimation.copyScales((Track)inputTrack);
        float[] times = new float[numFrames];
        Vector3f[] translations = null;
        if (oldTranslations != null) {
            assert (oldTranslations.length == numFrames);
            translations = new Vector3f[numFrames];
        }
        Quaternion[] rotations = new Quaternion[numFrames];
        Vector3f[] scales = null;
        if (oldScales != null) {
            assert (oldScales.length == numFrames);
            scales = new Vector3f[numFrames];
        }
        for (int frameIndex = 0; frameIndex < numFrames; ++frameIndex) {
            times[frameIndex] = oldTimes[frameIndex];
            if (translations != null) {
                translations[frameIndex] = oldTranslations[frameIndex].clone();
            }
            rotations[frameIndex] = oldRotations[frameIndex].clone();
            MyQuaternion.normalizeLocal((Quaternion)rotations[frameIndex]);
            if (scales == null) continue;
            scales[frameIndex] = oldScales[frameIndex].clone();
        }
        result = TrackEdit.newTrack(inputTrack, times, translations, rotations, scales);
        return result;
    }

    public static Track reduce(Track oldTrack, int factor) {
        assert (oldTrack instanceof BoneTrack || oldTrack instanceof SpatialTrack);
        Validate.inRange((int)factor, (String)"factor", (int)2, (int)Integer.MAX_VALUE);
        float[] oldTimes = oldTrack.getKeyFrameTimes();
        Vector3f[] oldTranslations = MyAnimation.copyTranslations((Track)oldTrack);
        Quaternion[] oldRotations = MyAnimation.copyRotations((Track)oldTrack);
        Vector3f[] oldScales = MyAnimation.copyScales((Track)oldTrack);
        int oldCount = oldTimes.length;
        assert (oldCount > 0) : oldCount;
        int newCount = 1 + (oldCount - 1) / factor;
        float[] newTimes = new float[newCount];
        Vector3f[] newTranslations = null;
        if (oldTranslations != null) {
            newTranslations = new Vector3f[newCount];
        }
        Quaternion[] newRotations = null;
        if (oldRotations != null) {
            newRotations = new Quaternion[newCount];
        }
        Vector3f[] newScales = null;
        if (oldScales != null) {
            newScales = new Vector3f[newCount];
        }
        for (int newIndex = 0; newIndex < newCount; ++newIndex) {
            int oldIndex = newIndex * factor;
            newTimes[newIndex] = oldTimes[oldIndex];
            if (newTranslations != null) {
                newTranslations[newIndex] = oldTranslations[oldIndex].clone();
            }
            if (newRotations != null) {
                newRotations[newIndex] = oldRotations[oldIndex].clone();
            }
            if (newScales == null) continue;
            newScales[newIndex] = oldScales[oldIndex].clone();
        }
        Track result = TrackEdit.newTrack(oldTrack, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static TransformTrack reduce(TransformTrack oldTrack, int factor) {
        Validate.inRange((int)factor, (String)"factor", (int)2, (int)Integer.MAX_VALUE);
        float[] oldTimes = oldTrack.getTimes();
        Vector3f[] oldTranslations = oldTrack.getTranslations();
        Quaternion[] oldRotations = oldTrack.getRotations();
        Vector3f[] oldScales = oldTrack.getScales();
        int oldCount = oldTimes.length;
        assert (oldCount > 0) : oldCount;
        int newCount = 1 + (oldCount - 1) / factor;
        float[] newTimes = new float[newCount];
        Vector3f[] newTranslations = null;
        if (oldTranslations != null) {
            newTranslations = new Vector3f[newCount];
        }
        Quaternion[] newRotations = null;
        if (oldRotations != null) {
            newRotations = new Quaternion[newCount];
        }
        Vector3f[] newScales = null;
        if (oldScales != null) {
            newScales = new Vector3f[newCount];
        }
        for (int newIndex = 0; newIndex < newCount; ++newIndex) {
            int oldIndex = newIndex * factor;
            newTimes[newIndex] = oldTimes[oldIndex];
            if (newTranslations != null) {
                newTranslations[newIndex] = oldTranslations[oldIndex].clone();
            }
            if (newRotations != null) {
                newRotations[newIndex] = oldRotations[oldIndex].clone();
            }
            if (newScales == null) continue;
            newScales[newIndex] = oldScales[oldIndex].clone();
        }
        HasLocalTransform target = oldTrack.getTarget();
        TransformTrack result = new TransformTrack(target, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static boolean removeRepeats(MorphTrack track) {
        float[] oldTimes = track.getTimes();
        int oldCount = oldTimes.length;
        int newCount = MyArray.countNeSorted((float[])oldTimes);
        if (newCount == oldCount) {
            return false;
        }
        float[] oldWeights = track.getWeights();
        float[] newTimes = new float[newCount];
        int numTargets = track.getNbMorphTargets();
        float[] newWeights = new float[newCount * numTargets];
        float prevTime = Float.NEGATIVE_INFINITY;
        int newIndex = 0;
        for (int oldIndex = 0; oldIndex < oldCount; ++oldIndex) {
            float time = oldTimes[oldIndex];
            if (time != prevTime) {
                newTimes[newIndex] = oldTimes[oldIndex];
                int oldStart = oldIndex * numTargets;
                int newStart = newIndex * numTargets;
                for (int j = 0; j < numTargets; ++j) {
                    float weight;
                    newWeights[newStart + j] = weight = oldWeights[oldStart + j];
                }
                ++newIndex;
            }
            prevTime = time;
        }
        track.setKeyframes(newTimes, newWeights);
        return true;
    }

    public static boolean removeRepeats(Track track) {
        assert (track instanceof BoneTrack || track instanceof SpatialTrack);
        float[] oldTimes = track.getKeyFrameTimes();
        int oldCount = oldTimes.length;
        int newCount = MyArray.countNeSorted((float[])oldTimes);
        if (newCount == oldCount) {
            return false;
        }
        Vector3f[] oldTranslations = MyAnimation.copyTranslations((Track)track);
        Quaternion[] oldRotations = MyAnimation.copyRotations((Track)track);
        Vector3f[] oldScales = MyAnimation.copyScales((Track)track);
        float[] newTimes = new float[newCount];
        Vector3f[] newTranslations = null;
        if (oldTranslations != null) {
            newTranslations = new Vector3f[newCount];
        }
        Quaternion[] newRotations = null;
        if (oldRotations != null) {
            newRotations = new Quaternion[newCount];
        }
        Vector3f[] newScales = null;
        if (oldScales != null) {
            newScales = new Vector3f[newCount];
        }
        float prevTime = Float.NEGATIVE_INFINITY;
        int newIndex = 0;
        for (int oldIndex = 0; oldIndex < oldCount; ++oldIndex) {
            float time = oldTimes[oldIndex];
            if (time != prevTime) {
                newTimes[newIndex] = oldTimes[oldIndex];
                if (newTranslations != null) {
                    newTranslations[newIndex] = oldTranslations[oldIndex];
                }
                if (newRotations != null) {
                    newRotations[newIndex] = oldRotations[oldIndex];
                }
                if (newScales != null) {
                    newScales[newIndex] = oldScales[oldIndex];
                }
                ++newIndex;
            }
            prevTime = time;
        }
        TrackEdit.setKeyframes(track, newTimes, newTranslations, newRotations, newScales);
        return true;
    }

    public static boolean removeRepeats(TransformTrack track) {
        float[] oldTimes = track.getTimes();
        int oldCount = oldTimes.length;
        int newCount = MyArray.countNeSorted((float[])oldTimes);
        if (newCount == oldCount) {
            return false;
        }
        Vector3f[] oldTranslations = track.getTranslations();
        Quaternion[] oldRotations = track.getRotations();
        Vector3f[] oldScales = track.getScales();
        float[] newTimes = new float[newCount];
        Vector3f[] newTranslations = null;
        if (oldTranslations != null) {
            newTranslations = new Vector3f[newCount];
        }
        Quaternion[] newRotations = null;
        if (oldRotations != null) {
            newRotations = new Quaternion[newCount];
        }
        Vector3f[] newScales = null;
        if (oldScales != null) {
            newScales = new Vector3f[newCount];
        }
        float prevTime = Float.NEGATIVE_INFINITY;
        int newIndex = 0;
        for (int oldIndex = 0; oldIndex < oldCount; ++oldIndex) {
            float time = oldTimes[oldIndex];
            if (time != prevTime) {
                newTimes[newIndex] = oldTimes[oldIndex];
                if (newTranslations != null) {
                    newTranslations[newIndex] = oldTranslations[oldIndex];
                }
                if (newRotations != null) {
                    newRotations[newIndex] = oldRotations[oldIndex];
                }
                if (newScales != null) {
                    newScales[newIndex] = oldScales[oldIndex];
                }
                ++newIndex;
            }
            prevTime = time;
        }
        track.setKeyframes(newTimes, newTranslations, newRotations, newScales);
        return true;
    }

    public static Track replaceKeyframe(Track oldTrack, int frameIndex, Transform transform) {
        assert (oldTrack instanceof BoneTrack || oldTrack instanceof SpatialTrack);
        float[] oldTimes = oldTrack.getKeyFrameTimes();
        int frameCount = oldTimes.length;
        Validate.inRange((int)frameIndex, (String)"keyframe index", (int)0, (int)(frameCount - 1));
        Validate.nonNull((Object)transform, (String)"transform");
        Vector3f[] oldTranslations = MyAnimation.copyTranslations((Track)oldTrack);
        Quaternion[] oldRotations = MyAnimation.copyRotations((Track)oldTrack);
        Vector3f[] oldScales = MyAnimation.copyScales((Track)oldTrack);
        float[] newTimes = new float[frameCount];
        Vector3f[] newTranslations = new Vector3f[frameCount];
        Quaternion[] newRotations = new Quaternion[frameCount];
        Vector3f[] newScales = new Vector3f[frameCount];
        for (int frameI = 0; frameI < frameCount; ++frameI) {
            newTimes[frameI] = oldTimes[frameI];
            if (frameI == frameIndex) {
                newTranslations[frameI] = transform.getTranslation().clone();
                newRotations[frameI] = transform.getRotation().clone();
                newScales[frameI] = transform.getScale().clone();
                continue;
            }
            newTranslations[frameI] = oldTranslations == null ? new Vector3f() : oldTranslations[frameI].clone();
            newRotations[frameI] = oldRotations == null ? new Quaternion() : oldRotations[frameI].clone();
            newScales[frameI] = oldScales == null ? new Vector3f(1.0f, 1.0f, 1.0f) : oldScales[frameI].clone();
        }
        Track result = TrackEdit.newTrack(oldTrack, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static TransformTrack replaceKeyframe(TransformTrack oldTrack, int frameIndex, Transform transform) {
        float[] oldTimes = oldTrack.getTimes();
        int frameCount = oldTimes.length;
        Validate.inRange((int)frameIndex, (String)"keyframe index", (int)0, (int)(frameCount - 1));
        Validate.nonNull((Object)transform, (String)"transform");
        Vector3f[] oldTranslations = oldTrack.getTranslations();
        Quaternion[] oldRotations = oldTrack.getRotations();
        Vector3f[] oldScales = oldTrack.getScales();
        float[] newTimes = new float[frameCount];
        Vector3f[] newTranslations = new Vector3f[frameCount];
        Quaternion[] newRotations = new Quaternion[frameCount];
        Vector3f[] newScales = new Vector3f[frameCount];
        HasLocalTransform target = oldTrack.getTarget();
        Transform fillData = target.getLocalTransform();
        for (int frameI = 0; frameI < frameCount; ++frameI) {
            newTimes[frameI] = oldTimes[frameI];
            if (frameI == frameIndex) {
                newTranslations[frameI] = transform.getTranslation().clone();
                newRotations[frameI] = transform.getRotation().clone();
                newScales[frameI] = transform.getScale().clone();
                continue;
            }
            newTranslations[frameI] = oldTranslations == null ? fillData.getTranslation().clone() : oldTranslations[frameI].clone();
            newRotations[frameI] = oldRotations == null ? fillData.getRotation().clone() : oldRotations[frameI].clone();
            newScales[frameI] = oldScales == null ? fillData.getScale().clone() : oldScales[frameI].clone();
        }
        TransformTrack result = new TransformTrack(target, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static TransformTrack resample(TransformTrack oldTrack, float[] newTimes) {
        int numSamples = newTimes.length;
        Vector3f[] oldTranslations = oldTrack.getTranslations();
        Quaternion[] oldRotations = oldTrack.getRotations();
        Vector3f[] oldScales = oldTrack.getScales();
        Vector3f[] newTranslations = null;
        if (oldTranslations != null) {
            newTranslations = new Vector3f[numSamples];
        }
        Quaternion[] newRotations = null;
        if (oldRotations != null) {
            newRotations = new Quaternion[numSamples];
        }
        Vector3f[] newScales = null;
        if (oldScales != null) {
            newScales = new Vector3f[numSamples];
        }
        for (int frameIndex = 0; frameIndex < numSamples; ++frameIndex) {
            float time = newTimes[frameIndex];
            Transform transform = new Transform();
            oldTrack.getDataAtTime((double)time, transform);
            if (newTranslations != null) {
                newTranslations[frameIndex] = transform.getTranslation();
            }
            if (newRotations != null) {
                newRotations[frameIndex] = transform.getRotation();
            }
            if (newScales == null) continue;
            newScales[frameIndex] = transform.getScale();
        }
        HasLocalTransform target = oldTrack.getTarget();
        TransformTrack result = new TransformTrack(target, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static TransformTrack resampleAtRate(TransformTrack oldTrack, float sampleRate, float duration) {
        Validate.positive((float)sampleRate, (String)"sample rate");
        Validate.nonNegative((float)duration, (String)"duration");
        int numSamples = 1 + (int)Math.floor(duration * sampleRate);
        float[] newTimes = new float[numSamples];
        for (int frameIndex = 0; frameIndex < numSamples; ++frameIndex) {
            float time = (float)frameIndex / sampleRate;
            if (time > duration) {
                time = duration;
            }
            newTimes[frameIndex] = time;
        }
        TransformTrack result = TrackEdit.resample(oldTrack, newTimes);
        return result;
    }

    public static TransformTrack resampleToNumber(TransformTrack oldTrack, int numSamples, float duration) {
        Validate.inRange((int)numSamples, (String)"number of samples", (int)2, (int)Integer.MAX_VALUE);
        Validate.positive((float)duration, (String)"duration");
        float[] newTimes = new float[numSamples];
        for (int frameIndex = 0; frameIndex < numSamples; ++frameIndex) {
            float time = frameIndex == numSamples - 1 ? duration : (float)frameIndex * duration / (float)(numSamples - 1);
            newTimes[frameIndex] = time;
        }
        TransformTrack result = TrackEdit.resample(oldTrack, newTimes);
        return result;
    }

    public static TransformTrack retargetTrack(AnimClip sourceClip, TransformTrack sourceTrack, Armature sourceArmature, Armature targetArmature, Joint targetJoint, SkeletonMapping map, Map<Float, Pose> cache) {
        Validate.nonNull((Object)sourceArmature, (String)"source armature");
        Validate.nonNull((Object)targetArmature, (String)"target armature");
        Validate.nonNull((Object)map, (String)"map");
        Validate.nonNull((Object)targetJoint, (String)"target joint");
        float[] times = sourceTrack.getTimes();
        int numKeyframes = times.length;
        assert (numKeyframes > 0) : numKeyframes;
        Vector3f[] translations = new Vector3f[numKeyframes];
        Quaternion[] rotations = new Quaternion[numKeyframes];
        Vector3f[] scales = new Vector3f[numKeyframes];
        Pose sourcePose = new Pose(sourceArmature);
        int targetJointIndex = targetJoint.getId();
        for (int frameIndex = 0; frameIndex < numKeyframes; ++frameIndex) {
            float trackTime = times[frameIndex];
            Pose targetPose = cache.get(Float.valueOf(trackTime));
            if (targetPose == null) {
                targetPose = new Pose(targetArmature);
                sourcePose.setToClip(sourceClip, trackTime);
                targetPose.setToRetarget(sourcePose, map);
                cache.put(Float.valueOf(trackTime), targetPose);
            }
            Transform localTransform = targetPose.localTransform(targetJointIndex, null);
            translations[frameIndex] = localTransform.getTranslation();
            rotations[frameIndex] = localTransform.getRotation();
            scales[frameIndex] = localTransform.getScale();
        }
        TransformTrack result = new TransformTrack((HasLocalTransform)targetJoint, times, translations, rotations, scales);
        return result;
    }

    public static BoneTrack retargetTrack(AnimClip sourceClip, TransformTrack sourceTrack, Armature sourceArmature, Skeleton targetSkeleton, int targetBoneIndex, SkeletonMapping map, Map<Float, Pose> cache) {
        Validate.nonNull((Object)sourceArmature, (String)"source armature");
        Validate.nonNull((Object)targetSkeleton, (String)"target skeleton");
        Validate.nonNull((Object)map, (String)"map");
        Validate.nonNegative((int)targetBoneIndex, (String)"target bone index");
        float[] times = sourceTrack.getTimes();
        int numKeyframes = times.length;
        assert (numKeyframes > 0) : numKeyframes;
        Vector3f[] translations = new Vector3f[numKeyframes];
        Quaternion[] rotations = new Quaternion[numKeyframes];
        Vector3f[] scales = new Vector3f[numKeyframes];
        Pose sourcePose = new Pose(sourceArmature);
        for (int frameIndex = 0; frameIndex < numKeyframes; ++frameIndex) {
            float trackTime = times[frameIndex];
            Pose targetPose = cache.get(Float.valueOf(trackTime));
            if (targetPose == null) {
                targetPose = new Pose(targetSkeleton);
                sourcePose.setToClip(sourceClip, trackTime);
                targetPose.setToRetarget(sourcePose, map);
                cache.put(Float.valueOf(trackTime), targetPose);
            }
            Transform userTransform = targetPose.userTransform(targetBoneIndex, null);
            translations[frameIndex] = userTransform.getTranslation();
            rotations[frameIndex] = userTransform.getRotation();
            scales[frameIndex] = userTransform.getScale();
        }
        BoneTrack result = new BoneTrack(targetBoneIndex, times, translations, rotations, scales);
        return result;
    }

    public static BoneTrack retargetTrack(Animation sourceAnimation, BoneTrack sourceTrack, Skeleton sourceSkeleton, Skeleton targetSkeleton, int targetBoneIndex, SkeletonMapping map, TweenTransforms techniques, Map<Float, Pose> cache) {
        float[] times;
        int numKeyframes;
        Validate.nonNull((Object)sourceSkeleton, (String)"source skeleton");
        Validate.nonNull((Object)targetSkeleton, (String)"target skeleton");
        Validate.nonNull((Object)map, (String)"map");
        Validate.nonNull((Object)techniques, (String)"techniques");
        Validate.nonNegative((int)targetBoneIndex, (String)"target bone index");
        if (sourceTrack == null) {
            numKeyframes = 1;
            times = new float[numKeyframes];
            times[0] = 0.0f;
        } else {
            times = sourceTrack.getKeyFrameTimes();
            numKeyframes = times.length;
            assert (numKeyframes > 0) : numKeyframes;
        }
        Vector3f[] translations = new Vector3f[numKeyframes];
        Quaternion[] rotations = new Quaternion[numKeyframes];
        Vector3f[] scales = new Vector3f[numKeyframes];
        Pose sourcePose = new Pose(sourceSkeleton);
        for (int frameIndex = 0; frameIndex < numKeyframes; ++frameIndex) {
            float trackTime = times[frameIndex];
            Pose targetPose = cache.get(Float.valueOf(trackTime));
            if (targetPose == null) {
                targetPose = new Pose(targetSkeleton);
                sourcePose.setToAnimation(sourceAnimation, trackTime, techniques);
                targetPose.setToRetarget(sourcePose, map);
                cache.put(Float.valueOf(trackTime), targetPose);
            }
            Transform userTransform = targetPose.userTransform(targetBoneIndex, null);
            translations[frameIndex] = userTransform.getTranslation();
            rotations[frameIndex] = userTransform.getRotation();
            scales[frameIndex] = userTransform.getScale();
        }
        BoneTrack result = new BoneTrack(targetBoneIndex, times, translations, rotations, scales);
        return result;
    }

    public static AnimTrack<?> reverse(AnimTrack<?> inputTrack) {
        MorphTrack result;
        Validate.nonNull(inputTrack, (String)"input track");
        float[] oldTimes = MyAnimation.getKeyFrameTimes(inputTrack);
        int numFrames = oldTimes.length;
        float lastFrameTime = oldTimes[numFrames - 1];
        if (inputTrack instanceof MorphTrack) {
            MorphTrack oldMorphTrack = (MorphTrack)inputTrack;
            float[] oldWeights = oldMorphTrack.getWeights();
            float[] newTimes = new float[numFrames];
            int numTargets = oldMorphTrack.getNbMorphTargets();
            float[] weights = new float[numFrames * numTargets];
            for (int newIndex = 0; newIndex < numFrames; ++newIndex) {
                int oldIndex = numFrames - newIndex - 1;
                newTimes[newIndex] = lastFrameTime - oldTimes[oldIndex];
                int oldStart = oldIndex * numTargets;
                int newStart = newIndex * numTargets;
                for (int j = 0; j < numTargets; ++j) {
                    float weight;
                    weights[newStart + j] = weight = oldWeights[oldStart + j];
                }
            }
            Geometry target = oldMorphTrack.getTarget();
            result = new MorphTrack(target, newTimes, weights, numTargets);
        } else {
            TransformTrack oldTransformTrack = (TransformTrack)inputTrack;
            Vector3f[] oldTranslations = oldTransformTrack.getTranslations();
            Quaternion[] oldRotations = oldTransformTrack.getRotations();
            Vector3f[] oldScales = oldTransformTrack.getScales();
            float[] newTimes = new float[numFrames];
            Vector3f[] newTranslations = null;
            if (oldTranslations != null) {
                newTranslations = new Vector3f[numFrames];
            }
            Quaternion[] newRotations = null;
            if (oldRotations != null) {
                newRotations = new Quaternion[numFrames];
            }
            Vector3f[] newScales = null;
            if (oldScales != null) {
                newScales = new Vector3f[numFrames];
            }
            for (int newIndex = 0; newIndex < numFrames; ++newIndex) {
                int oldI = numFrames - newIndex - 1;
                newTimes[newIndex] = lastFrameTime - oldTimes[oldI];
                if (newTranslations != null) {
                    newTranslations[newIndex] = oldTranslations[oldI].clone();
                }
                if (newRotations != null) {
                    newRotations[newIndex] = oldRotations[oldI].clone();
                }
                if (newScales == null) continue;
                newScales[newIndex] = oldScales[oldI].clone();
            }
            HasLocalTransform target = oldTransformTrack.getTarget();
            result = new TransformTrack(target, newTimes, newTranslations, newRotations, newScales);
        }
        return result;
    }

    public static Track reverse(Track inputTrack) {
        assert (inputTrack instanceof BoneTrack || inputTrack instanceof SpatialTrack);
        float[] oldTimes = inputTrack.getKeyFrameTimes();
        Vector3f[] oldTranslations = MyAnimation.copyTranslations((Track)inputTrack);
        Quaternion[] oldRotations = MyAnimation.copyRotations((Track)inputTrack);
        Vector3f[] oldScales = MyAnimation.copyScales((Track)inputTrack);
        int numFrames = oldTimes.length;
        float lastFrameTime = oldTimes[numFrames - 1];
        float[] newTimes = new float[numFrames];
        Vector3f[] newTranslations = null;
        if (oldTranslations != null) {
            newTranslations = new Vector3f[numFrames];
        }
        Quaternion[] newRotations = null;
        if (oldRotations != null) {
            newRotations = new Quaternion[numFrames];
        }
        Vector3f[] newScales = null;
        if (oldScales != null) {
            newScales = new Vector3f[numFrames];
        }
        for (int newIndex = 0; newIndex < numFrames; ++newIndex) {
            int oldIndex = numFrames - newIndex - 1;
            newTimes[newIndex] = lastFrameTime - oldTimes[oldIndex];
            if (newTranslations != null) {
                newTranslations[newIndex] = oldTranslations[oldIndex].clone();
            }
            if (newRotations != null) {
                newRotations[newIndex] = oldRotations[oldIndex].clone();
            }
            if (newScales == null) continue;
            newScales[newIndex] = oldScales[oldIndex].clone();
        }
        Track result = TrackEdit.newTrack(inputTrack, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static MorphTrack setDuration(MorphTrack oldTrack, float newDuration) {
        Validate.nonNegative((float)newDuration, (String)"new duration");
        float[] oldTimes = oldTrack.getTimes();
        int oldCount = oldTimes.length;
        assert (oldCount > 0) : oldCount;
        float oldDuration = oldTimes[oldCount - 1] - oldTimes[0];
        assert (oldDuration >= 0.0f) : oldCount;
        float[] oldWeights = oldTrack.getWeights();
        int newCount = oldDuration == 0.0f && newDuration > 0.0f ? oldCount + 1 : oldCount;
        float[] newTimes = new float[newCount];
        int numTargets = oldTrack.getNbMorphTargets();
        float[] newWeights = new float[newCount * numTargets];
        for (int frameI = 0; frameI < oldCount; ++frameI) {
            float newTime;
            if (oldDuration == 0.0f) {
                assert (frameI == 0) : frameI;
                newTime = 0.0f;
            } else {
                float oldTime = oldTimes[frameI] - oldTimes[0];
                newTime = newDuration * oldTime / oldDuration;
                newTime = FastMath.clamp((float)newTime, (float)0.0f, (float)newDuration);
            }
            newTimes[frameI] = newTime;
            int startWeightI = frameI * numTargets;
            for (int j = 0; j < numTargets; ++j) {
                int weightI = startWeightI + j;
                newWeights[weightI] = oldWeights[weightI];
            }
        }
        if (oldDuration == 0.0f && newDuration > 0.0f) {
            int oldIndex = oldCount - 1;
            int newIndex = oldCount;
            newTimes[newIndex] = newDuration;
            int oldStart = oldIndex * numTargets;
            int newStart = newIndex * numTargets;
            for (int j = 0; j < numTargets; ++j) {
                float weight;
                newWeights[newStart + j] = weight = oldWeights[oldStart + j];
            }
        }
        Geometry target = oldTrack.getTarget();
        MorphTrack result = new MorphTrack(target, newTimes, newWeights, numTargets);
        return result;
    }

    public static Track setDuration(Track oldTrack, float newDuration) {
        Validate.nonNegative((float)newDuration, (String)"new duration");
        float oldDuration = oldTrack.getLength();
        float[] oldTimes = oldTrack.getKeyFrameTimes();
        int numFrames = oldTimes.length;
        assert (numFrames > 0) : numFrames;
        assert (numFrames == 1 || oldDuration > 0.0f) : numFrames;
        Track result = oldTrack.clone();
        float[] newTimes = result.getKeyFrameTimes();
        for (int frameIndex = 0; frameIndex < numFrames; ++frameIndex) {
            float newTime;
            float oldTime = oldTimes[frameIndex];
            assert (oldTime <= oldDuration) : oldTime;
            if (oldDuration == 0.0f) {
                assert (oldTime == 0.0f) : oldTime;
                newTime = 0.0f;
            } else {
                newTime = newDuration * oldTime / oldDuration;
                newTime = FastMath.clamp((float)newTime, (float)0.0f, (float)newDuration);
            }
            newTimes[frameIndex] = newTime;
        }
        return result;
    }

    public static TransformTrack setDuration(TransformTrack oldTrack, float newDuration) {
        Validate.nonNegative((float)newDuration, (String)"new duration");
        float[] oldTimes = oldTrack.getTimes();
        int oldCount = oldTimes.length;
        assert (oldCount > 0) : oldCount;
        float oldDuration = oldTimes[oldCount - 1] - oldTimes[0];
        assert (oldDuration >= 0.0f) : oldCount;
        Vector3f[] oldTranslations = oldTrack.getTranslations();
        Quaternion[] oldRotations = oldTrack.getRotations();
        Vector3f[] oldScales = oldTrack.getScales();
        int newCount = oldDuration == 0.0f && newDuration > 0.0f ? oldCount + 1 : oldCount;
        float[] newTimes = new float[newCount];
        Vector3f[] newTranslations = null;
        if (oldTranslations != null) {
            newTranslations = new Vector3f[newCount];
        }
        Quaternion[] newRotations = null;
        if (oldRotations != null) {
            newRotations = new Quaternion[newCount];
        }
        Vector3f[] newScales = null;
        if (oldScales != null) {
            newScales = new Vector3f[newCount];
        }
        for (int frameI = 0; frameI < oldCount; ++frameI) {
            float newTime;
            if (oldDuration == 0.0f) {
                assert (frameI == 0) : frameI;
                newTime = 0.0f;
            } else {
                float oldTime = oldTimes[frameI] - oldTimes[0];
                newTime = newDuration * oldTime / oldDuration;
                newTime = FastMath.clamp((float)newTime, (float)0.0f, (float)newDuration);
            }
            newTimes[frameI] = newTime;
            if (newTranslations != null) {
                newTranslations[frameI] = oldTranslations[frameI].clone();
            }
            if (newRotations != null) {
                newRotations[frameI] = oldRotations[frameI].clone();
            }
            if (newScales == null) continue;
            newScales[frameI] = oldScales[frameI].clone();
        }
        if (oldDuration == 0.0f && newDuration > 0.0f) {
            int oldIndex = oldCount - 1;
            int newIndex = oldCount;
            newTimes[newIndex] = newDuration;
            if (newTranslations != null) {
                newTranslations[newIndex] = oldTranslations[oldIndex].clone();
            }
            if (newRotations != null) {
                newRotations[newIndex] = oldRotations[oldIndex].clone();
            }
            if (newScales != null) {
                newScales[newIndex] = oldScales[oldIndex].clone();
            }
        }
        HasLocalTransform target = oldTrack.getTarget();
        TransformTrack result = new TransformTrack(target, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static Track setFrameTime(Track oldTrack, int frameIndex, float newTime) {
        float[] oldTimes = oldTrack.getKeyFrameTimes();
        int numFrames = oldTimes.length;
        Validate.inRange((int)frameIndex, (String)"frame index", (int)1, (int)(numFrames - 1));
        Validate.positive((float)newTime, (String)"new time");
        if (newTime <= oldTimes[frameIndex - 1]) {
            return null;
        }
        if (frameIndex < numFrames - 1 && newTime >= oldTimes[frameIndex + 1]) {
            return null;
        }
        Track result = oldTrack.clone();
        float[] newTimes = result.getKeyFrameTimes();
        newTimes[frameIndex] = newTime;
        return result;
    }

    public static void setKeyframes(Track track, float[] times, Vector3f[] translations, Quaternion[] rotations, Vector3f[] scales) {
        Validate.nonNull((Object)times, (String)"times");
        int numKeyframes = times.length;
        assert (numKeyframes > 0) : numKeyframes;
        assert (translations == null || translations.length == numKeyframes);
        assert (rotations == null || rotations.length == numKeyframes);
        assert (scales == null || scales.length == numKeyframes);
        if (track instanceof BoneTrack) {
            BoneTrack boneTrack = (BoneTrack)track;
            if (scales == null) {
                boneTrack.setKeyframes(times, translations, rotations);
            } else {
                boneTrack.setKeyframes(times, translations, rotations, scales);
            }
        } else if (track instanceof SpatialTrack) {
            SpatialTrack spatialTrack = (SpatialTrack)track;
            spatialTrack.setKeyframes(times, translations, rotations, scales);
        } else {
            throw new IllegalArgumentException(track.getClass().getName());
        }
    }

    public static Track simplify(Track oldTrack) {
        assert (oldTrack instanceof BoneTrack || oldTrack instanceof SpatialTrack);
        boolean keepTranslations = false;
        boolean keepRotations = false;
        boolean keepScales = false;
        Vector3f[] oldTranslations = MyAnimation.copyTranslations((Track)oldTrack);
        Quaternion[] oldRotations = MyAnimation.copyRotations((Track)oldTrack);
        Vector3f[] oldScales = MyAnimation.copyScales((Track)oldTrack);
        float[] oldTimes = oldTrack.getKeyFrameTimes();
        int numFrames = oldTimes.length;
        assert (numFrames > 0) : numFrames;
        for (int index = 0; index < numFrames; ++index) {
            Vector3f scale;
            Quaternion rotation;
            Vector3f translation;
            if (oldTranslations != null && !MyVector3f.isZero((Vector3f)(translation = oldTranslations[index]))) {
                keepTranslations = true;
            }
            if (oldRotations != null && !MyQuaternion.isRotationIdentity((Quaternion)(rotation = oldRotations[index]))) {
                keepRotations = true;
            }
            if (oldScales == null || MyVector3f.isScaleIdentity((Vector3f)(scale = oldScales[index]))) continue;
            keepScales = true;
        }
        Track result = null;
        if (keepTranslations || keepRotations || keepScales) {
            if (oldTrack instanceof BoneTrack) {
                keepTranslations = true;
                keepRotations = true;
            }
            float[] newTimes = new float[numFrames];
            Vector3f[] newTranslations = keepTranslations ? new Vector3f[numFrames] : null;
            Quaternion[] newRotations = keepRotations ? new Quaternion[numFrames] : null;
            Vector3f[] newScales = keepScales ? new Vector3f[numFrames] : null;
            for (int index = 0; index < numFrames; ++index) {
                newTimes[index] = oldTimes[index];
                if (keepTranslations) {
                    newTranslations[index] = oldTranslations[index].clone();
                }
                if (keepRotations) {
                    newRotations[index] = oldRotations[index].clone();
                }
                if (!keepScales) continue;
                newScales[index] = oldScales[index].clone();
            }
            result = TrackEdit.newTrack(oldTrack, newTimes, newTranslations, newRotations, newScales);
        }
        return result;
    }

    public static TransformTrack simplify(TransformTrack oldTrack) {
        boolean keepScales = false;
        float[] oldTimes = oldTrack.getTimes();
        int numFrames = oldTimes.length;
        assert (numFrames > 0) : numFrames;
        Vector3f[] oldScales = oldTrack.getScales();
        if (oldScales != null) {
            for (int index = 0; index < numFrames; ++index) {
                Vector3f scale = oldScales[index];
                if (MyVector3f.isScaleIdentity((Vector3f)scale)) continue;
                keepScales = true;
                break;
            }
        }
        boolean keepTranslations = false;
        Vector3f[] oldTranslations = oldTrack.getTranslations();
        if (oldTranslations != null) {
            for (int index = 0; index < numFrames; ++index) {
                Vector3f translation = oldTranslations[index];
                if (MyVector3f.isZero((Vector3f)translation)) continue;
                keepTranslations = true;
                break;
            }
        }
        boolean keepRotations = false;
        Quaternion[] oldRotations = oldTrack.getRotations();
        if (oldRotations != null) {
            for (int index = 0; index < numFrames; ++index) {
                Quaternion rotation = oldRotations[index];
                if (MyQuaternion.isRotationIdentity((Quaternion)rotation)) continue;
                keepRotations = true;
                break;
            }
        }
        float[] newTimes = new float[numFrames];
        Vector3f[] newTranslations = keepTranslations ? new Vector3f[numFrames] : null;
        Quaternion[] newRotations = keepRotations ? new Quaternion[numFrames] : null;
        Vector3f[] newScales = keepScales ? new Vector3f[numFrames] : null;
        for (int index = 0; index < numFrames; ++index) {
            newTimes[index] = oldTimes[index];
            if (keepTranslations) {
                newTranslations[index] = oldTranslations[index].clone();
            }
            if (keepRotations) {
                newRotations[index] = oldRotations[index].clone();
            }
            if (!keepScales) continue;
            newScales[index] = oldScales[index].clone();
        }
        HasLocalTransform target = oldTrack.getTarget();
        TransformTrack result = new TransformTrack(target, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static TransformTrack simplify(TransformTrack oldTrack, float tolerance) {
        Validate.nonNegative((float)tolerance, (String)"tolerance");
        boolean keepScales = false;
        float[] oldTimes = oldTrack.getTimes();
        int numFrames = oldTimes.length;
        assert (numFrames > 0) : numFrames;
        Vector3f[] oldScales = oldTrack.getScales();
        if (oldScales != null) {
            for (int index = 0; index < numFrames; ++index) {
                Vector3f scale = oldScales[index];
                if (scale.isSimilar(scaleIdentity, tolerance)) continue;
                keepScales = true;
                break;
            }
        }
        Vector3f[] oldTranslations = oldTrack.getTranslations();
        Quaternion[] oldRotations = oldTrack.getRotations();
        float[] newTimes = new float[numFrames];
        Vector3f[] newTranslations = null;
        if (oldTranslations != null) {
            newTranslations = new Vector3f[numFrames];
        }
        Quaternion[] newRotations = null;
        if (oldRotations != null) {
            newRotations = new Quaternion[numFrames];
        }
        Vector3f[] newScales = keepScales ? new Vector3f[numFrames] : null;
        for (int frameI = 0; frameI < numFrames; ++frameI) {
            newTimes[frameI] = oldTimes[frameI];
            if (newTranslations != null) {
                newTranslations[frameI] = oldTranslations[frameI].clone();
            }
            if (newRotations != null) {
                newRotations[frameI] = oldRotations[frameI].clone();
            }
            if (!keepScales) continue;
            newScales[frameI] = oldScales[frameI].clone();
        }
        HasLocalTransform target = oldTrack.getTarget();
        TransformTrack result = new TransformTrack(target, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static Track smooth(Track oldTrack, float width, SmoothVectors smoothTranslations, SmoothRotations smoothRotations, SmoothVectors smoothScales, float duration) {
        assert (oldTrack instanceof BoneTrack || oldTrack instanceof SpatialTrack);
        Validate.inRange((float)width, (String)"width", (float)0.0f, (float)duration);
        Validate.nonNegative((float)duration, (String)"duration");
        float[] oldTimes = oldTrack.getKeyFrameTimes();
        Vector3f[] oldTranslations = MyAnimation.copyTranslations((Track)oldTrack);
        Quaternion[] oldRotations = MyAnimation.copyRotations((Track)oldTrack);
        Vector3f[] oldScales = MyAnimation.copyScales((Track)oldTrack);
        int numFrames = oldTimes.length;
        assert (numFrames > 0) : numFrames;
        float[] newTimes = new float[numFrames];
        System.arraycopy(oldTimes, 0, newTimes, 0, numFrames);
        Vector3f[] newTranslations = null;
        if (oldTranslations != null) {
            newTranslations = smoothTranslations.smooth(oldTimes, duration, oldTranslations, width, null);
        }
        Quaternion[] newRotations = null;
        if (oldRotations != null) {
            newRotations = smoothRotations.smooth(oldTimes, duration, oldRotations, width, null);
        }
        Vector3f[] newScales = null;
        if (oldScales != null) {
            newScales = smoothScales.smooth(oldTimes, duration, oldScales, width, null);
        }
        Track result = TrackEdit.newTrack(oldTrack, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static TransformTrack smooth(TransformTrack oldTrack, float width, SmoothVectors smoothTranslations, SmoothRotations smoothRotations, SmoothVectors smoothScales, float duration) {
        Validate.inRange((float)width, (String)"width", (float)0.0f, (float)duration);
        Validate.nonNegative((float)duration, (String)"duration");
        float[] oldTimes = oldTrack.getTimes();
        Vector3f[] oldTranslations = oldTrack.getTranslations();
        Quaternion[] oldRotations = oldTrack.getRotations();
        Vector3f[] oldScales = oldTrack.getScales();
        int numFrames = oldTimes.length;
        assert (numFrames > 0) : numFrames;
        float[] newTimes = new float[numFrames];
        System.arraycopy(oldTimes, 0, newTimes, 0, numFrames);
        Vector3f[] newTranslations = null;
        if (oldTranslations != null) {
            newTranslations = smoothTranslations.smooth(oldTimes, duration, oldTranslations, width, null);
        }
        Quaternion[] newRotations = null;
        if (oldRotations != null) {
            newRotations = smoothRotations.smooth(oldTimes, duration, oldRotations, width, null);
        }
        Vector3f[] newScales = null;
        if (oldScales != null) {
            newScales = smoothScales.smooth(oldTimes, duration, oldScales, width, null);
        }
        HasLocalTransform target = oldTrack.getTarget();
        TransformTrack result = new TransformTrack(target, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static MorphTrack truncate(MorphTrack oldTrack, float endTime, float[] endWeights) {
        Validate.nonNegative((float)endTime, (String)"end time");
        Validate.nonNull((Object)endWeights, (String)"end weights");
        float[] oldTimes = oldTrack.getTimes();
        float[] oldWeights = oldTrack.getWeights();
        int lastFrame = MyArray.findPreviousIndex((float)endTime, (float[])oldTimes);
        int newCount = lastFrame + 1;
        if (oldTimes[lastFrame] != endTime) {
            ++newCount;
        }
        lastFrame = newCount - 1;
        float[] newTimes = new float[newCount];
        int numTargets = oldTrack.getNbMorphTargets();
        float[] newWeights = new float[newCount * numTargets];
        for (int frameI = 0; frameI < lastFrame; ++frameI) {
            newTimes[frameI] = oldTimes[frameI] - oldTimes[0];
            int startWeightI = frameI * numTargets;
            for (int j = 0; j < numTargets; ++j) {
                int weightI = startWeightI + j;
                newWeights[weightI] = oldWeights[weightI];
            }
        }
        newTimes[lastFrame] = endTime;
        int startWeightI = lastFrame * numTargets;
        for (int j = 0; j < numTargets; ++j) {
            newWeights[startWeightI + j] = endWeights[j];
        }
        Geometry target = oldTrack.getTarget();
        MorphTrack result = new MorphTrack(target, newTimes, newWeights, numTargets);
        assert ((float)result.getLength() == endTime);
        return result;
    }

    public static Track truncate(Track oldTrack, float endTime) {
        assert (oldTrack instanceof BoneTrack || oldTrack instanceof SpatialTrack);
        Validate.nonNegative((float)endTime, (String)"end time");
        float[] oldTimes = oldTrack.getKeyFrameTimes();
        Vector3f[] oldTranslations = MyAnimation.copyTranslations((Track)oldTrack);
        Quaternion[] oldRotations = MyAnimation.copyRotations((Track)oldTrack);
        Vector3f[] oldScales = MyAnimation.copyScales((Track)oldTrack);
        int newCount = 1 + MyAnimation.findPreviousKeyframeIndex((Track)oldTrack, (float)endTime);
        float[] newTimes = new float[newCount];
        Vector3f[] newTranslations = null;
        if (oldTranslations != null) {
            newTranslations = new Vector3f[newCount];
        }
        Quaternion[] newRotations = null;
        if (oldRotations != null) {
            newRotations = new Quaternion[newCount];
        }
        Vector3f[] newScales = null;
        if (oldScales != null) {
            newScales = new Vector3f[newCount];
        }
        for (int frameIndex = 0; frameIndex < newCount; ++frameIndex) {
            newTimes[frameIndex] = oldTimes[frameIndex];
            if (newTranslations != null) {
                newTranslations[frameIndex] = oldTranslations[frameIndex].clone();
            }
            if (newRotations != null) {
                newRotations[frameIndex] = oldRotations[frameIndex].clone();
            }
            if (newScales == null) continue;
            newScales[frameIndex] = oldScales[frameIndex].clone();
        }
        Track result = TrackEdit.newTrack(oldTrack, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static TransformTrack truncate(TransformTrack oldTrack, float endTime, Transform endTransform) {
        Validate.nonNegative((float)endTime, (String)"end time");
        float[] oldTimes = oldTrack.getTimes();
        Vector3f[] oldTranslations = oldTrack.getTranslations();
        Quaternion[] oldRotations = oldTrack.getRotations();
        Vector3f[] oldScales = oldTrack.getScales();
        int lastFrame = MyAnimation.findPreviousKeyframeIndex((TransformTrack)oldTrack, (float)endTime);
        int newCount = lastFrame + 1;
        if (oldTimes[lastFrame] != endTime) {
            ++newCount;
        }
        lastFrame = newCount - 1;
        float[] newTimes = new float[newCount];
        Vector3f[] newTranslations = new Vector3f[newCount];
        Quaternion[] newRotations = new Quaternion[newCount];
        Vector3f[] newScales = new Vector3f[newCount];
        HasLocalTransform target = oldTrack.getTarget();
        Transform fillData = target.getLocalTransform();
        for (int frameI = 0; frameI < lastFrame; ++frameI) {
            newTimes[frameI] = oldTimes[frameI] - oldTimes[0];
            newTranslations[frameI] = oldTranslations == null ? fillData.getTranslation().clone() : oldTranslations[frameI].clone();
            newRotations[frameI] = oldRotations == null ? fillData.getRotation().clone() : oldRotations[frameI].clone();
            newScales[frameI] = oldScales == null ? fillData.getScale().clone() : oldScales[frameI].clone();
        }
        newTimes[lastFrame] = endTime;
        newTranslations[lastFrame] = endTransform.getTranslation().clone();
        newRotations[lastFrame] = endTransform.getRotation().clone();
        newScales[lastFrame] = endTransform.getScale().clone();
        TransformTrack result = new TransformTrack(target, newTimes, newTranslations, newRotations, newScales);
        assert ((float)result.getLength() == endTime);
        return result;
    }

    public static Track wrap(Track oldTrack, float duration, float endWeight) {
        int newCount;
        assert (oldTrack instanceof BoneTrack || oldTrack instanceof SpatialTrack);
        Validate.positive((float)duration, (String)"duration");
        Validate.fraction((float)endWeight, (String)"end weight");
        float[] oldTimes = oldTrack.getKeyFrameTimes();
        Vector3f[] oldTranslations = MyAnimation.copyTranslations((Track)oldTrack);
        Quaternion[] oldRotations = MyAnimation.copyRotations((Track)oldTrack);
        Vector3f[] oldScales = MyAnimation.copyScales((Track)oldTrack);
        int oldCount = oldTimes.length;
        assert (oldCount > 0) : oldCount;
        Vector3f wrapTranslation = new Vector3f();
        Quaternion wrapRotation = new Quaternion();
        Vector3f wrapScale = new Vector3f();
        int endIndex = MyAnimation.findKeyframeIndex((Track)oldTrack, (float)duration);
        if (endIndex == -1) {
            endIndex = oldCount;
            newCount = oldCount + 1;
            if (oldTranslations != null) {
                wrapTranslation.set(oldTranslations[0]);
            }
            if (oldRotations != null) {
                wrapRotation.set(oldRotations[0]);
            }
            if (oldScales != null) {
                wrapScale.set(oldScales[0]);
            }
        } else {
            newCount = oldCount;
            if (oldTranslations != null) {
                MyVector3f.lerp((float)endWeight, (Vector3f)oldTranslations[0], (Vector3f)oldTranslations[endIndex], (Vector3f)wrapTranslation);
            }
            if (oldRotations != null) {
                MyQuaternion.slerp((float)endWeight, (Quaternion)oldRotations[0], (Quaternion)oldRotations[endIndex], (Quaternion)wrapRotation);
            }
            if (oldScales != null) {
                MyVector3f.lerp((float)endWeight, (Vector3f)oldScales[0], (Vector3f)oldScales[endIndex], (Vector3f)wrapScale);
            }
        }
        assert (endIndex == newCount - 1);
        float[] newTimes = new float[newCount];
        newTimes[0] = 0.0f;
        newTimes[endIndex] = duration;
        Vector3f[] newTranslations = null;
        if (oldTranslations != null) {
            newTranslations = new Vector3f[newCount];
            newTranslations[0] = wrapTranslation.clone();
            newTranslations[endIndex] = wrapTranslation.clone();
        }
        Quaternion[] newRotations = null;
        if (oldRotations != null) {
            newRotations = new Quaternion[newCount];
            newRotations[0] = wrapRotation.clone();
            newRotations[endIndex] = wrapRotation.clone();
        }
        Vector3f[] newScales = null;
        if (oldScales != null) {
            newScales = new Vector3f[newCount];
            newScales[0] = wrapScale.clone();
            newScales[endIndex] = wrapScale.clone();
        }
        for (int frameIndex = 1; frameIndex < endIndex; ++frameIndex) {
            newTimes[frameIndex] = oldTimes[frameIndex];
            if (newTranslations != null) {
                newTranslations[frameIndex] = oldTranslations[frameIndex].clone();
            }
            if (newRotations != null) {
                newRotations[frameIndex] = oldRotations[frameIndex].clone();
            }
            if (newScales == null) continue;
            newScales[frameIndex] = oldScales[frameIndex].clone();
        }
        Track result = TrackEdit.newTrack(oldTrack, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public static TransformTrack wrap(TransformTrack oldTrack, float duration, float endWeight) {
        int newCount;
        Validate.positive((float)duration, (String)"duration");
        Validate.fraction((float)endWeight, (String)"end weight");
        float[] oldTimes = oldTrack.getTimes();
        Vector3f[] oldTranslations = oldTrack.getTranslations();
        Quaternion[] oldRotations = oldTrack.getRotations();
        Vector3f[] oldScales = oldTrack.getScales();
        int oldCount = oldTimes.length;
        assert (oldCount > 0) : oldCount;
        HasLocalTransform target = oldTrack.getTarget();
        Transform fillData = target.getLocalTransform();
        Vector3f wrapTranslation = fillData.getTranslation().clone();
        Quaternion wrapRotation = fillData.getRotation().clone();
        Vector3f wrapScale = fillData.getScale().clone();
        int endIndex = MyArray.findPreviousIndex((float)duration, (float[])oldTimes);
        if (endIndex >= 0 && oldTimes[endIndex] != duration) {
            endIndex = -1;
        }
        if (endIndex == -1) {
            endIndex = oldCount;
            newCount = oldCount + 1;
            if (oldTranslations != null) {
                wrapTranslation.set(oldTranslations[0]);
            }
            if (oldRotations != null) {
                wrapRotation.set(oldRotations[0]);
            }
            if (oldScales != null) {
                wrapScale.set(oldScales[0]);
            }
        } else {
            newCount = oldCount;
            if (oldTranslations != null) {
                MyVector3f.lerp((float)endWeight, (Vector3f)oldTranslations[0], (Vector3f)oldTranslations[endIndex], (Vector3f)wrapTranslation);
            }
            if (oldRotations != null) {
                MyQuaternion.slerp((float)endWeight, (Quaternion)oldRotations[0], (Quaternion)oldRotations[endIndex], (Quaternion)wrapRotation);
            }
            if (oldScales != null) {
                MyVector3f.lerp((float)endWeight, (Vector3f)oldScales[0], (Vector3f)oldScales[endIndex], (Vector3f)wrapScale);
            }
        }
        assert (endIndex == newCount - 1);
        float[] newTimes = new float[newCount];
        newTimes[0] = 0.0f;
        newTimes[endIndex] = duration;
        Vector3f[] newTranslations = null;
        if (oldTranslations != null) {
            newTranslations = new Vector3f[newCount];
            newTranslations[0] = wrapTranslation.clone();
            newTranslations[endIndex] = wrapTranslation.clone();
        }
        Quaternion[] newRotations = null;
        if (oldRotations != null) {
            newRotations = new Quaternion[newCount];
            newRotations[0] = wrapRotation.clone();
            newRotations[endIndex] = wrapRotation.clone();
        }
        Vector3f[] newScales = null;
        if (oldScales != null) {
            newScales = new Vector3f[newCount];
            newScales[0] = wrapScale.clone();
            newScales[endIndex] = wrapScale.clone();
        }
        for (int frameIndex = 1; frameIndex < endIndex; ++frameIndex) {
            newTimes[frameIndex] = oldTimes[frameIndex];
            if (newTranslations != null) {
                newTranslations[frameIndex] = oldTranslations[frameIndex].clone();
            }
            if (newRotations != null) {
                newRotations[frameIndex] = oldRotations[frameIndex].clone();
            }
            if (newScales == null) continue;
            newScales[frameIndex] = oldScales[frameIndex].clone();
        }
        TransformTrack result = new TransformTrack(target, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    private static Quaternion blendRotations(float weight2, Quaternion rot1, Quaternion rot2) {
        Quaternion result = rot1 == null ? (rot2 == null ? new Quaternion() : rot2.clone()) : (rot2 == null ? rot1.clone() : MyQuaternion.slerp((float)weight2, (Quaternion)rot1, (Quaternion)rot2, null));
        return result;
    }

    private static Vector3f blendScales(float weight2, Vector3f scale1, Vector3f scale2) {
        Vector3f result = scale1 == null ? (scale2 == null ? new Vector3f(1.0f, 1.0f, 1.0f) : scale2.clone()) : (scale2 == null ? scale1.clone() : MyVector3f.lerp((float)weight2, (Vector3f)scale1, (Vector3f)scale2, null));
        return result;
    }

    private static Vector3f blendTranslations(float weight2, Vector3f tra1, Vector3f tra2) {
        Vector3f result = tra1 == null ? (tra2 == null ? new Vector3f() : tra2.clone()) : (tra2 == null ? tra1.clone() : MyVector3f.lerp((float)weight2, (Vector3f)tra1, (Vector3f)tra2, null));
        return result;
    }
}

