/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.wes;

import com.jme3.anim.TransformTrack;
import com.jme3.anim.util.HasLocalTransform;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyArray;
import jme3utilities.wes.RotationCurve;
import jme3utilities.wes.TweenRotations;
import jme3utilities.wes.TweenVectors;
import jme3utilities.wes.VectorCurve;

public class TransformTrackBuilder {
    private static final Logger logger = Logger.getLogger(TransformTrackBuilder.class.getName());
    private final float duration;
    private final HasLocalTransform target;
    private final Map<Float, Quaternion> rotationMap = new TreeMap<Float, Quaternion>();
    private final Map<Float, Vector3f> scaleMap = new TreeMap<Float, Vector3f>();
    private final Map<Float, Vector3f> translationMap = new TreeMap<Float, Vector3f>();
    private final Set<Float> timeSet = new TreeSet<Float>();
    private TweenRotations tweenRotations = TweenRotations.LoopSpline;
    private TweenVectors tweenScales = TweenVectors.LoopFdcSpline;
    private TweenVectors tweenTranslations = TweenVectors.LoopFdcSpline;

    public TransformTrackBuilder(HasLocalTransform target, float duration) {
        Validate.nonNull((Object)target, (String)"target");
        Validate.nonNegative((float)duration, (String)"duration");
        this.target = target;
        this.duration = duration;
        Transform t = target.getLocalTransform();
        this.addRotation(0.0f, t.getRotation());
        this.addScale(0.0f, t.getScale());
        this.addTranslation(0.0f, t.getTranslation());
    }

    public void addRotation(float time, Quaternion rotation) {
        Validate.inRange((float)time, (String)"time", (float)0.0f, (float)this.duration);
        Quaternion cloneRotation = rotation.clone().normalizeLocal();
        this.rotationMap.put(Float.valueOf(time), cloneRotation);
        this.timeSet.add(Float.valueOf(time));
    }

    public void addScale(float time, Vector3f scale) {
        Validate.inRange((float)time, (String)"time", (float)0.0f, (float)this.duration);
        Vector3f cloneScale = scale.clone();
        this.scaleMap.put(Float.valueOf(time), cloneScale);
        this.timeSet.add(Float.valueOf(time));
    }

    public void addTranslation(float time, Vector3f translation) {
        Validate.inRange((float)time, (String)"time", (float)0.0f, (float)this.duration);
        Vector3f cloneTranslation = translation.clone();
        this.translationMap.put(Float.valueOf(time), cloneTranslation);
        this.timeSet.add(Float.valueOf(time));
    }

    public TransformTrack build() {
        VectorCurve scaleCurve = this.toVectorCurve(this.scaleMap, this.tweenScales);
        RotationCurve rotationCurve = this.toRotationCurve(this.rotationMap, this.tweenRotations);
        VectorCurve translationCurve = this.toVectorCurve(this.translationMap, this.tweenTranslations);
        float[] times = TransformTrackBuilder.toFloatArray(this.timeSet);
        int numFrames = times.length;
        Vector3f[] translations = new Vector3f[numFrames];
        Quaternion[] rotations = new Quaternion[numFrames];
        Vector3f[] scales = new Vector3f[numFrames];
        for (int frameIndex = 0; frameIndex < numFrames; ++frameIndex) {
            float time = times[frameIndex];
            Vector3f translation = this.translationMap.get(Float.valueOf(time));
            if (translation == null) {
                translation = this.tweenTranslations.interpolate(time, translationCurve, null);
            }
            translations[frameIndex] = translation;
            Quaternion rotation = this.rotationMap.get(Float.valueOf(time));
            if (rotation == null) {
                rotation = this.tweenRotations.interpolate(time, rotationCurve, null);
            }
            rotations[frameIndex] = rotation;
            Vector3f scale = this.scaleMap.get(Float.valueOf(time));
            if (scale == null) {
                scale = this.tweenScales.interpolate(time, scaleCurve, null);
            }
            scales[frameIndex] = scale;
        }
        TransformTrack result = new TransformTrack(this.target, times, translations, rotations, scales);
        return result;
    }

    public void setTweenRotations(TweenRotations newTechnique) {
        Validate.nonNull((Object)((Object)newTechnique), (String)"new technique");
        this.tweenRotations = newTechnique;
    }

    public void setTweenScales(TweenVectors newTechnique) {
        Validate.nonNull((Object)((Object)newTechnique), (String)"new technique");
        this.tweenScales = newTechnique;
    }

    public void setTweenTranslations(TweenVectors newTechnique) {
        Validate.nonNull((Object)((Object)newTechnique), (String)"new technique");
        this.tweenTranslations = newTechnique;
    }

    private static float[] toFloatArray(Set<Float> timeSet) {
        int numFrames = timeSet.size();
        float[] result = new float[numFrames];
        int frameIndex = 0;
        Iterator<Float> iterator = timeSet.iterator();
        while (iterator.hasNext()) {
            float time;
            result[frameIndex] = time = iterator.next().floatValue();
            ++frameIndex;
        }
        assert (MyArray.isSorted((float[])result));
        return result;
    }

    private RotationCurve toRotationCurve(Map<Float, Quaternion> map, TweenRotations tween) {
        float[] times = TransformTrackBuilder.toFloatArray(map.keySet());
        int numFrames = times.length;
        Quaternion[] array = new Quaternion[numFrames];
        for (int frameIndex = 0; frameIndex < numFrames; ++frameIndex) {
            float time = times[frameIndex];
            Quaternion rotation = map.get(Float.valueOf(time));
            array[frameIndex] = rotation.clone();
        }
        RotationCurve result = tween.precompute(times, this.duration, array);
        return result;
    }

    private VectorCurve toVectorCurve(Map<Float, Vector3f> map, TweenVectors tween) {
        float[] times = TransformTrackBuilder.toFloatArray(map.keySet());
        int numFrames = times.length;
        Vector3f[] array = new Vector3f[numFrames];
        for (int frameIndex = 0; frameIndex < numFrames; ++frameIndex) {
            float time = times[frameIndex];
            Vector3f vector = map.get(Float.valueOf(time));
            array[frameIndex] = vector.clone();
        }
        VectorCurve result = tween.precompute(times, this.duration, array);
        return result;
    }
}

