/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.wes;

import com.jme3.anim.TransformTrack;
import com.jme3.anim.util.HasLocalTransform;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.SpatialTrack;
import com.jme3.animation.Track;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.MyAnimation;
import jme3utilities.Validate;
import jme3utilities.wes.TrackEdit;
import jme3utilities.wes.TweenRotations;
import jme3utilities.wes.TweenVectors;

public class TweenTransforms
implements Cloneable {
    private static final Logger logger = Logger.getLogger(TweenTransforms.class.getName());
    private TweenRotations tweenRotations = TweenRotations.Nlerp;
    private TweenVectors tweenScales = TweenVectors.Lerp;
    private TweenVectors tweenTranslations = TweenVectors.Lerp;

    public TweenRotations getTweenRotations() {
        return this.tweenRotations;
    }

    public TweenVectors getTweenScales() {
        return this.tweenScales;
    }

    public TweenVectors getTweenTranslations() {
        return this.tweenTranslations;
    }

    public Transform interpolate(float time, Track track, float duration, Transform fallback, Transform storeResult) {
        Validate.inRange((float)time, (String)"time", (float)0.0f, (float)duration);
        assert (track instanceof BoneTrack || track instanceof SpatialTrack);
        float[] times = track.getKeyFrameTimes();
        Vector3f[] translations = MyAnimation.copyTranslations((Track)track);
        Quaternion[] rotations = MyAnimation.copyRotations((Track)track);
        Vector3f[] scales = MyAnimation.copyScales((Track)track);
        Transform result = this.interpolate(time, times, duration, translations, rotations, scales, fallback, storeResult);
        return result;
    }

    public Transform interpolate(float time, TransformTrack track, float duration, Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        float[] times = track.getTimes();
        int lastFrame = times.length - 1;
        if (lastFrame == 0) {
            result.setTranslation(track.getTranslations()[0]);
            result.setRotation(track.getRotations()[0]);
            result.setScale(track.getScales()[0]);
        } else {
            Vector3f[] translations = track.getTranslations();
            Quaternion[] rotations = track.getRotations();
            Vector3f[] scales = track.getScales();
            HasLocalTransform target = track.getTarget();
            Transform fallback = target.getLocalTransform();
            this.interpolate(time, times, duration, translations, rotations, scales, fallback, result);
        }
        return result;
    }

    public Transform interpolate(float time, float[] times, float duration, Vector3f[] translations, Quaternion[] rotations, Vector3f[] scales, Transform fallback, Transform storeResult) {
        Transform result;
        Validate.inRange((float)time, (String)"time", (float)0.0f, (float)duration);
        Validate.nonNull((Object)times, (String)"times");
        Transform transform = result = storeResult == null ? new Transform() : storeResult;
        if (fallback == null) {
            result.loadIdentity();
        } else {
            result.set(fallback);
        }
        if (translations != null) {
            this.tweenTranslations.interpolate(time, times, duration, translations, result.getTranslation());
        }
        if (rotations != null) {
            this.tweenRotations.interpolate(time, times, duration, rotations, result.getRotation());
        }
        if (scales != null) {
            this.tweenScales.interpolate(time, times, duration, scales, result.getScale());
        }
        return result;
    }

    public Track resample(Track oldTrack, float[] newTimes, float duration) {
        assert (oldTrack instanceof BoneTrack || oldTrack instanceof SpatialTrack);
        Validate.nonNegative((float)duration, (String)"duration");
        int numSamples = newTimes.length;
        Vector3f[] oldTranslations = MyAnimation.copyTranslations((Track)oldTrack);
        Quaternion[] oldRotations = MyAnimation.copyRotations((Track)oldTrack);
        Vector3f[] oldScales = MyAnimation.copyScales((Track)oldTrack);
        Vector3f[] newTranslations = null;
        if (oldTranslations != null) {
            newTranslations = new Vector3f[numSamples];
        }
        Quaternion[] newRotations = null;
        if (oldRotations != null) {
            newRotations = new Quaternion[numSamples];
        }
        Vector3f[] newScales = null;
        if (oldScales != null) {
            newScales = new Vector3f[numSamples];
        }
        for (int frameIndex = 0; frameIndex < numSamples; ++frameIndex) {
            float time = newTimes[frameIndex];
            Transform transform = this.transform(oldTrack, time, duration, null, null);
            if (newTranslations != null) {
                newTranslations[frameIndex] = transform.getTranslation();
            }
            if (newRotations != null) {
                newRotations[frameIndex] = transform.getRotation();
            }
            if (newScales == null) continue;
            newScales[frameIndex] = transform.getScale();
        }
        Track result = TrackEdit.newTrack(oldTrack, newTimes, newTranslations, newRotations, newScales);
        return result;
    }

    public Track resampleAtRate(Track oldTrack, float sampleRate, float duration) {
        assert (oldTrack instanceof BoneTrack || oldTrack instanceof SpatialTrack);
        Validate.positive((float)sampleRate, (String)"sample rate");
        Validate.nonNegative((float)duration, (String)"duration");
        int numSamples = 1 + (int)Math.floor(duration * sampleRate);
        float[] newTimes = new float[numSamples];
        for (int frameIndex = 0; frameIndex < numSamples; ++frameIndex) {
            float time = (float)frameIndex / sampleRate;
            if (time > duration) {
                time = duration;
            }
            newTimes[frameIndex] = time;
        }
        Track result = this.resample(oldTrack, newTimes, duration);
        return result;
    }

    public Track resampleToNumber(Track oldTrack, int numSamples, float duration) {
        assert (oldTrack instanceof BoneTrack || oldTrack instanceof SpatialTrack);
        Validate.inRange((int)numSamples, (String)"number of samples", (int)2, (int)Integer.MAX_VALUE);
        Validate.positive((float)duration, (String)"duration");
        float[] newTimes = new float[numSamples];
        for (int frameIndex = 0; frameIndex < numSamples; ++frameIndex) {
            float time = frameIndex == numSamples - 1 ? duration : (float)frameIndex * duration / (float)(numSamples - 1);
            newTimes[frameIndex] = time;
        }
        Track result = this.resample(oldTrack, newTimes, duration);
        return result;
    }

    public void setTweenRotations(TweenRotations newTechnique) {
        Validate.nonNull((Object)((Object)newTechnique), (String)"new technique");
        this.tweenRotations = newTechnique;
    }

    public void setTweenScales(TweenVectors newTechnique) {
        Validate.nonNull((Object)((Object)newTechnique), (String)"new technique");
        this.tweenScales = newTechnique;
    }

    public void setTweenTranslations(TweenVectors newTechnique) {
        Validate.nonNull((Object)((Object)newTechnique), (String)"new technique");
        this.tweenTranslations = newTechnique;
    }

    public Transform transform(Track track, float time, float duration, Transform fallback, Transform storeResult) {
        assert (track instanceof BoneTrack || track instanceof SpatialTrack);
        Transform result = storeResult == null ? new Transform() : storeResult;
        float[] times = track.getKeyFrameTimes();
        int lastFrame = times.length - 1;
        assert (lastFrame >= 0) : lastFrame;
        Vector3f[] translations = MyAnimation.copyTranslations((Track)track);
        Quaternion[] rotations = MyAnimation.copyRotations((Track)track);
        Vector3f[] scales = MyAnimation.copyScales((Track)track);
        if (time <= 0.0f || lastFrame == 0) {
            result.loadIdentity();
            if (translations != null) {
                result.setTranslation(translations[0]);
            }
            if (rotations != null) {
                result.setRotation(rotations[0]);
            }
            if (scales != null) {
                result.setScale(scales[0]);
            }
        } else {
            this.interpolate(time, times, duration, translations, rotations, scales, fallback, result);
        }
        return result;
    }

    public TweenTransforms clone() throws CloneNotSupportedException {
        TweenTransforms clone = (TweenTransforms)super.clone();
        return clone;
    }
}

