/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.wes;

import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class VectorCurve {
    private static final Logger logger = Logger.getLogger(VectorCurve.class.getName());
    private final float cycleTime;
    private float[] dt01s;
    private float[] dt12s;
    private float[] dt23s;
    private float[] intervalDurations;
    private final float[] times;
    private Vector3f[] aux1s;
    private Vector3f[] aux2s;
    private Vector3f[] endValues;
    private final Vector3f[] startValues;

    public VectorCurve(float[] times, float cycleTime, Vector3f[] values) {
        Validate.nonNull((Object)times, (String)"times");
        Validate.nonNegative((float)cycleTime, (String)"cycle time");
        Validate.nonNull((Object)values, (String)"values");
        assert (times.length == values.length);
        this.times = times;
        this.cycleTime = cycleTime;
        this.startValues = values;
        this.endValues = null;
        this.intervalDurations = null;
        this.aux1s = null;
        this.aux2s = null;
        this.dt01s = null;
        this.dt12s = null;
        this.dt23s = null;
    }

    Vector3f getAux1(int index) {
        Vector3f aux1 = this.aux1s[index];
        assert (aux1 != null);
        return aux1;
    }

    Vector3f getAux2(int index) {
        Vector3f aux2 = this.aux2s[index];
        assert (aux2 != null);
        return aux2;
    }

    float getCycleTime() {
        return this.cycleTime;
    }

    float getDt01(int index) {
        float value = this.dt01s[index];
        return value;
    }

    float getDt12(int index) {
        float value = this.dt12s[index];
        return value;
    }

    float getDt23(int index) {
        float value = this.dt23s[index];
        return value;
    }

    Vector3f getEndValue(int index) {
        Vector3f value = this.endValues[index];
        assert (value != null);
        return value;
    }

    float getIntervalDuration(int index) {
        float intervalDuration = this.intervalDurations[index];
        assert (intervalDuration > 0.0f) : intervalDuration;
        return intervalDuration;
    }

    int getLastIndex() {
        int lastIndex = this.aux1s.length - 1;
        assert (lastIndex >= 0) : lastIndex;
        return lastIndex;
    }

    Vector3f[] getSamples() {
        assert (this.startValues != null);
        return this.startValues;
    }

    Vector3f getStartValue(int index) {
        Vector3f value = this.startValues[index];
        assert (value != null);
        return value;
    }

    float[] getTimes() {
        assert (this.times != null);
        return this.times;
    }

    void setAuxPoints(int index, Vector3f auxPoint1, Vector3f auxPoint2) {
        Validate.nonNull((Object)auxPoint1, (String)"aux point 1");
        Validate.nonNull((Object)auxPoint2, (String)"aux point 2");
        this.aux1s[index] = auxPoint1;
        this.aux2s[index] = auxPoint2;
    }

    void setDts(int index, float dt01, float dt12, float dt23) {
        this.dt01s[index] = dt01;
        this.dt12s[index] = dt12;
        this.dt23s[index] = dt23;
    }

    void setLastIndex(int newLastIndex, boolean allocateDts) {
        Validate.nonNegative((int)newLastIndex, (String)"new last index");
        int numSamples = newLastIndex + 1;
        this.aux1s = new Vector3f[numSamples];
        this.aux2s = new Vector3f[numSamples];
        this.endValues = new Vector3f[numSamples];
        this.intervalDurations = new float[numSamples];
        if (allocateDts) {
            this.dt01s = new float[numSamples];
            this.dt12s = new float[numSamples];
            this.dt23s = new float[numSamples];
        }
    }

    void setParameters(int index, Vector3f endValue, float intervalDuration) {
        Validate.nonNull((Object)endValue, (String)"end value");
        Validate.positive((float)intervalDuration, (String)"interval duration");
        this.endValues[index] = endValue;
        this.intervalDurations[index] = intervalDuration;
    }
}

