/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.vorbis.Mapping0;
import de.jarnbjo.vorbis.SetupHeader;
import de.jarnbjo.vorbis.VorbisFormatException;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.IOException;

abstract class Mapping {
    Mapping() {
    }

    protected static Mapping createInstance(VorbisStream vorbis, BitInputStream source, SetupHeader header) throws IOException {
        int type = source.getInt(16);
        switch (type) {
            case 0: {
                return new Mapping0(vorbis, source, header);
            }
        }
        throw new VorbisFormatException("Mapping type " + type + " is not supported.");
    }

    protected abstract int getType();

    protected abstract int[] getAngles();

    protected abstract int[] getMagnitudes();

    protected abstract int[] getMux();

    protected abstract int[] getSubmapFloors();

    protected abstract int[] getSubmapResidues();

    protected abstract int getCouplingSteps();

    protected abstract int getSubmaps();
}

