/*
 * Decompiled with CFR 0.152.
 */
package com.atr.jme.font.shape;

import com.atr.jme.font.TrueTypeMesh;
import com.atr.jme.font.sfntly.AnchorTable;
import com.google.typography.font.sfntly.table.truetype.CompositeGlyph;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.SimpleGlyph;
import com.jme3.math.FastMath;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import edu.berkeley.jmescher.BPoint;
import edu.berkeley.jmescher.HalfEdge;
import edu.berkeley.jmescher.Point;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MeshGlyf
extends Mesh {
    public static final float EPSILON = 1.0E-7f;
    private float maxX = Float.MIN_VALUE;
    private float minX = Float.MAX_VALUE;
    private float maxY = Float.MIN_VALUE;
    private float minY = Float.MAX_VALUE;

    public MeshGlyf(TrueTypeMesh ttm, AnchorTable ankr, Glyph glyf) {
        this.processContours(ttm, ankr, glyf);
    }

    public float getMaxX() {
        return this.maxX;
    }

    public float getMinX() {
        return this.minX;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public float getMinY() {
        return this.minY;
    }

    private void processContours(TrueTypeMesh ttm, AnchorTable ankr, Glyph glyf) {
        LinkedList<Tri> innerTriangles = new LinkedList<Tri>();
        LinkedList<Tri> bTriangles = new LinkedList<Tri>();
        if (glyf.glyphType() == Glyph.GlyphType.Composite) {
            byte[] transform;
            CompositeGlyph g = (CompositeGlyph)glyf;
            int flags = g.flags(0);
            float[] matrix = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
            if ((flags & 8) == 8) {
                matrix[0] = this.f2dot14(g.transformation(0));
                matrix[3] = matrix[0];
            } else if ((flags & 0x40) == 64) {
                transform = g.transformation(0);
                matrix[0] = this.f2dot14(new byte[]{transform[0], transform[1]});
                matrix[3] = this.f2dot14(new byte[]{transform[2], transform[3]});
            } else if ((flags & 0x80) == 128) {
                transform = g.transformation(0);
                matrix[0] = this.f2dot14(new byte[]{transform[0], transform[1]});
                matrix[1] = this.f2dot14(new byte[]{transform[2], transform[3]});
                matrix[2] = this.f2dot14(new byte[]{transform[4], transform[5]});
                matrix[3] = this.f2dot14(new byte[]{transform[6], transform[7]});
            }
            if ((flags & 2) == 2) {
                matrix[4] = (short)g.argument1(0);
                matrix[5] = (short)g.argument2(0);
            }
            this.triangulate(ttm, (SimpleGlyph)ttm.getGlyph(g.glyphIndex(0)), innerTriangles, bTriangles, matrix);
            float[] lastMatrix = new float[]{matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]};
            for (int i = 1; i < g.numGlyphs(); ++i) {
                byte[] transform2;
                matrix[0] = 1.0f;
                matrix[1] = 0.0f;
                matrix[2] = 0.0f;
                matrix[3] = 1.0f;
                matrix[4] = 0.0f;
                matrix[5] = 0.0f;
                SimpleGlyph glyph = (SimpleGlyph)ttm.getGlyph(g.glyphIndex(i));
                flags = g.flags(i);
                if ((flags & 8) == 8) {
                    matrix[0] = this.f2dot14(g.transformation(i));
                    matrix[3] = matrix[0];
                } else if ((flags & 0x40) == 64) {
                    transform2 = g.transformation(i);
                    matrix[0] = this.f2dot14(new byte[]{transform2[0], transform2[1]});
                    matrix[3] = this.f2dot14(new byte[]{transform2[2], transform2[3]});
                } else if ((flags & 0x80) == 128) {
                    transform2 = g.transformation(i);
                    matrix[0] = this.f2dot14(new byte[]{transform2[0], transform2[1]});
                    matrix[1] = this.f2dot14(new byte[]{transform2[2], transform2[3]});
                    matrix[2] = this.f2dot14(new byte[]{transform2[4], transform2[5]});
                    matrix[3] = this.f2dot14(new byte[]{transform2[6], transform2[7]});
                }
                if ((flags & 2) == 2) {
                    matrix[4] = (short)g.argument1(i);
                    matrix[5] = (short)g.argument2(i);
                } else if ((flags & 1) == 1) {
                    int[] p1 = ankr.getAnchor(g.glyphIndex(i - 1), g.argument1(i));
                    int[] p2 = ankr.getAnchor(g.glyphIndex(i), g.argument2(i));
                    float x = (float)p1[0] * lastMatrix[0] + (float)p1[1] * lastMatrix[2] + lastMatrix[4];
                    float y = (float)p1[0] * lastMatrix[1] + (float)p1[1] * lastMatrix[3] + lastMatrix[5];
                    float x2 = (float)p2[0] * matrix[0] + (float)p2[1] * matrix[2];
                    float y2 = (float)p2[0] * matrix[1] + (float)p2[1] * matrix[3];
                    matrix[4] = x - x2;
                    matrix[5] = y - y2;
                }
                this.triangulate(ttm, glyph, innerTriangles, bTriangles, matrix);
                lastMatrix[0] = matrix[0];
                lastMatrix[1] = matrix[1];
                lastMatrix[2] = matrix[2];
                lastMatrix[3] = matrix[3];
                lastMatrix[4] = matrix[4];
                lastMatrix[5] = matrix[5];
            }
        } else {
            this.triangulate(ttm, (SimpleGlyph)glyf, innerTriangles, bTriangles, null);
        }
        this.createMesh(innerTriangles, bTriangles);
    }

    private float f2dot14(byte[] value) {
        return (float)ByteBuffer.wrap(value).getShort() * (float)Math.pow(2.0, -14.0);
    }

    private void triangulate(TrueTypeMesh ttm, SimpleGlyph glyf, List<Tri> innerTriangles, List<Tri> bTriangles, float[] matrix) {
        Tri t;
        int contour;
        edu.berkeley.jmescher.Mesh mesh = new edu.berkeley.jmescher.Mesh(1.0E-7f);
        Point[] boundary = new BPoint[]{new BPoint(ttm.getMinCharX(), ttm.getMinCharY()), new BPoint(ttm.getMinCharX() + ttm.getMaxCharY() / ttm.getItalicRef() * ttm.getItalicAngle(), ttm.getMaxCharY()), new BPoint(ttm.getMaxCharX() + ttm.getMaxCharY() / ttm.getItalicRef() * ttm.getItalicAngle(), ttm.getMaxCharY()), new BPoint(ttm.getMaxCharX(), ttm.getMinCharY())};
        edu.berkeley.jmescher.Mesh.linkBoundary((BPoint[])boundary);
        mesh.init(boundary);
        LinkedList<Seg> segs = new LinkedList<Seg>();
        LinkedList<Tri> bTris = new LinkedList<Tri>();
        int numContours = glyf.numberOfContours();
        if (matrix == null) {
            for (contour = 0; contour < numContours; ++contour) {
                this.getSimpleContours(glyf, contour, ttm, segs, bTris, mesh);
            }
        } else {
            for (contour = 0; contour < numContours; ++contour) {
                this.getSimpleContours(glyf, matrix, contour, ttm, segs, bTris, mesh);
            }
        }
        LinkedList<Tri> tmpTris = new LinkedList<Tri>();
        Iterator<Tri> it = bTris.listIterator();
        block8: while (it.hasNext()) {
            Tri newTri;
            Seg newBC;
            Point c2;
            Point b2;
            Seg newAB;
            Point b;
            float my;
            float mx;
            Tri t2 = (Tri)it.next();
            if (tmpTris.contains(t2)) {
                it.remove();
                tmpTris.remove(t2);
                continue;
            }
            for (Seg s : segs) {
                if (s.p1 == t2.ac.p1 || s.p1 == t2.ac.p2 || s.p2 == t2.ac.p1 || s.p2 == t2.ac.p2 || !mesh.intersect(t2.ac.p1, t2.ac.p2, s.p1, s.p2)) continue;
                it.remove();
                mx = t2.ab.p1.x + (t2.ab.p2.x - t2.ab.p1.x) / 2.0f;
                my = t2.ab.p1.y + (t2.ab.p2.y - t2.ab.p1.y) / 2.0f;
                if (t2.ab.p2.users == 1) {
                    mesh.removeInteriorPoint(t2.ab.p2);
                } else {
                    --t2.ab.p2.users;
                }
                b = mesh.addInteriorPoint(new Point(mx, my));
                newAB = new Seg(t2.ab.p1, b);
                mx = t2.bc.p1.x + (t2.bc.p2.x - t2.bc.p1.x) / 2.0f;
                my = t2.bc.p1.y + (t2.bc.p2.y - t2.bc.p1.y) / 2.0f;
                b2 = mesh.addInteriorPoint(new Point(mx, my));
                mx = b.x + (b2.x - b.x) / 2.0f;
                my = b.y + (b2.y - b.y) / 2.0f;
                c2 = mesh.addInteriorPoint(new Point(mx, my));
                newBC = new Seg(b, c2);
                newTri = new Tri(newAB, newBC, new Seg(t2.ab.p1, c2));
                it.add(newTri);
                newTri = new Tri(new Seg(c2, b2), new Seg(b2, t2.ac.p2), new Seg(c2, t2.ac.p2));
                it.add(newTri);
                continue block8;
            }
            for (Tri tri : bTris) {
                if (tmpTris.contains(tri) || tri.ac.p1 == t2.ac.p1 || tri.ac.p1 == t2.ac.p2 || tri.ac.p2 == t2.ac.p1 || tri.ac.p2 == t2.ac.p2 || !mesh.intersect(t2.ac.p1, t2.ac.p2, tri.ab.p1, tri.ab.p2)) continue;
                it.remove();
                mx = t2.ab.p1.x + (t2.ab.p2.x - t2.ab.p1.x) / 2.0f;
                my = t2.ab.p1.y + (t2.ab.p2.y - t2.ab.p1.y) / 2.0f;
                if (tri.ab.p2.users == 1) {
                    mesh.removeInteriorPoint(t2.ab.p2);
                } else {
                    --t2.ab.p2.users;
                }
                b = mesh.addInteriorPoint(new Point(mx, my));
                newAB = new Seg(t2.ab.p1, b);
                mx = t2.bc.p1.x + (t2.bc.p2.x - t2.bc.p1.x) / 2.0f;
                my = t2.bc.p1.y + (t2.bc.p2.y - t2.bc.p1.y) / 2.0f;
                b2 = mesh.addInteriorPoint(new Point(mx, my));
                mx = b.x + (b2.x - b.x) / 2.0f;
                my = b.y + (b2.y - b.y) / 2.0f;
                c2 = mesh.addInteriorPoint(new Point(mx, my));
                newBC = new Seg(b, c2);
                newTri = new Tri(newAB, newBC, new Seg(t2.ab.p1, c2));
                it.add(newTri);
                newTri = new Tri(new Seg(c2, b2), new Seg(b2, t2.ac.p2), new Seg(c2, t2.ac.p2));
                it.add(newTri);
                tmpTris.add(tri);
                mx = tri.ab.p1.x + (tri.ab.p2.x - tri.ab.p1.x) / 2.0f;
                my = tri.ab.p1.y + (tri.ab.p2.y - tri.ab.p1.y) / 2.0f;
                if (tri.ab.p2.users == 1) {
                    mesh.removeInteriorPoint(tri.ab.p2);
                } else {
                    --tri.ab.p2.users;
                }
                b = mesh.addInteriorPoint(new Point(mx, my));
                newAB = new Seg(tri.ab.p1, b);
                mx = tri.bc.p1.x + (tri.bc.p2.x - tri.bc.p1.x) / 2.0f;
                my = tri.bc.p1.y + (tri.bc.p2.y - tri.bc.p1.y) / 2.0f;
                b2 = mesh.addInteriorPoint(new Point(mx, my));
                mx = b.x + (b2.x - b.x) / 2.0f;
                my = b.y + (b2.y - b.y) / 2.0f;
                c2 = mesh.addInteriorPoint(new Point(mx, my));
                newBC = new Seg(b, c2);
                newTri = new Tri(newAB, newBC, new Seg(tri.ab.p1, c2));
                it.add(newTri);
                newTri = new Tri(new Seg(c2, b2), new Seg(b2, tri.ac.p2), new Seg(c2, tri.ac.p2));
                it.add(newTri);
                continue block8;
            }
        }
        bTris.removeAll(tmpTris);
        tmpTris.clear();
        it = segs.iterator();
        while (it.hasNext()) {
            Seg s = (Seg)it.next();
            if (!s.p1.isType(2) && !s.p2.isType(2)) {
                try {
                    s.he = mesh.addConstraint(s.p1, s.p2);
                }
                catch (Exception exception) {
                    it.remove();
                }
                continue;
            }
            it.remove();
        }
        it = bTris.iterator();
        while (it.hasNext()) {
            Tri t2 = (Tri)it.next();
            try {
                if (t2.ac.onRight(t2.bc.p1)) {
                    t2.ab.he = mesh.addConstraint(t2.ab.p1, t2.ab.p2);
                    t2.ab.he.flag(3);
                    t2.ab.he.sibling.flag(3);
                    t2.bc.he = mesh.addConstraint(t2.bc.p1, t2.bc.p2);
                    t2.bc.he.flag(3);
                    t2.bc.he.sibling.flag(3);
                    mesh.addConstraint(t2.ac.p1, t2.ac.p2);
                    segs.add(t2.ab);
                    segs.add(t2.bc);
                    continue;
                }
                mesh.addConstraint(t2.ab.p1, t2.ab.p2);
                mesh.addConstraint(t2.bc.p1, t2.bc.p2);
                t2.ac.he = mesh.addConstraint(t2.ac.p1, t2.ac.p2);
                segs.add(t2.ac);
                t2.ac.he.flag(3);
                t2.ac.he.sibling.flag(3);
            }
            catch (Exception exception) {
                try {
                    t2.ac.he = mesh.addConstraint(t2.ac.p1, t2.ac.p2);
                    segs.add(t2.ac);
                }
                catch (Exception ex) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Error inserting bezier constraint.", ex);
                }
                it.remove();
            }
        }
        mesh = null;
        LinkedList<Tri> innerTris = new LinkedList<Tri>();
        for (Seg seg : segs) {
            seg.he.flag(4);
            seg.he.sibling.flag(4);
            if (seg.onRight(seg.he.next.next.origin)) {
                if (seg.he.next.isFlagged(4) || seg.he.next.next.isFlagged(4)) continue;
                t = new Tri(new Seg(seg.he.origin.clone(), seg.he.next.origin.clone()), new Seg(seg.he.next.origin.clone(), seg.he.next.next.origin.clone()), new Seg(seg.he.origin.clone(), seg.he.next.next.origin.clone()));
                t.ab.he = seg.he;
                if (!seg.he.isFlagged(3)) {
                    t.ab.p1.setUV(0.0f, 0.0f);
                    t.ab.p2.setUV(0.0f, 0.0f);
                    t.ac.p2.setUV(1.0f, 1.0f);
                } else {
                    t.ab.p1.setUV(1.0f, 1.0f);
                    t.ab.p2.setUV(1.0f, 1.0f);
                    t.ac.p2.setUV(1.0f, 1.0f);
                }
                innerTris.add(t);
                continue;
            }
            if (seg.he.sibling.next.isFlagged(4) || seg.he.sibling.next.next.isFlagged(4)) continue;
            t = new Tri(new Seg(seg.he.sibling.origin.clone(), seg.he.sibling.next.origin.clone()), new Seg(seg.he.sibling.next.origin.clone(), seg.he.sibling.next.next.origin.clone()), new Seg(seg.he.sibling.origin.clone(), seg.he.sibling.next.next.origin.clone()));
            t.ab.he = seg.he.sibling;
            if (!seg.he.isFlagged(3)) {
                t.ab.p1.setUV(0.0f, 0.0f);
                t.ab.p2.setUV(0.0f, 0.0f);
                t.ac.p2.setUV(1.0f, 1.0f);
            } else {
                t.ab.p1.setUV(1.0f, 1.0f);
                t.ab.p2.setUV(1.0f, 1.0f);
                t.ac.p2.setUV(1.0f, 1.0f);
            }
            innerTris.add(t);
        }
        segs.clear();
        LinkedList<Tri> newTris = new LinkedList<Tri>();
        for (Tri t3 : innerTris) {
            this.innerTriSearch(newTris, t3.ab.he.next);
            this.innerTriSearch(newTris, t3.ab.he.next.next);
        }
        ListIterator<Tri> listIterator = innerTris.listIterator();
        while (listIterator.hasNext()) {
            Tri newTri;
            Seg ac;
            Seg bc;
            Seg ab;
            Point p;
            t = (Tri)listIterator.next();
            if (t.ab.he.next.isFlagged(4)) {
                if (t.ab.he.next.isFlagged(3)) {
                    if (t.ab.he.isFlagged(3)) continue;
                    t.ab.p1.setUV(0.0f, 0.0f);
                    t.ab.p2.setUV(0.0f, 0.0f);
                    t.ac.p2.setUV(1.0f, 1.0f);
                    continue;
                }
                if (t.ab.he.isFlagged(3)) {
                    if (t.ab.he.next.isFlagged(3)) continue;
                    t.ab.p2.setUV(0.0f, 0.0f);
                    t.ac.p2.setUV(0.0f, 0.0f);
                    t.ac.p1.setUV(1.0f, 1.0f);
                    continue;
                }
                listIterator.remove();
                p = new Point(t.ab.he.origin.x + (t.ab.he.next.next.origin.x - t.ab.he.origin.x) / 2.0f, t.ab.he.origin.y + (t.ab.he.next.next.origin.y - t.ab.he.origin.y) / 2.0f);
                ab = new Seg(t.ab.he.origin, t.ab.he.next.origin);
                bc = new Seg(t.ab.he.next.origin, p);
                ac = new Seg(t.ab.he.origin, p);
                newTri = new Tri(ab, bc, ac);
                newTri.ab.p1.setUV(0.0f, 0.0f);
                newTri.ab.p2.setUV(0.0f, 0.0f);
                newTri.ac.p2.setUV(1.0f, 1.0f);
                listIterator.add(newTri);
                ab = new Seg(t.ab.he.next.origin.clone(), t.ab.he.next.next.origin);
                bc = new Seg(t.ab.he.next.next.origin, p.clone());
                ac = new Seg(t.ab.he.next.origin.clone(), p.clone());
                newTri = new Tri(ab, bc, ac);
                newTri.ab.p1.setUV(0.0f, 0.0f);
                newTri.ab.p2.setUV(0.0f, 0.0f);
                newTri.ac.p2.setUV(1.0f, 1.0f);
                listIterator.add(newTri);
                continue;
            }
            if (!t.ab.he.next.next.isFlagged(4)) continue;
            if (t.ab.he.next.next.isFlagged(3)) {
                if (t.ab.he.isFlagged(3)) continue;
                t.ab.p1.setUV(0.0f, 0.0f);
                t.ab.p2.setUV(0.0f, 0.0f);
                t.ac.p2.setUV(1.0f, 1.0f);
                continue;
            }
            if (t.ab.he.isFlagged(3)) {
                if (t.ab.he.next.next.isFlagged(3)) continue;
                t.ac.p1.setUV(0.0f, 0.0f);
                t.ac.p2.setUV(0.0f, 0.0f);
                t.ab.p2.setUV(1.0f, 1.0f);
                continue;
            }
            listIterator.remove();
            p = new Point(t.ab.he.next.origin.x + (t.ab.he.next.next.origin.x - t.ab.he.next.origin.x) / 2.0f, t.ab.he.next.origin.y + (t.ab.he.next.next.origin.y - t.ab.he.next.origin.y) / 2.0f);
            ab = new Seg(t.ab.he.next.next.origin, t.ab.he.origin);
            bc = new Seg(t.ab.he.origin, p);
            ac = new Seg(t.ab.he.next.next.origin, p);
            newTri = new Tri(ab, bc, ac);
            newTri.ab.p1.setUV(0.0f, 0.0f);
            newTri.ab.p2.setUV(0.0f, 0.0f);
            newTri.ac.p2.setUV(1.0f, 1.0f);
            listIterator.add(newTri);
            ab = new Seg(t.ab.he.origin.clone(), t.ab.he.next.origin.clone());
            bc = new Seg(t.ab.he.next.origin.clone(), p.clone());
            ac = new Seg(t.ab.he.origin.clone(), p.clone());
            newTri = new Tri(ab, bc, ac);
            newTri.ab.p1.setUV(0.0f, 0.0f);
            newTri.ab.p2.setUV(0.0f, 0.0f);
            newTri.ac.p2.setUV(1.0f, 1.0f);
            listIterator.add(newTri);
        }
        innerTris.addAll(newTris);
        newTris.clear();
        if (this.maxX == Float.MIN_VALUE) {
            this.maxX = 0.0f;
            this.minX = 0.0f;
        }
        if (this.maxY == Float.MIN_VALUE) {
            this.maxY = 0.0f;
            this.minY = 0.0f;
        }
        innerTriangles.addAll(innerTris);
        bTriangles.addAll(bTris);
    }

    private void innerTriSearch(List<Tri> newTris, HalfEdge he) {
        if (he.sibling == null) {
            return;
        }
        if (!(he.sibling.isFlagged(2) || he.sibling.next.isFlagged(2) || he.sibling.next.next.isFlagged(2) || he.sibling.isFlagged(4) || he.sibling.next.isFlagged(4) || he.sibling.next.next.isFlagged(4))) {
            Tri tri = new Tri(new Seg(he.sibling.origin.clone(), he.sibling.next.origin.clone()), new Seg(he.sibling.next.origin.clone(), he.sibling.next.next.origin.clone()), new Seg(he.sibling.origin.clone(), he.sibling.next.next.origin.clone()));
            he.sibling.flag(2);
            tri.ab.p1.setUV(1.0f, 1.0f);
            tri.ab.p2.setUV(1.0f, 1.0f);
            tri.ac.p2.setUV(1.0f, 1.0f);
            newTris.add(tri);
        }
    }

    private edu.berkeley.jmescher.Mesh getSimpleContours(SimpleGlyph glyf, int contour, TrueTypeMesh ttm, List<Seg> segments, List<Tri> triangles, edu.berkeley.jmescher.Mesh mesh) {
        Seg bc;
        Point a = new Point();
        int numPoints = glyf.numberOfPoints(contour);
        float last1X = (float)glyf.xCoordinate(contour, 0) * ttm.getPointScale();
        float last1Y = (float)glyf.yCoordinate(contour, 0) * ttm.getPointScale();
        float firstOnCurveX = last1X += last1Y / ttm.getItalicRef() * ttm.getItalicAngle();
        float firstOnCurveY = last1Y;
        boolean last1OnCurve = glyf.onCurve(contour, 0);
        if (last1OnCurve) {
            a = mesh.addInteriorPoint(new Point(last1X, last1Y));
        }
        if (last1X > this.maxX) {
            this.maxX = last1X;
        }
        if (last1X < this.minX) {
            this.minX = last1X;
        }
        if (last1Y > this.maxY) {
            this.maxY = last1Y;
        }
        if (last1Y < this.minY) {
            this.minY = last1Y;
        }
        float firstX = last1X;
        float firstY = last1Y;
        boolean firstOnCurve = last1OnCurve;
        for (int point = 1; point < numPoints; ++point) {
            Point b;
            boolean onCurve = glyf.onCurve(contour, point);
            float x = (float)glyf.xCoordinate(contour, point) * ttm.getPointScale();
            float y = (float)glyf.yCoordinate(contour, point) * ttm.getPointScale();
            if ((x += y / ttm.getItalicRef() * ttm.getItalicAngle()) > this.maxX) {
                this.maxX = x;
            }
            if (x < this.minX) {
                this.minX = x;
            }
            if (y > this.maxY) {
                this.maxY = y;
            }
            if (y < this.minY) {
                this.minY = y;
            }
            if (!onCurve && !last1OnCurve) {
                if (point == 1) {
                    last1X = x;
                    last1Y = y;
                    x = last1X + (x - last1X) / 2.0f;
                    y = last1Y + (y - last1Y) / 2.0f;
                    firstOnCurveX = x;
                    firstOnCurveY = y;
                    a = mesh.addInteriorPoint(new Point(x, y));
                    last1OnCurve = false;
                    continue;
                }
                x = last1X + (x - last1X) / 2.0f;
                y = last1Y + (y - last1Y) / 2.0f;
                onCurve = true;
                --point;
            } else if (!last1OnCurve && point == 1) {
                firstOnCurveX = x;
                firstOnCurveY = y;
                a = mesh.addInteriorPoint(new Point(x, y));
                last1X = x;
                last1Y = y;
                last1OnCurve = true;
                continue;
            }
            if (onCurve && !last1OnCurve) {
                b = new Point(last1X, last1Y);
                Point c = mesh.addInteriorPoint(new Point(x, y));
                Seg ac = new Seg(a, c);
                if (ac.onLine(b)) {
                    segments.add(ac);
                } else {
                    b = mesh.addInteriorPoint(b);
                    Seg ab = new Seg(a, b);
                    Seg bc2 = new Seg(b, c);
                    triangles.add(new Tri(ab, bc2, ac));
                }
                a = c;
            } else if (onCurve) {
                b = mesh.addInteriorPoint(new Point(x, y));
                segments.add(new Seg(a, b));
                a = b;
            }
            last1X = x;
            last1Y = y;
            last1OnCurve = onCurve;
        }
        if (last1OnCurve) {
            if (firstOnCurve) {
                Point b = mesh.addInteriorPoint(new Point(firstX, firstY));
                segments.add(new Seg(a, b));
            } else {
                Point b = new Point(firstX, firstY);
                Point c = mesh.addInteriorPoint(new Point(firstOnCurveX, firstOnCurveY));
                Seg ac = new Seg(a, c);
                if (ac.onLine(b)) {
                    segments.add(ac);
                } else {
                    b = mesh.addInteriorPoint(b);
                    Seg ab = new Seg(a, b);
                    bc = new Seg(b, c);
                    triangles.add(new Tri(ab, bc, ac));
                }
            }
        } else if (firstOnCurve) {
            Point b = new Point(last1X, last1Y);
            Point c = mesh.addInteriorPoint(new Point(firstX, firstY));
            Seg ac = new Seg(a, c);
            if (ac.onLine(b)) {
                segments.add(ac);
            } else {
                b = mesh.addInteriorPoint(b);
                Seg ab = new Seg(a, b);
                bc = new Seg(b, c);
                triangles.add(new Tri(ab, bc, ac));
            }
        } else {
            Seg bc3;
            Seg ab;
            float x = last1X + (firstX - last1X) / 2.0f;
            float y = last1Y + (firstY - last1Y) / 2.0f;
            Point b = new Point(last1X, last1Y);
            Point c = mesh.addInteriorPoint(new Point(x, y));
            Seg ac = new Seg(a, c);
            if (ac.onLine(b)) {
                segments.add(ac);
            } else {
                b = mesh.addInteriorPoint(b);
                ab = new Seg(a, b);
                bc3 = new Seg(b, c);
                triangles.add(new Tri(ab, bc3, ac));
            }
            a = c;
            b = new Point(firstX, firstY);
            c = mesh.addInteriorPoint(new Point(firstOnCurveX, firstOnCurveY));
            ac = new Seg(a, c);
            if (ac.onLine(b)) {
                segments.add(ac);
            } else {
                b = mesh.addInteriorPoint(b);
                ab = new Seg(a, b);
                bc3 = new Seg(b, c);
                triangles.add(new Tri(ab, bc3, ac));
            }
        }
        return mesh;
    }

    private void getSimpleContours(SimpleGlyph glyf, float[] matrix, int contour, TrueTypeMesh ttm, List<Seg> segments, List<Tri> triangles, edu.berkeley.jmescher.Mesh mesh) {
        Seg bc;
        Point a = new Point();
        int numPoints = glyf.numberOfPoints(contour);
        float ox = glyf.xCoordinate(contour, 0);
        float last1Y = glyf.yCoordinate(contour, 0);
        float last1X = (ox * matrix[0] + last1Y * matrix[2] + matrix[4]) * ttm.getPointScale();
        last1Y = (ox * matrix[1] + last1Y * matrix[3] + matrix[5]) * ttm.getPointScale();
        float firstOnCurveX = last1X += last1Y / ttm.getItalicRef() * ttm.getItalicAngle();
        float firstOnCurveY = last1Y;
        boolean last1OnCurve = glyf.onCurve(contour, 0);
        if (last1OnCurve) {
            a = mesh.addInteriorPoint(new Point(last1X, last1Y));
        }
        if (last1X > this.maxX) {
            this.maxX = last1X;
        }
        if (last1X < this.minX) {
            this.minX = last1X;
        }
        if (last1Y > this.maxY) {
            this.maxY = last1Y;
        }
        if (last1Y < this.minY) {
            this.minY = last1Y;
        }
        float firstX = last1X;
        float firstY = last1Y;
        boolean firstOnCurve = last1OnCurve;
        for (int point = 1; point < numPoints; ++point) {
            Point b;
            boolean onCurve = glyf.onCurve(contour, point);
            ox = glyf.xCoordinate(contour, point);
            float y = glyf.yCoordinate(contour, point);
            float x = (ox * matrix[0] + y * matrix[2] + matrix[4]) * ttm.getPointScale();
            if ((x += (y = (ox * matrix[1] + y * matrix[3] + matrix[5]) * ttm.getPointScale()) / ttm.getItalicRef() * ttm.getItalicAngle()) > this.maxX) {
                this.maxX = x;
            }
            if (x < this.minX) {
                this.minX = x;
            }
            if (y > this.maxY) {
                this.maxY = y;
            }
            if (y < this.minY) {
                this.minY = y;
            }
            if (!onCurve && !last1OnCurve) {
                if (point == 1) {
                    last1X = x;
                    last1Y = y;
                    x = last1X + (x - last1X) / 2.0f;
                    y = last1Y + (y - last1Y) / 2.0f;
                    firstOnCurveX = x;
                    firstOnCurveY = y;
                    a = mesh.addInteriorPoint(new Point(x, y));
                    last1OnCurve = false;
                    continue;
                }
                x = last1X + (x - last1X) / 2.0f;
                y = last1Y + (y - last1Y) / 2.0f;
                onCurve = true;
                --point;
            } else if (!last1OnCurve && point == 1) {
                firstOnCurveX = x;
                firstOnCurveY = y;
                a = mesh.addInteriorPoint(new Point(x, y));
                last1X = x;
                last1Y = y;
                last1OnCurve = true;
                continue;
            }
            if (onCurve && !last1OnCurve) {
                b = new Point(last1X, last1Y);
                Point c = mesh.addInteriorPoint(new Point(x, y));
                Seg ac = new Seg(a, c);
                if (ac.onLine(b)) {
                    segments.add(ac);
                } else {
                    b = mesh.addInteriorPoint(b);
                    Seg ab = new Seg(a, b);
                    Seg bc2 = new Seg(b, c);
                    triangles.add(new Tri(ab, bc2, ac));
                }
                a = c;
            } else if (onCurve) {
                b = mesh.addInteriorPoint(new Point(x, y));
                segments.add(new Seg(a, b));
                a = b;
            }
            last1X = x;
            last1Y = y;
            last1OnCurve = onCurve;
        }
        if (last1OnCurve) {
            if (firstOnCurve) {
                Point b = mesh.addInteriorPoint(new Point(firstX, firstY));
                segments.add(new Seg(a, b));
            } else {
                Point b = new Point(firstX, firstY);
                Point c = mesh.addInteriorPoint(new Point(firstOnCurveX, firstOnCurveY));
                Seg ac = new Seg(a, c);
                if (ac.onLine(b)) {
                    segments.add(ac);
                } else {
                    b = mesh.addInteriorPoint(b);
                    Seg ab = new Seg(a, b);
                    bc = new Seg(b, c);
                    triangles.add(new Tri(ab, bc, ac));
                }
            }
        } else if (firstOnCurve) {
            Point b = new Point(last1X, last1Y);
            Point c = mesh.addInteriorPoint(new Point(firstX, firstY));
            Seg ac = new Seg(a, c);
            if (ac.onLine(b)) {
                segments.add(ac);
            } else {
                b = mesh.addInteriorPoint(b);
                Seg ab = new Seg(a, b);
                bc = new Seg(b, c);
                triangles.add(new Tri(ab, bc, ac));
            }
        } else {
            Seg bc3;
            Seg ab;
            float x = last1X + (firstX - last1X) / 2.0f;
            float y = last1Y + (firstY - last1Y) / 2.0f;
            Point b = new Point(last1X, last1Y);
            Point c = mesh.addInteriorPoint(new Point(x, y));
            Seg ac = new Seg(a, c);
            if (ac.onLine(b)) {
                segments.add(ac);
            } else {
                b = mesh.addInteriorPoint(b);
                ab = new Seg(a, b);
                bc3 = new Seg(b, c);
                triangles.add(new Tri(ab, bc3, ac));
            }
            a = c;
            b = new Point(firstX, firstY);
            c = mesh.addInteriorPoint(new Point(firstOnCurveX, firstOnCurveY));
            ac = new Seg(a, c);
            if (ac.onLine(b)) {
                segments.add(ac);
            } else {
                b = mesh.addInteriorPoint(b);
                ab = new Seg(a, b);
                bc3 = new Seg(b, c);
                triangles.add(new Tri(ab, bc3, ac));
            }
        }
    }

    private void createMesh(List<Tri> innerTris, List<Tri> bTris) {
        FloatBuffer verts = BufferUtils.createFloatBuffer((int)((innerTris.size() + bTris.size()) * 3 * 3));
        FloatBuffer tex1 = BufferUtils.createFloatBuffer((int)(verts.capacity() / 3 * 2));
        FloatBuffer tex2 = BufferUtils.createFloatBuffer((int)tex1.capacity());
        ShortBuffer indices = BufferUtils.createShortBuffer((int)(verts.capacity() / 3));
        float[] angles = new float[3];
        Point[] points = new Point[3];
        Point[] result = new Point[3];
        Point tmp = new Point();
        short count = 0;
        for (Tri t : innerTris) {
            points[0] = t.ab.p1;
            points[1] = t.ab.p2;
            points[2] = t.ac.p2;
            this.orderVerts(points, angles, tmp, result);
            verts.put(result[0].x);
            verts.put(result[0].y);
            verts.put(0.0f);
            tex1.put(result[0].getUV().x);
            tex1.put(result[0].getUV().y);
            tex2.put(2.0f);
            tex2.put(0.0f);
            verts.put(result[1].x);
            verts.put(result[1].y);
            verts.put(0.0f);
            tex1.put(result[1].getUV().x);
            tex1.put(result[1].getUV().y);
            tex2.put(2.0f);
            tex2.put(0.0f);
            verts.put(result[2].x);
            verts.put(result[2].y);
            verts.put(0.0f);
            tex1.put(result[2].getUV().x);
            tex1.put(result[2].getUV().y);
            tex2.put(2.0f);
            tex2.put(0.0f);
            indices.put(count);
            indices.put((short)(count + 1));
            indices.put((short)(count + 2));
            count = (short)(count + 3);
        }
        for (Tri t : bTris) {
            t.calcUV();
            points[0] = t.ab.p1.clone();
            points[0].setUV(0.0f, 0.0f);
            points[1] = t.ab.p2.clone();
            points[1].setUV(0.5f, 0.0f);
            points[2] = t.ac.p2.clone();
            points[2].setUV(1.0f, 1.0f);
            this.orderVerts(points, angles, tmp, result);
            verts.put(result[0].x);
            verts.put(result[0].y);
            verts.put(0.0f);
            tex1.put(result[0].getUV().x);
            tex1.put(result[0].getUV().y);
            verts.put(result[1].x);
            verts.put(result[1].y);
            verts.put(0.0f);
            tex1.put(result[1].getUV().x);
            tex1.put(result[1].getUV().y);
            verts.put(result[2].x);
            verts.put(result[2].y);
            verts.put(0.0f);
            tex1.put(result[2].getUV().x);
            tex1.put(result[2].getUV().y);
            if (t.pointingRight()) {
                tex2.put(1.0f);
                tex2.put(1.0f);
                tex2.put(1.0f);
                tex2.put(1.0f);
                tex2.put(1.0f);
                tex2.put(1.0f);
            } else {
                tex2.put(1.0f);
                tex2.put(-1.0f);
                tex2.put(1.0f);
                tex2.put(-1.0f);
                tex2.put(1.0f);
                tex2.put(-1.0f);
            }
            indices.put(count);
            indices.put((short)(count + 1));
            indices.put((short)(count + 2));
            count = (short)(count + 3);
        }
        this.setBuffer(VertexBuffer.Type.Position, 3, verts);
        this.setBuffer(VertexBuffer.Type.TexCoord, 2, tex1);
        this.setBuffer(VertexBuffer.Type.TexCoord2, 2, tex2);
        this.setBuffer(VertexBuffer.Type.Index, 3, indices);
        this.updateBound();
    }

    private Point[] orderVerts(Point[] points, float[] angles, Point tmp, Point[] result) {
        tmp.x = (points[0].x + points[1].x + points[2].x) / 3.0f;
        tmp.y = (points[0].y + points[1].y + points[2].y) / 3.0f;
        angles[0] = MeshGlyf.angle(tmp, points[0]);
        angles[1] = MeshGlyf.angle(tmp, points[1]);
        angles[2] = MeshGlyf.angle(tmp, points[2]);
        if (angles[0] < angles[1]) {
            if (angles[0] < angles[2]) {
                result[0] = points[0];
                if (angles[1] < angles[2]) {
                    result[1] = points[1];
                    result[2] = points[2];
                } else {
                    result[2] = points[1];
                    result[1] = points[2];
                }
            } else {
                result[0] = points[2];
                result[1] = points[0];
                result[2] = points[1];
            }
        } else if (angles[1] < angles[2]) {
            result[0] = points[1];
            if (angles[0] < angles[2]) {
                result[1] = points[0];
                result[2] = points[2];
            } else {
                result[2] = points[0];
                result[1] = points[2];
            }
        } else {
            result[0] = points[2];
            result[1] = points[1];
            result[2] = points[0];
        }
        return result;
    }

    public static float angle(Point p1, Point p2) {
        return FastMath.atan2((float)(p2.y - p1.y), (float)(p2.x - p1.x));
    }

    private class Tri {
        public final Seg ab;
        public final Seg bc;
        public final Seg ac;

        private Tri(Seg ab, Seg bc, Seg ac) {
            this.ab = ab;
            this.bc = bc;
            this.ac = ac;
        }

        public void calcUV() {
            this.ab.p1.setUV(0.0f, 0.0f);
            this.ab.p2.setUV(0.5f, 0.0f);
            this.ac.p2.setUV(1.0f, 1.0f);
        }

        public boolean pointingRight() {
            return this.ac.onRight(this.ab.p2);
        }
    }

    private class Seg {
        public final Point p1;
        public final Point p2;
        public HalfEdge he;

        private Seg(Point p1, Point p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        public final boolean onRight(Point p) {
            return (this.p2.x - this.p1.x) * (p.y - this.p1.y) - (this.p2.y - this.p1.y) * (p.x - this.p1.x) < 0.0f;
        }

        public final boolean onLine(Point p) {
            float pb;
            float ap;
            float ab = FastMath.sqrt((float)(FastMath.sqr((float)(this.p2.x - this.p1.x)) + FastMath.sqr((float)(this.p2.y - this.p1.y))));
            float result = ab - ((ap = FastMath.sqrt((float)(FastMath.sqr((float)(p.x - this.p1.x)) + FastMath.sqr((float)(p.y - this.p1.y))))) + (pb = FastMath.sqrt((float)(FastMath.sqr((float)(this.p2.x - p.x)) + FastMath.sqr((float)(this.p2.y - p.y))))));
            return result >= 0.0f ? result < 1.0E-7f : result > -1.0E-7f;
        }
    }
}

