/*
 * Decompiled with CFR 0.152.
 */
package com.atr.jme.font.shape;

import com.atr.jme.font.TrueTypeBMP;
import com.atr.jme.font.glyph.Glyph;
import com.atr.jme.font.glyph.GlyphBMP;
import com.atr.jme.font.shape.TrueTypeNode;
import com.atr.jme.font.util.StringContainer;
import com.jme3.material.Material;
import com.jme3.math.Vector2f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class TrueTypeText
extends TrueTypeNode<GlyphBMP> {
    TrueTypeBMP ttb;

    public TrueTypeText(TrueTypeBMP ttb, GlyphBMP[][] glyphs, int kerning, StringContainer.Align hAlign, StringContainer.VAlign vAlign, Material material) {
        super((Glyph[][])glyphs, kerning, hAlign, vAlign, material);
        this.ttb = ttb;
        this.attachChild((Spatial)new Geometry("TrueTypeText", (Mesh)new BMPMesh()));
        this.setMaterial(material);
    }

    @Override
    public void setText(String text) {
        this.setGlyphs(this.ttb.getGlyphMatrix(text));
    }

    @Override
    public void updateGeometry() {
        ((BMPMesh)((Geometry)this.getChild(0)).getMesh()).updateMesh();
    }

    private class BMPMesh
    extends Mesh {
        private BMPMesh() {
            this.updateMesh();
        }

        public void updateMesh() {
            int numChars = 0;
            float[] widths = new float[((GlyphBMP[][])TrueTypeText.this.glyphs).length];
            Vector2f[] lineHeights = new Vector2f[((GlyphBMP[][])TrueTypeText.this.glyphs).length];
            TrueTypeText.this.height = TrueTypeText.this.ttb.getScaledAscender() + TrueTypeText.this.ttb.getScaledDescender();
            if (((GlyphBMP[][])TrueTypeText.this.glyphs).length > 1) {
                TrueTypeText.this.height += (float)(((GlyphBMP[][])TrueTypeText.this.glyphs).length - 1) * TrueTypeText.this.ttb.getScaledLineHeight();
            }
            TrueTypeText.this.width = 0.0f;
            int count = 0;
            for (GlyphBMP[] line : (GlyphBMP[][])TrueTypeText.this.glyphs) {
                if (line.length == 0) {
                    widths[count++] = 0.0f;
                    continue;
                }
                float w = 0.0f;
                Vector2f lineHeight = new Vector2f(Float.MIN_VALUE, Float.MAX_VALUE);
                for (GlyphBMP glyph : line) {
                    w += (float)(glyph.getXAdvance() + TrueTypeText.this.kerning) * TrueTypeText.this.ttb.getScale();
                    if ((float)glyph.getAscender() > lineHeight.x) {
                        lineHeight.x = glyph.getAscender();
                    }
                    if ((float)glyph.getDescender() < lineHeight.y) {
                        lineHeight.y = glyph.getDescender();
                    }
                    if (glyph.codePoint == 32) continue;
                    ++numChars;
                }
                w -= (float)(line[line.length - 1].getXAdvance() + TrueTypeText.this.kerning) * TrueTypeText.this.ttb.getScale();
                lineHeights[count] = lineHeight.multLocal(TrueTypeText.this.ttb.getScale());
                widths[count++] = w += (float)line[line.length - 1].getRight() * TrueTypeText.this.ttb.getScale();
                if (!(w > TrueTypeText.this.width)) continue;
                TrueTypeText.this.width = w;
            }
            FloatBuffer verts = BufferUtils.createFloatBuffer((int)(numChars * 12));
            FloatBuffer tex1 = BufferUtils.createFloatBuffer((int)(numChars * 8));
            FloatBuffer tex2 = BufferUtils.createFloatBuffer((int)tex1.capacity());
            FloatBuffer tex3 = BufferUtils.createFloatBuffer((int)tex2.capacity());
            FloatBuffer tex4 = BufferUtils.createFloatBuffer((int)tex3.capacity());
            ShortBuffer indices = BufferUtils.createShortBuffer((int)(numChars * 6));
            float currentY = TrueTypeText.this.ttb.getScaledAscender();
            float yOffset = 0.0f;
            switch (TrueTypeText.this.vAlign) {
                case Center: {
                    yOffset = TrueTypeText.this.height / 2.0f;
                    break;
                }
                case Bottom: {
                    yOffset = TrueTypeText.this.height;
                }
            }
            int padding = TrueTypeText.this.ttb.padding / 2;
            short currentIndex = 0;
            count = 0;
            for (GlyphBMP[] line : (GlyphBMP[][])TrueTypeText.this.glyphs) {
                int currentX = 0;
                float xOffset = 0.0f;
                switch (TrueTypeText.this.hAlign) {
                    case Center: {
                        xOffset = -widths[count] / 2.0f;
                        break;
                    }
                    case Right: {
                        xOffset = TrueTypeText.this.width - widths[count];
                    }
                }
                Vector2f lineY = lineHeights[count];
                float lineHeight = lineY == null ? 0.0f : lineY.x - lineY.y;
                for (GlyphBMP glyph : line) {
                    if (glyph.codePoint == 32) {
                        currentX += glyph.getXAdvance() + TrueTypeText.this.kerning;
                        continue;
                    }
                    float w = glyph.getWidth();
                    float h = glyph.getHeight();
                    float x = currentX + glyph.getXOffset();
                    float y = glyph.getYOffset();
                    verts.put((x - (float)padding) * TrueTypeText.this.ttb.getScale() + xOffset);
                    verts.put((y - (float)padding) * TrueTypeText.this.ttb.getScale() + yOffset - currentY);
                    verts.put(0.0f);
                    x *= TrueTypeText.this.ttb.getScale();
                    y *= TrueTypeText.this.ttb.getScale();
                    tex1.put(glyph.getLeftU());
                    tex1.put(glyph.getBottomV());
                    tex2.put(0.0f);
                    tex2.put(0.0f);
                    tex3.put(x / widths[count]);
                    tex3.put((y - lineY.y) / lineHeight);
                    if (TrueTypeText.this.hAlign == StringContainer.Align.Center) {
                        tex4.put((x + (TrueTypeText.this.width / 2.0f - widths[count] / 2.0f)) / TrueTypeText.this.width);
                    } else {
                        tex4.put((x + xOffset) / TrueTypeText.this.width);
                    }
                    tex4.put(1.0f - (y - currentY) / -TrueTypeText.this.height);
                    x = currentX + glyph.getXOffset() + glyph.atlasWidth;
                    y = glyph.getYOffset();
                    verts.put(x * TrueTypeText.this.ttb.getScale() + xOffset);
                    verts.put((y - (float)padding) * TrueTypeText.this.ttb.getScale() + yOffset - currentY);
                    verts.put(0.0f);
                    x *= TrueTypeText.this.ttb.getScale();
                    y *= TrueTypeText.this.ttb.getScale();
                    tex1.put(glyph.getRightU());
                    tex1.put(glyph.getBottomV());
                    tex2.put(1.0f);
                    tex2.put(0.0f);
                    tex3.put(x / widths[count]);
                    tex3.put((y - lineY.y) / lineHeight);
                    if (TrueTypeText.this.hAlign == StringContainer.Align.Center) {
                        tex4.put((x + (TrueTypeText.this.width / 2.0f - widths[count] / 2.0f)) / TrueTypeText.this.width);
                    } else {
                        tex4.put((x + xOffset) / TrueTypeText.this.width);
                    }
                    tex4.put(1.0f - (y - currentY) / -TrueTypeText.this.height);
                    x = currentX + glyph.getXOffset();
                    y = glyph.getYOffset() + glyph.atlasHeight;
                    verts.put((x - (float)padding) * TrueTypeText.this.ttb.getScale() + xOffset);
                    verts.put(y * TrueTypeText.this.ttb.getScale() + yOffset - currentY);
                    verts.put(0.0f);
                    x *= TrueTypeText.this.ttb.getScale();
                    y *= TrueTypeText.this.ttb.getScale();
                    tex1.put(glyph.getLeftU());
                    tex1.put(glyph.getTopV());
                    tex2.put(0.0f);
                    tex2.put(1.0f);
                    tex3.put(x / widths[count]);
                    tex3.put((y - lineY.y) / lineHeight);
                    if (TrueTypeText.this.hAlign == StringContainer.Align.Center) {
                        tex4.put((x + (TrueTypeText.this.width / 2.0f - widths[count] / 2.0f)) / TrueTypeText.this.width);
                    } else {
                        tex4.put((x + xOffset) / TrueTypeText.this.width);
                    }
                    tex4.put(1.0f - (y - currentY) / -TrueTypeText.this.height);
                    x = currentX + glyph.getXOffset() + glyph.atlasWidth;
                    y = glyph.getYOffset() + glyph.atlasHeight;
                    verts.put(x * TrueTypeText.this.ttb.getScale() + xOffset);
                    verts.put(y * TrueTypeText.this.ttb.getScale() + yOffset - currentY);
                    verts.put(0.0f);
                    x *= TrueTypeText.this.ttb.getScale();
                    y *= TrueTypeText.this.ttb.getScale();
                    tex1.put(glyph.getRightU());
                    tex1.put(glyph.getTopV());
                    tex2.put(1.0f);
                    tex2.put(1.0f);
                    tex3.put(x / widths[count]);
                    tex3.put((y - lineY.y) / lineHeight);
                    if (TrueTypeText.this.hAlign == StringContainer.Align.Center) {
                        tex4.put((x + (TrueTypeText.this.width / 2.0f - widths[count] / 2.0f)) / TrueTypeText.this.width);
                    } else {
                        tex4.put((x + xOffset) / TrueTypeText.this.width);
                    }
                    tex4.put(1.0f - (y - currentY) / -TrueTypeText.this.height);
                    indices.put(currentIndex);
                    indices.put((short)(currentIndex + 1));
                    indices.put((short)(currentIndex + 2));
                    indices.put((short)(currentIndex + 2));
                    indices.put((short)(currentIndex + 1));
                    indices.put((short)(currentIndex + 3));
                    currentX += glyph.getXAdvance() + TrueTypeText.this.kerning;
                    currentIndex = (short)(currentIndex + 4);
                }
                ++count;
                currentY += TrueTypeText.this.ttb.getScaledLineHeight();
            }
            this.setBuffer(VertexBuffer.Type.Position, 3, verts);
            this.setBuffer(VertexBuffer.Type.TexCoord, 2, tex1);
            this.setBuffer(VertexBuffer.Type.TexCoord2, 2, tex2);
            this.setBuffer(VertexBuffer.Type.TexCoord3, 2, tex3);
            this.setBuffer(VertexBuffer.Type.TexCoord4, 2, tex4);
            this.setBuffer(VertexBuffer.Type.Index, 3, indices);
            this.clearCollisionData();
            this.updateBound();
        }
    }
}

