/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.jmescher;

import edu.berkeley.jmescher.HalfEdge;
import edu.berkeley.jmescher.Mesh;
import edu.berkeley.jmescher.Point;
import edu.berkeley.jmescher.PointCopy;
import java.util.HashMap;

public class MeshCopy
extends Mesh {
    private HashMap<Point, Point> pointLookup;
    private HashMap<HalfEdge, HalfEdge> halfEdgeLookup;

    public MeshCopy(float epsilon) {
        super(epsilon);
    }

    public MeshCopy(Mesh m, String name) {
        super(m.epsilon);
        this.pointLookup = new HashMap();
        this.halfEdgeLookup = new HashMap();
        this.name = name;
        for (Point p : m.points) {
            PointCopy p1 = new PointCopy(p);
            this.points.add(p1);
            this.pointLookup.put(p, p1);
        }
        for (HalfEdge he : m.halfEdges) {
            HalfEdge he1 = new HalfEdge(he);
            this.halfEdges.add(he1);
            this.halfEdgeLookup.put(he, he1);
        }
        for (Point p : this.points) {
            p.he = this.halfEdgeLookup.get(p.he);
        }
        for (HalfEdge he : this.halfEdges) {
            he.origin = this.pointLookup.get(he.origin);
            he.next = this.halfEdgeLookup.get(he.next);
            if (he.isType(1)) continue;
            he.sibling = this.halfEdgeLookup.get(he.sibling);
        }
        this.nBoundary = m.boundarySize();
    }

    public void boundaryOnly() {
        this.deleteQueue.clear();
        for (Point p : this.points) {
            if (!p.isType(0)) continue;
            this.deleteQueue.add(p);
        }
        for (Point p : this.deleteQueue) {
            this.removeInteriorPoint(p);
        }
    }

    public void updateCopy() {
        for (Point p : this.points) {
            if (!(p instanceof PointCopy)) continue;
            PointCopy pc = (PointCopy)p;
            pc.set(pc.origin);
            pc.coords3d.set(pc.origin.coords3d);
        }
    }

    public Point lookup(Point p) {
        Point p0 = this.pointLookup.get(p);
        if (p0 != null) {
            return p0;
        }
        if (this.contains(p)) {
            return p;
        }
        return null;
    }

    public Point[] getPoints() {
        return this.points.toArray(new Point[0]);
    }

    public HalfEdge[] getHalfEdges() {
        return this.halfEdges.toArray(new HalfEdge[0]);
    }
}

