/*
 * Decompiled with CFR 0.152.
 */
package com.atr.jme.font;

import com.atr.jme.font.TrueTypeBMP;
import com.atr.jme.font.TrueTypeFont;
import com.atr.jme.font.glyph.GlyphAWT;
import com.atr.jme.font.util.AtlasListener;
import com.atr.jme.font.util.Style;
import com.jme3.asset.AssetManager;
import com.jme3.texture.Texture2D;
import com.jme3.texture.plugins.AWTLoader;
import com.jme3.util.BufferUtils;
import com.jme3.util.NativeObjectManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TrueTypeAWT
extends TrueTypeBMP<GlyphAWT> {
    private final Font font;
    private final FontRenderContext frc;
    private final AffineTransform transform;

    public TrueTypeAWT(AssetManager assetManager, Font font, Style style, int pointSize, int outline, int dpi, int maxAtlasResolution, String preload, boolean fixedResolution) {
        super(assetManager, style, pointSize, outline, dpi, maxAtlasResolution, fixedResolution);
        this.font = font != null ? font : new Font("SansSerif", 0, pointSize);
        double dpiScale = (float)dpi / 72.0f;
        this.transform = new AffineTransform();
        this.transform.setToScale(dpiScale, -dpiScale);
        Graphics2D g = new BufferedImage(64, 64, 1).createGraphics();
        g.setFont(this.font);
        this.frc = g.getFontRenderContext();
        FontMetrics fm = g.getFontMetrics(this.font);
        g.dispose();
        this.ascender = (int)Math.ceil((double)fm.getMaxAscent() * dpiScale) + outline;
        this.descender = (int)Math.ceil((double)fm.getMaxDescent() * dpiScale) + Math.round((float)outline / 2.0f);
        this.lineGap = (int)Math.ceil((double)fm.getLeading() * dpiScale);
        this.lineHeight = this.ascender + this.descender + this.lineGap;
        this.charHeight = (int)Math.ceil(this.font.getMaxCharBounds(this.frc).getHeight() * dpiScale) + this.padding;
        this.resizeWidth = (int)Math.ceil(this.font.getMaxCharBounds(this.frc).getWidth() * dpiScale) + this.padding;
        this.getGlyphs(new StringBuilder().appendCodePoint(this.defaultCodePoint).append(" ").append(preload));
    }

    @Override
    public boolean canDisplay(int codePoint) {
        return this.font.canDisplay(codePoint);
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    protected void createGlyphs(List<TrueTypeFont.CharToCreate> characters) {
        if (this.atlas == null) {
            this.resizeAtlas();
        }
        boolean added = false;
        HashMap<Integer, GlyphVector> backLog = new HashMap<Integer, GlyphVector>();
        do {
            int line = 0;
            for (TrueTypeBMP.AtlasLine al : this.atlasLines) {
                Iterator<TrueTypeFont.CharToCreate> it = characters.iterator();
                while (it.hasNext()) {
                    TrueTypeFont.CharToCreate ctc = it.next();
                    if (this.cache.containsKey(ctc.codePoint)) {
                        it.remove();
                        continue;
                    }
                    this.sb.delete(0, this.sb.length());
                    this.sb.appendCodePoint(ctc.codePoint);
                    GlyphVector gv = (GlyphVector)backLog.get(ctc.codePoint);
                    if (gv == null) {
                        gv = this.font.createGlyphVector(this.frc, this.sb.toString());
                    }
                    gv.setGlyphTransform(0, this.transform);
                    Rectangle2D bounds = gv.getVisualBounds();
                    int w = (int)bounds.getWidth() + this.padding;
                    if (al.canFit(w)) {
                        GlyphAWT gawt = new GlyphAWT(this, al.getX(), line * this.charHeight, ctc.codePoint, gv);
                        this.cache.put(ctc.codePoint, gawt);
                        added = true;
                        al.addChar(w);
                        it.remove();
                        continue;
                    }
                    backLog.put(ctc.codePoint, gv);
                }
                ++line;
            }
            if (characters.isEmpty()) continue;
            if (this.atlasWidth + this.resizeWidth > this.maxTexRes && this.atlasHeight + this.charHeight > this.maxTexRes) {
                Iterator<TrueTypeFont.CharToCreate> it = characters.iterator();
                while (it.hasNext()) {
                    it.next().codePoint = this.defaultCodePoint;
                    it.remove();
                }
                break;
            }
            this.resizeAtlas();
        } while (!characters.isEmpty());
        if (this.atlasResized || added) {
            int oldHeight;
            int oldWidth = this.atlas != null ? this.atlas.getImage().getWidth() : 0;
            int n = oldHeight = this.atlas != null ? this.atlas.getImage().getHeight() : 0;
            if (this.outline > 0) {
                this.createAtlasOutlined();
            } else {
                this.createAtlas();
            }
            for (AtlasListener listener : this.onAtlas) {
                listener.mod(this.assetManager, oldWidth, oldHeight, this.atlasWidth, this.atlasHeight, this);
            }
        }
    }

    @Override
    protected void createAtlas() {
        BufferedImage tmpImg = new BufferedImage(this.atlasWidth, this.atlasHeight, 4);
        Graphics2D g = tmpImg.createGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.atlasWidth, this.atlasHeight);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g.setColor(Color.white);
        g.setFont(this.font);
        for (GlyphAWT glyph : this.cache.values()) {
            if (glyph.getOutline() == null) continue;
            int x = glyph.x + this.padding / 2 - glyph.getXOffset();
            int y = glyph.y + this.padding / 2 - glyph.getYOffset();
            g.translate(x, y);
            g.fill(glyph.getOutline());
            g.translate(-x, -y);
        }
        if (this.atlas != null) {
            this.atlas.getImage().dispose();
            if (!NativeObjectManager.UNSAFE) {
                for (ByteBuffer buf : this.atlas.getImage().getData()) {
                    BufferUtils.destroyDirectBuffer((Buffer)buf);
                }
            }
            this.atlas.setImage(new AWTLoader().load(tmpImg, false));
        } else {
            this.atlas = new Texture2D(new AWTLoader().load(tmpImg, false));
        }
        g.dispose();
        this.atlasResized = false;
    }

    @Override
    protected void createAtlasOutlined() {
        BufferedImage tmpImg = new BufferedImage(this.atlasWidth, this.atlasHeight, 4);
        Graphics2D g = tmpImg.createGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.atlasWidth, this.atlasHeight);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        Color fill = new Color(255, 0, 255);
        BasicStroke stroke = new BasicStroke(this.outline, 0, 1);
        BasicStroke noStroke = new BasicStroke(0.0f);
        for (GlyphAWT glyph : this.cache.values()) {
            if (glyph.getOutline() == null) continue;
            g.setStroke(stroke);
            int x = glyph.x + this.padding / 2 - glyph.getXOffset();
            int y = glyph.y + this.padding / 2 - glyph.getYOffset();
            g.translate(x, y);
            g.setPaint(new Color(255, 0, 0));
            g.draw(glyph.getOutline());
            g.setStroke(noStroke);
            g.setPaint(fill);
            g.fill(glyph.getOutline());
            g.translate(-x, -y);
        }
        if (this.atlas != null) {
            this.atlas.getImage().dispose();
            if (!NativeObjectManager.UNSAFE) {
                for (ByteBuffer buf : this.atlas.getImage().getData()) {
                    BufferUtils.destroyDirectBuffer((Buffer)buf);
                }
            }
            this.atlas.setImage(new AWTLoader().load(tmpImg, false));
        } else {
            this.atlas = new Texture2D(new AWTLoader().load(tmpImg, false));
        }
        g.dispose();
        this.atlasResized = false;
    }
}

