/*
 * Decompiled with CFR 0.152.
 */
package com.atr.jme.font;

import com.atr.jme.font.TrueTypeFont;
import com.atr.jme.font.TrueTypeSfntly;
import com.atr.jme.font.glyph.GlyphBMP;
import com.atr.jme.font.shape.TrueTypeBMPContainer;
import com.atr.jme.font.shape.TrueTypeContainer;
import com.atr.jme.font.shape.TrueTypeText;
import com.atr.jme.font.util.AtlasListener;
import com.atr.jme.font.util.StringContainer;
import com.atr.jme.font.util.Style;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.BufferUtils;
import com.jme3.util.NativeObjectManager;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class TrueTypeBMP<T extends GlyphBMP>
extends TrueTypeFont<T, TrueTypeText> {
    public final int outline;
    public final int padding;
    protected int charHeight;
    protected int resizeWidth;
    protected final List<AtlasLine> atlasLines = new ArrayList<AtlasLine>();
    protected Texture2D atlas;
    protected boolean atlasResized = false;
    protected int atlasWidth = 0;
    protected int atlasHeight = 0;
    protected int maxTexRes = 2048;
    protected final List<AtlasListener> onAtlas = new LinkedList<AtlasListener>();
    protected boolean fixedResolution = false;

    public TrueTypeBMP(AssetManager assetManager, Style style, int pointSize, int outline, int dpi, int maxAtlasResolution, boolean fixedResolution) {
        super(assetManager, style, pointSize, dpi);
        this.outline = outline;
        this.padding = 10 + outline * 2;
        this.maxTexRes = maxAtlasResolution;
        this.fixedResolution = fixedResolution;
    }

    public void setMaxAtlasResolution(int resolution) {
        this.maxTexRes = Math.max(resolution, 0);
    }

    public int getMaxAtlasResolution() {
        return this.maxTexRes;
    }

    public Texture2D getAtlas() {
        return this.atlas;
    }

    public void addAtlasListener(AtlasListener listener) {
        this.onAtlas.add(listener);
    }

    public boolean removeAtlasListener(AtlasListener listener) {
        return this.onAtlas.remove(listener);
    }

    @Override
    public TrueTypeText getText(T[][] glyphs, int kerning, ColorRGBA color, StringContainer.Align hAlign, StringContainer.VAlign vAlign) {
        return this.getText((GlyphBMP[][])glyphs, kerning, color, color, hAlign, vAlign);
    }

    public TrueTypeText getText(String text, int kerning, ColorRGBA color, ColorRGBA outlineColor) {
        return this.getText(text, kerning, color, outlineColor, StringContainer.Align.Left, StringContainer.VAlign.Top);
    }

    public TrueTypeText getText(T[][] glyphs, int kerning, ColorRGBA color, ColorRGBA outlineColor) {
        return this.getText((GlyphBMP[][])glyphs, kerning, color, outlineColor, StringContainer.Align.Left, StringContainer.VAlign.Top);
    }

    public TrueTypeText getText(String text, int kerning, ColorRGBA color, ColorRGBA outlineColor, StringContainer.Align hAlign, StringContainer.VAlign vAlign) {
        return this.getText(this.getGlyphMatrix(text), kerning, color, outlineColor, hAlign, vAlign);
    }

    public TrueTypeText getText(T[][] glyphs, int kerning, ColorRGBA color, ColorRGBA outlineColor, StringContainer.Align hAlign, StringContainer.VAlign vAlign) {
        Material mat;
        if (this.outline > 0) {
            mat = new Material(this.assetManager, "Common/MatDefs/TTF/TTF_BitmapOutlined.j3md");
            mat.setColor("Color", color);
            mat.setColor("Outline", outlineColor);
        } else {
            mat = new Material(this.assetManager, "Common/MatDefs/TTF/TTF_Bitmap.j3md");
            mat.setColor("Color", color);
        }
        TrueTypeText ttt = new TrueTypeText(this, (GlyphBMP[][])glyphs, kerning, hAlign, vAlign, mat);
        mat.setTexture("Texture", (Texture)this.atlas);
        return ttt;
    }

    @Override
    public TrueTypeText getText(T[][] glyphs, int kerning, Material material, StringContainer.Align hAlign, StringContainer.VAlign vAlign) {
        return new TrueTypeText(this, (GlyphBMP[][])glyphs, kerning, hAlign, vAlign, material);
    }

    @Override
    public TrueTypeContainer getFormattedText(StringContainer stringContainer, ColorRGBA color) {
        return this.getFormattedText(stringContainer, color, color);
    }

    public TrueTypeContainer getFormattedText(StringContainer stringContainer, ColorRGBA color, ColorRGBA outlineColor) {
        Material mat;
        if (this.outline > 0) {
            mat = new Material(this.assetManager, "Common/MatDefs/TTF/TTF_BitmapOutlined.j3md");
            mat.setColor("Color", color);
            mat.setColor("Outline", outlineColor);
        } else {
            mat = new Material(this.assetManager, "Common/MatDefs/TTF/TTF_Bitmap.j3md");
            mat.setColor("Color", color);
        }
        TrueTypeBMPContainer ttc = new TrueTypeBMPContainer(stringContainer, mat);
        mat.setTexture("Texture", (Texture)this.atlas);
        ttc.setLocalTranslation(stringContainer.getTextBox().x, stringContainer.getTextBox().y, 0.0f);
        return ttc;
    }

    @Override
    public TrueTypeContainer getFormattedText(StringContainer stringContainer, Material material) {
        TrueTypeBMPContainer ttc = new TrueTypeBMPContainer(stringContainer, material);
        ttc.setLocalTranslation(stringContainer.getTextBox().x, stringContainer.getTextBox().y, 0.0f);
        return ttc;
    }

    @Override
    public T[] getGlyphs(StringBuilder text) {
        GlyphBMP[] glyphs = new GlyphBMP[text.length()];
        LinkedList<TrueTypeFont.CharToCreate> unCached = new LinkedList<TrueTypeFont.CharToCreate>();
        for (int i = 0; i < text.length(); ++i) {
            int codePoint = text.codePointAt(i);
            if (!this.canDisplay(codePoint) || this.invalidCharacters.contains(codePoint)) {
                codePoint = this.defaultCodePoint;
            }
            glyphs[i] = (GlyphBMP)this.cache.get(codePoint);
            if (glyphs[i] != null) continue;
            if (this.cacheLock) {
                glyphs[i] = (GlyphBMP)this.cache.get(this.defaultCodePoint);
                continue;
            }
            unCached.add(new TrueTypeFont.CharToCreate(this, i, codePoint));
        }
        if (!unCached.isEmpty()) {
            this.createGlyphs((LinkedList)unCached.clone());
            for (TrueTypeFont.CharToCreate ctc : unCached) {
                glyphs[ctc.index] = (GlyphBMP)this.cache.get(ctc.codePoint);
            }
        }
        return glyphs;
    }

    @Override
    public T[][] getGlyphMatrix(String text) {
        GlyphBMP[][] lines;
        String[] strings = text.split("\n");
        if (text.startsWith("\n")) {
            if (text.endsWith("\n")) {
                lines = new GlyphBMP[strings.length + 2][];
                lines[0] = new GlyphBMP[0];
                lines[lines.length - 1] = new GlyphBMP[0];
                for (int i = 1; i < lines.length - 1; ++i) {
                    lines[i] = (GlyphBMP[])this.getGlyphs(strings[i - 1]);
                }
            } else {
                lines = new GlyphBMP[strings.length + 1][];
                lines[0] = new GlyphBMP[0];
                for (int i = 1; i < lines.length; ++i) {
                    lines[i] = (GlyphBMP[])this.getGlyphs(strings[i - 1]);
                }
            }
        } else {
            lines = new GlyphBMP[strings.length][];
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = (GlyphBMP[])this.getGlyphs(strings[i]);
            }
        }
        return lines;
    }

    public int getOutline() {
        return this.outline;
    }

    protected void resizeAtlas() {
        if (this.fixedResolution) {
            this.atlasWidth = this.maxTexRes;
            this.atlasHeight = this.maxTexRes;
        } else {
            this.atlasWidth += this.atlasWidth + this.resizeWidth > this.maxTexRes ? 0 : this.resizeWidth;
            this.atlasHeight += this.atlasHeight + this.charHeight > this.maxTexRes ? 0 : this.charHeight;
        }
        int numNewLines = (int)FastMath.floor((float)((float)this.atlasHeight / (float)this.charHeight)) - this.atlasLines.size();
        for (int i = 0; i < numNewLines; ++i) {
            this.atlasLines.add(new AtlasLine());
        }
        this.atlasResized = true;
    }

    protected abstract void createAtlas();

    protected abstract void createAtlasOutlined();

    public void reloadTexture() {
        int oldHeight;
        int oldWidth = this.atlas != null ? this.atlas.getImage().getWidth() : 0;
        int n = oldHeight = this.atlas != null ? this.atlas.getImage().getHeight() : 0;
        if (this.outline > 0) {
            this.createAtlasOutlined();
        } else {
            this.createAtlas();
        }
        for (AtlasListener listener : this.onAtlas) {
            listener.mod(this.assetManager, oldWidth, oldHeight, this.atlasWidth, this.atlasHeight, this);
        }
    }

    public void finalize() throws Throwable {
        if (!(this instanceof TrueTypeSfntly) && this.atlas != null) {
            this.atlas.getImage().dispose();
            if (!NativeObjectManager.UNSAFE) {
                for (ByteBuffer buf : this.atlas.getImage().getData()) {
                    BufferUtils.destroyDirectBuffer((Buffer)buf);
                }
            }
        }
        super.finalize();
    }

    protected class AtlasLine {
        private int currentX = 0;

        protected AtlasLine() {
        }

        public boolean canFit(int cWidth) {
            return TrueTypeBMP.this.atlasWidth - this.currentX - cWidth >= 0;
        }

        public void addChar(int cWidth) {
            this.currentX += cWidth;
        }

        public int getX() {
            return this.currentX;
        }
    }
}

