/*
 * Decompiled with CFR 0.152.
 */
package com.atr.jme.font;

import com.atr.jme.font.glyph.Glyph;
import com.atr.jme.font.shape.TrueTypeContainer;
import com.atr.jme.font.shape.TrueTypeNode;
import com.atr.jme.font.util.StringContainer;
import com.atr.jme.font.util.Style;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class TrueTypeFont<T extends Glyph, S extends TrueTypeNode> {
    public static final int SPACE_CODEPOINT = 32;
    protected int defaultCodePoint = 0;
    protected final AssetManager assetManager;
    public final int dpi;
    protected float scale = 1.0f;
    protected final Style style;
    protected final int pointSize;
    protected int lineHeight;
    protected int ascender;
    protected int descender;
    protected int lineGap;
    protected final Map<Integer, T> cache = new HashMap<Integer, T>();
    protected final List<Integer> invalidCharacters = new ArrayList<Integer>();
    protected final StringBuilder sb = new StringBuilder();
    protected boolean cacheLock = false;

    protected TrueTypeFont(AssetManager assetManager, Style style, int pointSize, int dpi) {
        this.assetManager = assetManager;
        this.style = style;
        this.pointSize = pointSize;
        this.dpi = dpi;
    }

    public void lock(boolean lock) {
        this.cacheLock = lock;
    }

    public boolean isLocked() {
        return this.cacheLock;
    }

    public abstract boolean canDisplay(int var1);

    public boolean setDefaultCharacter(String text) {
        if (text.isEmpty()) {
            return false;
        }
        this.sb.delete(0, this.sb.length());
        this.sb.append(text);
        int codePoint = this.sb.codePointAt(0);
        if (this.cacheLock && this.cache.get(codePoint) == null) {
            return false;
        }
        if (this.canDisplay(codePoint)) {
            this.defaultCodePoint = codePoint;
            return true;
        }
        return false;
    }

    public void setInvalidCharacters(String text) {
        this.sb.delete(0, this.sb.length());
        this.sb.append(text);
        for (int i = 0; i < this.sb.length(); ++i) {
            int codePoint = this.sb.codePointAt(i);
            if (this.invalidCharacters.contains(codePoint)) continue;
            this.invalidCharacters.add(codePoint);
        }
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    public S getText(String text, int kerning, ColorRGBA color) {
        return this.getText(text, kerning, color, StringContainer.Align.Left, StringContainer.VAlign.Top);
    }

    public S getText(String text, int kerning, Material material) {
        return this.getText(text, kerning, material, StringContainer.Align.Left, StringContainer.VAlign.Top);
    }

    public S getText(String text, int kerning, ColorRGBA color, StringContainer.Align hAlign, StringContainer.VAlign vAlign) {
        return (S)((Object)this.getText(this.getGlyphMatrix(text), kerning, color, hAlign, vAlign));
    }

    public S getText(String text, int kerning, Material material, StringContainer.Align hAlign, StringContainer.VAlign vAlign) {
        return (S)((Object)this.getText(this.getGlyphMatrix(text), kerning, material, hAlign, vAlign));
    }

    public S getText(T[][] glyphs, int kerning, ColorRGBA color) {
        return (S)((Object)this.getText((Glyph[][])glyphs, kerning, color, StringContainer.Align.Left, StringContainer.VAlign.Top));
    }

    public S getText(T[][] glyphs, int kerning, Material material) {
        return (S)((Object)this.getText((Glyph[][])glyphs, kerning, material, StringContainer.Align.Left, StringContainer.VAlign.Top));
    }

    public abstract S getText(T[][] var1, int var2, ColorRGBA var3, StringContainer.Align var4, StringContainer.VAlign var5);

    public abstract S getText(T[][] var1, int var2, Material var3, StringContainer.Align var4, StringContainer.VAlign var5);

    public abstract TrueTypeContainer getFormattedText(StringContainer var1, ColorRGBA var2);

    public abstract TrueTypeContainer getFormattedText(StringContainer var1, Material var2);

    public T[] getGlyphs(String text) {
        this.sb.delete(0, this.sb.length());
        this.sb.append(text);
        return this.getGlyphs(this.sb);
    }

    public abstract T[] getGlyphs(StringBuilder var1);

    public abstract T[][] getGlyphMatrix(String var1);

    protected abstract void createGlyphs(List<CharToCreate> var1);

    public float getLineWidth(String text, int kerning) {
        return this.getLineWidth(this.getGlyphs(text), kerning);
    }

    public float getLineWidth(StringBuilder text, int kerning) {
        return this.getLineWidth(this.getGlyphs(text), kerning);
    }

    public float getLineWidth(T[] glyphs, int kerning) {
        if (glyphs.length == 0) {
            return 0.0f;
        }
        int lineWidth = 0;
        for (int i = 0; i < glyphs.length - 1; ++i) {
            lineWidth += ((Glyph)glyphs[i]).getXAdvance() + kerning;
        }
        return (float)(lineWidth += ((Glyph)glyphs[glyphs.length - 1]).getRight()) * this.scale;
    }

    public int getActualLineHeight() {
        return this.lineHeight;
    }

    public float getScaledLineHeight() {
        return this.scale * (float)this.lineHeight;
    }

    public int getScaledLineHeightInt() {
        return Math.round(this.scale * (float)this.lineHeight);
    }

    public int getActualLineGap() {
        return this.lineGap;
    }

    public float getScaledLineGap() {
        return (float)this.lineGap * this.scale;
    }

    public int getScaledLineGapInt() {
        return Math.round(this.scale * (float)this.lineGap);
    }

    public float getActualPointSize() {
        return this.pointSize;
    }

    public float getScaledPointSize() {
        return (float)this.pointSize * this.scale;
    }

    public int getScaledPointSizeInt() {
        return Math.round(this.scale * (float)this.pointSize);
    }

    public int getActualAscender() {
        return this.ascender;
    }

    public float getScaledAscender() {
        return this.scale * (float)this.ascender;
    }

    public int getActualDescender() {
        return this.descender;
    }

    public float getScaledDescender() {
        return this.scale * (float)this.descender;
    }

    public float getVisualLineHeight(String text) {
        return this.getVisualLineHeight(this.getGlyphs(text));
    }

    public float getVisualLineHeight(StringBuilder text) {
        return this.getVisualLineHeight(this.getGlyphs(text));
    }

    public float getVisualLineHeight(T[] glyphs) {
        if (glyphs.length == 0) {
            return 0.0f;
        }
        int maxY = Integer.MIN_VALUE;
        for (T glyph : glyphs) {
            maxY = ((Glyph)glyph).getHeight() > maxY ? ((Glyph)glyph).getHeight() : maxY;
        }
        return (float)maxY * this.scale;
    }

    public float getVisualAscent(String text) {
        return this.getVisualAscent(this.getGlyphs(text));
    }

    public float getVisualAscent(StringBuilder text) {
        return this.getVisualAscent(this.getGlyphs(text));
    }

    public float getVisualAscent(T[] glyphs) {
        if (glyphs.length == 0) {
            return 0.0f;
        }
        int maxY = Integer.MIN_VALUE;
        for (T glyph : glyphs) {
            maxY = ((Glyph)glyph).getAscender() > maxY ? ((Glyph)glyph).getAscender() : maxY;
        }
        return (float)maxY * this.scale;
    }

    public float getVisualDescent(String text) {
        return this.getVisualDescent(this.getGlyphs(text));
    }

    public float getVisualDescent(StringBuilder text) {
        return this.getVisualDescent(this.getGlyphs(text));
    }

    public float getVisualDescent(T[] glyphs) {
        if (glyphs.length == 0) {
            return 0.0f;
        }
        int minY = Integer.MAX_VALUE;
        for (T glyph : glyphs) {
            minY = ((Glyph)glyph).getDescender() < minY ? ((Glyph)glyph).getDescender() : minY;
        }
        return (float)minY * this.scale;
    }

    protected class CharToCreate {
        public final int index;
        public int codePoint;

        protected CharToCreate(int index, int codePoint) {
            this.index = index;
            this.codePoint = codePoint;
        }
    }
}

