/*
 * Decompiled with CFR 0.152.
 */
package com.atr.jme.font.asset;

import com.atr.jme.font.asset.TrueTypeKey;
import com.atr.jme.font.util.Style;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import java.io.IOException;

public class TrueTypeKeyBMP
extends TrueTypeKey {
    private int outline;
    private int maxAtlasResolution = 2048;
    private boolean fixedResolution = false;

    public TrueTypeKeyBMP(String name, int pointSize) {
        this(name, Style.Plain, pointSize);
    }

    public TrueTypeKeyBMP(String name, Style style, int pointSize) {
        this(name, style, pointSize, 0);
    }

    public TrueTypeKeyBMP(String name, Style style, int pointSize, String preload) {
        this(name, style, pointSize, 0, preload);
    }

    public TrueTypeKeyBMP(String name, Style style, int pointSize, String preload, int maxAtlasResolution) {
        this(name, style, pointSize, 0, preload, maxAtlasResolution);
    }

    public TrueTypeKeyBMP(String name, Style style, int pointSize, int outline) {
        this(name, style, pointSize, outline, 72, false);
    }

    public TrueTypeKeyBMP(String name, Style style, int pointSize, int outline, String preload) {
        this(name, style, pointSize, outline, 72, false, preload);
    }

    public TrueTypeKeyBMP(String name, Style style, int pointSize, int outline, String preload, int maxAtlasResolution) {
        this(name, style, pointSize, outline, 72, false, preload, maxAtlasResolution);
    }

    public TrueTypeKeyBMP(String name, Style style, int pointSize, int outline, int dpi, boolean useWeakCache) {
        super(name, style, pointSize, dpi, useWeakCache);
        this.outline = outline;
    }

    public TrueTypeKeyBMP(String name, Style style, int pointSize, int outline, int dpi, boolean useWeakCache, String preload) {
        super(name, style, pointSize, dpi, useWeakCache, preload);
        this.outline = outline;
    }

    public TrueTypeKeyBMP(String name, Style style, int pointSize, int outline, int dpi, boolean useWeakCache, String preload, int maxAtlasResolution) {
        super(name, style, pointSize, dpi, useWeakCache, preload);
        this.outline = outline;
        this.maxAtlasResolution = maxAtlasResolution;
    }

    public TrueTypeKeyBMP(String name, Style style, int pointSize, int outline, int dpi, boolean useWeakCache, String preload, int maxAtlasResolution, boolean fixedResolution) {
        super(name, style, pointSize, dpi, useWeakCache, preload);
        this.outline = outline;
        this.maxAtlasResolution = maxAtlasResolution;
        this.fixedResolution = fixedResolution;
    }

    public void setOutline(int outline) {
        this.outline = outline;
    }

    public int getOutline() {
        return this.outline;
    }

    public void setMaxAtlasResolution(int maxAtlasResolution) {
        this.maxAtlasResolution = maxAtlasResolution;
    }

    public int getMaxAtlasRes() {
        return this.maxAtlasResolution;
    }

    public void setFixedResolution(boolean fixedResolution) {
        this.fixedResolution = fixedResolution;
    }

    public boolean isFixedResolution() {
        return this.fixedResolution;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof TrueTypeKeyBMP) || !super.equals(other)) {
            return false;
        }
        TrueTypeKeyBMP key = (TrueTypeKeyBMP)((Object)other);
        return this.outline == key.getOutline();
    }

    @Override
    public String toString() {
        return super.toString() + "_Outline:" + Integer.toString(this.outline) + "_MaxRes:" + Integer.toString(this.maxAtlasResolution) + "_FixedRes:" + Boolean.toString(this.fixedResolution);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write(this.outline, "outline", 0);
        oc.write(this.maxAtlasResolution, "maxres", 2048);
        oc.write(this.fixedResolution, "fixedResolution", false);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.outline = ic.readInt("outline", 0);
        this.maxAtlasResolution = ic.readInt("maxres", 2048);
        this.fixedResolution = ic.readBoolean("fixedResolution", false);
    }
}

