/*
 * Decompiled with CFR 0.152.
 */
package com.atr.jme.font.asset;

import com.atr.jme.font.TrueTypeAWT;
import com.atr.jme.font.TrueTypeBMP;
import com.atr.jme.font.asset.TrueTypeKeyBMP;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TrueTypeLoaderAWT
implements AssetLoader {
    public TrueTypeBMP load(AssetInfo assetInfo) throws IOException {
        TrueTypeKeyBMP key = (TrueTypeKeyBMP)assetInfo.getKey();
        Font font = null;
        try {
            font = Font.createFont(0, assetInfo.openStream());
        }
        catch (FontFormatException ffe) {
            font = null;
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unable to load " + key.getName() + " using system default Sans Serif font instead.", ffe);
            throw new IOException("Unable to load " + key.getName() + " using system default Sans Serif font instead.");
        }
        catch (IOException ioe) {
            throw ioe;
        }
        switch (key.getStyle()) {
            case Plain: {
                font = font.deriveFont(0, key.getPointSize());
                break;
            }
            case Bold: {
                font = font.deriveFont(1, key.getPointSize());
                break;
            }
            case Italic: {
                font = font.deriveFont(2, key.getPointSize());
                break;
            }
            case BoldItalic: {
                font = font.deriveFont(3, key.getPointSize());
                break;
            }
        }
        return new TrueTypeAWT(assetInfo.getManager(), font, key.getStyle(), key.getPointSize(), key.getOutline(), key.getScreenDensity(), key.getMaxAtlasRes(), key.getPreloadCharacters(), key.isFixedResolution());
    }
}

