/*
 * Decompiled with CFR 0.152.
 */
package com.atr.jme.font.shape;

import com.atr.jme.font.TrueTypeMesh;
import com.atr.jme.font.glyph.Glyph;
import com.atr.jme.font.glyph.GlyphMesh;
import com.atr.jme.font.shape.TrueTypeContainer;
import com.atr.jme.font.util.StringContainer;
import com.jme3.material.Material;
import com.jme3.math.Vector2f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.LinkedList;

public class TrueTypeMeshContainer
extends TrueTypeContainer {
    public TrueTypeMeshContainer(StringContainer stringContainer, Material material) {
        super(stringContainer, material);
        this.updateGeometry();
    }

    public void setAA(boolean aa) {
        if (this.material.getParam("useAA") == null) {
            return;
        }
        this.material.setBoolean("useAA", aa);
    }

    @Override
    public void updateGeometry() {
        this.detachAllChildren();
        TrueTypeMesh ttm = (TrueTypeMesh)this.stringContainer.getFont();
        Glyph[][] lines = this.stringContainer.getLines();
        int startIndex = 0;
        int startLine = 0;
        int numVerts = 0;
        int totalVerts = 0;
        int lineNum = 0;
        int index = 0;
        LinkedList<TextSnippet> snippets = new LinkedList<TextSnippet>();
        for (Glyph[] line : lines) {
            if (line.length == 0) {
                ++lineNum;
                index = 0;
                continue;
            }
            index = 0;
            for (Glyph glyf : line) {
                GlyphMesh glyph = (GlyphMesh)glyf;
                if (glyph.codePoint != 32) {
                    if (numVerts + glyph.getMesh().getVertexCount() < Short.MAX_VALUE) {
                        numVerts += glyph.getMesh().getVertexCount();
                    } else {
                        snippets.add(new TextSnippet(startLine, lineNum, startIndex, index, numVerts, totalVerts));
                        totalVerts += numVerts;
                        numVerts = glyph.getMesh().getVertexCount();
                        startLine = lineNum;
                        startIndex = index;
                    }
                }
                ++index;
            }
            ++lineNum;
        }
        snippets.add(new TextSnippet(startLine, lines.length - 1, startIndex, index, numVerts, totalVerts));
        Vector2f xyOffset = new Vector2f(0.0f, ttm.getScaledAscender());
        float yOffset = 0.0f;
        switch (this.stringContainer.getVerticalAlignment()) {
            case Bottom: {
                yOffset = this.stringContainer.getTextBox().height - this.stringContainer.getTextHeight();
                break;
            }
            case Center: {
                float halfBox = this.stringContainer.getTextBox().height / 2.0f;
                float halfHeight = this.stringContainer.getTextHeight() / 2.0f;
                yOffset = halfBox - halfHeight;
            }
        }
        for (TextSnippet snippet : snippets) {
            TextMesh mesh = new TextMesh();
            mesh.createMesh(lines, snippet, this.stringContainer.getLineWidths(), this.stringContainer.getLineHeights(), this.stringContainer.getTextWidth(), this.stringContainer.getTextHeight(), yOffset, xyOffset);
            Geometry g = new Geometry("TrueTypeMeshText", (Mesh)mesh);
            g.setMaterial(this.material);
            this.attachChild((Spatial)g);
        }
    }

    private class TextSnippet {
        public final int startLine;
        public final int endLine;
        public final int startIndex;
        public final int endIndex;
        public final int numVerts;

        private TextSnippet(int startLine, int endLine, int startIndex, int endIndex, int numVerts, int indexOffset) {
            this.startLine = startLine;
            this.endLine = endLine;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.numVerts = numVerts;
        }
    }

    private class TextMesh
    extends Mesh {
        private TextMesh() {
        }

        public Vector2f createMesh(Glyph[][] lines, TextSnippet snippet, float[] lineWidths, Vector2f[] lineHeights, float width, float height, float yOffset, Vector2f currentXY) {
            TrueTypeMesh ttm = (TrueTypeMesh)TrueTypeMeshContainer.this.stringContainer.getFont();
            FloatBuffer verts = BufferUtils.createFloatBuffer((int)(snippet.numVerts * 3));
            FloatBuffer tex1 = BufferUtils.createFloatBuffer((int)(snippet.numVerts * 2));
            FloatBuffer tex2 = BufferUtils.createFloatBuffer((int)tex1.capacity());
            FloatBuffer tex3 = BufferUtils.createFloatBuffer((int)tex2.capacity());
            FloatBuffer tex4 = BufferUtils.createFloatBuffer((int)tex3.capacity());
            FloatBuffer tex5 = BufferUtils.createFloatBuffer((int)tex4.capacity());
            ShortBuffer indices = BufferUtils.createShortBuffer((int)snippet.numVerts);
            float startX = currentXY.x;
            float currentY = currentXY.y;
            int currentIndex = 0;
            int startIndex = snippet.startIndex;
            block4: for (int i = snippet.startLine; i <= snippet.endLine; ++i) {
                float currentX = startX;
                startX = 0.0f;
                float xOffset = 0.0f;
                switch (TrueTypeMeshContainer.this.stringContainer.getAlignment()) {
                    case Right: {
                        xOffset = TrueTypeMeshContainer.this.stringContainer.getTextBox().width - lineWidths[i];
                        break;
                    }
                    case Center: {
                        float halfBox = TrueTypeMeshContainer.this.stringContainer.getTextBox().width / 2.0f;
                        float halfWidth = lineWidths[i] / 2.0f;
                        xOffset = halfBox - halfWidth;
                    }
                }
                Vector2f lineY = lineHeights[i];
                float lineHeight = lineY == null ? 0.0f : lineY.x - lineY.y;
                for (int n = startIndex; n < lines[i].length; ++n) {
                    startIndex = 0;
                    if (i == snippet.endLine && n == snippet.endIndex) {
                        if (snippet.endIndex == lines[i].length) {
                            currentXY.set(0.0f, currentY + ttm.getScaledLineHeight());
                            break block4;
                        }
                        currentXY.set(currentX, currentY);
                        break block4;
                    }
                    GlyphMesh glyph = (GlyphMesh)lines[i][n];
                    if (glyph.codePoint == 32) {
                        currentX += (float)(glyph.getXAdvance() + TrueTypeMeshContainer.this.stringContainer.getKerning());
                        continue;
                    }
                    FloatBuffer gverts = glyph.getMesh().getFloatBuffer(VertexBuffer.Type.Position);
                    gverts.clear();
                    FloatBuffer gtex1 = glyph.getMesh().getFloatBuffer(VertexBuffer.Type.TexCoord);
                    gtex1.clear();
                    FloatBuffer gtex2 = glyph.getMesh().getFloatBuffer(VertexBuffer.Type.TexCoord2);
                    gtex2.clear();
                    ShortBuffer gindices = glyph.getMesh().getShortBuffer(VertexBuffer.Type.Index);
                    gindices.clear();
                    int w = glyph.getWidth();
                    int h = glyph.getHeight();
                    while (gverts.hasRemaining()) {
                        float x = gverts.get();
                        float y = gverts.get();
                        float x2 = x + currentX * ttm.getScale();
                        float y2 = y - currentY;
                        verts.put(x2 + xOffset);
                        verts.put(y2 - yOffset);
                        verts.put(gverts.get());
                        tex1.put(gtex1.get());
                        tex1.put(gtex1.get());
                        tex2.put(gtex2.get());
                        tex2.put(gtex2.get());
                        tex3.put((x - (float)glyph.getLeft() * ttm.getScale()) / (float)w);
                        tex3.put((y - (float)glyph.getDescender() * ttm.getScale()) / (float)h);
                        tex4.put(x2 / lineWidths[i]);
                        tex4.put((y - lineY.y) / lineHeight);
                        if (TrueTypeMeshContainer.this.stringContainer.getAlignment() == StringContainer.Align.Center) {
                            tex5.put((x2 + (width / 2.0f - lineWidths[i] / 2.0f)) / width);
                        } else {
                            tex5.put((x2 + xOffset) / width);
                        }
                        tex5.put(1.0f - y2 / -height);
                        indices.put((short)(gindices.get() + currentIndex));
                    }
                    currentX += (float)(glyph.getXAdvance() + TrueTypeMeshContainer.this.stringContainer.getKerning());
                    currentIndex = (short)(currentIndex + glyph.getMesh().getVertexCount());
                }
                if (i == snippet.endLine) {
                    currentXY.set(0.0f, currentY + ttm.getScaledLineHeight());
                    break;
                }
                currentY += ttm.getScaledLineHeight();
            }
            this.setBuffer(VertexBuffer.Type.Position, 3, verts);
            this.setBuffer(VertexBuffer.Type.TexCoord, 2, tex1);
            this.setBuffer(VertexBuffer.Type.TexCoord2, 2, tex2);
            this.setBuffer(VertexBuffer.Type.TexCoord3, 2, tex3);
            this.setBuffer(VertexBuffer.Type.TexCoord4, 2, tex4);
            this.setBuffer(VertexBuffer.Type.TexCoord5, 2, tex5);
            this.setBuffer(VertexBuffer.Type.Index, 3, indices);
            this.clearCollisionData();
            this.updateBound();
            return currentXY;
        }
    }
}

