/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.jmescher;

import edu.berkeley.jmescher.BPoint;
import edu.berkeley.jmescher.Mesh;
import edu.berkeley.jmescher.Point;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Example
extends JPanel {
    float epsilon = 1.0f;
    int size = 600;
    int nsides = 16;
    int npts = 100;
    int nedges = 10;
    float min = 10.0f;
    float max = this.size - 10;
    Mesh mesh;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setTitle("jmEscher Example");
        Example example = new Example(frame);
        frame.getContentPane().add(example);
        frame.pack();
        frame.setVisible(true);
        example.createMesh();
        example.repaint();
    }

    public Example(JFrame frame) {
        this.setPreferredSize(new Dimension(this.size, this.size));
        this.setBackground(Color.WHITE);
        this.mesh = new Mesh(this.epsilon);
        this.mesh.setName("Example Mesh");
    }

    public void createMesh() {
        Point[] boundary = new BPoint[]{new BPoint(this.min, this.min), new BPoint(this.min, this.max), new BPoint(this.max, this.max), new BPoint(this.max, this.min)};
        Mesh.linkBoundary((BPoint[])boundary);
        this.mesh.init(boundary);
        for (int i = 0; i < this.npts; ++i) {
            Point p = new Point();
            p.x = this.min + this.epsilon + (float)Math.random() * (this.max - this.min - 2.0f * this.epsilon);
            p.y = this.min + this.epsilon + (float)Math.random() * (this.max - this.min - 2.0f * this.epsilon);
            this.mesh.addInteriorPoint(p);
        }
        int s = this.mesh.size() - 1;
        int i = 0;
        while (i < this.nedges) {
            Point p2;
            Point p1 = this.mesh.getPoint((int)(Math.random() * (double)s));
            if (p1 == (p2 = this.mesh.getPoint((int)(Math.random() * (double)s)))) continue;
            try {
                this.mesh.addConstraint(p1, p2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }
}

