/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.jmescher;

import com.atr.jme.font.util.Point2d;
import com.atr.jme.font.util.Point3d;
import edu.berkeley.jmescher.BPoint;
import edu.berkeley.jmescher.Edge;
import edu.berkeley.jmescher.FaceWalk;
import edu.berkeley.jmescher.HalfEdge;
import edu.berkeley.jmescher.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Mesh {
    protected static final boolean DRAW_PT_FULL = true;
    protected static final boolean DRAW_PT_INDICES = false;
    protected static final boolean DRAW_HE_INDICES = false;
    protected static final boolean DRAW_HALFEDGES = false;
    private static final int TYPICAL_POLYGON_SIZE = 16;
    protected static final String E_EXHAUSTED = "Exhausted halfedges or points!";
    protected static final String E_MISSING = "Missing halfedge or point!";
    protected static final String E_IDENTICAL = "Identical halfedges or points!";
    protected static final String E_COINCIDENT = "Coincident points!";
    protected static final String E_TYPE = "Incorrect type!";
    protected static final String E_POLYGON = "Illegal polygonal region!";
    protected static final String E_HALFEDGE = "Mismatched halfedge!";
    protected static final int NULL_VALUE = -100000;
    public static final boolean MESSAGES = false;
    public static final boolean TEST = false;
    public boolean toggleDebugVisual = false;
    public boolean toggleDebugInteractive = false;
    public boolean toggleDebugSuspend = false;
    private boolean testing = false;
    public final float epsilon;
    private final float orientErrorBound;
    private final float incircleErrorBound;
    protected final List<Point> points = Collections.synchronizedList(new LinkedList());
    protected final List<HalfEdge> halfEdges = Collections.synchronizedList(new LinkedList());
    protected int nBoundary;
    protected LinkedList<HalfEdge> delaunayQueue = new LinkedList();
    protected LinkedList<Point> removedConstraints = new LinkedList();
    protected LinkedList<Point> deleteQueue = new LinkedList();
    private Point removeConstraintPeg = null;
    protected String name = "(unnamed mesh)";

    public Mesh(float epsilon) {
        this.epsilon = epsilon;
        float e = this.initMachineEpsilon();
        this.orientErrorBound = (3.0f + 16.0f * e) * e;
        this.incircleErrorBound = (10.0f + 96.0f * e) * e;
    }

    float initMachineEpsilon() {
        float lastcheck;
        float half = 0.5f;
        float e = 1.0f;
        float check = 1.0f;
        do {
            lastcheck = check;
        } while ((double)(check = 1.0f + (e *= half)) != 1.0 && check != lastcheck);
        return e;
    }

    public int size() {
        return this.points.size();
    }

    public int boundarySize() {
        return this.nBoundary;
    }

    public void clear() {
        this.points.clear();
        this.halfEdges.clear();
        this.delaunayQueue.clear();
    }

    public void clearFlags(int flag) {
        for (HalfEdge he : this.halfEdges) {
            he.unflag(flag);
        }
    }

    public boolean contains(Point p) {
        return this.points.contains(p);
    }

    public int indexOf(Point p) {
        return this.points.indexOf(p);
    }

    public Point getPoint(int i) {
        return this.points.get(i);
    }

    public Point3d[] getPointCoordinates3d() {
        Point3d[] coords = new Point3d[this.points.size()];
        int i = 0;
        for (Point p : this.points) {
            coords[i++] = p.coords3d;
        }
        return coords;
    }

    public Point2d[] getFaceCoordinates() {
        ArrayList<Point2d> facePoints = new ArrayList<Point2d>();
        this.clearFlags(2);
        for (HalfEdge he0 : this.halfEdges) {
            if (he0.isFlagged(2)) continue;
            HalfEdge he1 = he0.next;
            HalfEdge he2 = he1.next;
            facePoints.add(new Point2d(he0.origin));
            facePoints.add(new Point2d(he1.origin));
            facePoints.add(new Point2d(he2.origin));
            he0.flag(2);
            he1.flag(2);
            he2.flag(2);
        }
        return facePoints.toArray(new Point2d[0]);
    }

    public Point3d[] getFaceCoordinates3d() {
        ArrayList<Point3d> coords = new ArrayList<Point3d>();
        this.clearFlags(2);
        for (HalfEdge he0 : this.halfEdges) {
            if (he0.isFlagged(2)) continue;
            HalfEdge he1 = he0.next;
            HalfEdge he2 = he1.next;
            coords.add(new Point3d(he0.origin.coords3d));
            coords.add(new Point3d(he1.origin.coords3d));
            coords.add(new Point3d(he2.origin.coords3d));
            he0.flag(2);
            he1.flag(2);
            he2.flag(2);
        }
        assert (coords.size() % 3 == 0) : this.error("Illegal face list!");
        return coords.toArray(new Point3d[0]);
    }

    public Edge[] getEdges() {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        this.clearFlags(2);
        for (HalfEdge he : this.halfEdges) {
            if (he.isFlagged(2)) continue;
            Edge e = new Edge(new Point(he.origin), new Point(he.next.origin));
            e.type = he.getType();
            edges.add(e);
            he.flag(2);
        }
        return edges.toArray(new Edge[0]);
    }

    public void setName(String s) {
        this.name = s;
    }

    public void translate(float x, float y) {
        for (Point p : this.points) {
            p.x += x;
            p.y += y;
        }
    }

    public static void linkBoundary(BPoint[] pts) {
        int s = pts.length;
        for (int i = 0; i < s; ++i) {
            pts[i].next = pts[(i + 1) % s];
            pts[i].prev = pts[(i - 1 + s) % s];
        }
    }

    public void init(Point[] pts) {
        int i;
        int s = pts.length;
        assert (s >= 3) : this.error("Initialization requires at least 3 points!");
        ArrayList<HalfEdge> polygon = new ArrayList<HalfEdge>(s);
        this.clear();
        for (Point p : pts) {
            this.points.add(p);
            p.setType(1);
            p.he = new HalfEdge(p, 1);
            this.halfEdges.add(p.he);
        }
        for (i = 0; i < s; ++i) {
            this.halfEdges.get((int)i).next = this.halfEdges.get((s + i - 1) % s);
        }
        this.nBoundary = s;
        for (i = 0; i < s; ++i) {
            polygon.add(this.halfEdges.get(s - 1 - i));
        }
        this.fillGeneralPolygon(polygon);
        this.delaunayQueue.addAll(polygon);
        this.updateDelaunay();
    }

    private HalfEdge addHalfEdge(Point origin, Point destination) {
        HalfEdge he2;
        HalfEdge he1 = new HalfEdge(origin);
        he1.sibling = he2 = new HalfEdge(destination);
        he2.sibling = he1;
        this.halfEdges.add(he1);
        this.halfEdges.add(he2);
        return he1;
    }

    private HalfEdge addEdge(HalfEdge he1, HalfEdge he2, HalfEdge he1prev, HalfEdge he2prev) {
        assert (he1prev.next == he1) : this.error("Mismatched halfedge!", he1, he1prev);
        assert (he2prev.next == he2) : this.error("Mismatched halfedge!", he2, he2prev);
        assert (he1 != he2) : this.error("Coincident points!");
        assert (he1.origin != he2.origin) : this.error("Coincident points!");
        HalfEdge heAdd = this.addHalfEdge(he1.origin, he2.origin);
        this.delaunayQueue.add(heAdd);
        heAdd.next = he2;
        he1prev.next = heAdd;
        heAdd.sibling.next = he1;
        he2prev.next = heAdd.sibling;
        return heAdd;
    }

    public Point addBoundaryPoint(Point p, HalfEdge he0) {
        assert (this.halfEdges.contains(he0)) : this.error("Missing halfedge or point!");
        assert (this.between(he0.origin, he0.next.origin, p)) : this.error("Adding boundary point that doesn't lie on boundary!");
        if (this.coincident(p, he0.origin)) {
            return he0.origin;
        }
        if (this.coincident(p, he0.next.origin)) {
            return he0.next.origin;
        }
        this.points.add(p);
        HalfEdge he2 = he0.next;
        HalfEdge he3 = he2.next;
        HalfEdge he1 = new HalfEdge(p, 1);
        this.halfEdges.add(he1);
        p.he = he1;
        he0.next = he1;
        he1.next = he2;
        this.fillQuadrilateral(he0);
        this.updateDelaunay();
        ++this.nBoundary;
        return p;
    }

    public Point addInteriorPoint(Point p) {
        Point pNearest = null;
        float min = Float.MAX_VALUE;
        for (Point pTest : this.points) {
            float dist = p.distanceSquared(pTest);
            if (dist < this.epsilon) {
                ++pTest.users;
                return pTest;
            }
            if (!(dist < min)) continue;
            min = dist;
            pNearest = pTest;
        }
        FaceWalk walk = this.findFace(pNearest.he, p);
        this.points.add(p);
        if (walk.status == 0) {
            this.splitEdge(p, walk.he);
        } else {
            this.splitFace(p, walk.he);
        }
        this.updateDelaunay();
        return p;
    }

    public HalfEdge addConstraint(Point pStart, Point pEnd) throws Exception {
        int i;
        assert (this.points.contains(pStart)) : this.error("Missing halfedge or point!");
        assert (this.points.contains(pEnd)) : this.error("Missing halfedge or point!");
        assert (pStart != pEnd) : this.error("Identical points!");
        assert (!this.coincident(pStart, pEnd)) : this.error("Coincident points!");
        FaceWalk walk = this.startFaceWalk(pStart, pEnd);
        if (walk.status == 0) {
            if (this.constrainEdge(walk.he)) {
                return walk.he;
            }
            return null;
        }
        HalfEdge heStart = walk.he;
        HalfEdge heStartPrev = this.findPrevious(heStart);
        HalfEdge heSearch = heStart.next;
        for (i = 0; i <= this.halfEdges.size(); ++i) {
            Point pSearch0 = heSearch.origin;
            Point pSearch1 = heSearch.next.origin;
            if (pSearch1 == pEnd) break;
            assert (!this.coincident(pSearch1, pStart)) : this.error("Coincident points!", pSearch1, pStart);
            assert (!this.coincident(pSearch1, pEnd)) : this.error("Coincident points!", pSearch1, pEnd);
            if (this.intersect(pStart, pEnd, pSearch0, pSearch1)) {
                assert (!heSearch.isType(1)) : this.error("Constraint crosses boundary edge!");
                if (heSearch.isType(0)) {
                    this.removeEdge(heSearch);
                    heSearch = heSearch.sibling;
                } else if (heSearch.isType(2)) {
                    Point2d p = Mesh.intersection(pStart, pEnd, pSearch0, pSearch1);
                    this.splitConstraint(heSearch, p);
                    this.addConstraintEdge(heStart, heSearch.next, heStartPrev, heSearch);
                    heStart = heSearch = heSearch.sibling;
                    heStartPrev = this.findPrevious(heStart);
                    pStart = heSearch.origin;
                }
            }
            heSearch = heSearch.next;
        }
        assert (i < this.halfEdges.size()) : this.error("Exhausted halfedges or points!", pStart, pEnd);
        HalfEdge heAdd = this.addConstraintEdge(heStart, heSearch.next, heStartPrev, heSearch);
        this.updateDelaunay();
        return heAdd;
    }

    private HalfEdge addConstraintEdge(HalfEdge he1, HalfEdge he2, HalfEdge he1prev, HalfEdge he2prev) {
        assert (he1prev.next == he1) : this.error("Mismatched halfedge!");
        assert (he2prev.next == he2) : this.error("Mismatched halfedge!");
        HalfEdge heAdd = this.addEdge(he1, he2, he1prev, he2prev);
        this.constrainEdge(heAdd);
        this.fillEdgeVisiblePolygon(heAdd);
        this.fillEdgeVisiblePolygon(heAdd.sibling);
        return heAdd;
    }

    protected void fillQuadrilateral(HalfEdge he1) {
        HalfEdge he2 = he1.next;
        HalfEdge he3 = he2.next;
        HalfEdge he4 = he3.next;
        assert (he4.next == he1);
        if (this.orient(he1.origin, he3.origin, he2.origin) * this.orient(he1.origin, he3.origin, he4.origin) < 0.0f) {
            this.addEdge(he1, he3, he4, he2);
        } else {
            this.addEdge(he2, he4, he1, he3);
        }
    }

    protected ArrayList<HalfEdge> constructPolygon(HalfEdge he) {
        int i;
        assert (this.halfEdges.contains(he)) : this.error("Missing halfedge or point!");
        ArrayList<HalfEdge> polygon = new ArrayList<HalfEdge>(16);
        polygon.add(he);
        HalfEdge heSearch = he.next;
        for (i = 0; i <= this.halfEdges.size() && heSearch != he; ++i) {
            polygon.add(heSearch);
            heSearch = heSearch.next;
        }
        assert (i < this.halfEdges.size()) : this.error("Exhausted halfedges or points!", he, he.origin);
        return polygon;
    }

    protected void fillGeneralPolygon(HalfEdge he) {
        this.fillGeneralPolygon(this.constructPolygon(he));
    }

    protected void fillGeneralPolygon(ArrayList<HalfEdge> polygon) {
        this.fillGeneralPolygonRecurse(polygon);
        this.delaunayQueue.addAll(polygon);
    }

    private void fillGeneralPolygonRecurse(ArrayList<HalfEdge> polygon) {
        assert (polygon.size() >= 3) : this.error("Illegal size!");
        int s = polygon.size();
        if (s > 3) {
            int j;
            Point p2 = null;
            Point p1 = null;
            Point p0 = null;
            HalfEdge heTest0 = null;
            int n = 0;
            block0: for (int i = 0; i < s; ++i) {
                n = i;
                heTest0 = polygon.get(i);
                p0 = heTest0.origin;
                p1 = heTest0.next.origin;
                p2 = polygon.get((int)((i + 2) % s)).origin;
                if (!(this.orient(p0, p1, p2) > 0.0f) || this.between(p0, p2, p1)) continue;
                HalfEdge heTest1 = heTest0.next.next;
                for (j = 0; j < s - 3; ++j) {
                    if (this.intersectProper(p0, p2, heTest1.origin, heTest1.next.origin)) continue block0;
                    heTest1 = heTest1.next;
                }
            }
            HalfEdge heAdd = this.addHalfEdge(p0, p2);
            this.delaunayQueue.add(heAdd);
            heAdd.sibling.next = heTest0;
            polygon.get((int)((n + 1) % s)).next = heAdd.sibling;
            heAdd.next = polygon.get((n + 2) % s);
            polygon.get((int)((n + s - 1) % s)).next = heAdd;
            if (s > 4) {
                ArrayList<HalfEdge> polygon0 = new ArrayList<HalfEdge>();
                for (j = 0; j < s - 1; ++j) {
                    polygon0.add(heAdd);
                    heAdd = heAdd.next;
                }
                this.fillGeneralPolygonRecurse(polygon0);
            }
        }
    }

    protected void fillEdgeVisiblePolygon(HalfEdge he) {
        ArrayList<HalfEdge> polygon = this.constructPolygon(he);
        this.fillEdgeVisiblePolygonRecurse(polygon);
        this.delaunayQueue.addAll(polygon);
    }

    private void fillEdgeVisiblePolygonRecurse(ArrayList<HalfEdge> polygon) {
        assert (polygon.size() >= 3) : this.error("Illegal size!");
        int s = polygon.size();
        if (s > 3) {
            HalfEdge heAdd;
            Point pa = polygon.get((int)0).origin;
            Point pb = polygon.get((int)1).origin;
            Point pc = polygon.get((int)2).origin;
            int c = 2;
            for (int i = 3; i < s; ++i) {
                Point p = polygon.get((int)i).origin;
                if (!(this.incircle(pa, pb, pc, p) > 0.0f)) continue;
                pc = p;
                c = i;
            }
            if (c < s - 1) {
                heAdd = this.addEdge(polygon.get(0), polygon.get(c), polygon.get(s - 1), polygon.get(c - 1));
                this.fillEdgeVisiblePolygonRecurse(this.constructPolygon(heAdd));
            }
            if (c > 2) {
                heAdd = this.addEdge(polygon.get(1), polygon.get((int)(c - 1)).next, polygon.get(0), polygon.get(c - 1));
                this.fillEdgeVisiblePolygonRecurse(this.constructPolygon(heAdd.sibling));
            }
        }
    }

    private void splitEdge(Point p, HalfEdge he) {
        assert (!he.isType(1)) : this.error("Attempting to split boundary edge!");
        HalfEdge he1 = this.findPrevious(he);
        HalfEdge he2 = he.sibling.next;
        HalfEdge he3 = this.findPrevious(he.sibling);
        he.origin = p;
        p.he = he;
        HalfEdge heAdd1 = this.addHalfEdge(p, he1.origin);
        HalfEdge heAdd2 = this.addHalfEdge(p, he2.origin);
        HalfEdge heAdd3 = this.addHalfEdge(p, he3.origin);
        heAdd1.next = he1;
        heAdd2.next = he2;
        heAdd3.next = he3;
        he.next.next = heAdd1.sibling;
        he1.next = heAdd2.sibling;
        he2.next = heAdd3.sibling;
        heAdd1.sibling.next = he;
        heAdd2.sibling.next = heAdd1;
        heAdd3.sibling.next = heAdd2;
        he.sibling.next = heAdd3;
        this.updateHalfEdge(he2);
        this.delaunayQueue.add(he);
        this.delaunayQueue.add(he1);
        this.delaunayQueue.add(he2);
        this.delaunayQueue.add(he3);
    }

    private void splitFace(Point p, HalfEdge he1) {
        assert (this.halfEdges.contains(he1)) : this.error("Missing halfedge or point!");
        HalfEdge he2 = he1.next;
        HalfEdge he3 = he2.next;
        HalfEdge heAdd1 = this.addHalfEdge(p, he1.origin);
        HalfEdge heAdd2 = this.addHalfEdge(p, he2.origin);
        HalfEdge heAdd3 = this.addHalfEdge(p, he3.origin);
        p.he = heAdd1;
        heAdd1.next = he1;
        heAdd2.next = he2;
        heAdd3.next = he3;
        he1.next = heAdd2.sibling;
        he2.next = heAdd3.sibling;
        he3.next = heAdd1.sibling;
        heAdd1.sibling.next = heAdd3;
        heAdd3.sibling.next = heAdd2;
        heAdd2.sibling.next = heAdd1;
        this.delaunayQueue.add(heAdd1);
        this.delaunayQueue.add(heAdd2);
        this.delaunayQueue.add(heAdd3);
        this.delaunayQueue.add(he1);
        this.delaunayQueue.add(he2);
        this.delaunayQueue.add(he3);
    }

    private void splitConstraint(HalfEdge he, Point2d p) {
        int i;
        assert (!he.isType(1)) : this.error("Attempting to split a boundary edge!");
        Point p0 = new Point(p);
        this.points.add(p0);
        HalfEdge he0 = this.addHalfEdge(p0, he.sibling.origin);
        he0.constrain();
        he0.sibling.constrain();
        he.sibling.origin = p0;
        p0.he = he0;
        this.updateHalfEdge(he0.sibling);
        he0.next = he.next;
        he.next = he0;
        he0.sibling.next = he.sibling;
        HalfEdge heTest = he.sibling;
        for (i = 0; i <= this.halfEdges.size(); ++i) {
            if (heTest.next == he.sibling) {
                heTest.next = he0.sibling;
                break;
            }
            heTest = heTest.next;
        }
        assert (i < this.halfEdges.size()) : this.error("Exhausted halfedges or points!");
    }

    public void removeInteriorPoint(Point p) {
        int i;
        assert (this.points.contains(p)) : this.error("Missing halfedge or point!");
        LinkedList<HalfEdge> star = new LinkedList<HalfEdge>();
        HalfEdge heSearch = p.he;
        for (i = 0; i <= this.halfEdges.size(); ++i) {
            star.add(heSearch);
            heSearch = heSearch.next.next.sibling;
            if (heSearch == p.he) break;
        }
        assert (i < this.halfEdges.size()) : this.error("Exhausted halfedges or points!");
        assert (star.size() >= 3);
        if (star.size() == 3) {
            for (HalfEdge he : star) {
                this.removeEdge(he);
            }
        } else {
            while (star.size() > 4) {
                HalfEdge heFlip = (HalfEdge)star.pop();
                Point p1 = heFlip.sibling.origin;
                Point p2 = heFlip.next.next.origin;
                Point p3 = heFlip.sibling.next.next.origin;
                if (this.orient(p2, p3, p) * this.orient(p2, p3, p1) < 0.0f) {
                    this.flipEdge(heFlip);
                    continue;
                }
                star.add(heFlip);
            }
            assert (star.size() == 4);
            heSearch = ((HalfEdge)star.get((int)0)).next;
            for (HalfEdge he : star) {
                this.removeEdge(he);
            }
            this.fillQuadrilateral(heSearch);
        }
        p.he = null;
        this.points.remove(p);
        p.setType(2);
        this.updateDelaunay();
    }

    private void removePoint(Point p) {
        int i;
        assert (this.points.contains(p)) : this.error("Missing halfedge or point!");
        assert (!p.isType(2)) : this.error("Re-removing point!");
        HalfEdge he = p.he;
        for (i = 0; i <= this.halfEdges.size(); ++i) {
            assert (he.origin == p) : this.error("Mismatched halfedge!");
            this.removeEdge(he);
            if (p.he == null) break;
            he = he.sibling.next;
        }
        assert (i < this.halfEdges.size()) : this.error("Exhausted halfedges or points!");
        this.points.remove(p);
        p.setType(2);
        p.he = null;
    }

    private void removeEdge(HalfEdge he) {
        assert (this.halfEdges.contains(he)) : this.error("Missing halfedge or point!");
        assert (!he.isType(1)) : this.error("Incorrect type!");
        HalfEdge hePrev = this.findPrevious(he);
        HalfEdge heSibPrev = this.findPrevious(he.sibling);
        this.halfEdges.remove(he);
        this.halfEdges.remove(he.sibling);
        this.delaunayQueue.remove(he);
        this.delaunayQueue.remove(he.sibling);
        if (he.isType(2)) {
            this.removedConstraints.add(he.next.origin);
        }
        if (he.sibling == hePrev) {
            he.origin.he = null;
            this.updateHalfEdge(he.next);
        } else if (he.next == he.sibling) {
            he.next.origin.he = null;
            this.updateHalfEdge(he.sibling.next);
        } else {
            this.updateHalfEdge(he.next);
            this.updateHalfEdge(he.sibling.next);
        }
        hePrev.next = he.sibling.next;
        heSibPrev.next = he.next;
    }

    private void clearNewBoundaryEdge(Point pStart, Point pEnd) {
        assert (this.points.contains(pStart)) : this.error("Missing halfedge or point!");
        assert (this.points.contains(pEnd)) : this.error("Missing halfedge or point!");
        assert (pStart != pEnd) : this.error("Identical halfedges or points!");
        FaceWalk walk = this.startFaceWalk(pStart, pEnd);
        if (walk.status == 0) {
            this.removeEdge(walk.he);
        } else {
            int i;
            HalfEdge heSearch = walk.he;
            for (i = 0; i <= this.halfEdges.size(); ++i) {
                Point pSearch0 = heSearch.origin;
                Point pSearch1 = heSearch.next.origin;
                if (pSearch1 == pEnd) break;
                if (this.between(pStart, pEnd, pSearch1)) {
                    if (pSearch1.isType(1)) {
                        heSearch = heSearch.next;
                        continue;
                    }
                    this.deleteQueue.add(pSearch1);
                    heSearch = heSearch.sibling.next;
                    continue;
                }
                if (this.intersectProper(pStart, pEnd, pSearch0, pSearch1)) {
                    this.removeEdge(heSearch);
                    this.deleteQueue.add(pSearch0);
                    heSearch = heSearch.sibling.next;
                    continue;
                }
                heSearch = heSearch.next;
            }
            assert (i < this.halfEdges.size()) : this.error("Exhausted halfedges or points!");
        }
    }

    protected final void updateHalfEdge(HalfEdge he) {
        assert (this.halfEdges.contains(he)) : this.error("Missing halfedge or point!");
        if (he.origin.isType(0)) {
            he.origin.he = he;
        }
    }

    public void updateDelaunay() {
        while (this.delaunayQueue.size() > 0) {
            Point p4;
            Point p3;
            Point p2;
            Point p1;
            HalfEdge he = this.delaunayQueue.pop();
            if (!he.isType(0) || !(this.incircle(p1 = he.next.origin, p2 = he.next.next.origin, p3 = he.origin, p4 = he.sibling.next.next.origin) > 0.0f) && !(this.incircle(p3, p4, p1, p2) > 0.0f)) continue;
            this.flipEdge(he);
        }
    }

    public void updateDelaunayAll() {
        this.delaunayQueue.addAll(this.halfEdges);
        this.updateDelaunay();
    }

    public void updateInteriorPoint(Point p) {
        assert (this.points.contains(p)) : this.error("Missing halfedge or point!");
        this.initRemoveConstraints(p);
        this.removeInteriorPoint(p);
        p = this.addInteriorPoint(p);
        p.setType(0);
        this.restoreConstraints(p);
        this.updateDelaunay();
    }

    public void updateBoundaryPointOutside(Point p) {
        int i;
        assert (this.points.contains(p)) : this.error("Missing halfedge or point!");
        this.initRemoveConstraints(p);
        HalfEdge he = p.he.next.next;
        assert (he.next == p.he) : this.error("Illegal polygonal region!");
        for (i = 0; i <= this.halfEdges.size() && !he.isType(1); ++i) {
            this.removeEdge(he.sibling);
            he = he.sibling.next.next;
        }
        assert (i < this.halfEdges.size()) : "Exhausted halfedges or points!";
        this.fillGeneralPolygon(p.he);
        this.restoreConstraints(p);
        this.updateDelaunay();
    }

    private boolean validateBoundary(BPoint bp) {
        int j;
        BPoint bpTest = bp.next;
        for (j = 3; j < this.nBoundary; ++j) {
            if (this.intersect(bp.prev, bp, bpTest, bpTest.next)) {
                return false;
            }
            bpTest = bpTest.next;
        }
        bpTest = bp.prev;
        for (j = 3; j < this.nBoundary; ++j) {
            if (this.intersect(bp, bp.next, bpTest.prev, bpTest)) {
                return false;
            }
            bpTest = bpTest.prev;
        }
        return true;
    }

    private boolean constrainEdge(HalfEdge he) {
        assert (this.halfEdges.contains(he)) : this.error("Missing halfedge or point!");
        if (he.isType(1)) {
            return false;
        }
        he.constrain();
        he.sibling.constrain();
        return true;
    }

    public void constrainAllEdges() {
        for (HalfEdge he : this.halfEdges) {
            if (he.isType(1)) continue;
            he.constrain();
        }
    }

    public void initRemoveConstraints(Point p) {
        assert (this.points.contains(p)) : this.error("Missing halfedge or point!");
        this.removeConstraintPeg = p;
        this.removedConstraints.clear();
    }

    public void restoreConstraints(Point p) {
        assert (this.points.contains(p)) : this.error("Missing halfedge or point!");
        assert (p == this.removeConstraintPeg) : this.error("Race condition!");
        this.removedConstraints.remove(p);
        for (Point p0 : this.removedConstraints) {
            if (p0.isType(2)) continue;
            try {
                this.addConstraint(p, p0);
            }
            catch (Exception exception) {}
        }
        this.removeConstraintPeg = null;
    }

    private boolean flipEdge(HalfEdge he) {
        assert (this.halfEdges.contains(he)) : this.error("Missing halfedge or point!");
        assert (!he.isType(1)) : this.error("Incorrect type!");
        HalfEdge he1 = he.next;
        HalfEdge he2 = he1.next;
        HalfEdge he3 = he.sibling.next;
        HalfEdge he4 = he3.next;
        he.origin = he2.origin;
        he.sibling.origin = he4.origin;
        this.updateHalfEdge(he3);
        this.updateHalfEdge(he1);
        he1.next = he;
        he.next = he4;
        he4.next = he1;
        he3.next = he.sibling;
        he.sibling.next = he2;
        he2.next = he3;
        this.delaunayQueue.add(he1);
        this.delaunayQueue.add(he2);
        this.delaunayQueue.add(he3);
        this.delaunayQueue.add(he4);
        return true;
    }

    public FaceWalk findFaceBruteForce(HalfEdge heStart, Point p) {
        float[] ccw = new float[3];
        this.clearFlags(0);
        for (HalfEdge he0 : this.halfEdges) {
            if (he0.isFlagged(0)) continue;
            HalfEdge he1 = he0.next;
            HalfEdge he2 = he1.next;
            assert (he2.next == he0) : this.error("Found non-face!");
            he0.flag(0);
            he1.flag(0);
            he2.flag(0);
            ccw[0] = this.orient(he0.origin, he1.origin, p);
            if (ccw[0] < 0.0f) continue;
            ccw[1] = this.orient(he1.origin, he2.origin, p);
            if (ccw[1] < 0.0f) continue;
            ccw[2] = this.orient(he2.origin, he0.origin, p);
            if (ccw[2] < 0.0f) continue;
            if (ccw[0] == 0.0f) {
                return new FaceWalk(he0, 0);
            }
            if (ccw[1] == 0.0f) {
                return new FaceWalk(he1, 0);
            }
            if (ccw[2] == 0.0f) {
                return new FaceWalk(he2, 0);
            }
            return new FaceWalk(he0, 1);
        }
        return null;
    }

    public FaceWalk findFace(HalfEdge heStart, Point p) {
        int i;
        float[] ccw = new float[3];
        LinkedList<HalfEdge> queue = new LinkedList<HalfEdge>();
        this.clearFlags(0);
        queue.add(heStart);
        queue.addAll(this.halfEdges);
        HalfEdge he0 = (HalfEdge)queue.pop();
        for (i = 0; i <= this.halfEdges.size(); ++i) {
            if (he0.isFlagged(0)) {
                he0 = (HalfEdge)queue.pop();
                continue;
            }
            HalfEdge he1 = he0.next;
            HalfEdge he2 = he1.next;
            assert (he2.next == he0) : this.error("Found non-face!");
            he0.flag(0);
            he1.flag(0);
            he2.flag(0);
            ccw[0] = this.orient(he0.origin, he1.origin, p);
            if (ccw[0] < 0.0f) {
                if (he0.sibling == null) {
                    return new FaceWalk(he0, 1);
                }
                he0 = he0.sibling;
                continue;
            }
            ccw[1] = this.orient(he1.origin, he2.origin, p);
            if (ccw[1] < 0.0f) {
                if (he1.sibling == null) {
                    return new FaceWalk(he0, 1);
                }
                he0 = he1.sibling;
                continue;
            }
            ccw[2] = this.orient(he2.origin, he0.origin, p);
            if (ccw[2] < 0.0f) {
                if (he2.sibling == null) {
                    return new FaceWalk(he0, 1);
                }
                he0 = he2.sibling;
                continue;
            }
            if (ccw[0] == 0.0f) {
                return new FaceWalk(he0, 0);
            }
            if (ccw[1] == 0.0f) {
                return new FaceWalk(he1, 0);
            }
            if (ccw[2] == 0.0f) {
                return new FaceWalk(he2, 0);
            }
            return new FaceWalk(he0, 1);
        }
        assert (i < this.halfEdges.size()) : this.error("Exhausted halfedges or points!");
        return null;
    }

    protected final HalfEdge findPrevious(HalfEdge he) {
        int i;
        assert (this.halfEdges.contains(he)) : this.error("Missing halfedge or point!", he);
        HalfEdge heSearch = he.next;
        for (i = 0; i <= this.halfEdges.size() && heSearch.next != he; ++i) {
            heSearch = heSearch.next;
        }
        assert (i < this.halfEdges.size()) : this.error("Exhausted halfedges or points!", he);
        assert (this.halfEdges.contains(heSearch)) : this.error("Missing halfedge or point!", heSearch);
        return heSearch;
    }

    FaceWalk startFaceWalk(Point pStart, Point pEnd) {
        int i;
        assert (this.points.contains(pStart)) : this.error("Missing halfedge or point!");
        assert (this.points.contains(pEnd)) : this.error("Missing halfedge or point!");
        assert (pStart != pEnd) : this.error("Identical halfedges or points!", pStart, pEnd);
        assert (!this.coincident(pStart, pEnd)) : this.error("Coincident points!", pStart, pEnd);
        HalfEdge hePrev = null;
        HalfEdge he = pStart.he;
        Point pTrailing = he.next.origin;
        float ccwTrailing = this.orient(pStart, pEnd, pTrailing);
        if (pStart.isType(1)) {
            if (pTrailing == pEnd) {
                return new FaceWalk(he, 0);
            }
            assert (ccwTrailing <= 0.0f) : this.error("Point lies outside boundary!", pEnd);
            if (ccwTrailing == 0.0f && (this.betweenProper(pStart, pEnd, pTrailing) || this.betweenProper(pStart, pTrailing, pEnd))) {
                return new FaceWalk(he, 1);
            }
        }
        for (i = 0; i <= this.halfEdges.size(); ++i) {
            hePrev = this.findPrevious(he);
            pTrailing = he.next.origin;
            Point pLeading = hePrev.origin;
            if (pTrailing == pEnd) {
                return new FaceWalk(he, 0);
            }
            if (pLeading == pEnd) {
                return new FaceWalk(hePrev, 0);
            }
            assert (!this.coincident(pTrailing, pEnd)) : this.error("Coincident points!", pTrailing, pEnd);
            assert (!this.coincident(pLeading, pEnd)) : this.error("Coincident points!", pLeading, pEnd);
            float ccwLeading = this.orient(pStart, pEnd, pLeading);
            if (ccwLeading >= 0.0f && ccwTrailing < 0.0f) {
                return new FaceWalk(he, 1);
            }
            ccwTrailing = ccwLeading;
            he = hePrev.sibling;
        }
        assert (i < this.halfEdges.size()) : "Exhausted halfedges or points!";
        return new FaceWalk(null, -1);
    }

    private static final float projNorm(Point2d a, Point2d b, Point2d c) {
        float x1 = b.x - a.x;
        float x2 = c.x - a.x;
        float y1 = b.y - a.y;
        float y2 = c.y - a.y;
        return (x1 * x2 + y1 * y2) / (x1 * x1 + y1 * y1);
    }

    private static final float cross(Point2d a, Point2d b, Point2d c) {
        float x1 = b.x - a.x;
        float x2 = c.x - a.x;
        float y1 = b.y - a.y;
        float y2 = c.y - a.y;
        return x1 * y2 - y1 * x2;
    }

    private static final float perpDistSq(Point2d a, Point2d b, Point2d c) {
        float x1 = b.x - a.x;
        float x2 = c.x - a.x;
        float y1 = b.y - a.y;
        float y2 = c.y - a.y;
        float cross = x1 * y2 - y1 * x2;
        float lenSq = cross * cross;
        return lenSq /= x1 * x1 + y1 * y1;
    }

    public final boolean coincident(Point2d a, Point2d b) {
        return a.distanceSquared(b) < this.epsilon;
    }

    public static final float projection(Point2d p1, Point2d p2, Point2d p) {
        float ax = p.x - p1.x;
        float ay = p.y - p1.y;
        float bx = p2.x - p1.x;
        float by = p2.y - p1.y;
        return (ax * bx + ay * by) / (bx * bx + by * by);
    }

    public static final Point2d intersection(Point2d a, Point2d b, Point2d c, Point2d d) throws Exception {
        float l2;
        float cdy = c.y - d.y;
        float cdx = c.x - d.x;
        float l1 = Math.abs((a.x - d.x) * cdy - (a.y - d.y) * cdx);
        if (l1 + (l2 = Math.abs((b.x - d.x) * cdy - (b.y - d.y) * cdx)) == 0.0f) {
            throw new Exception("Intersection called on parallel overlapping segments!");
        }
        float t = l1 / (l1 + l2);
        Point2d p = new Point2d((1.0f - t) * a.x + t * b.x, (1.0f - t) * a.y + t * b.y);
        return p;
    }

    public final boolean intersect(Point2d a, Point2d b, Point2d c, Point2d d) {
        if (this.intersectProper(a, b, c, d)) {
            return true;
        }
        return this.between(a, b, c) || this.between(a, b, d) || this.between(c, d, a) || this.between(c, d, b);
    }

    public final boolean intersectProper(Point2d a, Point2d b, Point2d c, Point2d d) {
        if (this.orient(a, b, c) == 0.0f || this.orient(a, b, d) == 0.0f || this.orient(c, d, a) == 0.0f || this.orient(c, d, b) == 0.0f) {
            return false;
        }
        return !(this.orient(a, b, c) * this.orient(a, b, d) > 0.0f) && !(this.orient(c, d, a) * this.orient(c, d, b) > 0.0f);
    }

    public final boolean between(Point2d a, Point2d b, Point2d c) {
        float d;
        if (this.coincident(a, c)) {
            return true;
        }
        if (this.coincident(b, c)) {
            return true;
        }
        return Mesh.perpDistSq(a, b, c) < this.epsilon && 0.0f < (d = Mesh.projNorm(a, b, c)) && d < 1.0f;
    }

    public final boolean betweenProper(Point2d a, Point2d b, Point2d c) {
        float d;
        if (this.coincident(a, c)) {
            return false;
        }
        if (this.coincident(b, c)) {
            return false;
        }
        return Mesh.perpDistSq(a, b, c) < this.epsilon && 0.0f < (d = Mesh.projNorm(a, b, c)) && d < 1.0f;
    }

    public final float orient(Point2d pa, Point2d pb, Point2d pc) {
        float detleft = (pa.x - pc.x) * (pb.y - pc.y);
        float detright = (pa.y - pc.y) * (pb.x - pc.x);
        float det = detleft - detright;
        if ((double)detleft > 0.0) {
            if ((double)detright <= 0.0) {
                return det;
            }
            float detsum = detleft + detright;
        } else if ((double)detleft < 0.0) {
            if ((double)detright >= 0.0) {
                return det;
            }
            float detsum = -detleft - detright;
        } else {
            return det;
        }
        return det;
    }

    public final float orientNonRobust(Point2d a, Point2d b, Point2d c) {
        if (Mesh.perpDistSq(a, b, c) < this.epsilon) {
            return 0.0f;
        }
        return Mesh.cross(a, b, c);
    }

    public final float incircle(Point2d pa, Point2d pb, Point2d pc, Point2d pd) {
        float adx = pa.x - pd.x;
        float bdx = pb.x - pd.x;
        float cdx = pc.x - pd.x;
        float ady = pa.y - pd.y;
        float bdy = pb.y - pd.y;
        float cdy = pc.y - pd.y;
        float bdxcdy = bdx * cdy;
        float cdxbdy = cdx * bdy;
        float alift = adx * adx + ady * ady;
        float cdxady = cdx * ady;
        float adxcdy = adx * cdy;
        float blift = bdx * bdx + bdy * bdy;
        float adxbdy = adx * bdy;
        float bdxady = bdx * ady;
        float clift = cdx * cdx + cdy * cdy;
        float det = alift * (bdxcdy - cdxbdy) + blift * (cdxady - adxcdy) + clift * (adxbdy - bdxady);
        if (bdxcdy < 0.0f) {
            bdxcdy = -bdxcdy;
        }
        if (cdxbdy < 0.0f) {
            cdxbdy = -cdxbdy;
        }
        if (cdxady < 0.0f) {
            cdxady = -cdxady;
        }
        if (adxcdy < 0.0f) {
            adxcdy = -adxcdy;
        }
        if (adxbdy < 0.0f) {
            adxbdy = -adxbdy;
        }
        if (bdxady < 0.0f) {
            bdxady = -bdxady;
        }
        return det;
    }

    public static final int incircleNonRobust(Point2d a, Point2d b, Point2d c, Point2d d) {
        float adx = a.x - d.x;
        float ady = a.y - d.y;
        float bdx = b.x - d.x;
        float bdy = b.y - d.y;
        float cdx = c.x - d.x;
        float cdy = c.y - d.y;
        float abdet = adx * bdy - bdx * ady;
        float bcdet = bdx * cdy - cdx * bdy;
        float cadet = cdx * ady - adx * cdy;
        float alift = adx * adx + ady * ady;
        float blift = bdx * bdx + bdy * bdy;
        float clift = cdx * cdx + cdy * cdy;
        return (int)Math.signum(alift * bcdet + blift * cadet + clift * abdet);
    }

    public static final float edgeDistanceSq(Point2d p1, Point2d p2, Point2d p) {
        float py;
        float px;
        float x2 = p2.x - p1.x;
        float y2 = p2.y - p1.y;
        float dotprod = (px = p.x - p1.x) * x2 + (py = p.y - p1.y) * y2;
        float projlenSq = (double)dotprod <= 0.0 ? 0.0f : ((double)(dotprod = (px = x2 - px) * x2 + (py = y2 - py) * y2) <= 0.0 ? 0.0f : dotprod * dotprod / (x2 * x2 + y2 * y2));
        float lenSq = px * px + py * py - projlenSq;
        if (lenSq < 0.0f) {
            lenSq = 0.0f;
        }
        return lenSq;
    }

    public final void test() {
        this.message("Testing.");
        this.testing = true;
        this.testPoints();
        this.testFaces();
        this.testHalfEdges();
        this.testHalfEdgePointers();
        this.testing = false;
    }

    private final void testPoints() {
        for (int i = 0; i < this.points.size(); ++i) {
            Point p1 = this.points.get(i);
            for (int j = 0; j < this.points.size(); ++j) {
                Point p2 = this.points.get(j);
                if (p1 == p2 || !this.coincident(p1, p2)) continue;
                System.err.printf("%s: Coincident points: %d, %d!\n", this.name, i, j);
            }
        }
    }

    private final void testFaces() {
        LinkedList<HalfEdge> used = new LinkedList<HalfEdge>();
        LinkedList<HalfEdge> face = new LinkedList<HalfEdge>();
        for (HalfEdge he : this.halfEdges) {
            int i;
            if (used.contains(he)) continue;
            face.clear();
            HalfEdge heTest = he;
            for (i = 0; i <= this.halfEdges.size(); ++i) {
                used.add(heTest);
                face.add(heTest);
                heTest = heTest.next;
                if (heTest == he) break;
            }
            assert (i < this.halfEdges.size()) : this.error("Exhausted halfedges or points!");
            if (face.size() <= 3) continue;
            System.out.printf("%s: polygon: (", this.name);
            for (HalfEdge he0 : face) {
                System.out.printf(" %d ", this.points.indexOf(he0.origin));
            }
            System.out.println(")");
        }
    }

    private final void testHalfEdges() {
        for (int i = 0; i < this.halfEdges.size(); ++i) {
            HalfEdge he = this.halfEdges.get(i);
            if (!this.points.contains(he.origin)) {
                System.err.printf("%s: Missing origin for halfedge %d!\n", this.name, i);
            }
            if (!this.halfEdges.contains(he.next)) {
                System.err.printf("%s: Missing next pointer for halfedge %d!\n", this.name, i);
            }
            if (this.coincident(he.origin, he.next.origin)) {
                System.err.printf("%s: Coincident endpoints for halfedge %d!\n", this.name, i);
            }
            if (he.isType(1)) continue;
            if (!this.halfEdges.contains(he.sibling)) {
                System.err.printf("%s: Missing sibling for halfedge %d!\n", this.name, i);
            }
            if (he.sibling.sibling != he) {
                System.err.printf("%s: Mismatched sibling for halfedge %d!\n", this.name, i);
            }
            if (he.next.origin == he.sibling.origin) continue;
            System.err.printf("%s: Unaligned next/sibling for halfedge %d\n", this.name, i);
        }
    }

    private final void testHalfEdgePointers() {
        for (int i = 0; i < this.points.size(); ++i) {
            Point p = this.points.get(i);
            if (!this.halfEdges.contains(p.he)) {
                System.err.printf("%s: Missing halfedge for point %d!\n", this.name, i);
            }
            if (p.he.origin == p) continue;
            System.err.printf("%s: Mismatched halfedge for point %d!\n", this.name, i);
        }
    }

    public void listPoints() {
        this.message("### POINT LIST ###");
        for (int i = 0; i < this.points.size(); ++i) {
            int ip;
            int ih;
            Point p = this.points.get(i);
            if (i % 20 == 0) {
                this.message("     ID | Halfedge |    Pair | Type");
            }
            try {
                ih = this.halfEdges.indexOf(p.he);
            }
            catch (NullPointerException e) {
                ih = -100000;
            }
            try {
                ip = this.halfEdges.indexOf(p.he);
            }
            catch (NullPointerException e) {
                ip = -100000;
            }
            this.message("%7d |  %7d | %7d |    %1d", i, ih, ip, p.type);
        }
    }

    public final void listHalfEdges() {
        this.message("### HALFEDGE LIST ###");
        for (int i = 0; i < this.halfEdges.size(); ++i) {
            int is;
            int ino;
            int io;
            int in;
            HalfEdge he = this.halfEdges.get(i);
            if (i % 20 == 0) {
                this.message("     ID ->    Next |  Origin ->    Next | Sibling | Type");
            }
            try {
                in = this.halfEdges.indexOf(he.next);
            }
            catch (NullPointerException e) {
                in = -100000;
            }
            try {
                io = this.points.indexOf(he.origin);
            }
            catch (NullPointerException e) {
                io = -100000;
            }
            try {
                ino = this.points.indexOf(he.next.origin);
            }
            catch (NullPointerException e) {
                ino = -100000;
            }
            try {
                is = this.halfEdges.indexOf(he.sibling);
            }
            catch (NullPointerException e) {
                is = -100000;
            }
            this.message("%7d -> %7d | %7d -> %7d | %7d | %1d", i, in, io, ino, is, he.type);
        }
    }

    public final void message(String s) {
        System.out.print(this.name);
        System.out.print(": ");
        System.out.print(s);
        System.out.print("\n");
    }

    public final void message(String s, Object ... args) {
        this.message(String.format(s, args));
    }

    protected final String error(String s) {
        this.listHalfEdges();
        this.listPoints();
        if (!this.testing) {
            this.test();
        }
        return s;
    }

    protected final String error(String s, Object ... args) {
        return this.error(s);
    }
}

