/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.niftygui;

import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.niftygui.NiftyJmeDisplay;
import de.lessvoid.nifty.spi.render.RenderFont;

public class RenderFontJme
implements RenderFont {
    private final BitmapFont font;
    private final BitmapText text;

    public RenderFontJme(String name, NiftyJmeDisplay display) {
        this.font = display.getAssetManager().loadFont(name);
        this.text = new BitmapText(this.font);
        float actualSize = this.font.getPreferredSize();
        this.text.setSize(actualSize);
    }

    public BitmapText createText() {
        return new BitmapText(this.font);
    }

    public BitmapFont getFont() {
        return this.font;
    }

    public BitmapText getText() {
        return this.text;
    }

    public int getHeight() {
        return (int)this.text.getLineHeight();
    }

    public int getWidth(String str) {
        if (str.isEmpty()) {
            return 0;
        }
        int result = (int)this.font.getLineWidth((CharSequence)str);
        return result;
    }

    public int getWidth(String str, float size) {
        return this.getWidth(str);
    }

    public int getCharacterAdvance(char currentCharacter, char nextCharacter, float size) {
        return Math.round(this.font.getCharacterAdvance(currentCharacter, nextCharacter, size));
    }

    public void dispose() {
    }
}

