/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.cursors.plugins.JmeCursor;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MyString;
import jme3utilities.nifty.BasicScreenController;
import jme3utilities.nifty.GuiApplication;
import jme3utilities.nifty.PopScreenController;
import jme3utilities.ui.InputMode;

class DialogInputMode
extends InputMode {
    private static final Logger logger = Logger.getLogger(DialogInputMode.class.getName());
    private static final String cursorAssetPath = "Textures/cursors/dialog.cur";
    public static final String name = "dialog";

    DialogInputMode() {
        super(name);
    }

    public void onAction(String actionString, boolean ongoing, float tpf) {
        if (ongoing) {
            logger.log(Level.INFO, "Got action {0}", MyString.quote((CharSequence)actionString));
        }
        GuiApplication guiApplication = (GuiApplication)this.simpleApplication;
        BasicScreenController controller = guiApplication.getEnabledScreen();
        boolean handled = true;
        if (this.isEnabled() && ongoing && controller != null) {
            PopScreenController psc = (PopScreenController)controller;
            assert (psc.getActiveDialog() != null);
            switch (actionString) {
                case "cancel": {
                    psc.closeActiveDialog();
                    break;
                }
                case "commit": {
                    psc.dialogCommit();
                    break;
                }
                case "invert": {
                    psc.invertDialogSelection();
                    break;
                }
                case "selectAll": {
                    psc.selectAllDialogItems();
                    break;
                }
                default: {
                    handled = false;
                    break;
                }
            }
        } else {
            handled = false;
        }
        if (!handled) {
            guiApplication.onAction(actionString, ongoing, tpf);
        }
    }

    protected void defaultBindings() {
        this.bind("cancel", new int[]{1});
        this.bind("commit", new int[]{28});
        this.bind("SIMPLEAPP_HideStats", new int[]{63});
    }

    public void initialize(AppStateManager stateManager, Application application) {
        AssetManager am = application.getAssetManager();
        JmeCursor cursor = (JmeCursor)am.loadAsset(cursorAssetPath);
        this.setCursor(cursor);
        super.initialize(stateManager, application);
    }
}

