/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty;

import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.controls.Button;
import de.lessvoid.nifty.controls.CheckBox;
import de.lessvoid.nifty.controls.CheckBoxStateChangedEvent;
import de.lessvoid.nifty.controls.RadioButton;
import de.lessvoid.nifty.controls.RadioButtonStateChangedEvent;
import de.lessvoid.nifty.controls.Slider;
import de.lessvoid.nifty.controls.SliderChangedEvent;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.screen.Screen;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.InitialState;
import jme3utilities.MyString;
import jme3utilities.Validate;
import jme3utilities.nifty.PopScreenController;
import jme3utilities.nifty.SliderTransform;
import jme3utilities.nifty.Tool;
import jme3utilities.nifty.dialog.DialogController;
import jme3utilities.nifty.dialog.FloatSliderDialog;

public class GuiScreenController
extends PopScreenController {
    private static final Logger logger = Logger.getLogger(GuiScreenController.class.getName());
    private boolean ignoreGuiChanges = false;
    private final Map<String, Tool> checkBoxMap = new TreeMap<String, Tool>();
    private final Map<String, Tool> radioButtonMap = new TreeMap<String, Tool>();
    private final Map<String, Tool> sliderMap = new TreeMap<String, Tool>();
    private final Map<String, Tool> toolMap = new TreeMap<String, Tool>();

    public GuiScreenController(String screenId, String xmlAssetPath, boolean enableDuringInitialization) {
        super(screenId, xmlAssetPath, enableDuringInitialization);
        assert (!this.isInitialized());
        assert (!this.isEnabled());
    }

    public GuiScreenController(String screenId, String xmlAssetPath, InitialState initialState) {
        super(screenId, xmlAssetPath, initialState);
        assert (!this.isInitialized());
        assert (!this.isEnabled());
    }

    public void disableCheckBox(String name) {
        Validate.nonNull((Object)name, (String)"check-box name");
        CheckBox checkBox = this.getCheckBox(name);
        checkBox.disable();
    }

    public Tool findTool(String toolName) {
        Validate.nonNull((Object)toolName, (String)"tool name");
        Tool tool = this.toolMap.get(toolName);
        return tool;
    }

    public Button getButton(String name) {
        Validate.nonNull((Object)name, (String)"button name");
        Screen screen = this.getScreen();
        String niftyId = name + "Button";
        Button button = (Button)screen.findNiftyControl(niftyId, Button.class);
        if (button == null) {
            String qnid = MyString.quote((CharSequence)niftyId);
            logger.log(Level.SEVERE, "missing button {0} in {1}", new Object[]{qnid, MyString.quote((CharSequence)this.getScreenId())});
            throw new IllegalArgumentException("missing button: " + qnid);
        }
        return button;
    }

    public CheckBox getCheckBox(String name) {
        Validate.nonNull((Object)name, (String)"check-box name");
        Screen screen = this.getScreen();
        String niftyId = name + "CheckBox";
        CheckBox box = (CheckBox)screen.findNiftyControl(niftyId, CheckBox.class);
        if (box == null) {
            String qnid = MyString.quote((CharSequence)niftyId);
            logger.log(Level.SEVERE, "missing check box {0} in {1}", new Object[]{qnid, MyString.quote((CharSequence)this.getScreenId())});
            throw new IllegalArgumentException("missing check box: " + qnid);
        }
        return box;
    }

    public Slider getSlider(String name) {
        Validate.nonNull((Object)name, (String)"slider name");
        Screen screen = this.getScreen();
        String niftyId = name + "Slider";
        Slider slider = (Slider)screen.findNiftyControl(niftyId, Slider.class);
        if (slider == null) {
            String qnid = MyString.quote((CharSequence)niftyId);
            logger.log(Level.SEVERE, "missing slider {0} in {1}", new Object[]{qnid, MyString.quote((CharSequence)this.getScreenId())});
            throw new IllegalArgumentException("missing slider: " + qnid);
        }
        return slider;
    }

    public boolean isChecked(String name) {
        Validate.nonNull((Object)name, (String)"check-box name");
        CheckBox checkBox = this.getCheckBox(name);
        boolean result = checkBox.isChecked();
        return result;
    }

    public boolean isIgnoreGuiChanges() {
        return this.ignoreGuiChanges;
    }

    public void mapCheckBox(String checkBoxName, Tool managingTool) {
        Validate.nonNull((Object)checkBoxName, (String)"check-box name");
        Validate.nonNull((Object)((Object)managingTool), (String)"managing tool");
        Tool oldMapping = this.checkBoxMap.put(checkBoxName, managingTool);
        assert (oldMapping == null);
    }

    public void mapRadioButton(String radioButtonName, Tool managingTool) {
        Validate.nonNull((Object)radioButtonName, (String)"radio-button name");
        Validate.nonNull((Object)((Object)managingTool), (String)"managing tool");
        Tool oldMapping = this.radioButtonMap.put(radioButtonName, managingTool);
        assert (oldMapping == null);
    }

    public void mapSlider(String sliderName, Tool managingTool) {
        Validate.nonNull((Object)sliderName, (String)"slider name");
        Validate.nonNull((Object)((Object)managingTool), (String)"managing tool");
        Tool oldMapping = this.sliderMap.put(sliderName, managingTool);
        assert (oldMapping == null);
    }

    public void mapTool(String toolName, Tool controller) {
        Validate.nonNull((Object)toolName, (String)"tool name");
        Validate.nonNull((Object)((Object)controller), (String)"controller");
        Tool oldMapping = this.toolMap.put(toolName, controller);
        if (oldMapping != null) {
            String message = "Two tools with the same name: " + MyString.quote((CharSequence)toolName);
            throw new IllegalArgumentException(message);
        }
    }

    @NiftyEventSubscriber(pattern=".*CheckBox")
    public void onCheckBoxChanged(String checkBoxId, CheckBoxStateChangedEvent event) {
        String checkBoxName;
        Tool manager;
        Validate.nonNull((Object)checkBoxId, (String)"check box ID");
        Validate.nonNull((Object)event, (String)"event");
        Validate.require((boolean)checkBoxId.endsWith("CheckBox"), (String)"ID ends with CheckBox");
        if (!this.isIgnoreGuiChanges() && this.hasStarted() && (manager = this.findCheckBoxTool(checkBoxName = MyString.removeSuffix((String)checkBoxId, (String)"CheckBox"))) != null) {
            boolean isChecked = event.isChecked();
            manager.onCheckBoxChanged(checkBoxName, isChecked);
        }
    }

    @NiftyEventSubscriber(pattern=".*RadioButton")
    public void onRadioButtonChanged(String buttonId, RadioButtonStateChangedEvent event) {
        String buttonName;
        Tool manager;
        Validate.nonNull((Object)buttonId, (String)"button ID");
        Validate.require((boolean)buttonId.endsWith("RadioButton"), (String)"expected suffix");
        Validate.nonNull((Object)event, (String)"event");
        if (!this.isIgnoreGuiChanges() && this.hasStarted() && (manager = this.findRadioButtonTool(buttonName = MyString.removeSuffix((String)buttonId, (String)"RadioButton"))) != null) {
            manager.onRadioButtonChanged(buttonName);
        }
    }

    @NiftyEventSubscriber(pattern=".*Slider")
    public void onSliderChanged(String sliderId, SliderChangedEvent event) {
        String sliderName;
        Tool manager;
        Validate.nonNull((Object)sliderId, (String)"slider ID");
        Validate.require((boolean)sliderId.endsWith("Slider"), (String)"expected suffix");
        Validate.nonNull((Object)event, (String)"event");
        if (!this.isIgnoreGuiChanges() && this.hasStarted() && (manager = this.findSliderTool(sliderName = MyString.removeSuffix((String)sliderId, (String)"Slider"))) != null) {
            manager.onSliderChanged(sliderName);
        }
    }

    @NiftyEventSubscriber(pattern=".*#dialogslider")
    public void onSliderChangedInDialog(String sliderId, SliderChangedEvent event) {
        DialogController dc;
        Validate.nonNull((Object)sliderId, (String)"slider ID");
        Validate.require((boolean)sliderId.endsWith("#dialogslider"), (String)"expected suffix");
        Validate.nonNull((Object)event, (String)"event");
        if (this.hasStarted() && (dc = this.getActiveDialog()) instanceof FloatSliderDialog) {
            Element dialogElement = this.getDialogElement();
            ((FloatSliderDialog)dc).onSliderChanged(dialogElement);
        }
    }

    public ColorRGBA readColorBank(String name, SliderTransform transform, ColorRGBA storeResult) {
        Validate.nonNull((Object)name, (String)"name");
        Validate.nonNull((Object)((Object)transform), (String)"transform");
        ColorRGBA color = storeResult == null ? new ColorRGBA() : storeResult;
        float r = this.readSlider(name + "R", transform);
        float g = this.readSlider(name + "G", transform);
        float b = this.readSlider(name + "B", transform);
        color.set(r, g, b, 1.0f);
        return color;
    }

    public float readSlider(String name, SliderTransform transform) {
        Validate.nonNull((Object)name, (String)"slider name");
        Validate.nonNull((Object)((Object)transform), (String)"transform");
        Slider slider = this.getSlider(name);
        float result = GuiScreenController.readSlider(slider, transform);
        return result;
    }

    public Vector3f readVectorBank(String name, SliderTransform transform, Vector3f storeResult) {
        Validate.nonNull((Object)name, (String)"name");
        Validate.nonNull((Object)((Object)transform), (String)"transform");
        Vector3f vector = storeResult == null ? new Vector3f() : storeResult;
        float x = this.readSlider("x" + name, transform);
        float y = this.readSlider("y" + name, transform);
        float z = this.readSlider("z" + name, transform);
        vector.set(x, y, z);
        return vector;
    }

    public void setButtonText(String name, String newText) {
        Validate.nonNull((Object)name, (String)"button name");
        Validate.nonNull((Object)newText, (String)"new text");
        Button button = this.getButton(name);
        if (newText.isEmpty()) {
            button.getElement().hide();
        } else {
            button.setText(newText);
            button.getElement().show();
        }
    }

    public void setChecked(String name, boolean newStatus) {
        Validate.nonNull((Object)name, (String)"check-box name");
        CheckBox checkBox = this.getCheckBox(name);
        checkBox.setChecked(newStatus);
        checkBox.enable();
    }

    public void setColorBank(String name, SliderTransform transform, ColorRGBA color) {
        Validate.nonNull((Object)name, (String)"name");
        Validate.nonNull((Object)((Object)transform), (String)"transform");
        this.setSlider(name + "R", transform, color.r);
        this.updateSliderStatus(name + "R", color.r, "");
        this.setSlider(name + "G", transform, color.g);
        this.updateSliderStatus(name + "G", color.g, "");
        this.setSlider(name + "B", transform, color.b);
        this.updateSliderStatus(name + "B", color.b, "");
    }

    public void setIgnoreGuiChanges(boolean newSetting) {
        this.ignoreGuiChanges = newSetting;
    }

    public void setRadioButton(String elementId) {
        Validate.nonNull((Object)elementId, (String)"element id");
        RadioButton button = (RadioButton)this.getScreen().findNiftyControl(elementId, RadioButton.class);
        try {
            button.select();
        }
        catch (NullPointerException exception) {
            logger.log(Level.WARNING, "screen {0} lacks radio button {1}", new Object[]{MyString.quote((CharSequence)this.getScreenId()), MyString.quote((CharSequence)elementId)});
        }
    }

    public void setRadioButtonEnabled(String elementId, boolean newState) {
        Validate.nonNull((Object)elementId, (String)"element id");
        RadioButton button = (RadioButton)this.getScreen().findNiftyControl(elementId, RadioButton.class);
        try {
            if (newState) {
                button.enable();
            } else {
                button.disable();
            }
        }
        catch (NullPointerException exception) {
            logger.log(Level.WARNING, "screen {0} lacks radio button {1}", new Object[]{MyString.quote((CharSequence)this.getScreenId()), MyString.quote((CharSequence)elementId)});
        }
    }

    public void setSlider(String name, SliderTransform transform, float inputValue) {
        Validate.nonNull((Object)name, (String)"name");
        Validate.nonNull((Object)((Object)transform), (String)"transform");
        Slider slider = this.getSlider(name);
        GuiScreenController.setSlider(slider, transform, inputValue);
    }

    public void setSliderEnabled(String name, boolean newState) {
        Validate.nonNull((Object)name, (String)"name");
        Slider slider = this.getSlider(name);
        if (newState) {
            slider.enable();
        } else {
            slider.disable();
        }
    }

    public void setStatusText(String elementId, String newText) {
        Validate.nonNull((Object)elementId, (String)"element id");
        Validate.nonNull((Object)newText, (String)"text");
        Element element = this.getScreen().findElementById(elementId);
        if (element == null) {
            logger.log(Level.WARNING, "screen {0} lacks element {1}", new Object[]{MyString.quote((CharSequence)this.getScreenId()), MyString.quote((CharSequence)elementId)});
            return;
        }
        TextRenderer textRenderer = (TextRenderer)element.getRenderer(TextRenderer.class);
        if (textRenderer != null) {
            textRenderer.setText(newText);
            return;
        }
        logger.log(Level.WARNING, "Nifty element {0} lacks a text renderer", MyString.quote((CharSequence)elementId));
    }

    public void updateSliderStatus(String name, float value, String statusSuffix) {
        Validate.nonNull((Object)name, (String)"name");
        Validate.nonNull((Object)statusSuffix, (String)"status suffix");
        String format = FastMath.abs((float)value) >= 5.0f ? "%.1f" : (FastMath.abs((float)value) >= 0.5f ? "%.2f" : (FastMath.abs((float)value) >= 0.05f ? "%.3f" : "%.4f"));
        String valueString = String.format(format, Float.valueOf(value));
        valueString = MyString.trimFloat((String)valueString);
        String statusText = String.format("%s = %s%s", name, valueString, statusSuffix);
        String statusName = name + "SliderStatus";
        this.setStatusText(statusName, statusText);
    }

    protected Tool findCheckBoxTool(String checkBoxName) {
        Validate.nonNull((Object)checkBoxName, (String)"check-box name");
        Tool managingTool = this.checkBoxMap.get(checkBoxName);
        return managingTool;
    }

    protected Tool findRadioButtonTool(String buttonName) {
        Validate.nonNull((Object)buttonName, (String)"radio-button name");
        Tool result = this.radioButtonMap.get(buttonName);
        return result;
    }

    protected Tool findSliderTool(String sliderName) {
        Validate.nonNull((Object)sliderName, (String)"slider name");
        Tool managingTool = this.sliderMap.get(sliderName);
        return managingTool;
    }

    private static float readSlider(Slider slider, SliderTransform transform) {
        float transformed;
        Validate.nonNull((Object)((Object)transform), (String)"transform");
        float max = slider.getMax();
        float min = slider.getMin();
        float raw = slider.getValue();
        float reversed = min + max - raw;
        switch (transform) {
            case None: {
                transformed = raw;
                break;
            }
            case Reversed: {
                transformed = reversed;
                break;
            }
            case Log10: {
                transformed = FastMath.pow((float)10.0f, (float)raw);
                break;
            }
            case Log2: {
                transformed = FastMath.pow((float)2.0f, (float)raw);
                break;
            }
            case ReversedLog10: {
                transformed = FastMath.pow((float)10.0f, (float)reversed);
                break;
            }
            case ReversedLog2: {
                transformed = FastMath.pow((float)2.0f, (float)reversed);
                break;
            }
            default: {
                throw new IllegalArgumentException("transform = " + (Object)((Object)transform));
            }
        }
        return transformed;
    }

    private static void setSlider(Slider slider, SliderTransform transform, float inputValue) {
        float raw;
        Validate.nonNull((Object)((Object)transform), (String)"transform");
        float max = slider.getMax();
        float min = slider.getMin();
        switch (transform) {
            case None: {
                raw = inputValue;
                break;
            }
            case Reversed: {
                raw = min + max - inputValue;
                break;
            }
            case Log10: {
                raw = FastMath.log((float)inputValue, (float)10.0f);
                break;
            }
            case Log2: {
                raw = FastMath.log((float)inputValue, (float)2.0f);
                break;
            }
            case ReversedLog10: {
                raw = min + max - FastMath.log((float)inputValue, (float)10.0f);
                break;
            }
            case ReversedLog2: {
                raw = min + max - FastMath.log((float)inputValue, (float)2.0f);
                break;
            }
            default: {
                throw new IllegalArgumentException("transform = " + (Object)((Object)transform));
            }
        }
        slider.setValue(raw);
    }
}

