/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty;

import de.lessvoid.nifty.NiftyMouse;
import de.lessvoid.nifty.builder.ControlBuilder;
import de.lessvoid.nifty.builder.ElementBuilder;
import de.lessvoid.nifty.builder.PanelBuilder;
import de.lessvoid.nifty.builder.PopupBuilder;
import de.lessvoid.nifty.controls.Button;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.Menu;
import de.lessvoid.nifty.controls.MenuItemActivatedEvent;
import de.lessvoid.nifty.controls.TextField;
import de.lessvoid.nifty.controls.button.builder.ButtonBuilder;
import de.lessvoid.nifty.controls.label.builder.LabelBuilder;
import de.lessvoid.nifty.controls.scrollpanel.builder.ScrollPanelBuilder;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.nifty.tools.SizeValueType;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.InitialState;
import jme3utilities.MyString;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;
import jme3utilities.nifty.BasicScreenController;
import jme3utilities.nifty.PopupMenu;
import jme3utilities.nifty.PopupMenuBuilder;
import jme3utilities.nifty.dialog.DialogController;
import jme3utilities.nifty.dialog.MinimalDialog;
import jme3utilities.nifty.dialog.MultiSelectDialog;
import jme3utilities.ui.InputMode;
import org.bushe.swing.event.EventTopicSubscriber;

public class PopScreenController
extends BasicScreenController {
    private static final Logger logger = Logger.getLogger(PopScreenController.class.getName());
    private float warpX = 0.0f;
    private float warpY = 0.0f;
    private DialogController dialogController = null;
    private Element dialogElement = null;
    private PopupMenu activePopupMenu = null;
    private String dialogActionPrefix = null;

    public PopScreenController(String screenId, String xmlAssetPath, boolean enableDuringInitialization) {
        super(screenId, xmlAssetPath, enableDuringInitialization);
        assert (!this.isInitialized());
        assert (!this.isEnabled());
    }

    public PopScreenController(String screenId, String xmlAssetPath, InitialState initialState) {
        super(screenId, xmlAssetPath, initialState);
        assert (!this.isInitialized());
        assert (!this.isEnabled());
    }

    void closeActiveDialog() {
        if (this.dialogController == null) {
            throw new IllegalStateException("no active dialog");
        }
        String popupId = this.dialogElement.getId();
        this.getNifty().closePopup(popupId);
        this.dialogActionPrefix = null;
        this.setDialogElement(null);
        InputMode.resumeLifo();
        this.dialogController = null;
    }

    public void closeActivePopupMenu() {
        if (this.activePopupMenu == null) {
            throw new IllegalStateException("no active popup menu");
        }
        this.activePopupMenu.close();
        this.activePopupMenu = this.activePopupMenu.getParent();
        if (this.activePopupMenu != null) {
            this.activePopupMenu.setEnabled(true);
        } else {
            InputMode.resumeLifo();
        }
    }

    public void closeAllPopups() {
        if (this.hasActivePopupMenu()) {
            this.closePopupMenu(this.activePopupMenu);
        } else if (this.dialogController != null) {
            this.closeActiveDialog();
        }
    }

    void closePopupMenu(PopupMenu popupMenu) {
        Validate.nonNull((Object)popupMenu, (String)"popup menu");
        if (popupMenu != this.activePopupMenu) {
            return;
        }
        popupMenu.close();
        for (PopupMenu ancestor = popupMenu.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            ancestor.close();
        }
        this.activePopupMenu = null;
        InputMode.resumeLifo();
    }

    void dialogCommit() {
        if (this.dialogController == null) {
            throw new IllegalStateException("no active dialog");
        }
        if (!this.dialogController.allowCommit(this.dialogElement)) {
            return;
        }
        if (this.dialogActionPrefix == null) {
            this.closeActiveDialog();
        } else {
            String suffix = this.dialogController.commitSuffix(this.dialogElement);
            String commitAction = this.dialogActionPrefix + suffix;
            this.closeActiveDialog();
            this.perform(commitAction);
        }
    }

    public DialogController getActiveDialog() {
        return this.dialogController;
    }

    boolean hasActivePopupMenu() {
        return this.activePopupMenu != null;
    }

    void invertDialogSelection() {
        if (this.dialogController == null) {
            throw new IllegalStateException("no active dialog");
        }
        String popupId = this.dialogElement.getId();
        assert (popupId != null);
        ListBox listBox = (ListBox)this.dialogElement.findNiftyControl("#box", ListBox.class);
        List selectedIndices = listBox.getSelectedIndices();
        int itemCount = listBox.itemCount();
        for (int itemIndex = 0; itemIndex < itemCount; ++itemIndex) {
            boolean isSelected = selectedIndices.contains(itemIndex);
            if (isSelected) {
                listBox.deselectItemByIndex(itemIndex);
                continue;
            }
            listBox.selectItemByIndex(itemIndex);
        }
    }

    void selectAllDialogItems() {
        if (this.dialogController == null) {
            throw new IllegalStateException("no active dialog");
        }
        String popupId = this.dialogElement.getId();
        assert (popupId != null);
        ListBox listBox = (ListBox)this.dialogElement.findNiftyControl("#box", ListBox.class);
        List selectedIndices = listBox.getSelectedIndices();
        int itemCount = listBox.itemCount();
        for (int itemIndex = 0; itemIndex < itemCount; ++itemIndex) {
            boolean isSelected = selectedIndices.contains(itemIndex);
            if (isSelected) continue;
            listBox.selectItemByIndex(itemIndex);
        }
    }

    void selectMenuItem(int index) {
        Validate.nonNegative((int)index, (String)"index");
        if (this.activePopupMenu == null) {
            throw new IllegalStateException("no active popup menu");
        }
        String actionString = this.activePopupMenu.actionString(index);
        if (actionString == null) {
            return;
        }
        PopupMenu oldPopupMenu = this.activePopupMenu;
        this.perform(actionString);
        this.closePopupMenu(oldPopupMenu);
    }

    public void setSubmenuWarp(float newWarpX, float newWarpY) {
        this.warpX = newWarpX;
        this.warpY = newWarpY;
    }

    public void showConfirmDialog(String promptMessage, String commitLabel, String actionString, DialogController controller) {
        Validate.nonNull((Object)promptMessage, (String)"prompt message");
        Validate.nonNull((Object)commitLabel, (String)"commit-button label");
        Validate.nonNull((Object)actionString, (String)"action string");
        Validate.nonNull((Object)controller, (String)"controller");
        this.dialogElement = this.getNifty().createPopup("dialogs/confirm");
        String popupId = this.dialogElement.getId();
        assert (popupId != null);
        Element prompt = this.dialogElement.findElementById("#prompt");
        TextRenderer textRenderer = (TextRenderer)prompt.getRenderer(TextRenderer.class);
        textRenderer.setText(promptMessage);
        Button commitButton = (Button)this.dialogElement.findNiftyControl("#commit", Button.class);
        commitButton.setText(commitLabel);
        this.activateDialog(popupId, actionString, "#commit", controller);
    }

    public void showInfoDialog(String titleText, String bodyText) {
        Validate.nonNull((Object)titleText, (String)"title text");
        String[] lines = bodyText.split("\n");
        int numLines = lines.length;
        int numChars = bodyText.length();
        if (numLines > 10 || numChars > 200) {
            String masterId = this.registerInfoScrollDialog(numLines + 2);
            this.dialogElement = this.getNifty().createPopup(masterId);
        } else {
            this.dialogElement = this.getNifty().createPopup("dialogs/info10");
        }
        String popupId = this.dialogElement.getId();
        assert (popupId != null);
        Element titleElement = this.dialogElement.findElementById("#title");
        TextRenderer renderer = (TextRenderer)titleElement.getRenderer(TextRenderer.class);
        renderer.setText(titleText);
        Element lineElement = this.dialogElement.findElementById("#1");
        renderer = (TextRenderer)lineElement.getRenderer(TextRenderer.class);
        renderer.setText(bodyText);
        MinimalDialog controller = new MinimalDialog();
        this.activateDialog(popupId, null, null, controller);
    }

    public void showMultiSelectDialog(String promptMessage, String actionPrefix, MultiSelectDialog<?> controller) {
        Validate.nonNull((Object)promptMessage, (String)"prompt message");
        Validate.nonNull((Object)actionPrefix, (String)"action prefix");
        Validate.nonNull(controller, (String)"controller");
        this.dialogElement = this.getNifty().createPopup("dialogs/multiSelect");
        String popupId = this.dialogElement.getId();
        assert (popupId != null);
        Element titleElement = this.dialogElement.findElementById("#prompt");
        TextRenderer renderer = (TextRenderer)titleElement.getRenderer(TextRenderer.class);
        renderer.setText(promptMessage);
        ListBox listBox = (ListBox)this.dialogElement.findNiftyControl("#box", ListBox.class);
        List<String> allDescriptions = controller.listItemDescriptions();
        listBox.addAllItems(allDescriptions);
        Button commitButton = (Button)this.dialogElement.findNiftyControl("#commit", Button.class);
        String commitButtonText = controller.commitDescription();
        commitButton.setText(commitButtonText);
        this.activateDialog(popupId, actionPrefix, "#commit", controller);
    }

    public void showPopupMenu(String actionPrefix, List<String> itemList) {
        Validate.nonNull((Object)actionPrefix, (String)"action prefix");
        Validate.nonNull(itemList, (String)"item list");
        String[] itemArray = MyString.toArray(itemList);
        this.showPopupMenu(actionPrefix, itemArray);
    }

    public void showPopupMenu(String actionPrefix, PopupMenuBuilder menuBuilder) {
        Validate.nonNull((Object)menuBuilder, (String)"menuBuilder");
        Validate.nonNull((Object)actionPrefix, (String)"action prefix");
        logger.log(Level.INFO, "actionPrefix = {0}", MyString.quote((CharSequence)actionPrefix));
        if (!menuBuilder.isEmpty()) {
            String[] itemArray = menuBuilder.copyItems();
            String[] iconArray = menuBuilder.copyIconAssetPaths();
            this.showPopupMenu(actionPrefix, itemArray, iconArray);
        }
    }

    public void showPopupMenu(String actionPrefix, String[] itemArray) {
        Validate.nonNull((Object)actionPrefix, (String)"action prefix");
        Validate.nonNull((Object)itemArray, (String)"item array");
        int numItems = itemArray.length;
        String[] iconArray = new String[numItems];
        this.showPopupMenu(actionPrefix, itemArray, iconArray);
    }

    public void showPopupMenu(String actionPrefix, String[] itemArray, String[] iconArray) {
        Validate.nonNull((Object)actionPrefix, (String)"prefix");
        Validate.nonNull((Object)itemArray, (String)"item array");
        Validate.nonNull((Object)itemArray, (String)"icon array");
        Validate.require((itemArray.length == iconArray.length ? 1 : 0) != 0, (String)"equal-length arrays");
        Element element = this.getNifty().createPopup("popup-menu");
        Menu menu = (Menu)element.findNiftyControl("#menu", Menu.class);
        assert (menu != null);
        int maxChars = 0;
        for (int itemIndex = 0; itemIndex < itemArray.length; ++itemIndex) {
            String item = itemArray[itemIndex];
            String displayText = itemIndex < 9 ? String.format("%d] %s", itemIndex + 1, item) : (itemIndex == 9 ? String.format("0] %s", item) : item);
            int numChars = displayText.length();
            if (numChars > maxChars) {
                maxChars = numChars;
            }
            displayText = displayText.replace("$", "\\$");
            String displayIcon = iconArray[itemIndex];
            menu.addMenuItem(displayText, displayIcon, (Object)item);
        }
        int pixelWidth = 50 + 7 * maxChars;
        SizeValue width = new SizeValue(pixelWidth, SizeValueType.Pixel);
        menu.setWidth(width);
        String elementId = element.getId();
        assert (elementId != null);
        PopupMenu popupMenu = this.activePopupMenu == null ? new PopupMenu(elementId, actionPrefix, itemArray, this) : new PopupMenu(elementId, actionPrefix, itemArray, this.activePopupMenu);
        this.activatePopupMenu(popupMenu, (Menu<String>)menu);
    }

    public void showTextAndCheckDialog(String promptMessage, String defaultValue, String actionPrefix, DialogController controller) {
        Validate.nonNull((Object)promptMessage, (String)"prompt message");
        Validate.nonNull((Object)defaultValue, (String)"default value");
        Validate.nonNull((Object)actionPrefix, (String)"action prefix");
        Validate.nonNull((Object)controller, (String)"controller");
        this.showTextAndCheckDialog(promptMessage, defaultValue, "", actionPrefix, controller);
    }

    public void showTextAndCheckDialog(String promptMessage, CharSequence defaultValue, String commitLabel, String actionPrefix, DialogController controller) {
        Validate.nonNull((Object)promptMessage, (String)"prompt message");
        Validate.nonNull((Object)defaultValue, (String)"default value");
        Validate.nonNull((Object)commitLabel, (String)"commit-button label");
        Validate.nonNull((Object)actionPrefix, (String)"action prefix");
        Validate.nonNull((Object)controller, (String)"controller");
        this.dialogElement = this.getNifty().createPopup("dialogs/text-and-check");
        String popupId = this.dialogElement.getId();
        assert (popupId != null);
        Element prompt = this.dialogElement.findElementById("#prompt");
        TextRenderer textRenderer = (TextRenderer)prompt.getRenderer(TextRenderer.class);
        textRenderer.setText(promptMessage);
        TextField textField = (TextField)this.dialogElement.findNiftyControl("#textfield", TextField.class);
        textField.setText(defaultValue);
        Button commitButton = (Button)this.dialogElement.findNiftyControl("#commit", Button.class);
        commitButton.setText(commitLabel);
        this.activateDialog(popupId, actionPrefix, "#textfield", controller);
    }

    public void showTextAndSliderDialog(String promptMessage, String defaultValue, String actionPrefix, DialogController controller) {
        Validate.nonNull((Object)promptMessage, (String)"prompt message");
        Validate.nonNull((Object)defaultValue, (String)"default value");
        Validate.nonNull((Object)actionPrefix, (String)"action prefix");
        Validate.nonNull((Object)controller, (String)"controller");
        this.showTextAndSliderDialog(promptMessage, defaultValue, "", actionPrefix, controller);
    }

    public void showTextAndSliderDialog(String promptMessage, CharSequence defaultValue, String commitLabel, String actionPrefix, DialogController controller) {
        Validate.nonNull((Object)promptMessage, (String)"prompt message");
        Validate.nonNull((Object)defaultValue, (String)"default value");
        Validate.nonNull((Object)commitLabel, (String)"commit-button label");
        Validate.nonNull((Object)actionPrefix, (String)"action prefix");
        Validate.nonNull((Object)controller, (String)"controller");
        this.dialogElement = this.getNifty().createPopup("dialogs/text-and-slider");
        String popupId = this.dialogElement.getId();
        assert (popupId != null);
        Element prompt = this.dialogElement.findElementById("#prompt");
        TextRenderer textRenderer = (TextRenderer)prompt.getRenderer(TextRenderer.class);
        textRenderer.setText(promptMessage);
        TextField textField = (TextField)this.dialogElement.findNiftyControl("#textfield", TextField.class);
        textField.setText(defaultValue);
        Button commitButton = (Button)this.dialogElement.findNiftyControl("#commit", Button.class);
        commitButton.setText(commitLabel);
        this.activateDialog(popupId, actionPrefix, "#textfield", controller);
    }

    public void showTextEntryDialog(String promptMessage, String defaultValue, String actionPrefix, DialogController controller) {
        Validate.nonNull((Object)promptMessage, (String)"prompt message");
        Validate.nonNull((Object)defaultValue, (String)"default value");
        Validate.nonNull((Object)actionPrefix, (String)"action prefix");
        Validate.nonNull((Object)controller, (String)"controller");
        this.showTextEntryDialog(promptMessage, defaultValue, "", actionPrefix, controller);
    }

    public void showTextEntryDialog(String promptMessage, CharSequence defaultValue, String commitLabel, String actionPrefix, DialogController controller) {
        Validate.nonNull((Object)promptMessage, (String)"prompt message");
        Validate.nonNull((Object)defaultValue, (String)"default value");
        Validate.nonNull((Object)commitLabel, (String)"commit-button label");
        Validate.nonNull((Object)actionPrefix, (String)"action prefix");
        Validate.nonNull((Object)controller, (String)"controller");
        this.dialogElement = this.getNifty().createPopup("dialogs/text-entry");
        String popupId = this.dialogElement.getId();
        assert (popupId != null);
        Element prompt = this.dialogElement.findElementById("#prompt");
        TextRenderer textRenderer = (TextRenderer)prompt.getRenderer(TextRenderer.class);
        textRenderer.setText(promptMessage);
        TextField textField = (TextField)this.dialogElement.findNiftyControl("#textfield", TextField.class);
        textField.setText(defaultValue);
        Button commitButton = (Button)this.dialogElement.findNiftyControl("#commit", Button.class);
        commitButton.setText(commitLabel);
        this.activateDialog(popupId, actionPrefix, "#textfield", controller);
    }

    protected void activateDialog(String popupId, String actionPrefix, String focusElementId, DialogController controller) {
        Validate.nonNull((Object)popupId, (String)"popup id");
        Validate.nonNull((Object)controller, (String)"controller");
        Screen screen = this.getNifty().getCurrentScreen();
        assert (screen != null);
        Element focusElement = focusElementId == null ? null : this.dialogElement.findElementById(focusElementId);
        this.getNifty().showPopup(screen, popupId, focusElement);
        InputMode dialogMode = InputMode.findMode((String)"dialog");
        InputMode.suspendAndActivate((InputMode)dialogMode);
        this.dialogActionPrefix = actionPrefix;
        this.dialogController = controller;
    }

    protected Element getDialogElement() {
        return this.dialogElement;
    }

    protected void setDialogElement(Element element) {
        this.dialogElement = element;
    }

    public void update(float tpf) {
        super.update(tpf);
        if (this.dialogController != null) {
            this.dialogController.update(this.dialogElement, tpf);
        }
    }

    private void activatePopupMenu(PopupMenu popupMenu, Menu<String> menu) {
        Validate.nonNull((Object)popupMenu, (String)"popup menu");
        Screen screen = this.getNifty().getCurrentScreen();
        String controlId = menu.getId();
        this.getNifty().subscribe(screen, controlId, MenuItemActivatedEvent.class, (EventTopicSubscriber)popupMenu);
        if (this.activePopupMenu != null) {
            NiftyMouse mouse = this.getNifty().getNiftyMouse();
            float floatX = mouse.getX();
            float floatY = mouse.getY();
            String parentMenuId = this.activePopupMenu.getElementId() + "#menu";
            Element parentMenu = screen.findElementById(parentMenuId);
            floatX = MyMath.lerp((float)this.warpX, (float)floatX, (float)parentMenu.getX());
            floatY = MyMath.lerp((float)this.warpY, (float)floatY, (float)parentMenu.getY());
            int intX = Math.round(floatX);
            int intY = Math.round(floatY);
            mouse.setMousePosition(intX, intY);
        }
        String elementId = popupMenu.getElementId();
        this.getNifty().showPopup(screen, elementId, null);
        if (this.activePopupMenu == null) {
            InputMode menuMode = InputMode.findMode((String)"menu");
            InputMode.suspendAndActivate((InputMode)menuMode);
        } else {
            this.activePopupMenu.setEnabled(false);
        }
        this.activePopupMenu = popupMenu;
    }

    private String registerInfoScrollDialog(int capacity) {
        Validate.positive((int)capacity, (String)"number of lines");
        int pixelHeight = 16 * capacity;
        final String heightText = pixelHeight + "px";
        final ElementBuilder.VAlign top = ElementBuilder.VAlign.Top;
        String masterId = "dialogs/infoScroll" + capacity;
        new PopupBuilder(masterId){
            {
                super(arg0);
                this.backgroundColor("#000a");
                this.childLayoutCenter();
                this.panel(new PanelBuilder(){
                    {
                        this.childLayoutVertical();
                        this.backgroundColor("#aaaf");
                        this.padding("8px");
                        this.height("300px");
                        this.width("630px");
                        this.control((ControlBuilder)new LabelBuilder("#title"));
                        this.panel(new PanelBuilder(){
                            {
                                this.height("8px");
                            }
                        });
                        this.control((ControlBuilder)new ScrollPanelBuilder(""){
                            {
                                this.height("220px");
                                this.parameter("horizontal", "false");
                                this.parameter("pageSizeY", "200");
                                this.parameter("stepSizeY", "50");
                                this.panel(new PanelBuilder(){
                                    {
                                        this.childLayoutVertical();
                                        this.backgroundColor("#acff");
                                        this.padding("0px,6px");
                                        this.height(heightText);
                                        this.width("590px");
                                        this.control((ControlBuilder)new LabelBuilder("#1"){
                                            {
                                                this.color("#000f");
                                                this.textVAlign(top);
                                                this.wrap(true);
                                            }
                                        });
                                    }
                                });
                            }
                        });
                        this.panel(new PanelBuilder(){
                            {
                                this.height("8px");
                            }
                        });
                        this.panel(new PanelBuilder(){
                            {
                                this.childLayoutHorizontal();
                                this.panel(new PanelBuilder());
                                this.control((ControlBuilder)new ButtonBuilder("#cancel"){
                                    {
                                        this.label("Dismiss");
                                        this.width("50px");
                                        this.interactOnRelease("performActive(cancel)");
                                    }
                                });
                                this.panel(new PanelBuilder());
                            }
                        });
                    }
                });
            }
        }.registerPopup(this.getNifty());
        return masterId;
    }
}

