/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class PopupMenuBuilder {
    private static final Logger logger = Logger.getLogger(PopupMenuBuilder.class.getName());
    protected final Map<String, String> itemMap = new HashMap<String, String>(40);

    public void add(String item) {
        Validate.nonEmpty((String)item, (String)"item");
        assert (!this.itemMap.containsKey(item)) : item;
        this.itemMap.put(item, null);
    }

    public void add(String item, String iconAssetPath) {
        Validate.nonEmpty((String)item, (String)"item");
        assert (!this.itemMap.containsKey(item)) : item;
        this.itemMap.put(item, iconAssetPath);
    }

    public void addAll(Iterable<String> items) {
        Validate.nonNull(items, (String)"items");
        for (String item : items) {
            this.add(item);
        }
    }

    public String[] copyIconAssetPaths() {
        int numIcons = this.itemMap.size();
        String[] result = new String[numIcons];
        int i = 0;
        Iterator<String> iterator = this.itemMap.values().iterator();
        while (iterator.hasNext()) {
            String icontAssetPath;
            result[i] = icontAssetPath = iterator.next();
            ++i;
        }
        return result;
    }

    public String[] copyItems() {
        int numItems = this.itemMap.size();
        String[] result = new String[numItems];
        int i = 0;
        Iterator<String> iterator = this.itemMap.keySet().iterator();
        while (iterator.hasNext()) {
            String item;
            result[i] = item = iterator.next();
            ++i;
        }
        return result;
    }

    public boolean hasItem(String item) {
        Validate.nonEmpty((String)item, (String)"item");
        boolean result = this.itemMap.containsKey(item);
        return result;
    }

    public boolean isEmpty() {
        boolean result = this.itemMap.isEmpty();
        return result;
    }

    public void reset() {
        this.itemMap.clear();
    }
}

