/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import de.lessvoid.nifty.controls.Window;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.screen.Screen;
import java.util.logging.Logger;
import jme3utilities.InitialState;
import jme3utilities.Validate;
import jme3utilities.nifty.BasicScreenController;
import jme3utilities.nifty.GuiAppState;

public class WindowController
extends GuiAppState {
    private static final Logger logger = Logger.getLogger(WindowController.class.getName());
    private final BasicScreenController screenController;
    private boolean startEnabled;
    private final String controlId;

    public WindowController(BasicScreenController screenController, String controlId, boolean startEnabled) {
        super(InitialState.Enabled);
        Validate.nonNull((Object)((Object)screenController), (String)"screen controller");
        Validate.nonNull((Object)controlId, (String)"control id");
        this.screenController = screenController;
        this.controlId = controlId;
        this.startEnabled = startEnabled;
        assert (!this.isInitialized());
        assert (this.isEnabled());
    }

    public WindowController(BasicScreenController screenController, String controlId, InitialState initialState) {
        super(InitialState.Enabled);
        Validate.nonNull((Object)((Object)screenController), (String)"screen controller");
        Validate.nonNull((Object)controlId, (String)"control id");
        this.screenController = screenController;
        this.controlId = controlId;
        boolean bl = this.startEnabled = initialState == InitialState.Enabled;
        assert (!this.isInitialized());
        assert (this.isEnabled());
    }

    public Element getElement() {
        Element element = this.getWindow().getElement();
        assert (element != null);
        return element;
    }

    public BasicScreenController getScreenController() {
        assert (this.screenController != null);
        return this.screenController;
    }

    public void select() {
        this.setEnabled(true);
        this.getWindow().moveToFront();
    }

    @Override
    public void initialize(AppStateManager stateManager, Application application) {
        super.initialize(stateManager, application);
        assert (this.screenController.isInitialized());
        this.screenController.addWindowController(this);
        if (!this.startEnabled) {
            this.hide();
        }
        assert (this.isInitialized());
    }

    public void setEnabled(boolean newSetting) {
        if (!this.isInitialized()) {
            this.startEnabled = newSetting;
            return;
        }
        if (newSetting && !this.isEnabled()) {
            this.display();
        } else if (!newSetting && this.isEnabled()) {
            this.hide();
        }
    }

    public void update(float tpf) {
        super.update(tpf);
        boolean isDisplayed = this.getElement().isVisible();
        if (isDisplayed != this.isEnabled()) {
            this.setEnabled(isDisplayed);
        }
    }

    private void display() {
        assert (this.isInitialized());
        assert (!this.isEnabled());
        this.getElement().setVisible(true);
        super.setEnabled(true);
    }

    private Window getWindow() {
        Screen screen = this.screenController.getScreen();
        Window window = (Window)screen.findNiftyControl(this.controlId, Window.class);
        assert (window != null);
        return window;
    }

    private void hide() {
        assert (this.isInitialized());
        assert (this.isEnabled());
        this.getElement().setVisible(false);
        super.setEnabled(false);
    }
}

