/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty.dialog;

import java.util.Locale;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.nifty.dialog.AllowNull;
import jme3utilities.nifty.dialog.TextEntryDialog;

public class DoubleDialog
extends TextEntryDialog {
    private static final Logger logger = Logger.getLogger(DoubleDialog.class.getName());
    private final AllowNull allowNull;
    private final double maxValue;
    private final double minValue;

    public DoubleDialog(String description, double min, double max, AllowNull allowNull) {
        super(description);
        Validate.require((min < max ? 1 : 0) != 0, (String)"min < max");
        Validate.nonNull((Object)((Object)allowNull), (String)"allow null");
        this.minValue = min;
        this.maxValue = max;
        this.allowNull = allowNull;
    }

    @Override
    protected String feedback(String input) {
        Validate.nonNull((Object)input, (String)"input");
        String msg = "";
        try {
            double inputValue = Double.parseDouble(input);
            if (inputValue < this.minValue) {
                String minText = Double.toString(this.minValue);
                msg = String.format("must not be < %s", minText);
            } else if (inputValue > this.maxValue) {
                String maxText = Double.toString(this.maxValue);
                msg = String.format("must not be > %s", maxText);
            } else if (Double.isNaN(inputValue)) {
                msg = this.notANumber();
            }
        }
        catch (NumberFormatException exception) {
            msg = this.notANumber();
        }
        String lcText = input.toLowerCase(Locale.ROOT);
        if (this.allowNull.equals((Object)AllowNull.Yes) && DoubleDialog.matchesNull(lcText)) {
            msg = "";
        }
        return msg;
    }

    private String notANumber() {
        if (this.allowNull.equals((Object)AllowNull.Yes)) {
            return "must be a number or null";
        }
        return "must be a number";
    }
}

