/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.nifty.dialog;

import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jme3utilities.Validate;
import jme3utilities.nifty.dialog.AllowNull;
import jme3utilities.nifty.dialog.TextEntryDialog;

public class VectorDialog
extends TextEntryDialog {
    private static final Logger logger = Logger.getLogger(VectorDialog.class.getName());
    private static final Pattern elementPattern = Pattern.compile("([^)(,\\s]+)");
    private final AllowNull allowNull;
    private final int numElements;

    public VectorDialog(String description, int numElements, AllowNull allowNull) {
        super(description);
        Validate.inRange((int)numElements, (String)"number of elements", (int)2, (int)4);
        Validate.nonNull((Object)((Object)allowNull), (String)"allow null");
        this.numElements = numElements;
        this.allowNull = allowNull;
    }

    public static Object parseVector(String text) {
        Vector2f result;
        Validate.nonEmpty((String)text, (String)"text");
        String lcText = text.toLowerCase(Locale.ROOT);
        Matcher matcher = elementPattern.matcher(lcText);
        ArrayList<Float> elements = new ArrayList<Float>(4);
        while (matcher.find()) {
            String group = matcher.group(1);
            float element = Float.parseFloat(group);
            elements.add(Float.valueOf(element));
        }
        int numElements = elements.size();
        float x = ((Float)elements.get(0)).floatValue();
        float y = ((Float)elements.get(1)).floatValue();
        switch (numElements) {
            case 2: {
                result = new Vector2f(x, y);
                break;
            }
            case 3: {
                float z = ((Float)elements.get(2)).floatValue();
                result = new Vector3f(x, y, z);
                break;
            }
            case 4: {
                float z = ((Float)elements.get(2)).floatValue();
                float w = ((Float)elements.get(3)).floatValue();
                result = new Vector4f(x, y, z, w);
                break;
            }
            default: {
                throw new IllegalArgumentException("numElements = " + numElements);
            }
        }
        return result;
    }

    @Override
    protected String feedback(String input) {
        Validate.nonNull((Object)input, (String)"input");
        String lcText = input.toLowerCase(Locale.ROOT);
        String msg = "";
        Matcher matcher = elementPattern.matcher(lcText);
        int elementCount = 0;
        while (msg.isEmpty() && matcher.find()) {
            String element = matcher.group(1);
            try {
                float inputValue = Float.parseFloat(element);
                if (Float.isNaN(inputValue)) {
                    msg = this.notAVector();
                }
                ++elementCount;
            }
            catch (NumberFormatException exception) {
                msg = this.notAVector();
            }
        }
        if (elementCount != this.numElements) {
            msg = this.notAVector();
        }
        if (this.allowNull.equals((Object)AllowNull.Yes) && VectorDialog.matchesNull(lcText)) {
            msg = "";
        }
        return msg;
    }

    private String notAVector() {
        String msg = String.format("must be a %d-element vector", this.numElements);
        if (this.allowNull.equals((Object)AllowNull.Yes)) {
            msg = msg + " or null";
        }
        return msg;
    }
}

